package com.zurrtum.create.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.AllRecipeSets;
import com.zurrtum.create.content.kinetics.mixer.PotionRecipe;
import com.zurrtum.create.content.processing.sequenced.SequencedAssemblyRecipe;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Map.Entry;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Stream;
import net.minecraft.class_10289;
import net.minecraft.class_10290;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1863.class_10357;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_5321;

@Mixin(class_1863.class)
public class ServerRecipeManagerMixin {
    @Inject(method = "prepare(Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/util/profiler/Profiler;)Lnet/minecraft/recipe/PreparedRecipes;", at = @At(value = "INVOKE", target = "Ljava/util/SortedMap;size()I"))
    private void addSequencedAssemblyRecipe(
        class_3300 resourceManager,
        class_3695 profiler,
        CallbackInfoReturnable<class_10289> cir,
        @Local SortedMap<class_2960, class_1860<?>> sortedMap
    ) {
        sortedMap.putAll(SequencedAssemblyRecipe.Serializer.GENERATE_RECIPES);
        PotionRecipe.register(sortedMap);
    }

    @WrapOperation(method = "initialize(Lnet/minecraft/resource/featuretoggle/FeatureSet;)V", at = @At(value = "INVOKE", target = "Ljava/util/Set;stream()Ljava/util/stream/Stream;"))
    public Stream<Entry<class_5321<class_10290>, class_10357>> registerRecipeSet(
        Set<Entry<class_5321<class_10290>, class_10357>> instance,
        Operation<Stream<Entry<class_5321<class_10290>, class_10357>>> original
    ) {
        return Stream.concat(original.call(instance), AllRecipeSets.ALL.entrySet().stream());
    }
}
