package com.zurrtum.create.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SyncedBlockEntity;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.foundation.item.ItemHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;
import net.minecraft.class_11368;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_3218;

@Mixin(class_2818.class)
public abstract class WorldChunkMixin {
    @Shadow
    public abstract class_1937 getWorld();

    @Shadow
    public abstract Map<class_2338, class_2586> getBlockEntities();

    @Inject(method = "setBlockEntity", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/chunk/WorldChunk;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/BlockState;"))
    private void setBlockEntity(class_2586 blockEntity, CallbackInfo info, @Local class_2338 pos) {
        if (getWorld() instanceof class_3218) {
            ItemHelper.invalidateInventoryCache(pos);
            FluidHelper.invalidateInventoryCache(pos);
        }
    }

    @WrapOperation(method = "getBlockEntity(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/chunk/WorldChunk$CreationType;)Lnet/minecraft/block/entity/BlockEntity;", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/entity/BlockEntity;isRemoved()Z"))
    private boolean onRemoveBlockEntity(class_2586 instance, Operation<Boolean> original, @Local(argsOnly = true) class_2338 pos) {
        if (original.call(instance)) {
            ItemHelper.invalidateInventoryCache(pos);
            FluidHelper.invalidateInventoryCache(pos);
            return true;
        }
        return false;
    }

    @Inject(method = "removeBlockEntity", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/chunk/WorldChunk;removeGameEventListener(Lnet/minecraft/block/entity/BlockEntity;Lnet/minecraft/server/world/ServerWorld;)V"))
    private void onRemoveBlockEntity(class_2338 pos, CallbackInfo ci) {
        ItemHelper.invalidateInventoryCache(pos);
        FluidHelper.invalidateInventoryCache(pos);
    }

    @WrapOperation(method = "method_31716(Lnet/minecraft/util/ErrorReporter$Logging;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/entity/BlockEntityType;Lnet/minecraft/nbt/NbtCompound;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/entity/BlockEntity;read(Lnet/minecraft/storage/ReadView;)V"))
    private void handleUpdateTag(class_2586 blockEntity, class_11368 view, Operation<Void> original) {
        if (blockEntity instanceof SyncedBlockEntity syncedBlockEntity) {
            syncedBlockEntity.handleUpdateTag(view);
        } else {
            original.call(blockEntity, view);
        }
    }

    @Inject(method = "clear()V", at = @At("HEAD"))
    private void clear(CallbackInfo ci) {
        getBlockEntities().values().forEach(blockEntity -> {
            if (blockEntity instanceof SmartBlockEntity sbe) {
                sbe.onChunkUnloaded();
            }
        });
    }
}
