/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.jei.category;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.client.compat.jei.CreateCategory;
import com.zurrtum.create.client.compat.jei.JeiClientPlugin;
import com.zurrtum.create.client.compat.jei.renderer.TwoIconRenderer;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.SpoutRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.content.fluids.transfer.FillingRecipe;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.foundation.fluid.FluidStackIngredient;
import com.zurrtum.create.infrastructure.component.BottleType;
import com.zurrtum.create.infrastructure.fluids.FluidItemInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.types.IRecipeType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.recipe.v1.ingredient.DefaultCustomIngredients;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_10289;
import net.minecraft.class_11256;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class SpoutFillingCategory
extends CreateCategory<class_8786<FillingRecipe>> {
    public static final int MAX = 3;
    public static AtomicInteger idGenerator = new AtomicInteger();

    public static List<class_8786<FillingRecipe>> getRecipes(class_10289 preparedRecipes, Stream<class_1799> itemStream, Stream<IJeiFluidIngredient> fluidStream) {
        ArrayList<class_8786<FillingRecipe>> recipes = new ArrayList<class_8786<FillingRecipe>>(preparedRecipes.method_64698(AllRecipeTypes.FILLING));
        List<FluidStack> fluids = fluidStream.map(ingredient -> {
            FluidVariant variant = ingredient.getFluidVariant();
            return new FluidStack(variant.getFluid(), ingredient.getAmount(), variant.getComponents());
        }).toList();
        MutableInt i = new MutableInt();
        itemStream.forEach(stack -> {
            if (PotionFluidHandler.isPotionItem(stack)) {
                class_1844 potion = (class_1844)stack.method_58695(class_9334.field_49651, (Object)class_1844.field_49274);
                BottleType bottleType = PotionFluidHandler.bottleTypeFromItem(stack.method_7909());
                recipes.add(new class_8786(class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)class_2960.method_60655((String)"create", (String)("filling_potions_" + i.getAndIncrement()))), (class_1860)new FillingRecipe((class_1799)stack, class_1856.method_8101((class_1935)class_1802.field_8469), PotionFluidHandler.getFluidIngredientFromPotion(potion, bottleType, 27000))));
                return;
            }
            try (FluidItemInventory capability = FluidHelper.getFluidInventory(stack.method_7972());){
                if (capability == null) {
                    return;
                }
                int size = capability.size();
                FluidStack existingFluid = size == 1 ? capability.getStack(0) : FluidStack.EMPTY;
                for (FluidStack fluid : fluids) {
                    class_1792 item;
                    int insert;
                    if (size == 1 && !existingFluid.isEmpty() && !FluidStack.areFluidsAndComponentsEqual(existingFluid, fluid) || (insert = capability.insert(fluid, 81000)) == 0) continue;
                    class_1799 result = capability.getContainer();
                    if (!result.method_7960() && !result.method_31574(item = stack.method_7909())) {
                        class_2960 itemName = class_7923.field_41178.method_10221((Object)item);
                        class_2960 fluidName = class_7923.field_41173.method_10221((Object)fluid.getFluid());
                        class_2960 id = class_2960.method_60655((String)"create", (String)("fill_" + itemName.method_12836() + "_" + itemName.method_12832() + "_with_" + fluidName.method_12836() + "_" + fluidName.method_12832()));
                        class_1856 ingredient = stack.method_57380().method_57848() ? class_1856.method_8101((class_1935)stack.method_7909()) : DefaultCustomIngredients.components((class_1799)stack);
                        recipes.add(new class_8786(class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)id), (class_1860)new FillingRecipe(result, ingredient, new FluidStackIngredient(fluid.getFluid(), fluid.getComponentChanges(), insert))));
                    }
                    capability.extract(fluid, insert);
                }
            }
        });
        return recipes;
    }

    @NotNull
    public IRecipeType<class_8786<FillingRecipe>> getRecipeType() {
        return JeiClientPlugin.SPOUT_FILLING;
    }

    @NotNull
    public class_2561 getTitle() {
        return CreateLang.translateDirect("recipe.spout_filling", new Object[0]);
    }

    public IDrawable getIcon() {
        return new TwoIconRenderer((class_1792)AllItems.SPOUT, class_1802.field_8705);
    }

    public int getHeight() {
        return 70;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, class_8786<FillingRecipe> entry, IFocusGroup focuses) {
        FillingRecipe recipe = (FillingRecipe)entry.comp_1933();
        builder.addInputSlot(27, 51).setBackground((IDrawable)SLOT, -1, -1).add(recipe.ingredient());
        SpoutFillingCategory.addFluidSlot(builder, 27, 32, recipe.fluidIngredient()).setBackground((IDrawable)SLOT, -1, -1).setSlotName("fluid");
        builder.addOutputSlot(132, 51).setBackground((IDrawable)SLOT, -1, -1).add(recipe.result());
    }

    public void draw(class_8786<FillingRecipe> entry, IRecipeSlotsView recipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SHADOW.render(graphics, 62, 57);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 126, 29);
        recipeSlotsView.findSlotByName("fluid").flatMap(view -> view.getDisplayedIngredient((IIngredientType)FabricTypes.FLUID_STACK)).ifPresent(fluidIngredient -> {
            FluidVariant fluidVariant = fluidIngredient.getFluidVariant();
            int i = idGenerator.getAndIncrement();
            if (i >= 3) {
                idGenerator.set(0);
            }
            graphics.field_59826.method_70922((class_11256)new SpoutRenderState(i, new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), fluidVariant.getFluid(), fluidVariant.getComponents(), 75, 1, 0));
        });
    }
}

