/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.sodium;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllFluidConfigs;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.infrastructure.fluid.FluidConfig;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.fluids.tank.FluidTankBlock;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.HashSet;
import net.caffeinemc.mods.sodium.api.texture.SpriteUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1059;
import net.minecraft.class_11697;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4730;

@Environment(value=EnvType.CLIENT)
public class SodiumCompat {
    private static final boolean DISABLE = !FabricLoader.getInstance().isModLoaded("sodium");
    public static final class_4730 SAW_TEXTURE = new class_4730(class_1059.field_5275, Create.asResource("block/saw_reversed"));
    public static final class_4730 FACTORY_PANEL_TEXTURE = new class_4730(class_1059.field_5275, Create.asResource("block/factory_panel_connections_animated"));
    public static final class_4730 SAW_VANILLA_TEXTURE = new class_4730(class_1059.field_5275, class_2960.method_60656((String)"block/stonecutter_saw"));

    public static void markSpriteActive(class_310 mc) {
        if (DISABLE) {
            return;
        }
        class_11697 atlasManager = mc.method_72703();
        SpriteUtil.INSTANCE.markSpriteActive(atlasManager.method_73030(SAW_TEXTURE));
        SpriteUtil.INSTANCE.markSpriteActive(atlasManager.method_73030(SAW_VANILLA_TEXTURE));
        SpriteUtil.INSTANCE.markSpriteActive(atlasManager.method_73030(FACTORY_PANEL_TEXTURE));
    }

    public static void markPonderSpriteActive(PonderLevel world, Selection section) {
        if (DISABLE) {
            return;
        }
        boolean saw = true;
        boolean panel = true;
        HashSet<class_3611> fluids = new HashSet<class_3611>();
        for (class_2338 pos : section) {
            class_3611 fluid;
            class_2586 class_25862;
            class_2680 state = world.method_8320(pos);
            if (state.method_26215()) continue;
            if (saw && state.method_27852((class_2248)AllBlocks.MECHANICAL_SAW)) {
                class_11697 atlasManager = class_310.method_1551().method_72703();
                SpriteUtil.INSTANCE.markSpriteActive(atlasManager.method_73030(SAW_TEXTURE));
                SpriteUtil.INSTANCE.markSpriteActive(atlasManager.method_73030(SAW_VANILLA_TEXTURE));
                saw = false;
                continue;
            }
            if (panel && state.method_27852((class_2248)AllBlocks.FACTORY_GAUGE)) {
                SpriteUtil.INSTANCE.markSpriteActive(class_310.method_1551().method_72703().method_73030(FACTORY_PANEL_TEXTURE));
                panel = false;
                continue;
            }
            if (state.method_26204() instanceof FluidTankBlock && (class_25862 = world.method_8321(pos)) instanceof FluidTankBlockEntity) {
                class_3611 fluid2;
                FluidTankBlockEntity tank = (FluidTankBlockEntity)class_25862;
                FluidStack stack = tank.getTankInventory().getFluid();
                if (stack.isEmpty() || !fluids.add(fluid2 = stack.getFluid())) continue;
                SodiumCompat.markFluidSpriteActive(fluid2);
                continue;
            }
            class_3610 fluidState = state.method_26227();
            if (fluidState.method_15769() || !fluids.add(fluid = fluidState.method_15772())) continue;
            SodiumCompat.markFluidSpriteActive(fluid);
        }
    }

    public static void markFluidSpriteActive(class_3611 fluid) {
        if (DISABLE) {
            return;
        }
        FluidConfig config = AllFluidConfigs.get(fluid);
        if (config != null) {
            SpriteUtil.INSTANCE.markSpriteActive(config.still().get());
            SpriteUtil.INSTANCE.markSpriteActive(config.flowing().get());
        }
    }
}

