/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.content.contraptions.ContraptionColliderClient;
import com.zurrtum.create.client.content.trains.entity.TrainRelocatorClient;
import com.zurrtum.create.client.foundation.utility.RaycastHelper;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.infrastructure.packet.c2s.ContraptionInteractionPacket;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3499;
import net.minecraft.class_3965;
import net.minecraft.class_745;
import net.minecraft.class_746;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ContraptionHandlerClient {
    public static WorldAttached<Map<Integer, WeakReference<AbstractContraptionEntity>>> loadedContraptions = new WorldAttached<Map>($ -> new HashMap());
    static WorldAttached<List<AbstractContraptionEntity>> queuedAdditions = new WorldAttached<List>($ -> ObjectLists.synchronize((ObjectList)new ObjectArrayList()));

    public static void tick(class_1937 world) {
        Map<Integer, WeakReference<AbstractContraptionEntity>> map = loadedContraptions.get((class_1936)world);
        List<AbstractContraptionEntity> queued = queuedAdditions.get((class_1936)world);
        for (AbstractContraptionEntity contraptionEntity : queued) {
            map.put(contraptionEntity.method_5628(), new WeakReference<AbstractContraptionEntity>(contraptionEntity));
        }
        queued.clear();
        Collection<WeakReference<AbstractContraptionEntity>> values = map.values();
        Iterator<WeakReference<AbstractContraptionEntity>> iterator = values.iterator();
        while (iterator.hasNext()) {
            WeakReference<AbstractContraptionEntity> weakReference = iterator.next();
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)((Object)weakReference.get());
            if (contraptionEntity == null || !contraptionEntity.isAliveOrStale()) {
                iterator.remove();
                continue;
            }
            if (!contraptionEntity.method_5805()) {
                --contraptionEntity.staleTicks;
                continue;
            }
            ContraptionColliderClient.collideEntities(contraptionEntity);
        }
    }

    public static void addSpawnedContraptionsToCollisionList(class_1297 entity, class_1937 world) {
        if (entity instanceof AbstractContraptionEntity) {
            queuedAdditions.get((class_1936)world).add((AbstractContraptionEntity)entity);
        }
    }

    public static void entitiesWhoJustDismountedGetSentToTheRightLocation(class_1309 entityLiving, class_1937 world) {
        if (!world.method_8608()) {
            return;
        }
        AllSynchedDatas.CONTRAPTION_DISMOUNT_LOCATION.get((class_1297)entityLiving).ifPresent(position -> {
            if (entityLiving.method_5854() == null) {
                entityLiving.method_5641(position.field_1352, position.field_1351, position.field_1350, entityLiving.method_36454(), entityLiving.method_36455());
            }
            AllSynchedDatas.CONTRAPTION_DISMOUNT_LOCATION.set((class_1297)entityLiving, Optional.empty());
            entityLiving.method_24830(false);
        });
    }

    public static void preventRemotePlayersWalkingAnimations(class_745 remotePlayer) {
        int lastOverride = AllSynchedDatas.LAST_OVERRIDE_LIMB_SWING_UPDATE.get((class_1297)remotePlayer);
        if (lastOverride == -1) {
            return;
        }
        if (lastOverride > 5) {
            AllSynchedDatas.LAST_OVERRIDE_LIMB_SWING_UPDATE.set((class_1297)remotePlayer, -1);
            AllSynchedDatas.OVERRIDE_LIMB_SWING.set((class_1297)remotePlayer, Float.valueOf(0.0f));
            return;
        }
        AllSynchedDatas.LAST_OVERRIDE_LIMB_SWING_UPDATE.set((class_1297)remotePlayer, lastOverride + 1);
        float limbSwing = AllSynchedDatas.OVERRIDE_LIMB_SWING.get((class_1297)remotePlayer).floatValue();
        remotePlayer.field_6014 = remotePlayer.method_23317() - (double)(limbSwing / 4.0f);
        remotePlayer.field_5969 = remotePlayer.method_23321();
    }

    public static boolean rightClickingOnContraptionsGetsHandledLocally(class_310 mc, class_1268 hand) {
        class_746 player = mc.field_1724;
        if (player == null) {
            return false;
        }
        if (player.method_7325()) {
            return false;
        }
        if (mc.field_1687 == null) {
            return false;
        }
        Couple<class_243> rayInputs = ContraptionHandlerClient.getRayInputs(mc, player);
        class_243 origin = (class_243)rayInputs.getFirst();
        class_243 target = (class_243)rayInputs.getSecond();
        class_238 aabb = new class_238(origin, target).method_1014(16.0);
        Collection<WeakReference<AbstractContraptionEntity>> contraptions = loadedContraptions.get((class_1936)mc.field_1687).values();
        double bestDistance = Double.MAX_VALUE;
        class_3965 bestResult = null;
        AbstractContraptionEntity bestEntity = null;
        for (WeakReference<AbstractContraptionEntity> ref : contraptions) {
            double distance;
            class_3965 rayTraceResult;
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)((Object)ref.get());
            if (contraptionEntity == null || !contraptionEntity.method_5829().method_994(aabb) || (rayTraceResult = ContraptionHandlerClient.rayTraceContraption(origin, target, contraptionEntity)) == null || (distance = contraptionEntity.toGlobalVector(rayTraceResult.method_17784(), 1.0f).method_1022(origin)) > bestDistance) continue;
            bestResult = rayTraceResult;
            bestDistance = distance;
            bestEntity = contraptionEntity;
        }
        if (bestResult == null) {
            return false;
        }
        class_2350 face = bestResult.method_17780();
        class_2338 pos = bestResult.method_17777();
        if (bestEntity.handlePlayerInteraction((class_1657)player, pos, face, hand)) {
            player.field_3944.method_52787((class_2596)new ContraptionInteractionPacket(bestEntity, hand, pos, face));
        } else {
            ContraptionHandlerClient.handleSpecialInteractions(bestEntity, (class_1657)player, pos, face, hand);
        }
        return true;
    }

    private static boolean handleSpecialInteractions(AbstractContraptionEntity contraptionEntity, class_1657 player, class_2338 localPos, class_2350 side, class_1268 interactionHand) {
        if (player.method_5998(interactionHand).method_31574((class_1792)AllItems.WRENCH) && contraptionEntity instanceof CarriageContraptionEntity) {
            CarriageContraptionEntity car = (CarriageContraptionEntity)contraptionEntity;
            return TrainRelocatorClient.carriageWrenched(car.toGlobalVector(VecHelper.getCenterOf((class_2382)localPos), 1.0f), car);
        }
        return false;
    }

    public static Couple<class_243> getRayInputs(class_310 mc, class_746 player) {
        class_243 origin = player.method_33571();
        double reach = player.method_55754();
        if (mc.field_1765 != null && mc.field_1765.method_17784() != null) {
            reach = Math.min(mc.field_1765.method_17784().method_1022(origin), reach);
        }
        class_243 target = RaycastHelper.getTraceTarget((class_1657)player, reach, origin);
        return Couple.create(origin, target);
    }

    @Nullable
    public static class_3965 rayTraceContraption(class_243 origin, class_243 target, AbstractContraptionEntity contraptionEntity) {
        MutableObject mutableResult;
        Contraption contraption;
        class_243 localTarget;
        class_243 localOrigin = contraptionEntity.toLocalVector(origin, 1.0f);
        RaycastHelper.PredicateTraceResult predicateResult = RaycastHelper.rayTraceUntil(localOrigin, localTarget = contraptionEntity.toLocalVector(target, 1.0f), arg_0 -> ContraptionHandlerClient.lambda$rayTraceContraption$3(contraption = contraptionEntity.getContraption(), localOrigin, localTarget, mutableResult = new MutableObject(), arg_0));
        if (predicateResult == null || predicateResult.missed()) {
            return null;
        }
        class_3965 rayTraceResult = (class_3965)mutableResult.getValue();
        return rayTraceResult;
    }

    private static /* synthetic */ boolean lambda$rayTraceContraption$3(Contraption contraption, class_243 localOrigin, class_243 localTarget, MutableObject mutableResult, class_2338 p) {
        for (class_2350 d : Iterate.directions) {
            class_3965 rayTrace;
            class_2680 state;
            class_265 raytraceShape;
            if (d == class_2350.field_11036) continue;
            class_2338 pos = d == class_2350.field_11033 ? p : p.method_10093(d);
            class_3499.class_3501 blockInfo = contraption.getBlocks().get(pos);
            if (blockInfo == null || (raytraceShape = (state = blockInfo.comp_1342()).method_26218((class_1922)contraption.getContraptionWorld(), class_2338.field_10980.method_10074())).method_1110() || contraption.isHiddenInPortal(pos) || (rayTrace = raytraceShape.method_1092(localOrigin, localTarget, pos)) == null) continue;
            mutableResult.setValue((Object)rayTrace);
            return true;
        }
        return false;
    }
}

