/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.blueprint;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.equipment.blueprint.BlueprintEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10017;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_897;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class BlueprintRenderer
extends class_897<BlueprintEntity, BlueprintState> {
    protected final class_10442 itemModelManager;

    public BlueprintRenderer(class_5617.class_5618 context) {
        super(context);
        this.itemModelManager = context.method_65566();
    }

    public BlueprintState createRenderState() {
        return new BlueprintState();
    }

    public void updateRenderState(BlueprintEntity entity, BlueprintState state, float tickProgress) {
        super.method_62354((class_1297)entity, (class_10017)state, tickProgress);
        float yaw = entity.method_61415(tickProgress);
        float pitch = entity.method_36455();
        int size = entity.size;
        state.layer = class_4722.method_24073();
        PartialModel partialModel = size == 3 ? AllPartialModels.CRAFTING_BLUEPRINT_3x3 : (size == 2 ? AllPartialModels.CRAFTING_BLUEPRINT_2x2 : AllPartialModels.CRAFTING_BLUEPRINT_1x1);
        state.model = CachedBuffers.partial(partialModel, class_2246.field_10124.method_9564());
        state.yRot = (float)Math.PI / 180 * -yaw;
        state.xRot = (float)Math.PI / 180 * (90.0f + pitch);
        class_243 offset = new class_243(-0.5, -0.03125, -0.5);
        if (size == 2) {
            offset = offset.method_1031(0.5, 0.0, -0.5);
        }
        state.offset = offset;
        class_1937 world = entity.method_73183();
        int itemSize = size * size * 2;
        class_10444[] items = new class_10444[itemSize];
        boolean empty = true;
        for (int i = 0; i < itemSize; ++i) {
            Couple<class_1799> displayItems = entity.getSection(i >> 1).getDisplayItems();
            class_1799 firstStack = (class_1799)displayItems.getFirst();
            if (!firstStack.method_7960()) {
                empty = false;
                items[i] = BlueprintRenderer.createItemRenderState(this.itemModelManager, firstStack, world);
            }
            ++i;
            class_1799 secondStack = (class_1799)displayItems.getSecond();
            if (secondStack.method_7960()) continue;
            empty = false;
            items[i] = BlueprintRenderer.createItemRenderState(this.itemModelManager, secondStack, world);
        }
        if (empty) {
            return;
        }
        state.items = items;
        state.size = size;
        int bl = state.field_61820 >> 4 & 0xF;
        int sl = state.field_61820 >> 20 & 0xF;
        float f = state.normalYRot = pitch != 0.0f ? 0.0f : state.yRot;
        if (pitch == -90.0f) {
            state.normalXRot = -0.7853982f;
        } else if (pitch == 90.0f || yaw % 180.0f != 0.0f) {
            state.normalXRot = -0.2617994f;
            bl = (int)((double)bl / 1.35);
            sl = (int)((double)sl / 1.35);
        } else {
            state.normalXRot = -0.2617994f;
        }
        state.itemXRot = (float)Math.PI / 180 * pitch;
        state.itemOffsetZ = 0.03225f;
        if (size == 3) {
            state.itemOffsetXY = -1;
        }
        state.itemLight = class_3532.method_15357((double)((double)sl + 0.5)) << 20 | (class_3532.method_15357((double)((double)bl + 0.5)) & 0xF) << 4;
    }

    private static class_10444 createItemRenderState(class_10442 itemModelManager, class_1799 stack, class_1937 world) {
        class_10444 state = new class_10444();
        state.field_55337 = class_811.field_4317;
        itemModelManager.method_65596(state, stack, state.field_55337, world, null, 0);
        return state;
    }

    public void render(BlueprintState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, (class_11659.class_11660)state);
        class_10444[] items = state.items;
        if (items == null) {
            return;
        }
        matrices.method_22903();
        class_4587.class_4665 entry = matrices.method_23760();
        Matrix3f normal = entry.method_23762();
        if (state.normalYRot != 0.0f) {
            normal.rotate((Quaternionfc)class_7833.field_40716.rotation(state.normalYRot));
        }
        normal.rotate((Quaternionfc)class_7833.field_40714.rotation(state.normalXRot));
        Matrix4f pose = entry.method_23761();
        pose.rotate((Quaternionfc)class_7833.field_40716.rotation(state.yRot));
        pose.rotate((Quaternionfc)class_7833.field_40714.rotation(state.itemXRot));
        pose.translate((float)state.itemOffsetXY, (float)state.itemOffsetXY, state.itemOffsetZ);
        Matrix4f copy = new Matrix4f((Matrix4fc)pose);
        int light = state.itemLight;
        int i = 0;
        int size = items.length;
        int n = 0;
        int w = state.size - 1;
        while (i < size) {
            class_10444 firstState = items[i++];
            class_10444 secondState = items[i++];
            if (firstState != null || secondState != null) {
                pose.scale(0.5f, 0.5f, 9.765625E-4f);
                if (firstState != null) {
                    firstState.method_65604(matrices, queue, light, class_4608.field_21444, 0);
                }
                if (secondState != null) {
                    pose.translate(0.325f, -0.325f, 1.0f);
                    pose.scale(0.625f, 0.625f, 1.0f);
                    secondState.method_65604(matrices, queue, light, class_4608.field_21444, 0);
                }
            }
            if (n < w) {
                copy.translate(1.0f, 0.0f, 0.0f);
                ++n;
            } else {
                copy.translate((float)(-w), 1.0f, 0.0f);
                n = 0;
            }
            pose.set((Matrix4fc)copy);
        }
        matrices.method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    public static class BlueprintState
    extends class_10017
    implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer model;
        public float yRot;
        public float xRot;
        public class_243 offset;
        public class_10444[] items;
        public int size;
        public float normalYRot;
        public float normalXRot;
        public float itemXRot;
        public int itemOffsetXY;
        public float itemOffsetZ;
        public int itemLight;

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.model.rotateY(this.yRot)).rotateX(this.xRot)).translate(this.offset)).disableDiffuse().light(this.field_61820).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

