/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.deployer;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.content.kinetics.base.RotatingInstance;
import com.zurrtum.create.client.content.kinetics.deployer.DeployerRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.render.AllInstanceTypes;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public class DeployerActorVisual
extends ActorVisual {
    class_2350 facing;
    boolean stationaryTimer;
    TransformedInstance pole;
    TransformedInstance hand;
    RotatingInstance shaft;
    Matrix4fc baseHandTransform;
    Matrix4fc basePoleTransform;

    public DeployerActorVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext context) {
        super(visualizationContext, (class_1920)simulationWorld, context);
        class_2680 state = context.state;
        DeployerBlockEntity.Mode mode = context.blockEntityData.method_67491("Mode", DeployerBlockEntity.Mode.CODEC).orElse(DeployerBlockEntity.Mode.PUNCH);
        PartialModel handPose = DeployerRenderer.getHandPose(mode);
        this.stationaryTimer = context.data.method_10545("StationaryTimer");
        this.facing = (class_2350)state.method_11654(DirectionalKineticBlock.FACING);
        boolean rotatePole = (Boolean)state.method_11654((class_2769)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ this.facing.method_10166() == class_2350.class_2351.field_11051;
        float yRot = AngleHelper.horizontalAngle(this.facing);
        float xRot = this.facing == class_2350.field_11036 ? 270.0f : (this.facing == class_2350.field_11033 ? 90.0f : 0.0f);
        float zRot = rotatePole ? 90.0f : 0.0f;
        this.pole = this.instancerProvider.instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.DEPLOYER_POLE)).createInstance();
        this.hand = this.instancerProvider.instancer(InstanceTypes.TRANSFORMED, Models.partial(handPose)).createInstance();
        class_2350.class_2351 axis = KineticBlockEntityVisual.rotationAxis(state);
        this.shaft = this.instancerProvider.instancer(AllInstanceTypes.ROTATING, Models.partial(AllPartialModels.SHAFT)).createInstance().rotateToFace(axis);
        int blockLight = this.localBlockLight();
        this.shaft.setRotationAxis(axis).setRotationOffset(KineticBlockEntityVisual.rotationOffset(state, axis, (class_2382)context.localPos)).setPosition((class_2382)context.localPos).light(blockLight, 0).setChanged();
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.pole.translate((class_2382)context.localPos)).center()).rotate(yRot * ((float)Math.PI / 180), class_2350.field_11036)).rotate(xRot * ((float)Math.PI / 180), class_2350.field_11034)).rotate(zRot * ((float)Math.PI / 180), class_2350.field_11035)).uncenter()).light(blockLight, 0).setChanged();
        this.basePoleTransform = new Matrix4f((Matrix4fc)this.pole.pose);
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.hand.translate((class_2382)context.localPos)).center()).rotate(yRot * ((float)Math.PI / 180), class_2350.field_11036)).rotate(xRot * ((float)Math.PI / 180), class_2350.field_11034)).uncenter()).light(blockLight, 0).setChanged();
        this.baseHandTransform = new Matrix4f((Matrix4fc)this.hand.pose);
    }

    @Override
    public void beginFrame() {
        float distance = this.deploymentDistance();
        ((TransformedInstance)this.pole.setTransform(this.basePoleTransform).translateZ(distance)).setChanged();
        ((TransformedInstance)this.hand.setTransform(this.baseHandTransform).translateZ(distance)).setChanged();
    }

    private float deploymentDistance() {
        double factor;
        if (this.context.disabled) {
            factor = 0.0;
        } else if (this.context.contraption.stalled || this.context.position == null || this.context.data.method_10545("StationaryTimer")) {
            factor = class_3532.method_15374((float)(AnimationTickHolder.getRenderTime() * 0.5f)) * 0.25f + 0.25f;
        } else {
            class_243 center = VecHelper.getCenterOf((class_2382)class_2338.method_49638((class_2374)this.context.position));
            double distance = this.context.position.method_1022(center);
            double nextDistance = this.context.position.method_1019(this.context.motion).method_1022(center);
            factor = 0.5 - class_3532.method_15350((double)class_3532.method_16436((double)AnimationTickHolder.getPartialTicks(), (double)distance, (double)nextDistance), (double)0.0, (double)1.0);
        }
        return (float)factor;
    }

    @Override
    protected void _delete() {
        this.pole.delete();
        this.hand.delete();
        this.shaft.delete();
    }
}

