/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.deployer;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.zurrtum.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class DeployerRenderer
implements class_827<DeployerBlockEntity, DeployerRenderState> {
    protected final class_10442 itemModelManager;

    public DeployerRenderer(class_5614.class_5615 context) {
        this.itemModelManager = context.comp_4536();
    }

    public DeployerRenderState createRenderState() {
        return new DeployerRenderState();
    }

    public void updateRenderState(DeployerBlockEntity be, DeployerRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        class_11954.method_74399((class_2586)be, (class_11954)state, (class_11683.class_11792)crumblingOverlay);
        class_1937 world = be.method_10997();
        DeployerRenderer.updateItemRenderState(be, state, this.itemModelManager, world, tickProgress);
        state.filter = FilteringRenderer.getFilterRenderState(be, state.field_62674, this.itemModelManager, be.isVirtual() ? -1.0 : cameraPos.method_1025(VecHelper.getCenterOf((class_2382)state.field_62673)));
        DeployerRenderer.updateComponentsRenderState(be, state, world, tickProgress);
    }

    public static void updateItemRenderState(DeployerBlockEntity be, DeployerRenderState state, class_10442 itemModelManager, class_1937 world, float tickProgress) {
        boolean isBlockItem;
        class_1799 heldItem = be.heldItem;
        if (heldItem.method_7960()) {
            return;
        }
        DeployerItemRenderState data = state.item = new DeployerItemRenderState();
        data.offset = DeployerRenderer.getHandOffset(state, be, tickProgress, state.field_62674).method_1019(VecHelper.getCenterOf(class_2338.field_11176));
        class_2350 facing = (class_2350)state.field_62674.method_11654(DirectionalKineticBlock.FACING);
        data.punching = be.mode == DeployerBlockEntity.Mode.PUNCH;
        data.yRot = (float)Math.PI / 180 * (AngleHelper.horizontalAngle(facing) + 180.0f);
        data.xRot = (float)Math.PI / 180 * (float)(facing == class_2350.field_11036 ? 90 : (facing == class_2350.field_11033 ? 270 : 0));
        data.displayMode = facing == class_2350.field_11036 && be.getSpeed() == 0.0f && !data.punching;
        class_10444 renderState = data.state = new class_10444();
        renderState.field_55337 = data.displayMode ? class_811.field_4318 : (data.punching ? class_811.field_4320 : class_811.field_4319);
        itemModelManager.method_65596(renderState, heldItem, renderState.field_55337, world, null, 0);
        boolean bl = isBlockItem = heldItem.method_7909() instanceof class_1747 && renderState.method_65608();
        if (data.displayMode) {
            data.translateY = isBlockItem ? 0.5625f : 0.6875f;
            data.scale = isBlockItem ? 1.25f : 1.0f;
            data.yRot2 = (float)Math.PI / 180 * AnimationTickHolder.getRenderTime((class_1936)world);
        } else {
            data.scale = data.punching ? 0.75f : (isBlockItem ? 0.734375f : 0.5f);
        }
    }

    public static void updateComponentsRenderState(DeployerBlockEntity be, DeployerRenderState state, class_1937 world, float tickProgress) {
        if (VisualizationManager.supportsVisualization((class_1936)world)) {
            return;
        }
        ComponentsRenderState components = state.components = new ComponentsRenderState();
        components.layer = class_1921.method_23577();
        components.light = state.field_62676;
        class_2350.class_2351 axis = ((IRotate)state.field_62674.method_26204()).getRotationAxis(state.field_62674);
        components.shaft = CachedBuffers.block(KineticBlockEntityRenderer.KINETIC_BLOCK, KineticBlockEntityRenderer.shaft(axis));
        components.angle = KineticBlockEntityRenderer.getAngleForBe(be, state.field_62673, axis);
        components.direction = class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11056);
        components.color = KineticBlockEntityRenderer.getColor(be);
        components.offset = DeployerRenderer.getHandOffset(state, be, tickProgress, state.field_62674);
        components.pole = CachedBuffers.partial(AllPartialModels.DEPLOYER_POLE, state.field_62674);
        components.hand = CachedBuffers.partial(DeployerRenderer.getHandPose(be), state.field_62674);
        class_2350 facing = (class_2350)state.field_62674.method_11654(DirectionalKineticBlock.FACING);
        components.yRot = (float)Math.PI / 180 * AngleHelper.horizontalAngle(facing);
        components.xRot = (float)Math.PI / 180 * (float)(facing == class_2350.field_11036 ? 270 : (facing == class_2350.field_11033 ? 90 : 0));
        components.zRot = (float)Math.PI / 180 * (float)((Boolean)state.field_62674.method_11654((class_2769)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ facing.method_10166() == class_2350.class_2351.field_11051 ? 90 : 0);
    }

    public void render(DeployerRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.item != null) {
            state.item.render(matrices, queue, state.field_62676);
        }
        if (state.filter != null) {
            state.filter.render(state.field_62674, queue, matrices, state.field_62676);
        }
        if (state.components != null) {
            queue.method_73483(matrices, state.components.layer, (class_11659.class_11660)state.components);
        }
    }

    public static PartialModel getHandPose(DeployerBlockEntity be) {
        return be.mode == DeployerBlockEntity.Mode.PUNCH ? AllPartialModels.DEPLOYER_HAND_PUNCHING : (be.heldItem.method_7960() ? AllPartialModels.DEPLOYER_HAND_POINTING : AllPartialModels.DEPLOYER_HAND_HOLDING);
    }

    public static class_243 getHandOffset(DeployerRenderState state, DeployerBlockEntity be, float partialTicks, class_2680 blockState) {
        if (state.offset != null) {
            return state.offset;
        }
        state.offset = DeployerRenderer.getHandOffset(be, partialTicks, blockState);
        return state.offset;
    }

    public static class_243 getHandOffset(DeployerBlockEntity be, float partialTicks, class_2680 blockState) {
        float distance = DeployerRenderer.getHandOffset(be, partialTicks);
        return class_243.method_24954((class_2382)((class_2350)blockState.method_11654(DirectionalKineticBlock.FACING)).method_62675()).method_1021((double)distance);
    }

    public static float getHandOffset(DeployerBlockEntity be, float partialTicks) {
        if (be.isVirtual()) {
            return be.animatedOffset.getValue(partialTicks);
        }
        float progress = 0.0f;
        int timerSpeed = be.getTimerSpeed();
        PartialModel handPose = DeployerRenderer.getHandPose(be);
        if (be.state == DeployerBlockEntity.State.EXPANDING) {
            progress = 1.0f - ((float)be.timer - partialTicks * (float)timerSpeed) / 1000.0f;
            if (be.fistBump) {
                progress *= progress;
            }
        }
        if (be.state == DeployerBlockEntity.State.RETRACTING) {
            progress = ((float)be.timer - partialTicks * (float)timerSpeed) / 1000.0f;
        }
        float handLength = handPose == AllPartialModels.DEPLOYER_HAND_POINTING ? 0.0f : (handPose == AllPartialModels.DEPLOYER_HAND_HOLDING ? 0.25f : 0.1875f);
        return Math.min(class_3532.method_15363((float)progress, (float)0.0f, (float)1.0f) * (be.reach + handLength), 1.3125f);
    }

    private static SuperByteBuffer transform(SuperByteBuffer buffer, class_2680 deployerState, boolean axisDirectionMatters) {
        float xRot;
        class_2350 facing = (class_2350)deployerState.method_11654(DirectionalKineticBlock.FACING);
        float yRot = AngleHelper.horizontalAngle(facing);
        float f = facing == class_2350.field_11036 ? 270.0f : (xRot = facing == class_2350.field_11033 ? 90.0f : 0.0f);
        float zRot = axisDirectionMatters && (Boolean)deployerState.method_11654((class_2769)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ facing.method_10166() == class_2350.class_2351.field_11051 ? 90.0f : 0.0f;
        buffer.rotateCentered((float)((double)(yRot / 180.0f) * Math.PI), class_2350.field_11036);
        buffer.rotateCentered((float)((double)(xRot / 180.0f) * Math.PI), class_2350.field_11034);
        buffer.rotateCentered((float)((double)(zRot / 180.0f) * Math.PI), class_2350.field_11035);
        return buffer;
    }

    static PartialModel getHandPose(DeployerBlockEntity.Mode mode) {
        return mode == DeployerBlockEntity.Mode.PUNCH ? AllPartialModels.DEPLOYER_HAND_PUNCHING : AllPartialModels.DEPLOYER_HAND_POINTING;
    }

    @Environment(value=EnvType.CLIENT)
    public static class DeployerRenderState
    extends class_11954 {
        public class_243 offset;
        public DeployerItemRenderState item;
        public FilteringRenderer.FilterRenderState filter;
        public ComponentsRenderState components;
    }

    @Environment(value=EnvType.CLIENT)
    public static class DeployerItemRenderState {
        public class_243 offset;
        public boolean punching;
        public float yRot;
        public float xRot;
        public boolean displayMode;
        public class_10444 state;
        public float translateY;
        public float scale;
        public float yRot2;

        public void render(class_4587 matrices, class_11659 queue, int light) {
            matrices.method_22903();
            matrices.method_61958(this.offset);
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(this.yRot));
            if (!this.displayMode) {
                matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(this.xRot));
                matrices.method_46416(0.0f, 0.0f, -0.6875f);
            }
            if (this.punching) {
                matrices.method_46416(0.0f, 0.125f, -0.0625f);
            }
            if (this.displayMode) {
                matrices.method_46416(0.0f, this.translateY, 0.0f);
                matrices.method_22905(this.scale, this.scale, this.scale);
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(this.yRot2));
            } else {
                matrices.method_22905(this.scale, this.scale, this.scale);
            }
            this.state.method_65604(matrices, queue, light, class_4608.field_21444, 0);
            matrices.method_22909();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ComponentsRenderState
    implements class_11659.class_11660 {
        public class_1921 layer;
        public int light;
        public SuperByteBuffer shaft;
        public float angle;
        public class_2350 direction;
        public Color color;
        public class_243 offset;
        public SuperByteBuffer pole;
        public SuperByteBuffer hand;
        public float yRot;
        public float xRot;
        public float zRot;

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            ((SuperByteBuffer)this.shaft.light(this.light).rotateCentered(this.angle, this.direction)).color(this.color).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.pole.translate(this.offset)).rotateCentered(this.yRot, class_2350.field_11036)).rotateCentered(this.xRot, class_2350.field_11034)).rotateCentered(this.zRot, class_2350.field_11035)).light(this.light).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.hand.translate(this.offset)).rotateCentered(this.yRot, class_2350.field_11036)).rotateCentered(this.xRot, class_2350.field_11034)).light(this.light).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

