/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.redstone.thresholdSwitch;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.infrastructure.ponder.AllCreatePonderTags;
import com.zurrtum.create.client.ponder.foundation.ui.PonderTagScreen;
import com.zurrtum.create.content.redstone.thresholdSwitch.ThresholdSwitchBlockEntity;
import com.zurrtum.create.content.redstone.thresholdSwitch.ThresholdSwitchObservable;
import com.zurrtum.create.infrastructure.packet.c2s.ConfigureThresholdSwitchPacket;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2459;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class ThresholdSwitchScreen
extends AbstractSimiScreen {
    private ScrollInput offBelow;
    private ScrollInput onAbove;
    private SelectionScrollInput inStacks;
    private IconButton confirmButton;
    private IconButton flipSignals;
    private final class_2561 invertSignal = CreateLang.translateDirect("gui.threshold_switch.invert_signal", new Object[0]);
    private ElementWidget renderedItem;
    private ElementWidget torchPower;
    private ElementWidget torchOff;
    private AllGuiTextures background = AllGuiTextures.THRESHOLD_SWITCH;
    private ThresholdSwitchBlockEntity blockEntity;
    private int lastModification;

    public ThresholdSwitchScreen(ThresholdSwitchBlockEntity be) {
        super((class_2561)CreateLang.translateDirect("gui.threshold_switch.title", new Object[0]));
        this.blockEntity = be;
        this.lastModification = -1;
    }

    @Override
    protected void method_25426() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight());
        this.setWindowOffset(-20, 0);
        super.method_25426();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.inStacks = (SelectionScrollInput)new SelectionScrollInput(x + 100, y + 23, 52, 42).forOptions(List.of(CreateLang.translateDirect("schedule.condition.threshold.items", new Object[0]), CreateLang.translateDirect("schedule.condition.threshold.stacks", new Object[0]))).titled(CreateLang.translateDirect("schedule.condition.threshold.item_measure", new Object[0])).setState(this.blockEntity.inStacks ? 1 : 0);
        this.offBelow = new ScrollInput(x + 48, y + 47, 1, 18).withRange(this.blockEntity.getMinLevel(), this.blockEntity.getMaxLevel() + 1 - this.getValueStep()).titled(CreateLang.translateDirect("gui.threshold_switch.lower_threshold", new Object[0])).calling(state -> {
            this.lastModification = 0;
            int valueStep = this.getValueStep();
            if (this.onAbove.getState() / valueStep == 0 && state / valueStep == 0) {
                return;
            }
            if (this.onAbove.getState() / valueStep <= state / valueStep) {
                this.onAbove.setState((state + valueStep) / valueStep * valueStep);
                this.onAbove.onChanged();
            }
        }).withStepFunction(sc -> sc.shift ? 10 * this.getValueStep() : this.getValueStep()).setState(this.blockEntity.offWhenBelow);
        this.onAbove = new ScrollInput(x + 48, y + 23, 1, 18).withRange(this.blockEntity.getMinLevel() + this.getValueStep(), this.blockEntity.getMaxLevel() + 1).titled(CreateLang.translateDirect("gui.threshold_switch.upper_threshold", new Object[0])).calling(state -> {
            this.lastModification = 0;
            int valueStep = this.getValueStep();
            if (this.offBelow.getState() / valueStep == 0 && state / valueStep == 0) {
                return;
            }
            if (this.offBelow.getState() / valueStep >= state / valueStep) {
                this.offBelow.setState((state - valueStep) / valueStep * valueStep);
                this.offBelow.onChanged();
            }
        }).withStepFunction(sc -> sc.shift ? 10 * this.getValueStep() : this.getValueStep()).setState(this.blockEntity.onWhenAbove);
        this.onAbove.onChanged();
        this.offBelow.onChanged();
        this.method_37063(this.onAbove);
        this.method_37063(this.offBelow);
        this.method_37063(this.inStacks);
        this.confirmButton = new IconButton(x + this.background.getWidth() - 33, y + this.background.getHeight() - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(this::method_25419);
        this.method_37063(this.confirmButton);
        this.flipSignals = new IconButton(x + this.background.getWidth() - 62, y + this.background.getHeight() - 24, AllIcons.I_FLIP);
        this.flipSignals.withCallback(() -> this.send(!this.blockEntity.isInverted()));
        this.flipSignals.setToolTip(this.invertSignal);
        this.method_37063(this.flipSignals);
        this.renderedItem = new ElementWidget(x + this.background.getWidth() + 6, y + this.background.getHeight() - 56).showingElement(GuiGameElement.of(AllItems.THRESHOLD_SWITCH.method_7854()).scale(5.0f));
        this.method_37063(this.renderedItem);
        class_2680 torch = class_2246.field_10523.method_9564();
        this.torchPower = new ElementWidget(x + 22, y + 19).showingElement(GuiGameElement.of(torch).rotate(-22.5f, 45.0f, 0.0f).scale(1.25f));
        this.method_37063(this.torchPower);
        this.torchOff = new ElementWidget(x + 22, y + 43).showingElement(GuiGameElement.of((class_2680)torch.method_11657((class_2769)class_2459.field_11446, (Comparable)Boolean.valueOf(false))).rotate(-22.5f, 45.0f, 0.0f).scale(1.25f));
        this.method_37063(this.torchOff);
        this.updateInputBoxes();
    }

    public void method_25419() {
        super.method_25419();
        this.renderedItem.getRenderElement().clear();
        this.torchPower.getRenderElement().clear();
        this.torchOff.getRenderElement().clear();
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        int itemX = this.guiLeft + 13;
        int itemY = this.guiTop + 80;
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        if (mouseX >= (double)itemX && mouseX < (double)(itemX + 16) && mouseY >= (double)itemY && mouseY < (double)(itemY + 16)) {
            ScreenOpener.open(new PonderTagScreen(AllCreatePonderTags.THRESHOLD_SWITCH_TARGETS));
            return true;
        }
        return super.method_25402(click, doubled);
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        boolean stacks;
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        graphics.method_51439(this.field_22793, this.field_22785, x + this.background.getWidth() / 2 - this.field_22793.method_27525((class_5348)this.field_22785) / 2, y + 4, -10935260, false);
        ThresholdSwitchBlockEntity.ThresholdType typeOfCurrentTarget = this.blockEntity.getTypeOfCurrentTarget();
        boolean forItems = typeOfCurrentTarget == ThresholdSwitchBlockEntity.ThresholdType.ITEM;
        AllGuiTextures inputBg = forItems ? AllGuiTextures.THRESHOLD_SWITCH_ITEMCOUNT_INPUTS : AllGuiTextures.THRESHOLD_SWITCH_MISC_INPUTS;
        inputBg.render(graphics, x + 44, y + 21);
        inputBg.render(graphics, x + 44, y + 21 + 24);
        int valueStep = 1;
        boolean bl = stacks = this.inStacks.getState() == 1;
        if (typeOfCurrentTarget == ThresholdSwitchBlockEntity.ThresholdType.FLUID) {
            valueStep = 81000;
        }
        if (forItems) {
            class_5250 suffix = this.inStacks.getState() == 0 ? CreateLang.translateDirect("schedule.condition.threshold.items", new Object[0]) : CreateLang.translateDirect("schedule.condition.threshold.stacks", new Object[0]);
            valueStep = this.inStacks.getState() == 0 ? 1 : 64;
            graphics.method_51439(this.field_22793, (class_2561)suffix, x + 105, y + 28, -1, true);
            graphics.method_51439(this.field_22793, (class_2561)suffix, x + 105, y + 28 + 24, -1, true);
        }
        graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)("\u2265 " + String.valueOf(typeOfCurrentTarget == ThresholdSwitchBlockEntity.ThresholdType.UNSUPPORTED ? "" : (forItems ? Integer.valueOf(this.onAbove.getState() / valueStep) : ThresholdSwitchScreen.format(this.blockEntity, this.onAbove.getState() / valueStep, stacks).getString())))), x + 53, y + 28, -1, true);
        graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)("\u2264 " + String.valueOf(typeOfCurrentTarget == ThresholdSwitchBlockEntity.ThresholdType.UNSUPPORTED ? "" : (forItems ? Integer.valueOf(this.offBelow.getState() / valueStep) : ThresholdSwitchScreen.format(this.blockEntity, this.offBelow.getState() / valueStep, stacks).getString())))), x + 53, y + 28 + 24, -1, true);
        int itemX = x + 13;
        int itemY = y + 80;
        class_1799 displayItem = this.blockEntity.getDisplayItemForScreen();
        graphics.method_51427(displayItem.method_7960() ? new class_1799((class_1935)class_1802.field_8077) : displayItem, itemX, itemY);
        int torchX = x + 23;
        int torchY = y + 24;
        boolean highlightTopRow = this.blockEntity.isInverted() ^ this.blockEntity.isPowered();
        AllGuiTextures.THRESHOLD_SWITCH_CURRENT_STATE.render(graphics, torchX - 3, torchY - 4 + (highlightTopRow ? 0 : 24));
        if (this.blockEntity.isInverted()) {
            this.torchPower.method_46419(y + 43);
            this.torchOff.method_46419(y + 19);
        } else {
            this.torchPower.method_46419(y + 19);
            this.torchOff.method_46419(y + 43);
        }
        if (mouseX >= itemX && mouseX < itemX + 16 && mouseY >= itemY && mouseY < itemY + 16) {
            ArrayList<Object> list = new ArrayList<Object>();
            if (displayItem.method_7960()) {
                list.add(CreateLang.translateDirect("gui.threshold_switch.not_attached", new Object[0]));
                list.add(CreateLang.translateDirect("display_link.view_compatible", new Object[0]).method_27692(class_124.field_1063));
                graphics.method_51434(this.field_22793, list, mouseX, mouseY);
                return;
            }
            list.add(displayItem.method_7964());
            if (typeOfCurrentTarget == ThresholdSwitchBlockEntity.ThresholdType.UNSUPPORTED) {
                list.add(CreateLang.translateDirect("gui.threshold_switch.incompatible", new Object[0]).method_27692(class_124.field_1080));
                list.add(CreateLang.translateDirect("display_link.view_compatible", new Object[0]).method_27692(class_124.field_1063));
                graphics.method_51434(this.field_22793, list, mouseX, mouseY);
                return;
            }
            CreateLang.translate("gui.threshold_switch.currently", ThresholdSwitchScreen.format(this.blockEntity, this.blockEntity.currentLevel / valueStep, stacks)).style(class_124.field_1062).addTo(list);
            if (this.blockEntity.currentMinLevel / valueStep == 0) {
                CreateLang.translate("gui.threshold_switch.range_max", ThresholdSwitchScreen.format(this.blockEntity, this.blockEntity.currentMaxLevel / valueStep, stacks)).style(class_124.field_1080).addTo(list);
            } else {
                CreateLang.translate("gui.threshold_switch.range", this.blockEntity.currentMinLevel / valueStep, ThresholdSwitchScreen.format(this.blockEntity, this.blockEntity.currentMaxLevel / valueStep, stacks)).style(class_124.field_1080).addTo(list);
            }
            list.add(CreateLang.translateDirect("display_link.view_compatible", new Object[0]).method_27692(class_124.field_1063));
            graphics.method_51434(this.field_22793, list, mouseX, mouseY);
            return;
        }
        for (boolean power : Iterate.trueAndFalse) {
            int thisTorchY;
            int n = thisTorchY = power ? torchY : torchY + 26;
            if (mouseX < torchX || mouseX >= torchX + 16 || mouseY < thisTorchY || mouseY >= thisTorchY + 16) continue;
            graphics.method_51434(this.field_22793, List.of(CreateLang.translate(power ^ this.blockEntity.isInverted() ? "gui.threshold_switch.power_on_when" : "gui.threshold_switch.power_off_when", new Object[0]).color(AbstractSimiWidget.HEADER_RGB).component()), mouseX, mouseY);
            return;
        }
    }

    public static class_5250 format(ThresholdSwitchBlockEntity be, int value, boolean stacks) {
        class_2586 class_25862;
        ThresholdSwitchBlockEntity.ThresholdType type = be.getTypeOfCurrentTarget();
        if (type == ThresholdSwitchBlockEntity.ThresholdType.CUSTOM && (class_25862 = be.method_10997().method_8321(be.getTargetPos())) instanceof ThresholdSwitchObservable) {
            ThresholdSwitchObservable tso = (ThresholdSwitchObservable)class_25862;
            return tso.format(value);
        }
        String suffix = type == ThresholdSwitchBlockEntity.ThresholdType.ITEM ? (stacks ? "schedule.condition.threshold.stacks" : "schedule.condition.threshold.items") : "schedule.condition.threshold.buckets";
        return CreateLang.text(value + " ").add(CreateLang.translate(suffix, new Object[0])).component();
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (this.lastModification >= 0) {
            ++this.lastModification;
        }
        if (this.lastModification >= 20) {
            this.lastModification = -1;
            this.send(this.blockEntity.isInverted());
        }
        if (this.inStacks == null) {
            return;
        }
        this.updateInputBoxes();
    }

    private void updateInputBoxes() {
        ThresholdSwitchBlockEntity.ThresholdType typeOfCurrentTarget = this.blockEntity.getTypeOfCurrentTarget();
        boolean forItems = typeOfCurrentTarget == ThresholdSwitchBlockEntity.ThresholdType.ITEM;
        int valueStep = this.getValueStep();
        this.inStacks.field_22763 = this.inStacks.field_22764 = forItems;
        this.onAbove.method_25358(forItems ? 48 : 103);
        this.offBelow.method_25358(forItems ? 48 : 103);
        this.onAbove.field_22764 = typeOfCurrentTarget != ThresholdSwitchBlockEntity.ThresholdType.UNSUPPORTED;
        this.offBelow.field_22764 = typeOfCurrentTarget != ThresholdSwitchBlockEntity.ThresholdType.UNSUPPORTED;
        int min = this.blockEntity.currentMinLevel + valueStep;
        int max = this.blockEntity.currentMaxLevel;
        this.onAbove.withRange(min, max + 1);
        int roundedState = class_3532.method_15340((int)(this.onAbove.getState() / valueStep * valueStep), (int)min, (int)max);
        if (roundedState != this.onAbove.getState()) {
            this.onAbove.setState(roundedState);
            this.onAbove.onChanged();
        }
        min = this.blockEntity.currentMinLevel;
        max = this.blockEntity.currentMaxLevel - valueStep;
        this.offBelow.withRange(min, max + 1);
        roundedState = class_3532.method_15340((int)(this.offBelow.getState() / valueStep * valueStep), (int)min, (int)max);
        if (roundedState != this.offBelow.getState()) {
            this.offBelow.setState(roundedState);
            this.offBelow.onChanged();
        }
    }

    private int getValueStep() {
        boolean stacks = this.inStacks.getState() == 1;
        int valueStep = 1;
        if (this.blockEntity.getTypeOfCurrentTarget() == ThresholdSwitchBlockEntity.ThresholdType.FLUID) {
            valueStep = 81000;
        } else if (stacks) {
            valueStep = 64;
        }
        return valueStep;
    }

    public void method_25432() {
        this.send(this.blockEntity.isInverted());
    }

    protected void send(boolean invert) {
        this.field_22787.field_1724.field_3944.method_52787((class_2596)new ConfigureThresholdSwitchPacket(this.blockEntity.method_11016(), this.offBelow.getState(), this.onAbove.getState(), invert, this.inStacks.getState() == 1));
    }
}

