/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.cannon;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.Create;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.element.ScreenElement;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.catnip.lang.FontHelper;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Indicator;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.zurrtum.create.content.schematics.cannon.SchematicannonMenu;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.infrastructure.packet.c2s.ConfigureSchematicannonPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7225;
import net.minecraft.class_768;
import net.minecraft.class_8942;
import net.minecraft.class_9129;

@Environment(value=EnvType.CLIENT)
public class SchematicannonScreen
extends AbstractSimiContainerScreen<SchematicannonMenu> {
    private static final AllGuiTextures BG_BOTTOM = AllGuiTextures.SCHEMATICANNON_BOTTOM;
    private static final AllGuiTextures BG_TOP = AllGuiTextures.SCHEMATICANNON_TOP;
    private final class_2561 listPrinter = CreateLang.translateDirect("gui.schematicannon.listPrinter", new Object[0]);
    private final String _gunpowderLevel = "gui.schematicannon.gunpowderLevel";
    private final String _shotsRemaining = "gui.schematicannon.shotsRemaining";
    private final String _showSettings = "gui.schematicannon.showOptions";
    private final String _shotsRemainingWithBackup = "gui.schematicannon.shotsRemainingWithBackup";
    private final String _slotGunpowder = "gui.schematicannon.slot.gunpowder";
    private final String _slotListPrinter = "gui.schematicannon.slot.listPrinter";
    private final String _slotSchematic = "gui.schematicannon.slot.schematic";
    private final class_2561 optionEnabled = CreateLang.translateDirect("gui.schematicannon.optionEnabled", new Object[0]);
    private final class_2561 optionDisabled = CreateLang.translateDirect("gui.schematicannon.optionDisabled", new Object[0]);
    protected List<Indicator> replaceLevelIndicators;
    protected List<IconButton> replaceLevelButtons;
    protected IconButton skipMissingButton;
    protected Indicator skipMissingIndicator;
    protected IconButton skipBlockEntitiesButton;
    protected Indicator skipBlockEntitiesIndicator;
    protected IconButton playButton;
    protected Indicator playIndicator;
    protected IconButton pauseButton;
    protected Indicator pauseIndicator;
    protected IconButton resetButton;
    protected Indicator resetIndicator;
    private IconButton confirmButton;
    private IconButton showSettingsButton;
    private Indicator showSettingsIndicator;
    private ElementWidget renderedItem;
    protected List<class_339> placementSettingWidgets;
    private List<class_768> extraAreas = Collections.emptyList();

    public SchematicannonScreen(SchematicannonMenu menu, class_1661 inventory, class_2561 title) {
        super(menu, inventory, title);
        this.placementSettingWidgets = new ArrayList<class_339>();
    }

    public static SchematicannonScreen create(class_310 mc, MenuType<SchematicannonBlockEntity> type, int syncId, class_1661 inventory, class_2561 title, class_9129 extraData) {
        SchematicannonBlockEntity entity = (SchematicannonBlockEntity)SchematicannonScreen.getBlockEntity(mc, extraData);
        if (entity == null) {
            return null;
        }
        try (class_8942.class_11340 logging = new class_8942.class_11340(entity.method_71402(), Create.LOGGER);){
            class_11368 view = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)extraData.method_56349(), (class_2487)extraData.method_10798());
            entity.readClient(view);
            SchematicannonScreen schematicannonScreen = (SchematicannonScreen)((Object)type.create(SchematicannonScreen::new, syncId, inventory, title, entity));
            return schematicannonScreen;
        }
    }

    @Override
    protected void method_25426() {
        this.setWindowSize(BG_TOP.getWidth(), BG_TOP.getHeight() + BG_BOTTOM.getHeight() + 2 + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        this.setWindowOffset(-11, 0);
        super.method_25426();
        this.playButton = new IconButton(this.field_2776 + 75, this.field_2800 + 85, AllIcons.I_PLAY);
        this.playButton.withCallback(() -> this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.PLAY, true));
        this.playIndicator = new Indicator(this.field_2776 + 75, this.field_2800 + 79, class_5244.field_39003);
        this.pauseButton = new IconButton(this.field_2776 + 93, this.field_2800 + 85, AllIcons.I_PAUSE);
        this.pauseButton.withCallback(() -> this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.PAUSE, true));
        this.pauseIndicator = new Indicator(this.field_2776 + 93, this.field_2800 + 79, class_5244.field_39003);
        this.resetButton = new IconButton(this.field_2776 + 111, this.field_2800 + 85, AllIcons.I_STOP);
        this.resetButton.withCallback(() -> this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.STOP, true));
        this.resetIndicator = new Indicator(this.field_2776 + 111, this.field_2800 + 79, class_5244.field_39003);
        this.resetIndicator.state = Indicator.State.RED;
        this.addRenderableWidgets(new AbstractSimiWidget[]{this.playButton, this.playIndicator, this.pauseButton, this.pauseIndicator, this.resetButton, this.resetIndicator});
        this.confirmButton = new IconButton(this.field_2776 + 180, this.field_2800 + 111, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.field_22787.field_1724.method_7346());
        this.method_37063(this.confirmButton);
        this.showSettingsButton = new IconButton(this.field_2776 + 8, this.field_2800 + 111, AllIcons.I_PLACEMENT_SETTINGS);
        this.showSettingsButton.withCallback(() -> {
            this.showSettingsIndicator.state = this.placementSettingsHidden() ? Indicator.State.GREEN : Indicator.State.OFF;
            this.initPlacementSettings();
        });
        this.showSettingsButton.setToolTip((class_2561)CreateLang.translateDirect("gui.schematicannon.showOptions", new Object[0]));
        this.method_37063(this.showSettingsButton);
        this.showSettingsIndicator = new Indicator(this.field_2776 + 9, this.field_2800 + 111, class_5244.field_39003);
        this.extraAreas = ImmutableList.of((Object)new class_768(this.field_2776 + BG_TOP.getWidth(), this.field_2800 + BG_TOP.getHeight() + BG_BOTTOM.getHeight() - 62, 84, 92));
        this.renderedItem = new ElementWidget(this.field_2776 + BG_TOP.getWidth() - 14, this.field_2800 + BG_TOP.getHeight() + BG_BOTTOM.getHeight() - 62).showingElement(GuiGameElement.of(AllItems.SCHEMATICANNON.method_7854()).scale(5.0f).padding(28));
        this.method_37063(this.renderedItem);
        this.method_25393();
    }

    public void method_25419() {
        super.method_25419();
        this.renderedItem.getRenderElement().clear();
    }

    private void initPlacementSettings() {
        this.removeWidgets(this.placementSettingWidgets);
        this.placementSettingWidgets.clear();
        if (this.placementSettingsHidden()) {
            return;
        }
        this.replaceLevelButtons = new ArrayList<IconButton>(4);
        this.replaceLevelIndicators = new ArrayList<Indicator>(4);
        ImmutableList icons = ImmutableList.of((Object)AllIcons.I_DONT_REPLACE, (Object)AllIcons.I_REPLACE_SOLID, (Object)AllIcons.I_REPLACE_ANY, (Object)AllIcons.I_REPLACE_EMPTY);
        ImmutableList toolTips = ImmutableList.of((Object)CreateLang.translateDirect("gui.schematicannon.option.dontReplaceSolid", new Object[0]), (Object)CreateLang.translateDirect("gui.schematicannon.option.replaceWithSolid", new Object[0]), (Object)CreateLang.translateDirect("gui.schematicannon.option.replaceWithAny", new Object[0]), (Object)CreateLang.translateDirect("gui.schematicannon.option.replaceWithEmpty", new Object[0]));
        for (int i = 0; i < 4; ++i) {
            this.replaceLevelIndicators.add(new Indicator(this.field_2776 + 33 + i * 18, this.field_2800 + 111, class_5244.field_39003));
            IconButton replaceLevelButton = new IconButton(this.field_2776 + 33 + i * 18, this.field_2800 + 111, (ScreenElement)icons.get(i));
            int replaceMode = i;
            replaceLevelButton.withCallback(() -> {
                if (((SchematicannonBlockEntity)((SchematicannonMenu)this.field_2797).contentHolder).replaceMode != replaceMode) {
                    this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.values()[replaceMode], true);
                }
            });
            replaceLevelButton.setToolTip((class_2561)toolTips.get(i));
            this.replaceLevelButtons.add(replaceLevelButton);
        }
        this.placementSettingWidgets.addAll(this.replaceLevelButtons);
        this.skipMissingButton = new IconButton(this.field_2776 + 111, this.field_2800 + 111, AllIcons.I_SKIP_MISSING);
        this.skipMissingButton.withCallback(() -> this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.SKIP_MISSING, !((SchematicannonBlockEntity)((SchematicannonMenu)this.field_2797).contentHolder).skipMissing));
        this.skipMissingButton.setToolTip((class_2561)CreateLang.translateDirect("gui.schematicannon.option.skipMissing", new Object[0]));
        this.skipMissingIndicator = new Indicator(this.field_2776 + 111, this.field_2800 + 111, class_5244.field_39003);
        Collections.addAll(this.placementSettingWidgets, this.skipMissingButton);
        this.skipBlockEntitiesButton = new IconButton(this.field_2776 + 135, this.field_2800 + 111, AllIcons.I_SKIP_BLOCK_ENTITIES);
        this.skipBlockEntitiesButton.withCallback(() -> this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.SKIP_BLOCK_ENTITIES, !((SchematicannonBlockEntity)((SchematicannonMenu)this.field_2797).contentHolder).replaceBlockEntities));
        this.skipBlockEntitiesButton.setToolTip((class_2561)CreateLang.translateDirect("gui.schematicannon.option.skipBlockEntities", new Object[0]));
        this.skipBlockEntitiesIndicator = new Indicator(this.field_2776 + 129, this.field_2800 + 111, class_5244.field_39003);
        Collections.addAll(this.placementSettingWidgets, this.skipBlockEntitiesButton);
        this.addRenderableWidgets(this.placementSettingWidgets);
    }

    protected boolean placementSettingsHidden() {
        return this.showSettingsIndicator.state == Indicator.State.OFF;
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        SchematicannonBlockEntity be = (SchematicannonBlockEntity)((SchematicannonMenu)this.field_2797).contentHolder;
        if (!this.placementSettingsHidden()) {
            for (int replaceMode = 0; replaceMode < this.replaceLevelButtons.size(); ++replaceMode) {
                this.replaceLevelButtons.get((int)replaceMode).green = replaceMode == be.replaceMode;
                this.replaceLevelIndicators.get((int)replaceMode).state = replaceMode == be.replaceMode ? Indicator.State.ON : Indicator.State.OFF;
            }
            this.skipMissingButton.green = be.skipMissing;
            this.skipBlockEntitiesButton.green = !be.replaceBlockEntities;
        }
        this.playIndicator.state = Indicator.State.OFF;
        this.pauseIndicator.state = Indicator.State.OFF;
        this.resetIndicator.state = Indicator.State.OFF;
        switch (be.state) {
            case PAUSED: {
                this.pauseIndicator.state = Indicator.State.YELLOW;
                this.playButton.field_22763 = true;
                this.pauseButton.field_22763 = false;
                this.resetButton.field_22763 = true;
                break;
            }
            case RUNNING: {
                this.playIndicator.state = Indicator.State.GREEN;
                this.playButton.field_22763 = false;
                this.pauseButton.field_22763 = true;
                this.resetButton.field_22763 = true;
                break;
            }
            case STOPPED: {
                this.resetIndicator.state = Indicator.State.RED;
                this.playButton.field_22763 = true;
                this.pauseButton.field_22763 = false;
                this.resetButton.field_22763 = false;
                break;
            }
        }
        this.handleTooltips();
    }

    protected void handleTooltips() {
        if (this.placementSettingsHidden()) {
            return;
        }
        boolean hasShiftDown = AllKeys.hasShiftDown();
        for (class_339 w : this.placementSettingWidgets) {
            IconButton button;
            if (!(w instanceof IconButton) || (button = (IconButton)w).getToolTip().isEmpty()) continue;
            button.setToolTip(button.getToolTip().getFirst());
            button.getToolTip().add((class_2561)TooltipHelper.holdShift(FontHelper.Palette.BLUE, hasShiftDown));
        }
        if (hasShiftDown) {
            this.fillToolTip(this.skipMissingButton, this.skipMissingIndicator, "skipMissing");
            this.fillToolTip(this.skipBlockEntitiesButton, this.skipBlockEntitiesIndicator, "skipBlockEntities");
            this.fillToolTip(this.replaceLevelButtons.get(0), this.replaceLevelIndicators.get(0), "dontReplaceSolid");
            this.fillToolTip(this.replaceLevelButtons.get(1), this.replaceLevelIndicators.get(1), "replaceWithSolid");
            this.fillToolTip(this.replaceLevelButtons.get(2), this.replaceLevelIndicators.get(2), "replaceWithAny");
            this.fillToolTip(this.replaceLevelButtons.get(3), this.replaceLevelIndicators.get(3), "replaceWithEmpty");
        }
    }

    private void fillToolTip(IconButton button, Indicator indicator, String tooltipKey) {
        if (!button.method_49606()) {
            return;
        }
        boolean enabled = button.green;
        List<class_2561> tip = button.getToolTip();
        tip.add((class_2561)(enabled ? this.optionEnabled : this.optionDisabled).method_27662().method_27692(enabled ? class_124.field_1077 : class_124.field_1061));
        tip.addAll(TooltipHelper.cutTextComponent((class_2561)CreateLang.translateDirect("gui.schematicannon.option." + tooltipKey + ".description", new Object[0]), FontHelper.Palette.ALL_GRAY));
    }

    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.getWidth());
        int invY = this.field_2800 + BG_TOP.getHeight() + BG_BOTTOM.getHeight() + 2;
        this.renderPlayerInventory(graphics, invX, invY);
        BG_TOP.render(graphics, this.field_2776, this.field_2800);
        BG_BOTTOM.render(graphics, this.field_2776, this.field_2800 + BG_TOP.getHeight());
        AllGuiTextures.SCHEMATIC_TITLE.render(graphics, this.field_2776, this.field_2800 - 2);
        SchematicannonBlockEntity be = (SchematicannonBlockEntity)((SchematicannonMenu)this.field_2797).contentHolder;
        this.renderPrintingProgress(graphics, this.field_2776, this.field_2800, be.schematicProgress);
        float amount = (float)be.remainingFuel / (float)be.getShotsPerGunpowder();
        this.renderFuelBar(graphics, this.field_2776, this.field_2800, amount);
        this.renderChecklistPrinterProgress(graphics, this.field_2776, this.field_2800, be.bookPrintingProgress);
        if (!be.inventory.method_5438(0).method_7960()) {
            this.renderBlueprintHighlight(graphics, this.field_2776, this.field_2800);
        }
        graphics.method_51439(this.field_22793, this.field_22785, this.field_2776 + (BG_TOP.getWidth() - 8 - this.field_22793.method_27525((class_5348)this.field_22785)) / 2, this.field_2800 + 2, -11513776, false);
        class_5250 msg = CreateLang.translateDirect("schematicannon.status." + be.statusMsg, new Object[0]);
        int stringWidth = this.field_22793.method_27525((class_5348)msg);
        if (be.missingItem != null) {
            stringWidth += 16;
            graphics.method_51427(be.missingItem, this.field_2776 + 128, this.field_2800 + 49);
        }
        graphics.method_51439(this.field_22793, (class_2561)msg, this.field_2776 + 103 - stringWidth / 2, this.field_2800 + 53, -2232577, true);
        if ("schematicErrored".equals(be.statusMsg)) {
            graphics.method_51439(this.field_22793, (class_2561)CreateLang.translateDirect("schematicannon.status.schematicErroredCheckLogs", new Object[0]), this.field_2776 + 103 - stringWidth / 2, this.field_2800 + 65, -2232577, true);
        }
    }

    protected void renderBlueprintHighlight(class_332 graphics, int x, int y) {
        AllGuiTextures.SCHEMATICANNON_HIGHLIGHT.render(graphics, x + 10, y + 60);
    }

    protected void renderPrintingProgress(class_332 graphics, int x, int y, float progress) {
        progress = Math.min(progress, 1.0f);
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_PROGRESS;
        graphics.method_25290(class_10799.field_56883, sprite.location, x + 44, y + 64, (float)sprite.getStartX(), (float)sprite.getStartY(), (int)((float)sprite.getWidth() * progress), sprite.getHeight(), 256, 256);
    }

    protected void renderChecklistPrinterProgress(class_332 graphics, int x, int y, float progress) {
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_CHECKLIST_PROGRESS;
        graphics.method_25290(class_10799.field_56883, sprite.location, x + 154, y + 20, (float)sprite.getStartX(), (float)sprite.getStartY(), (int)((float)sprite.getWidth() * progress), sprite.getHeight(), 256, 256);
    }

    protected void renderFuelBar(class_332 graphics, int x, int y, float amount) {
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_FUEL;
        if (((SchematicannonBlockEntity)((SchematicannonMenu)this.field_2797).contentHolder).hasCreativeCrate) {
            AllGuiTextures.SCHEMATICANNON_FUEL_CREATIVE.render(graphics, x + 36, y + 19);
            return;
        }
        graphics.method_25290(class_10799.field_56883, sprite.location, x + 36, y + 19, (float)sprite.getStartX(), (float)sprite.getStartY(), (int)((float)sprite.getWidth() * amount), sprite.getHeight(), 256, 256);
    }

    @Override
    protected void renderForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        SchematicannonBlockEntity be = (SchematicannonBlockEntity)((SchematicannonMenu)this.field_2797).contentHolder;
        int fuelX = this.field_2776 + 36;
        int fuelY = this.field_2800 + 19;
        if (mouseX >= fuelX && mouseY >= fuelY && mouseX <= fuelX + AllGuiTextures.SCHEMATICANNON_FUEL.getWidth() && mouseY <= fuelY + AllGuiTextures.SCHEMATICANNON_FUEL.getHeight()) {
            List<class_2561> tooltip = this.getFuelLevelTooltip(be);
            graphics.method_51434(this.field_22793, tooltip, mouseX, mouseY);
        }
        if (this.field_2787 != null && !this.field_2787.method_7681()) {
            String tooltipKey;
            switch (this.field_2787.field_7874) {
                case 0: {
                    String string = "gui.schematicannon.slot.schematic";
                    break;
                }
                case 2: {
                    String string = "gui.schematicannon.slot.listPrinter";
                    break;
                }
                case 4: {
                    String string = "gui.schematicannon.slot.gunpowder";
                    break;
                }
                default: {
                    String string = tooltipKey = null;
                }
            }
            if (tooltipKey != null) {
                graphics.method_51434(this.field_22793, TooltipHelper.cutTextComponent((class_2561)CreateLang.translateDirect(tooltipKey, new Object[0]), FontHelper.Palette.GRAY_AND_BLUE), mouseX, mouseY);
            }
        }
        if (be.missingItem != null) {
            int missingBlockX = this.field_2776 + 128;
            int missingBlockY = this.field_2800 + 49;
            if (mouseX >= missingBlockX && mouseY >= missingBlockY && mouseX <= missingBlockX + 16 && mouseY <= missingBlockY + 16) {
                graphics.method_51446(this.field_22793, be.missingItem, mouseX, mouseY);
            }
        }
        int paperX = this.field_2776 + 112;
        int paperY = this.field_2800 + 19;
        if (mouseX >= paperX && mouseY >= paperY && mouseX <= paperX + 16 && mouseY <= paperY + 16) {
            graphics.method_51438(this.field_22793, this.listPrinter, mouseX, mouseY);
        }
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
    }

    protected List<class_2561> getFuelLevelTooltip(SchematicannonBlockEntity be) {
        int shotsLeft = be.remainingFuel;
        int shotsLeftWithItems = shotsLeft + be.inventory.method_5438(4).method_7947() * be.getShotsPerGunpowder();
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        if (be.hasCreativeCrate) {
            tooltip.add((class_2561)CreateLang.translateDirect("gui.schematicannon.gunpowderLevel", "100"));
            tooltip.add((class_2561)class_2561.method_43470((String)"(").method_10852(AllItems.CREATIVE_CRATE.method_63680()).method_27693(")").method_27692(class_124.field_1064));
            return tooltip;
        }
        int fillPercent = (int)((float)be.remainingFuel / (float)be.getShotsPerGunpowder() * 100.0f);
        tooltip.add((class_2561)CreateLang.translateDirect("gui.schematicannon.gunpowderLevel", fillPercent));
        tooltip.add((class_2561)CreateLang.translateDirect("gui.schematicannon.shotsRemaining", class_2561.method_43470((String)Integer.toString(shotsLeft)).method_27692(class_124.field_1078)).method_27692(class_124.field_1080));
        if (shotsLeftWithItems != shotsLeft) {
            tooltip.add((class_2561)CreateLang.translateDirect("gui.schematicannon.shotsRemainingWithBackup", class_2561.method_43470((String)Integer.toString(shotsLeftWithItems)).method_27692(class_124.field_1078)).method_27692(class_124.field_1080));
        }
        return tooltip;
    }

    protected void sendOptionUpdate(ConfigureSchematicannonPacket.Option option, boolean set) {
        this.field_22787.field_1724.field_3944.method_52787((class_2596)new ConfigureSchematicannonPacket(option, set));
    }

    @Override
    public List<class_768> getExtraAreas() {
        return this.extraAreas;
    }
}

