/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.signal;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllTrackRenders;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderer;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.TickableVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleTickableVisual;
import com.zurrtum.create.content.trains.signal.SignalBlockEntity;
import com.zurrtum.create.content.trains.signal.SignalBoundary;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SignalVisual
extends AbstractBlockEntityVisual<SignalBlockEntity>
implements SimpleTickableVisual {
    private final TransformedInstance signalLight;
    private final TransformedInstance signalOverlay;
    private boolean previousIsRedLight;
    private SignalBlockEntity.OverlayState previousOverlayState;

    public SignalVisual(VisualizationContext ctx, SignalBlockEntity blockEntity, float partialTick) {
        super(ctx, blockEntity, partialTick);
        this.signalLight = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.SIGNAL_OFF)).createInstance();
        this.signalOverlay = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.TRACK_SIGNAL_OVERLAY)).createInstance();
        this.setupVisual();
    }

    @Override
    public void tick(TickableVisual.Context context) {
        this.setupVisual();
    }

    @Override
    public void updateLight(float partialTick) {
        this.relight(this.signalLight, this.signalOverlay);
    }

    @Override
    protected void _delete() {
        this.signalLight.delete();
        this.signalOverlay.delete();
    }

    @Override
    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept(this.signalLight);
    }

    private void setupVisual() {
        ITrackBlock trackBlock;
        class_2680 trackState;
        class_1937 level;
        class_2338 targetPosition;
        TrackTargetingBehaviour<SignalBoundary> target;
        SignalBlockEntity.OverlayState overlayState;
        block10: {
            block9: {
                float renderTime;
                SignalBlockEntity.SignalState signalState = ((SignalBlockEntity)this.blockEntity).getState();
                boolean isRedLight = signalState.isRedLight(renderTime = AnimationTickHolder.getRenderTime((class_1936)((SignalBlockEntity)this.blockEntity).method_10997()));
                if (isRedLight != this.previousIsRedLight) {
                    PartialModel partial = isRedLight ? AllPartialModels.SIGNAL_ON : AllPartialModels.SIGNAL_OFF;
                    this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(partial)).stealInstance(this.signalLight);
                }
                this.signalLight.setIdentityTransform().translate((class_2382)this.getVisualPosition());
                if (isRedLight) {
                    this.signalLight.light(240);
                }
                this.signalLight.setChanged();
                this.previousIsRedLight = isRedLight;
                overlayState = ((SignalBlockEntity)this.blockEntity).getOverlay();
                target = ((SignalBlockEntity)this.blockEntity).edgePoint;
                targetPosition = target.getGlobalPosition();
                level = ((SignalBlockEntity)this.blockEntity).method_10997();
                trackState = level.method_8320(targetPosition);
                class_2248 block = trackState.method_26204();
                if (!(block instanceof ITrackBlock)) break block9;
                trackBlock = (ITrackBlock)block;
                if (overlayState != SignalBlockEntity.OverlayState.SKIP) break block10;
            }
            this.previousOverlayState = null;
            this.signalOverlay.setZeroTransform().setChanged();
            return;
        }
        if (overlayState != this.previousOverlayState) {
            PartialModel partial;
            TrackTargetingBehaviour.RenderedTrackOverlayType type;
            this.previousOverlayState = overlayState;
            if (overlayState == SignalBlockEntity.OverlayState.DUAL) {
                type = TrackTargetingBehaviour.RenderedTrackOverlayType.DUAL_SIGNAL;
                partial = AllPartialModels.TRACK_SIGNAL_DUAL_OVERLAY;
            } else {
                type = TrackTargetingBehaviour.RenderedTrackOverlayType.SIGNAL;
                partial = AllPartialModels.TRACK_SIGNAL_OVERLAY;
            }
            this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(partial)).stealInstance(this.signalOverlay);
            this.signalOverlay.setIdentityTransform().translate((class_2382)targetPosition.method_10059(this.renderOrigin()));
            TrackBlockRenderer renderer = AllTrackRenders.get(trackBlock);
            if (renderer != null) {
                renderer.prepareTrackOverlay(this.signalOverlay, (class_1922)level, targetPosition, trackState, target.getTargetBezier(), target.getTargetDirection(), type);
            }
            this.signalOverlay.setChanged();
        }
    }
}

