/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine;

import com.zurrtum.create.client.flywheel.api.backend.Engine;
import com.zurrtum.create.client.flywheel.api.backend.RenderContext;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.InstanceType;
import com.zurrtum.create.client.flywheel.api.instance.Instancer;
import com.zurrtum.create.client.flywheel.api.instance.InstancerProvider;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.task.Plan;
import com.zurrtum.create.client.flywheel.api.visualization.VisualEmbedding;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.backend.FlwBackend;
import com.zurrtum.create.client.flywheel.backend.engine.AbstractInstancer;
import com.zurrtum.create.client.flywheel.backend.engine.DrawManager;
import com.zurrtum.create.client.flywheel.backend.engine.InstancerProviderImpl;
import com.zurrtum.create.client.flywheel.backend.engine.LightStorage;
import com.zurrtum.create.client.flywheel.backend.engine.embed.EmbeddedEnvironment;
import com.zurrtum.create.client.flywheel.backend.engine.embed.Environment;
import com.zurrtum.create.client.flywheel.backend.engine.embed.EnvironmentStorage;
import com.zurrtum.create.client.flywheel.backend.engine.uniform.Uniforms;
import com.zurrtum.create.client.flywheel.backend.gl.GlStateTracker;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1936;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_4076;
import net.minecraft.class_4184;

@net.fabricmc.api.Environment(value=EnvType.CLIENT)
public class EngineImpl
implements Engine {
    private final DrawManager<? extends AbstractInstancer<?>> drawManager;
    private final int sqrMaxOriginDistance;
    private final EnvironmentStorage environmentStorage;
    private final LightStorage lightStorage;
    private class_2338 renderOrigin = class_2338.field_10980;

    public EngineImpl(class_1936 level, DrawManager<? extends AbstractInstancer<?>> drawManager, int maxOriginDistance) {
        this.drawManager = drawManager;
        this.sqrMaxOriginDistance = maxOriginDistance * maxOriginDistance;
        this.environmentStorage = new EnvironmentStorage();
        this.lightStorage = new LightStorage(level);
    }

    @Override
    public VisualizationContext createVisualizationContext() {
        return new VisualizationContextImpl();
    }

    @Override
    public Plan<RenderContext> createFramePlan() {
        return this.drawManager.createFramePlan().and(this.lightStorage.createFramePlan());
    }

    @Override
    public class_2382 renderOrigin() {
        return this.renderOrigin;
    }

    @Override
    public boolean updateRenderOrigin(class_4184 camera) {
        double dz;
        double dy;
        class_243 cameraPos = camera.method_19326();
        double dx = (double)this.renderOrigin.method_10263() - cameraPos.field_1352;
        double distanceSqr = dx * dx + (dy = (double)this.renderOrigin.method_10264() - cameraPos.field_1351) * dy + (dz = (double)this.renderOrigin.method_10260() - cameraPos.field_1350) * dz;
        if (distanceSqr <= (double)this.sqrMaxOriginDistance) {
            return false;
        }
        this.renderOrigin = class_2338.method_49638((class_2374)cameraPos);
        this.drawManager.onRenderOriginChanged();
        return true;
    }

    @Override
    public void lightSections(LongSet sections) {
        this.lightStorage.sections(sections);
    }

    @Override
    public void onLightUpdate(class_4076 sectionPos, class_1944 layer) {
        this.lightStorage.onLightUpdate(sectionPos.method_18694());
    }

    @Override
    public void render(RenderContext context) {
        try (GlStateTracker.State state = GlStateTracker.getRestoreState();){
            Uniforms.update(context);
            this.environmentStorage.flush();
            this.drawManager.render(this.lightStorage, this.environmentStorage);
        }
        catch (Exception e) {
            FlwBackend.LOGGER.error("Falling back", (Throwable)e);
            this.triggerFallback();
        }
    }

    @Override
    public void renderCrumbling(RenderContext context, List<Engine.CrumblingBlock> crumblingBlocks) {
        try (GlStateTracker.State state = GlStateTracker.getRestoreState();){
            this.drawManager.renderCrumbling(crumblingBlocks);
        }
        catch (Exception e) {
            FlwBackend.LOGGER.error("Falling back", (Throwable)e);
            this.triggerFallback();
        }
    }

    @Override
    public void delete() {
        this.drawManager.delete();
        this.lightStorage.delete();
        this.environmentStorage.delete();
    }

    private void triggerFallback() {
        this.drawManager.triggerFallback();
    }

    public <I extends Instance> Instancer<I> instancer(Environment environment, InstanceType<I> type, Model model, int bias) {
        return this.drawManager.getInstancer(environment, type, model, bias);
    }

    public EnvironmentStorage environmentStorage() {
        return this.environmentStorage;
    }

    public LightStorage lightStorage() {
        return this.lightStorage;
    }

    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    private class VisualizationContextImpl
    implements VisualizationContext {
        private final InstancerProviderImpl instancerProvider;

        public VisualizationContextImpl() {
            this.instancerProvider = new InstancerProviderImpl(EngineImpl.this);
        }

        @Override
        public InstancerProvider instancerProvider() {
            return this.instancerProvider;
        }

        @Override
        public class_2382 renderOrigin() {
            return EngineImpl.this.renderOrigin();
        }

        @Override
        public VisualEmbedding createEmbedding(class_2382 renderOrigin) {
            EmbeddedEnvironment out = new EmbeddedEnvironment(EngineImpl.this, renderOrigin);
            EngineImpl.this.environmentStorage.track(out);
            return out;
        }
    }
}

