/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.particle;

import com.zurrtum.create.AllParticleTypes;
import com.zurrtum.create.client.content.equipment.bell.SoulPulseEffect;
import com.zurrtum.create.client.infrastructure.particle.CustomRotationParticle;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11944;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2400;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import org.joml.Quaternionf;

@Environment(value=EnvType.CLIENT)
public class SoulParticle
extends CustomRotationParticle {
    protected int startTicks;
    protected int endTicks;
    protected int numLoops;
    protected int firstStartFrame = 0;
    protected int startFrames = 17;
    protected int firstLoopFrame = 17;
    protected int loopFrames = 16;
    protected int firstEndFrame = 33;
    protected int endFrames = 20;
    protected AnimationStage animationStage;
    protected int totalFrames = 53;
    protected int ticksPerFrame = 2;
    protected boolean isPerimeter = false;
    protected boolean isExpandingPerimeter = false;
    protected boolean isVisible = true;
    protected int perimeterFrames = 8;

    public SoulParticle(class_2400 type, class_4002 spriteSet, class_638 worldIn, double x, double y, double z, double vx, double vy, double vz, class_5819 random) {
        super(worldIn, x, y, z, spriteSet, 0.0f);
        this.field_17867 = 0.5f;
        this.method_3080(this.field_17867, this.field_17867);
        this.loopLength = this.loopFrames + (int)(random.method_43057() * 5.0f - 4.0f);
        this.startTicks = this.startFrames + (int)(random.method_43057() * 5.0f - 4.0f);
        this.endTicks = this.endFrames + (int)(random.method_43057() * 5.0f - 4.0f);
        this.numLoops = (int)(1.0f + random.method_43057() * 2.0f);
        this.setFrame(0);
        this.field_21507 = true;
        this.mirror = random.method_43056();
        this.isExpandingPerimeter = type == AllParticleTypes.SOUL_EXPANDING_PERIMETER;
        this.isPerimeter = type == AllParticleTypes.SOUL_PERIMETER || this.isExpandingPerimeter;
        AnimationStage animationStage = this.animationStage = !this.isPerimeter ? new StartAnimation(this) : new PerimeterAnimation(this);
        if (this.isPerimeter) {
            this.field_3838 = y -= 0.4921875;
            this.totalFrames = this.perimeterFrames;
            this.isVisible = false;
        }
    }

    public void method_3070() {
        this.animationStage.tick();
        this.animationStage = this.animationStage.getNext();
        class_2338 pos = class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871);
        if (this.animationStage == null) {
            this.method_3085();
        }
        if (!SoulPulseEffect.isDark((class_1937)this.field_3851, pos)) {
            this.isVisible = true;
            if (!this.isPerimeter) {
                this.method_3085();
            }
        } else if (this.isPerimeter) {
            this.isVisible = false;
        }
    }

    @Override
    public void method_3074(class_11944 submittable, class_4184 camera, float partialTicks) {
        if (!this.isVisible) {
            return;
        }
        super.method_3074(submittable, camera, partialTicks);
    }

    public void setFrame(int frame) {
        if (frame >= 0 && frame < this.totalFrames) {
            this.method_74307(this.field_17866.method_18138(frame, this.totalFrames));
        }
    }

    @Override
    public Quaternionf getCustomRotation(class_4184 camera, float partialTicks) {
        if (this.isPerimeter) {
            return class_7833.field_40714.rotationDegrees(-90.0f);
        }
        Quaternionf rotation = camera.method_23767();
        return new Quaternionf(0.0f, rotation.y, 0.0f, rotation.w);
    }

    @Environment(value=EnvType.CLIENT)
    public static class StartAnimation
    extends AnimationStage {
        public StartAnimation(SoulParticle particle) {
            super(particle);
        }

        @Override
        public void tick() {
            super.tick();
            this.particle.setFrame(this.particle.firstStartFrame + (int)(this.getAnimAge() / (float)this.particle.startTicks * (float)this.particle.startFrames));
        }

        @Override
        public AnimationStage getNext() {
            if (this.animAge < this.particle.startTicks) {
                return this;
            }
            return new LoopAnimation(this.particle);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class PerimeterAnimation
    extends AnimationStage {
        public PerimeterAnimation(SoulParticle particle) {
            super(particle);
        }

        @Override
        public void tick() {
            super.tick();
            this.particle.setFrame((int)this.getAnimAge() % this.particle.perimeterFrames);
        }

        @Override
        public AnimationStage getNext() {
            if (this.animAge < (this.particle.isExpandingPerimeter ? 8 : this.particle.startTicks + this.particle.endTicks + this.particle.numLoops * this.particle.loopLength)) {
                return this;
            }
            return null;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class AnimationStage {
        protected final SoulParticle particle;
        protected int ticks;
        protected int animAge;

        public AnimationStage(SoulParticle particle) {
            this.particle = particle;
        }

        public void tick() {
            ++this.ticks;
            if (this.ticks % this.particle.ticksPerFrame == 0) {
                ++this.animAge;
            }
        }

        public float getAnimAge() {
            return this.animAge;
        }

        public abstract AnimationStage getNext();
    }

    @Environment(value=EnvType.CLIENT)
    public static class EndAnimation
    extends AnimationStage {
        public EndAnimation(SoulParticle particle) {
            super(particle);
        }

        @Override
        public void tick() {
            super.tick();
            this.particle.setFrame(this.particle.firstEndFrame + (int)(this.getAnimAge() / (float)this.particle.endTicks * (float)this.particle.endFrames));
        }

        @Override
        public AnimationStage getNext() {
            if (this.animAge < this.particle.endTicks) {
                return this;
            }
            return null;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class LoopAnimation
    extends AnimationStage {
        int loops;

        public LoopAnimation(SoulParticle particle) {
            super(particle);
        }

        @Override
        public void tick() {
            super.tick();
            int loopTick = this.getLoopTick();
            if (loopTick == 0) {
                ++this.loops;
            }
            this.particle.setFrame(this.particle.firstLoopFrame + loopTick);
        }

        private int getLoopTick() {
            return this.animAge % this.particle.loopFrames;
        }

        @Override
        public AnimationStage getNext() {
            if (this.loops <= this.particle.numLoops) {
                return this;
            }
            return new EndAnimation(this.particle);
        }
    }
}

