/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.visuals;

import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.part.InstanceTree;
import com.zurrtum.create.client.flywheel.lib.model.part.ModelTrees;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import net.minecraft.class_3721;
import net.minecraft.class_3880;
import net.minecraft.class_5602;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public class BellVisual
extends AbstractBlockEntityVisual<class_3721>
implements SimpleDynamicVisual {
    private static final Material MATERIAL = SimpleMaterial.builder().mipmap(false).build();
    private final InstanceTree instances = InstanceTree.create(this.instancerProvider(), ModelTrees.of(class_5602.field_27683, class_3880.field_17145, MATERIAL));
    private final InstanceTree bellBody = this.instances.childOrThrow("bell_body");
    private final Matrix4fc initialPose;
    private boolean wasShaking = false;

    public BellVisual(VisualizationContext ctx, class_3721 blockEntity, float partialTick) {
        super(ctx, blockEntity, partialTick);
        class_2338 visualPos = this.getVisualPosition();
        this.initialPose = new Matrix4f().translate((float)visualPos.method_10263(), (float)visualPos.method_10264(), (float)visualPos.method_10260());
        this.updateRotation(partialTick);
    }

    @Override
    public void beginFrame(DynamicVisual.Context context) {
        if (this.doDistanceLimitThisFrame(context) || !this.isVisible(context.frustum())) {
            return;
        }
        this.updateRotation(context.partialTick());
    }

    private void updateRotation(float partialTick) {
        float xRot = 0.0f;
        float zRot = 0.0f;
        if (((class_3721)this.blockEntity).field_17096) {
            float ringTime = (float)((class_3721)this.blockEntity).field_17095 + partialTick;
            float angle = class_3532.method_15374((float)(ringTime / (float)Math.PI)) / (4.0f + ringTime / 3.0f);
            switch (((class_3721)this.blockEntity).field_17097) {
                case field_11043: {
                    xRot = -angle;
                    break;
                }
                case field_11035: {
                    xRot = angle;
                    break;
                }
                case field_11034: {
                    zRot = -angle;
                    break;
                }
                case field_11039: {
                    zRot = angle;
                }
            }
            this.wasShaking = true;
        } else if (this.wasShaking) {
            this.wasShaking = false;
        }
        this.bellBody.xRot(xRot);
        this.bellBody.zRot(zRot);
        this.instances.updateInstancesStatic(this.initialPose);
    }

    @Override
    public void updateLight(float partialTick) {
        int packedLight = this.computePackedLight();
        this.instances.traverse(instance -> instance.light(packedLight).setChanged());
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        this.instances.traverse(consumer);
    }

    @Override
    protected void _delete() {
        this.instances.delete();
    }
}

