/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.mounted;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.minecart.CouplingHandler;
import com.zurrtum.create.content.contraptions.minecart.capability.MinecartController;
import com.zurrtum.create.content.contraptions.mounted.CartAssemblerBlock;
import com.zurrtum.create.content.contraptions.mounted.MountedContraption;
import com.zurrtum.create.content.redstone.rail.ControllerRailBlock;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_1696;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_7225;
import net.minecraft.class_8942;

public class CartAssemblerBlockEntity
extends SmartBlockEntity {
    private static final int assemblyCooldown = 8;
    protected ServerScrollOptionBehaviour<CartMovementMode> movementMode;
    private int ticksSinceMinecartUpdate = 8;
    protected AssemblyException lastException;
    protected class_1688 cartToAssemble;

    public CartAssemblerBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.CART_ASSEMBLER, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.ticksSinceMinecartUpdate < 8) {
            ++this.ticksSinceMinecartUpdate;
        }
        this.tryAssemble(this.cartToAssemble);
        this.cartToAssemble = null;
    }

    public void tryAssemble(class_1688 cart) {
        if (cart == null) {
            return;
        }
        if (!this.isMinecartUpdateValid()) {
            return;
        }
        this.resetTicksSinceMinecartUpdate();
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        if (!state.method_27852((class_2248)AllBlocks.CART_ASSEMBLER)) {
            return;
        }
        CartAssemblerBlock.CartAssemblerAction action = CartAssemblerBlock.getActionForCart(state, cart);
        if (action.shouldAssemble()) {
            this.assemble(this.field_11863, this.field_11867, cart);
        }
        if (action.shouldDisassemble()) {
            this.disassemble(this.field_11863, this.field_11867, cart);
        }
        if (action == CartAssemblerBlock.CartAssemblerAction.ASSEMBLE_ACCELERATE && cart.method_18798().method_1033() > 0.0078125) {
            class_2350 facing = cart.method_5755();
            class_2768 railShape = (class_2768)state.method_11654(CartAssemblerBlock.RAIL_SHAPE);
            for (class_2350 d : Iterate.directionsInAxis(railShape == class_2768.field_12674 ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051)) {
                if (!this.field_11863.method_8320(this.field_11867.method_10093(d)).method_26212((class_1922)this.field_11863, this.field_11867.method_10093(d))) continue;
                facing = d.method_10153();
            }
            double speed = cart.method_7504((class_3218)this.field_11863);
            cart.method_18800((double)facing.method_10148() * speed, (double)facing.method_10164() * speed, (double)facing.method_10165() * speed);
        }
        if (action == CartAssemblerBlock.CartAssemblerAction.ASSEMBLE_ACCELERATE_DIRECTIONAL) {
            class_2382 accelerationVector = ControllerRailBlock.getAccelerationVector((class_2680)((class_2680)AllBlocks.CONTROLLER_RAIL.method_9564().method_11657(ControllerRailBlock.SHAPE, (Comparable)((class_2768)state.method_11654(CartAssemblerBlock.RAIL_SHAPE)))).method_11657((class_2769)ControllerRailBlock.BACKWARDS, (Comparable)((Boolean)state.method_11654((class_2769)CartAssemblerBlock.BACKWARDS))));
            double speed = cart.method_7504((class_3218)this.field_11863);
            cart.method_18799(class_243.method_24954((class_2382)accelerationVector).method_1021(speed));
        }
        if (action == CartAssemblerBlock.CartAssemblerAction.DISASSEMBLE_BRAKE) {
            class_243 diff = VecHelper.getCenterOf((class_2382)this.field_11867).method_1020(cart.method_73189());
            cart.method_18800(diff.field_1352 / 16.0, 0.0, diff.field_1350 / 16.0);
        }
    }

    protected void assemble(class_1937 world, class_2338 pos, class_1688 cart) {
        if (!cart.method_5685().isEmpty()) {
            return;
        }
        Optional<MinecartController> value = AllSynchedDatas.MINECART_CONTROLLER.get((class_1297)cart);
        if (value.map(MinecartController::isCoupledThroughContraption).orElse(false).booleanValue()) {
            return;
        }
        CartMovementMode mode = CartMovementMode.values()[this.movementMode.getValue()];
        MountedContraption contraption = new MountedContraption(mode);
        try {
            if (!contraption.assemble(world, pos)) {
                return;
            }
            this.lastException = null;
            this.sendData();
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        boolean couplingFound = contraption.connectedCart != null;
        class_2350 initialOrientation = CartAssemblerBlock.getHorizontalDirection(this.method_11010());
        if (couplingFound) {
            cart.method_5814((double)((float)pos.method_10263() + 0.5f), (double)pos.method_10264(), (double)((float)pos.method_10260() + 0.5f));
            if (!CouplingHandler.tryToCoupleCarts(null, world, cart.method_5628(), contraption.connectedCart.method_5628())) {
                return;
            }
        }
        contraption.removeBlocksFromWorld(world, class_2338.field_10980);
        contraption.startMoving(world);
        contraption.expandBoundsAroundAxis(class_2350.class_2351.field_11052);
        if (couplingFound) {
            class_243 diff = contraption.connectedCart.method_73189().method_1020(cart.method_73189());
            initialOrientation = class_2350.method_10150((double)(class_3532.method_15349((double)diff.field_1350, (double)diff.field_1352) * 180.0 / Math.PI));
        }
        OrientedContraptionEntity entity = OrientedContraptionEntity.create(world, contraption, initialOrientation);
        if (couplingFound) {
            entity.setCouplingId(cart.method_5667());
        }
        entity.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
        world.method_8649((class_1297)entity);
        entity.method_5804((class_1297)cart);
        if (cart instanceof class_1696) {
            try (class_8942.class_11340 logging = new class_8942.class_11340(this.method_71402(), Create.LOGGER);){
                class_11362 view = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)world.method_30349());
                if (cart.method_5662((class_11372)view)) {
                    view.method_71463("PushZ", 0.0);
                    view.method_71463("PushX", 0.0);
                    class_11368 data = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)world.method_30349(), (class_2487)view.method_71475());
                    cart.method_5651(data);
                }
            }
        }
        if (contraption.containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
    }

    protected void disassemble(class_1937 world, class_2338 pos, class_1688 cart) {
        if (cart.method_5685().isEmpty()) {
            return;
        }
        class_1297 entity = (class_1297)cart.method_5685().getFirst();
        if (!(entity instanceof OrientedContraptionEntity)) {
            return;
        }
        OrientedContraptionEntity contraption = (OrientedContraptionEntity)entity;
        UUID couplingId = contraption.getCouplingId();
        if (couplingId == null) {
            contraption.yaw = CartAssemblerBlock.getHorizontalDirection(this.method_11010()).method_10144();
            this.disassembleCart(cart);
            return;
        }
        Couple<MinecartController> coupledCarts = contraption.getCoupledCartsIfPresent();
        if (coupledCarts == null) {
            return;
        }
        for (boolean current : Iterate.trueAndFalse) {
            MinecartController minecartController = coupledCarts.get(current);
            if (minecartController.cart() == cart) continue;
            class_2338 otherPos = minecartController.cart().method_24515();
            class_2680 blockState = world.method_8320(otherPos);
            if (!blockState.method_27852((class_2248)AllBlocks.CART_ASSEMBLER)) {
                return;
            }
            if (CartAssemblerBlock.getActionForCart(blockState, minecartController.cart()).shouldDisassemble()) continue;
            return;
        }
        for (boolean current : Iterate.trueAndFalse) {
            coupledCarts.get(current).removeConnection(current);
        }
        this.disassembleCart(cart);
    }

    protected void disassembleCart(class_1688 cart) {
        cart.method_5772();
        if (cart instanceof class_1696) {
            try (class_8942.class_11340 logging = new class_8942.class_11340(this.method_71402(), Create.LOGGER);){
                class_11362 view = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)this.field_11863.method_30349());
                cart.method_5786((class_11372)view);
                class_243 velocity = cart.method_18798();
                view.method_71463("PushX", velocity.field_1352);
                view.method_71463("PushZ", velocity.field_1350);
                class_11368 data = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)this.field_11863.method_30349(), (class_2487)view.method_71475());
                cart.method_5651(data);
            }
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.movementMode = new ServerScrollOptionBehaviour<CartMovementMode>(CartMovementMode.class, this);
        behaviours.add(this.movementMode);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.CONTRAPTION_ACTORS);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        AssemblyException.write(view, this.lastException);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        this.lastException = AssemblyException.read(view);
        super.read(view, clientPacket);
    }

    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    public void resetTicksSinceMinecartUpdate() {
        this.ticksSinceMinecartUpdate = 0;
    }

    public void assembleNextTick(class_1688 cart) {
        if (this.cartToAssemble == null) {
            this.cartToAssemble = cart;
        }
    }

    public boolean isMinecartUpdateValid() {
        return this.ticksSinceMinecartUpdate >= 8;
    }

    public static enum CartMovementMode implements class_3542
    {
        ROTATE,
        ROTATE_PAUSED,
        ROTATION_LOCKED;

        public static final Codec<CartMovementMode> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(CartMovementMode::values);
        }
    }
}

