/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.contraption.storage.fluid.MountedFluidStorageType;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorageType;
import com.zurrtum.create.api.contraption.storage.item.chest.ChestMountedStorageType;
import com.zurrtum.create.api.contraption.storage.item.simple.SimpleMountedStorage;
import com.zurrtum.create.api.contraption.storage.item.simple.SimpleMountedStorageType;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.api.registry.CreateRegistryKeys;
import com.zurrtum.create.content.contraptions.behaviour.dispenser.storage.DispenserMountedStorageType;
import com.zurrtum.create.content.equipment.toolbox.ToolboxMountedStorageType;
import com.zurrtum.create.content.fluids.tank.storage.FluidTankMountedStorageType;
import com.zurrtum.create.content.fluids.tank.storage.creative.CreativeFluidTankMountedStorageType;
import com.zurrtum.create.content.logistics.crate.CreativeCrateMountedStorageType;
import com.zurrtum.create.content.logistics.depot.storage.DepotMountedStorageType;
import com.zurrtum.create.content.logistics.vault.ItemVaultMountedStorageType;
import com.zurrtum.create.impl.contraption.storage.FallbackMountedStorageType;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class AllMountedStorageTypes {
    public static final DepotMountedStorageType DEPOT = AllMountedStorageTypes.register("depot", new DepotMountedStorageType());
    public static final CreativeCrateMountedStorageType CREATIVE_CRATE = AllMountedStorageTypes.register("creative_crate", new CreativeCrateMountedStorageType());
    public static final ItemVaultMountedStorageType VAULT = AllMountedStorageTypes.register("vault", new ItemVaultMountedStorageType());
    public static final ToolboxMountedStorageType TOOLBOX = AllMountedStorageTypes.register("toolbox", new ToolboxMountedStorageType());
    public static final ChestMountedStorageType CHEST = AllMountedStorageTypes.register("chest", new ChestMountedStorageType());
    public static final DispenserMountedStorageType DISPENSER = AllMountedStorageTypes.register("dispenser", new DispenserMountedStorageType());
    public static final SimpleMountedStorageType<SimpleMountedStorage> SIMPLE = AllMountedStorageTypes.register("simple", new SimpleMountedStorageType.Impl());
    public static final FallbackMountedStorageType FALLBACK = AllMountedStorageTypes.register("fallback", new FallbackMountedStorageType());
    public static final FluidTankMountedStorageType FLUID_TANK = AllMountedStorageTypes.register("fluid_tank", new FluidTankMountedStorageType());
    public static final CreativeFluidTankMountedStorageType CREATIVE_FLUID_TANK = AllMountedStorageTypes.register("creative_fluid_tank", new CreativeFluidTankMountedStorageType());

    private static <T extends MountedItemStorageType<?>> T register(String id, T type) {
        return (T)((MountedItemStorageType)class_2378.method_39197(CreateRegistries.MOUNTED_ITEM_STORAGE_TYPE, (class_5321)class_5321.method_29179(CreateRegistryKeys.MOUNTED_ITEM_STORAGE_TYPE, (class_2960)class_2960.method_60655((String)"create", (String)id)), type));
    }

    private static <T extends MountedFluidStorageType<?>> T register(String id, T type) {
        return (T)((MountedFluidStorageType)class_2378.method_39197(CreateRegistries.MOUNTED_FLUID_STORAGE_TYPE, (class_5321)class_5321.method_29179(CreateRegistryKeys.MOUNTED_FLUID_STORAGE_TYPE, (class_2960)class_2960.method_60655((String)"create", (String)id)), type));
    }

    public static void register(MountedItemStorageType<?> type, class_2248 ... blocks) {
        for (class_2248 block : blocks) {
            MountedItemStorageType.REGISTRY.register(block, type);
        }
    }

    public static void register(MountedItemStorageType<?> type, class_6862<class_2248> tag) {
        MountedItemStorageType.REGISTRY.registerProvider(block -> block.method_40142().method_40220(tag) ? type : null);
    }

    public static void register(MountedFluidStorageType<?> type, class_2248 ... blocks) {
        for (class_2248 block : blocks) {
            MountedFluidStorageType.REGISTRY.register(block, type);
        }
    }

    public static void register() {
        AllMountedStorageTypes.register(DEPOT, AllBlocks.DEPOT);
        AllMountedStorageTypes.register(CREATIVE_CRATE, new class_2248[]{AllBlocks.CREATIVE_CRATE});
        AllMountedStorageTypes.register(VAULT, AllBlocks.ITEM_VAULT);
        AllMountedStorageTypes.register(TOOLBOX, new class_2248[]{AllBlocks.WHITE_TOOLBOX, AllBlocks.ORANGE_TOOLBOX, AllBlocks.MAGENTA_TOOLBOX, AllBlocks.LIGHT_BLUE_TOOLBOX, AllBlocks.YELLOW_TOOLBOX, AllBlocks.LIME_TOOLBOX, AllBlocks.PINK_TOOLBOX, AllBlocks.GRAY_TOOLBOX, AllBlocks.LIGHT_GRAY_TOOLBOX, AllBlocks.CYAN_TOOLBOX, AllBlocks.PURPLE_TOOLBOX, AllBlocks.BLUE_TOOLBOX, AllBlocks.BROWN_TOOLBOX, AllBlocks.GREEN_TOOLBOX, AllBlocks.RED_TOOLBOX, AllBlocks.BLACK_TOOLBOX});
        AllMountedStorageTypes.register(CHEST, class_2246.field_10034, class_2246.field_10380);
        AllMountedStorageTypes.register(DISPENSER, class_2246.field_10200, class_2246.field_10228);
        AllMountedStorageTypes.register(SIMPLE, AllBlockTags.SIMPLE_MOUNTED_STORAGE);
        AllMountedStorageTypes.register(FALLBACK, AllBlockTags.FALLBACK_MOUNTED_STORAGE_BLACKLIST);
        AllMountedStorageTypes.register(FLUID_TANK, AllBlocks.FLUID_TANK);
    }
}

