/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.render;

import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_761;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class DefaultSuperByteBuffer
implements SuperByteBuffer {
    protected ByteBuffer template;
    protected int formatSize;
    protected class_4587 transforms;
    protected boolean shouldColor;
    protected int r;
    protected int g;
    protected int b;
    protected int a;
    protected boolean disableDiffuse;
    @Nullable
    protected SuperByteBuffer.SpriteShiftFunc spriteShiftFunc;
    protected boolean hasOverlay;
    protected int overlay = class_4608.field_21444;
    protected boolean useWorldLight;
    @Nullable
    protected Matrix4f lightTransform;
    protected boolean hasCustomLight;
    protected int packedLightCoordinates;
    protected boolean hybridLight;
    protected boolean fullNormalTransform;
    protected static final Long2IntMap WORLD_LIGHT_CACHE = new Long2IntOpenHashMap();
    private final SuperByteBuffer.ShiftOutput shiftOutput = new SuperByteBuffer.ShiftOutput();

    public DefaultSuperByteBuffer(class_9801 data) {
        ByteBuffer rendered = data.method_60818();
        class_9801.class_4574 drawState = data.method_60822();
        rendered.order(ByteOrder.nativeOrder());
        drawState.comp_749().getVertexSize();
        this.formatSize = drawState.comp_749().getVertexSize();
        int size = drawState.comp_750() * this.formatSize;
        this.template = ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
        this.template.order(rendered.order());
        this.template.limit(rendered.limit());
        this.template.put(rendered);
        this.transforms = new class_4587();
        this.transforms.method_22903();
    }

    @Override
    public void renderInto(class_4587 ms, class_4588 consumer) {
        Matrix3f normalMatrix;
        if (this.isEmpty()) {
            return;
        }
        Matrix4f modelMatrix = new Matrix4f((Matrix4fc)ms.method_23760().method_23761());
        Matrix4f localTransforms = this.transforms.method_23760().method_23761();
        modelMatrix.mul((Matrix4fc)localTransforms);
        if (this.fullNormalTransform) {
            normalMatrix = new Matrix3f((Matrix3fc)ms.method_23760().method_23762());
            normalMatrix.mul((Matrix3fc)this.transforms.method_23760().method_23762());
        } else {
            normalMatrix = new Matrix3f((Matrix3fc)this.transforms.method_23760().method_23762());
        }
        for (int i = 0; i < this.vertexCount(); ++i) {
            int light;
            byte a;
            byte b;
            byte g;
            byte r;
            float x = this.getX(i);
            float y = this.getY(i);
            float z = this.getZ(i);
            float normalX = this.getNX(i);
            float normalY = this.getNY(i);
            float normalZ = this.getNZ(i);
            Vector4f pos = new Vector4f(x, y, z, 1.0f);
            Vector3f normal = new Vector3f(normalX, normalY, normalZ);
            Vector4f lightPos = new Vector4f(x, y, z, 1.0f);
            pos.mul((Matrix4fc)modelMatrix);
            normal.mul((Matrix3fc)normalMatrix);
            lightPos.mul((Matrix4fc)localTransforms);
            consumer.method_22912(pos.x(), pos.y(), pos.z());
            if (this.shouldColor) {
                r = (byte)this.r;
                g = (byte)this.g;
                b = (byte)this.b;
                a = (byte)this.a;
            } else {
                r = this.getR(i);
                g = this.getG(i);
                b = this.getB(i);
                a = this.getA(i);
            }
            if (this.disableDiffuse) {
                consumer.method_1336((int)r, (int)g, (int)b, (int)a);
            } else {
                consumer.method_1336((int)r, (int)g, (int)b, (int)a);
            }
            float u = this.getU(i);
            float v = this.getV(i);
            if (this.spriteShiftFunc != null) {
                this.spriteShiftFunc.shift(u, v, this.shiftOutput);
                u = this.shiftOutput.u;
                v = this.shiftOutput.v;
            }
            consumer.method_22913(u, v);
            if (this.useWorldLight) {
                lightPos.set((x - 0.5f) * 15.0f / 16.0f + 0.5f, (y - 0.5f) * 15.0f / 16.0f + 0.5f, (z - 0.5f) * 15.0f / 16.0f + 0.5f, 1.0f);
                lightPos.mul((Matrix4fc)localTransforms);
                if (this.lightTransform != null) {
                    lightPos.mul((Matrix4fc)this.lightTransform);
                }
                light = DefaultSuperByteBuffer.getLight((class_1937)class_310.method_1551().field_1687, lightPos);
                if (this.hasCustomLight) {
                    light = SuperByteBuffer.maxLight(light, this.packedLightCoordinates);
                }
            } else {
                light = this.hasCustomLight ? this.packedLightCoordinates : this.getLight(i);
            }
            if (this.hybridLight) {
                consumer.method_60803(SuperByteBuffer.maxLight(light, this.getLight(i)));
            } else {
                consumer.method_60803(light);
            }
            consumer.method_22914(normal.x(), normal.y(), normal.z());
        }
        this.reset();
    }

    public DefaultSuperByteBuffer reset() {
        while (!this.transforms.method_67795()) {
            this.transforms.method_22909();
        }
        this.transforms.method_22903();
        this.shouldColor = false;
        this.r = 0;
        this.g = 0;
        this.b = 0;
        this.a = 0;
        this.disableDiffuse = false;
        this.spriteShiftFunc = null;
        this.hasOverlay = false;
        this.overlay = class_4608.field_21444;
        this.useWorldLight = false;
        this.lightTransform = null;
        this.hasCustomLight = false;
        this.packedLightCoordinates = 0;
        this.hybridLight = false;
        this.fullNormalTransform = false;
        WORLD_LIGHT_CACHE.clear();
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.template.limit() == 0;
    }

    @Override
    public class_4587 getTransforms() {
        return this.transforms;
    }

    @Override
    public DefaultSuperByteBuffer translate(float x, float y, float z) {
        this.transforms.method_46416(x, y, z);
        return this;
    }

    @Override
    public DefaultSuperByteBuffer translate(double x, double y, double z) {
        this.transforms.method_22904(x, y, z);
        return this;
    }

    @Override
    public DefaultSuperByteBuffer scale(float factorX, float factorY, float factorZ) {
        this.transforms.method_22905(factorX, factorY, factorZ);
        return this;
    }

    @Override
    public DefaultSuperByteBuffer pushPose() {
        this.transforms.method_22903();
        return this;
    }

    @Override
    public DefaultSuperByteBuffer popPose() {
        this.transforms.method_22909();
        return this;
    }

    @Override
    public DefaultSuperByteBuffer mulPose(Matrix4fc matrix4fc) {
        this.transforms.method_23760().method_23761().mul(matrix4fc);
        return this;
    }

    @Override
    public DefaultSuperByteBuffer mulNormal(Matrix3fc matrix3fc) {
        this.transforms.method_23760().method_23762().mul(matrix3fc);
        return this;
    }

    @Override
    public DefaultSuperByteBuffer transform(class_4587 ms) {
        this.transforms.method_23760().method_23761().mul((Matrix4fc)ms.method_23760().method_23761());
        this.transforms.method_23760().method_23762().mul((Matrix3fc)ms.method_23760().method_23762());
        return this;
    }

    public DefaultSuperByteBuffer color(int color) {
        this.shouldColor = true;
        this.r = color >> 16 & 0xFF;
        this.g = color >> 8 & 0xFF;
        this.b = color & 0xFF;
        this.a = 255;
        return this;
    }

    public DefaultSuperByteBuffer color(int r, int g, int b, int a) {
        this.shouldColor = true;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        return this;
    }

    public DefaultSuperByteBuffer disableDiffuse() {
        this.disableDiffuse = true;
        return this;
    }

    public DefaultSuperByteBuffer shiftUV(SpriteShiftEntry entry) {
        this.spriteShiftFunc = (u, v, output) -> output.accept(entry.getTargetU(u), entry.getTargetV(v));
        return this;
    }

    public DefaultSuperByteBuffer shiftUVScrolling(SpriteShiftEntry entry, float scrollU, float scrollV) {
        this.spriteShiftFunc = (u, v, output) -> {
            float targetU = u - entry.getOriginal().method_4594() + entry.getTarget().method_4594() + scrollU;
            float targetV = v - entry.getOriginal().method_4593() + entry.getTarget().method_4593() + scrollV;
            output.accept(targetU, targetV);
        };
        return this;
    }

    public DefaultSuperByteBuffer shiftUVtoSheet(SpriteShiftEntry entry, float uTarget, float vTarget, int sheetSize) {
        this.spriteShiftFunc = (u, v, output) -> {
            float targetU = entry.getTarget().method_4580(SpriteShiftEntry.getUnInterpolatedU(entry.getOriginal(), u) / (float)sheetSize + uTarget);
            float targetV = entry.getTarget().method_4570(SpriteShiftEntry.getUnInterpolatedV(entry.getOriginal(), v) / (float)sheetSize + vTarget);
            output.accept(targetU, targetV);
        };
        return this;
    }

    public DefaultSuperByteBuffer overlay(int overlay) {
        this.hasOverlay = true;
        this.overlay = overlay;
        return this;
    }

    public DefaultSuperByteBuffer useLevelLight(class_1920 level) {
        return this;
    }

    public DefaultSuperByteBuffer useLevelLight(class_1920 level, Matrix4f lightTransform) {
        return this;
    }

    public DefaultSuperByteBuffer light(int packedLight) {
        this.hasCustomLight = true;
        this.packedLightCoordinates = packedLight;
        return this;
    }

    protected int vertexCount() {
        return this.template.limit() / this.formatSize;
    }

    protected int getBufferPosition(int vertexIndex) {
        return vertexIndex * this.formatSize;
    }

    protected float getX(int index) {
        return this.template.getFloat(this.getBufferPosition(index));
    }

    protected float getY(int index) {
        return this.template.getFloat(this.getBufferPosition(index) + 4);
    }

    protected float getZ(int index) {
        return this.template.getFloat(this.getBufferPosition(index) + 8);
    }

    protected byte getR(int index) {
        return this.template.get(this.getBufferPosition(index) + 12);
    }

    protected byte getG(int index) {
        return this.template.get(this.getBufferPosition(index) + 13);
    }

    protected byte getB(int index) {
        return this.template.get(this.getBufferPosition(index) + 14);
    }

    protected byte getA(int index) {
        return this.template.get(this.getBufferPosition(index) + 15);
    }

    protected float getU(int index) {
        return this.template.getFloat(this.getBufferPosition(index) + 16);
    }

    protected float getV(int index) {
        return this.template.getFloat(this.getBufferPosition(index) + 20);
    }

    protected int getLight(int index) {
        return this.template.getInt(this.getBufferPosition(index) + 24);
    }

    protected byte getNX(int index) {
        return this.template.get(this.getBufferPosition(index) + 28);
    }

    protected byte getNY(int index) {
        return this.template.get(this.getBufferPosition(index) + 29);
    }

    protected byte getNZ(int index) {
        return this.template.get(this.getBufferPosition(index) + 30);
    }

    private static int getLight(class_1937 world, Vector4f lightPos) {
        class_2338 pos = class_2338.method_49637((double)lightPos.x(), (double)lightPos.y(), (double)lightPos.z());
        return WORLD_LIGHT_CACHE.computeIfAbsent(pos.method_10063(), $ -> class_761.method_23794((class_1920)world, (class_2338)pos));
    }

    @Override
    public SuperByteBuffer rotate(Quaternionfc quaternionfc) {
        return null;
    }
}

