/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.rei;

import com.zurrtum.create.client.content.logistics.stockTicker.CraftableBigItemStack;
import com.zurrtum.create.client.content.logistics.stockTicker.CraftableInput;
import com.zurrtum.create.client.content.logistics.stockTicker.StockKeeperRequestScreen;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.stockTicker.StockKeeperRequestMenu;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class StockKeeperTransferHandler
implements TransferHandler {
    private static class_1799 findOutput(Display display) {
        for (EntryIngredient ingredient : display.getOutputEntries()) {
            if (ingredient.isEmpty()) continue;
            for (EntryStack stack : ingredient) {
                if (stack.getType() != VanillaEntryTypes.ITEM) continue;
                return (class_1799)stack.castValue();
            }
        }
        return class_1799.field_8037;
    }

    public TransferHandler.ApplicabilityResult checkApplicable(TransferHandler.Context context) {
        if (context.getContainerScreen() instanceof StockKeeperRequestScreen && context.getDisplay().getDisplayLocation().isPresent()) {
            return TransferHandler.ApplicabilityResult.createApplicable();
        }
        return TransferHandler.ApplicabilityResult.createNotApplicable();
    }

    public TransferHandler.Result handle(TransferHandler.Context context) {
        StockKeeperRequestScreen screen = (StockKeeperRequestScreen)context.getContainerScreen();
        Display display = context.getDisplay();
        class_2960 id = (class_2960)display.getDisplayLocation().orElseThrow();
        for (CraftableBigItemStack cbis : screen.recipesToOrder) {
            if (!cbis.id.equals((Object)id)) continue;
            return TransferHandler.Result.createFailed((class_2561)CreateLang.translateDirect("gui.stock_keeper.already_ordering_recipe", new Object[0]));
        }
        if (screen.itemsToOrder.size() >= 9) {
            return TransferHandler.Result.createFailed((class_2561)CreateLang.translateDirect("gui.stock_keeper.slots_full", new Object[0]));
        }
        CraftableInput inputs = CraftableInput.create(display.getCategoryIdentifier().equals((Object)BuiltinPlugin.CRAFTING));
        List inputIngredients = display.getInputIngredients(context.getMenu(), (class_1657)context.getMinecraft().field_1724);
        for (InputIngredient input : inputIngredients) {
            List ingredient = input.get();
            int size = ingredient.size();
            if (size == 0) continue;
            if (size == 1) {
                EntryStack stack = (EntryStack)ingredient.getFirst();
                if (stack.getType() != VanillaEntryTypes.ITEM) {
                    return TransferHandler.Result.createNotApplicable();
                }
                inputs.add(List.of((class_1799)stack.castValue()), input.getDisplayIndex());
                continue;
            }
            ArrayList<class_1799> items = new ArrayList<class_1799>(size);
            for (int j = 0; j < size; ++j) {
                EntryStack stack = (EntryStack)ingredient.get(j);
                if (stack.getType() != VanillaEntryTypes.ITEM) {
                    return TransferHandler.Result.createNotApplicable();
                }
                items.add((class_1799)stack.castValue());
            }
            inputs.add(items, input.getDisplayIndex());
        }
        if (inputs.data().size() > 9) {
            return TransferHandler.Result.createNotApplicable();
        }
        class_1799 output = StockKeeperTransferHandler.findOutput(display);
        if (output.method_7960()) {
            return TransferHandler.Result.createFailed((class_2561)CreateLang.translateDirect("gui.stock_keeper.recipe_result_empty", new Object[0]));
        }
        InventorySummary summary = ((StockTickerBlockEntity)((StockKeeperRequestMenu)screen.method_17577()).contentHolder).getLastClientsideStockSnapshotAsSummary();
        if (summary == null) {
            return TransferHandler.Result.createNotApplicable();
        }
        IntSet missingIndices = inputs.getMissing(summary.getStacksByCount());
        if (!missingIndices.isEmpty()) {
            return TransferHandler.Result.createFailed((class_2561)CreateLang.translateDirect("gui.stock_keeper.not_in_stock", new Object[0])).renderer((graphics, mouseX, mouseY, delta, widgets, bounds, d) -> {
                int i = 0;
                for (Widget widget : widgets) {
                    Slot slot;
                    if (!(widget instanceof Slot) || (slot = (Slot)widget).getNoticeMark() != 1 || !missingIndices.contains(i++)) continue;
                    Rectangle innerBounds = slot.getInnerBounds();
                    graphics.method_25294(innerBounds.x, innerBounds.y, innerBounds.getMaxX(), innerBounds.getMaxY(), 0x40FF0000);
                }
            });
        }
        if (context.isActuallyCrafting()) {
            CraftableBigItemStack cbis = new CraftableBigItemStack(id, inputs, output);
            screen.recipesToOrder.add(cbis);
            screen.searchBox.method_1852("");
            screen.refreshSearchNextTick = true;
            screen.requestCraftable(cbis, context.isStackedCrafting() ? cbis.stack.method_7914() : 1);
        }
        return TransferHandler.Result.createSuccessful().blocksFurtherHandling();
    }
}

