/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.actors.harvester;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;

@Environment(value=EnvType.CLIENT)
public class HarvesterActorVisual
extends ActorVisual {
    static float originOffset = 0.0625f;
    static class_243 rotOffset = new class_243(0.5, (double)(-2.0f * originOffset + 0.5f), (double)(originOffset + 0.5f));
    protected TransformedInstance harvester;
    private final class_2350 facing;
    protected float horizontalAngle;
    private double rotation;
    private double previousRotation;

    public HarvesterActorVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        super(visualizationContext, (class_1920)simulationWorld, movementContext);
        class_2680 state = movementContext.state;
        this.facing = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        this.harvester = this.instancerProvider.instancer(InstanceTypes.TRANSFORMED, Models.partial(this.getRollingPartial())).createInstance();
        this.horizontalAngle = this.facing.method_10144() + (float)(this.facing.method_10166() == class_2350.class_2351.field_11048 ? 180 : 0);
        this.harvester.light(this.localBlockLight(), 0);
        this.harvester.setChanged();
    }

    protected PartialModel getRollingPartial() {
        return AllPartialModels.HARVESTER_BLADE;
    }

    protected class_243 getRotationOffset() {
        return rotOffset;
    }

    protected double getRadius() {
        return 6.5;
    }

    @Override
    public void tick() {
        super.tick();
        this.previousRotation = this.rotation;
        if (this.context.contraption.stalled || this.context.disabled || VecHelper.isVecPointingTowards(this.context.relativeMotion, this.facing.method_10153())) {
            return;
        }
        double arcLength = this.context.motion.method_1033();
        double radians = arcLength * 16.0 / this.getRadius();
        float deg = AngleHelper.deg(radians);
        deg = (int)(deg * 3000.0f) / 3000;
        this.rotation += (double)deg * 1.25;
        this.rotation %= 360.0;
    }

    @Override
    public void beginFrame() {
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.harvester.setIdentityTransform().translate((class_2382)this.context.localPos)).center()).rotateYDegrees(this.horizontalAngle)).uncenter()).translate(this.getRotationOffset())).rotateXDegrees((float)this.getRotation())).translateBack(this.getRotationOffset())).setChanged();
    }

    @Override
    protected void _delete() {
        this.harvester.delete();
    }

    protected double getRotation() {
        return AngleHelper.angleLerp(AnimationTickHolder.getPartialTicks(), this.previousRotation, this.rotation);
    }
}

