/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.render;

import com.zurrtum.create.Create;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.client.catnip.render.SuperByteBufferCache;
import com.zurrtum.create.client.content.contraptions.render.ContraptionEntityRenderer;
import com.zurrtum.create.client.content.contraptions.render.ContraptionMatrices;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11352;
import net.minecraft.class_11515;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ClientContraption {
    private final VirtualRenderWorld renderLevel;
    private final List<class_2586> renderedBlockEntities = new ArrayList<class_2586>();
    public final List<class_2586> renderedBlockEntityView = Collections.unmodifiableList(this.renderedBlockEntities);
    public final BitSet shouldRenderBlockEntities = new BitSet();
    public final BitSet scratchErroredBlockEntities = new BitSet();
    private final ContraptionMatrices matrices = new ContraptionMatrices();
    protected final Contraption contraption;
    private int structureVersion = 0;
    private int childrenVersion = 0;

    public ClientContraption(Contraption contraption) {
        class_1937 level = contraption.entity.method_37908();
        this.contraption = contraption;
        class_2338 origin = contraption.anchor;
        int minY = VirtualRenderWorld.nextMultipleOf16(class_3532.method_15357((double)(contraption.bounds.field_1322 - 1.0)));
        int height = VirtualRenderWorld.nextMultipleOf16(class_3532.method_15384((double)(contraption.bounds.field_1325 + 1.0))) - minY;
        this.renderLevel = new VirtualRenderWorld(this, level, minY, height, (class_2382)origin, this::invalidateStructure){

            @Override
            public boolean supportsVisualization() {
                return VisualizationManager.supportsVisualization((class_1936)this.level);
            }
        };
        this.setupRenderLevelAndRenderedBlockEntities();
    }

    public Contraption getContraption() {
        return this.contraption;
    }

    public int structureVersion() {
        return this.structureVersion;
    }

    public int childrenVersion() {
        return this.childrenVersion;
    }

    public void resetRenderLevel() {
        this.renderedBlockEntities.clear();
        this.renderLevel.clear();
        this.shouldRenderBlockEntities.clear();
        this.setupRenderLevelAndRenderedBlockEntities();
        this.invalidateStructure();
        this.invalidateChildren();
    }

    public void invalidateChildren() {
        ++this.childrenVersion;
    }

    public void invalidateStructure() {
        for (class_11515 renderType : class_11515.values()) {
            SuperByteBufferCache.getInstance().invalidate(ContraptionEntityRenderer.CONTRAPTION, Pair.of((Object)this.contraption, (Object)renderType));
        }
        ++this.structureVersion;
    }

    private void setupRenderLevelAndRenderedBlockEntities() {
        for (class_3499.class_3501 info : this.contraption.getBlocks().values()) {
            this.renderLevel.method_8652(info.comp_1341(), info.comp_1342(), 0);
            class_2586 blockEntity = this.readBlockEntity(this.renderLevel, info, this.contraption.getIsLegacy().getBoolean((Object)info.comp_1341()));
            if (blockEntity == null) continue;
            this.renderLevel.method_8438(blockEntity);
            MovementBehaviour movementBehaviour = MovementBehaviour.REGISTRY.get((class_2688<class_2248, ?>)info.comp_1342());
            if (movementBehaviour != null && movementBehaviour.disableBlockEntityRendering()) continue;
            this.renderedBlockEntities.add(blockEntity);
        }
        this.shouldRenderBlockEntities.set(0, this.renderedBlockEntities.size());
        this.renderLevel.runLightEngine();
    }

    @Nullable
    public class_2586 readBlockEntity(class_1937 level, class_3499.class_3501 info, boolean legacy) {
        class_2248 class_22482;
        class_2680 state = info.comp_1342();
        class_2338 pos = info.comp_1341();
        class_2487 nbt = info.comp_1343();
        if (legacy) {
            if (nbt == null) {
                return null;
            }
            nbt.method_10569("x", pos.method_10263());
            nbt.method_10569("y", pos.method_10264());
            nbt.method_10569("z", pos.method_10260());
            class_2586 be = class_2586.method_11005((class_2338)pos, (class_2680)state, (class_2487)nbt, (class_7225.class_7874)level.method_30349());
            ClientContraption.postprocessReadBlockEntity(level, be, state);
            return be;
        }
        if (!state.method_31709() || !((class_22482 = state.method_26204()) instanceof class_2343)) {
            return null;
        }
        class_2343 entityBlock = (class_2343)class_22482;
        class_2586 be = entityBlock.method_10123(pos, state);
        ClientContraption.postprocessReadBlockEntity(level, be, state);
        if (be != null && nbt != null) {
            try (class_8942.class_11340 logging = new class_8942.class_11340(be.method_71402(), Create.LOGGER);){
                be.method_58690(class_11352.method_71417((class_8942)logging, (class_7225.class_7874)level.method_30349(), (class_2487)nbt));
            }
        }
        return be;
    }

    protected static void postprocessReadBlockEntity(class_1937 level, @Nullable class_2586 be, class_2680 blockState) {
        if (be != null) {
            be.method_31662(level);
            be.method_31664(blockState);
            if (be instanceof KineticBlockEntity) {
                KineticBlockEntity kbe = (KineticBlockEntity)be;
                kbe.setSpeed(0.0f);
            }
        }
    }

    public VirtualRenderWorld getRenderLevel() {
        return this.renderLevel;
    }

    public ContraptionMatrices getMatrices() {
        return this.matrices;
    }

    public RenderedBlocks getRenderedBlocks() {
        return new RenderedBlocks(pos -> {
            class_3499.class_3501 info = this.contraption.getBlocks().get(pos);
            if (info == null) {
                return class_2246.field_10124.method_9564();
            }
            return info.comp_1342();
        }, this.contraption.getBlocks().keySet());
    }

    @Nullable
    public class_2586 getBlockEntity(class_2338 localPos) {
        return this.renderLevel.method_8321(localPos);
    }

    public BitSet getAndAdjustShouldRenderBlockEntities() {
        return this.shouldRenderBlockEntities;
    }

    public static void resetClientContraption(Contraption contraption) {
        AtomicReference<?> clientContraption = contraption.clientContraption;
        ClientContraption maybeNullClientContraption = (ClientContraption)clientContraption.getAcquire();
        if (maybeNullClientContraption != null) {
            maybeNullClientContraption.resetRenderLevel();
        }
    }

    public static void invalidateClientContraptionStructure(Contraption contraption) {
        AtomicReference<?> clientContraption = contraption.clientContraption;
        ClientContraption maybeNullClientContraption = (ClientContraption)clientContraption.getAcquire();
        if (maybeNullClientContraption != null) {
            maybeNullClientContraption.invalidateStructure();
        }
    }

    public static void invalidateClientContraptionChildren(Contraption contraption) {
        AtomicReference<?> clientContraption = contraption.clientContraption;
        ClientContraption maybeNullClientContraption = (ClientContraption)clientContraption.getAcquire();
        if (maybeNullClientContraption != null) {
            maybeNullClientContraption.invalidateChildren();
        }
    }

    @Nullable
    public static class_2586 getBlockEntityClientSide(Contraption contraption, class_2338 localPos) {
        AtomicReference<?> clientContraption = contraption.clientContraption;
        ClientContraption maybeNullClientContraption = (ClientContraption)clientContraption.getAcquire();
        if (maybeNullClientContraption == null) {
            return null;
        }
        return maybeNullClientContraption.getBlockEntity(localPos);
    }

    @Environment(value=EnvType.CLIENT)
    public record RenderedBlocks(Function<class_2338, class_2680> lookup, Iterable<class_2338> positions) {
    }
}

