/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.base;

import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.content.kinetics.KineticDebugger;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.flywheel.api.instance.InstanceHandle;
import com.zurrtum.create.client.flywheel.api.instance.InstanceType;
import com.zurrtum.create.client.flywheel.lib.instance.ColoredLitOverlayInstance;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class RotatingInstance
extends ColoredLitOverlayInstance {
    public static final float SPEED_MULTIPLIER = 6.0f;
    public byte rotationAxisX;
    public byte rotationAxisY;
    public byte rotationAxisZ;
    public float x;
    public float y;
    public float z;
    public float rotationalSpeed;
    public float rotationOffset;
    public final Quaternionf rotation = new Quaternionf();

    public RotatingInstance(InstanceType<? extends RotatingInstance> type, InstanceHandle handle) {
        super((InstanceType<? extends ColoredLitOverlayInstance>)type, handle);
    }

    public static int colorFromBE(KineticBlockEntity be) {
        if (be.hasNetwork()) {
            return Color.generateFromLong(be.network).getRGB();
        }
        return 0xFFFFFF;
    }

    public RotatingInstance setup(KineticBlockEntity blockEntity) {
        class_2680 blockState = blockEntity.method_11010();
        class_2350.class_2351 axis = KineticBlockEntityVisual.rotationAxis(blockState);
        return this.setup(blockEntity, axis, blockEntity.getSpeed());
    }

    public RotatingInstance setup(KineticBlockEntity blockEntity, class_2350.class_2351 axis) {
        return this.setup(blockEntity, axis, blockEntity.getSpeed());
    }

    public RotatingInstance setup(KineticBlockEntity blockEntity, float speed) {
        class_2680 blockState = blockEntity.method_11010();
        class_2350.class_2351 axis = KineticBlockEntityVisual.rotationAxis(blockState);
        return this.setup(blockEntity, axis, speed);
    }

    public RotatingInstance setup(KineticBlockEntity blockEntity, class_2350.class_2351 axis, float speed) {
        class_2680 blockState = blockEntity.method_11010();
        class_2338 pos = blockEntity.method_11016();
        RotatingInstance instance = this.setRotationAxis(axis).setRotationalSpeed(speed * 6.0f).setRotationOffset(KineticBlockEntityVisual.rotationOffset(blockState, axis, (class_2382)pos) + (float)blockEntity.getRotationAngleOffset(axis));
        if (KineticDebugger.isActive()) {
            instance.setColor(blockEntity);
        }
        return instance;
    }

    public RotatingInstance rotateToFace(class_2350.class_2351 axis) {
        class_2350 orientation = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
        return this.rotateToFace(orientation);
    }

    public RotatingInstance rotateToFace(class_2350 from, class_2350.class_2351 axis) {
        class_2350 orientation = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
        return this.rotateToFace(from, orientation);
    }

    public RotatingInstance rotateToFace(class_2350 orientation) {
        return this.rotateToFace(orientation.method_10148(), orientation.method_10164(), orientation.method_10165());
    }

    public RotatingInstance rotateToFace(class_2350 from, class_2350 orientation) {
        return this.rotateTo(from.method_10148(), from.method_10164(), from.method_10165(), orientation.method_10148(), orientation.method_10164(), orientation.method_10165());
    }

    public RotatingInstance rotateToFace(float stepX, float stepY, float stepZ) {
        return this.rotateTo(0.0f, 1.0f, 0.0f, stepX, stepY, stepZ);
    }

    public RotatingInstance rotateTo(float fromX, float fromY, float fromZ, float toX, float toY, float toZ) {
        this.rotation.rotateTo(fromX, fromY, fromZ, toX, toY, toZ);
        return this;
    }

    public RotatingInstance setRotationAxis(class_2350.class_2351 axis) {
        class_2350 orientation = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
        return this.setRotationAxis(orientation.method_23955());
    }

    public RotatingInstance setRotationAxis(Vector3f axis) {
        return this.setRotationAxis(axis.x(), axis.y(), axis.z());
    }

    public RotatingInstance setRotationAxis(float rotationAxisX, float rotationAxisY, float rotationAxisZ) {
        this.rotationAxisX = (byte)(rotationAxisX * 127.0f);
        this.rotationAxisY = (byte)(rotationAxisY * 127.0f);
        this.rotationAxisZ = (byte)(rotationAxisZ * 127.0f);
        return this;
    }

    public RotatingInstance setPosition(class_2382 pos) {
        return this.setPosition(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public RotatingInstance setPosition(Vector3f pos) {
        return this.setPosition(pos.x(), pos.y(), pos.z());
    }

    public RotatingInstance setPosition(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public RotatingInstance nudge(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public RotatingInstance setColor(KineticBlockEntity blockEntity) {
        this.colorRgb(RotatingInstance.colorFromBE(blockEntity));
        return this;
    }

    public RotatingInstance setColor(Color c) {
        this.color(c.getRed(), c.getGreen(), c.getBlue());
        return this;
    }

    public RotatingInstance setRotationalSpeed(float rotationalSpeed) {
        this.rotationalSpeed = rotationalSpeed;
        return this;
    }

    public RotatingInstance setRotationOffset(float rotationOffset) {
        this.rotationOffset = rotationOffset;
        return this;
    }
}

