/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.transmission.sequencer;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.catnip.lang.Lang;
import com.zurrtum.create.client.compat.computercraft.ComputerScreen;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.transmission.sequencer.Instruction;
import com.zurrtum.create.content.kinetics.transmission.sequencer.InstructionSpeedModifiers;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import com.zurrtum.create.infrastructure.packet.c2s.ConfigureSequencedGearshiftPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class SequencedGearshiftScreen
extends AbstractSimiScreen
implements ComputerScreen.AdditionalRenderer {
    private final AllGuiTextures background = AllGuiTextures.SEQUENCER;
    private IconButton confirmButton;
    private GuiGameElement.GuiItemRenderBuilder renderedItem;
    private SequencedGearshiftBlockEntity be;
    private Vector<Instruction> instructions;
    private Vector<Vector<ScrollInput>> inputs;

    public SequencedGearshiftScreen(SequencedGearshiftBlockEntity be) {
        super((class_2561)CreateLang.translateDirect("gui.sequenced_gearshift.title", new Object[0]));
        this.instructions = be.getInstructions();
        this.be = be;
    }

    @Override
    protected void method_25426() {
        int row;
        this.renderedItem = GuiGameElement.of(AllItems.SEQUENCED_GEARSHIFT.method_7854()).scale(5.0f);
        if (this.be.computerBehaviour.hasAttachedComputer()) {
            ScreenOpener.open(new ComputerScreen(this.field_22785, this, this, this.be.computerBehaviour::hasAttachedComputer));
        }
        this.setWindowSize(this.background.getWidth(), this.background.getHeight());
        this.setWindowOffset(-20, 0);
        super.method_25426();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.inputs = new Vector(5);
        for (row = 0; row < this.inputs.capacity(); ++row) {
            this.inputs.add(new Vector(3));
        }
        for (row = 0; row < this.instructions.size(); ++row) {
            this.initInputsOfRow(row, x, y);
        }
        this.confirmButton = new IconButton(x + this.background.getWidth() - 33, y + this.background.getHeight() - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(this::method_25419);
        this.method_37063(this.confirmButton);
        this.addAdditional(this, x, y, this.background);
    }

    @Override
    public void addAdditional(class_437 screen, int x, int y, AllGuiTextures background) {
        screen.method_37063(new ElementWidget(x + background.getWidth() + 6, y + background.getHeight() - 56).showingElement(this.renderedItem));
    }

    public void method_25419() {
        super.method_25419();
        this.renderedItem.clear();
    }

    private static String translationKey(SequencerInstructions def) {
        return "gui.sequenced_gearshift.instruction." + Lang.asId(def.name());
    }

    private static String descriptiveTranslationKey(SequencerInstructions def) {
        return SequencedGearshiftScreen.translationKey(def) + ".descriptive";
    }

    private static String translationKey(InstructionSpeedModifiers def) {
        return "gui.sequenced_gearshift.speed." + Lang.asId(def.name());
    }

    private static List<class_2561> getSpeedOptions() {
        ArrayList<class_2561> options = new ArrayList<class_2561>();
        for (InstructionSpeedModifiers entry : InstructionSpeedModifiers.values()) {
            options.add((class_2561)CreateLang.translateDirect(SequencedGearshiftScreen.translationKey(entry), new Object[0]));
        }
        return options;
    }

    private static List<class_2561> getSequencerOptions() {
        ArrayList<class_2561> options = new ArrayList<class_2561>();
        for (SequencerInstructions entry : SequencerInstructions.values()) {
            options.add((class_2561)CreateLang.translateDirect(SequencedGearshiftScreen.descriptiveTranslationKey(entry), new Object[0]));
        }
        return options;
    }

    public void initInputsOfRow(int row, int backgroundX, int backgroundY) {
        int x = backgroundX + 30;
        int y = backgroundY + 20;
        int rowHeight = 22;
        Vector<ScrollInput> rowInputs = this.inputs.get(row);
        this.removeWidgets(rowInputs);
        rowInputs.clear();
        int index = row;
        Instruction instruction = this.instructions.get(row);
        ScrollInput type = new SelectionScrollInput(x, y + rowHeight * row, 50, 18).forOptions(SequencedGearshiftScreen.getSequencerOptions()).calling(state -> this.instructionUpdated(index, (int)state)).setState(instruction.instruction.ordinal()).titled(CreateLang.translateDirect("gui.sequenced_gearshift.instruction", new Object[0]));
        ScrollInput value = new ScrollInput(x + 58, y + rowHeight * row, 28, 18).calling(state -> {
            instruction.value = state;
        });
        ScrollInput direction = new SelectionScrollInput(x + 88, y + rowHeight * row, 28, 18).forOptions(SequencedGearshiftScreen.getSpeedOptions()).calling(state -> {
            instruction.speedModifier = InstructionSpeedModifiers.values()[state];
        }).titled(CreateLang.translateDirect("gui.sequenced_gearshift.speed", new Object[0]));
        rowInputs.add(type);
        rowInputs.add(value);
        rowInputs.add(direction);
        this.addRenderableWidgets(rowInputs);
        this.updateParamsOfRow(row);
    }

    private static boolean hasValueParameter(SequencerInstructions def) {
        return switch (def) {
            case SequencerInstructions.DELAY, SequencerInstructions.TURN_DISTANCE, SequencerInstructions.TURN_ANGLE -> true;
            default -> false;
        };
    }

    private static boolean hasSpeedParameter(SequencerInstructions def) {
        return switch (def) {
            case SequencerInstructions.TURN_DISTANCE, SequencerInstructions.TURN_ANGLE -> true;
            default -> false;
        };
    }

    private static int maxValue(SequencerInstructions def) {
        return switch (def) {
            case SequencerInstructions.TURN_ANGLE -> 360;
            case SequencerInstructions.TURN_DISTANCE -> 128;
            case SequencerInstructions.DELAY -> 600;
            default -> -1;
        };
    }

    private static String parameterKey(SequencerInstructions def) {
        String string = SequencedGearshiftScreen.translationKey(def);
        return string + (switch (def) {
            case SequencerInstructions.TURN_ANGLE -> ".angle";
            case SequencerInstructions.TURN_DISTANCE -> ".distance";
            case SequencerInstructions.DELAY -> "";
            default -> "";
        });
    }

    private static AllGuiTextures background(SequencerInstructions def) {
        return switch (def) {
            default -> throw new MatchException(null, null);
            case SequencerInstructions.TURN_DISTANCE, SequencerInstructions.TURN_ANGLE -> AllGuiTextures.SEQUENCER_INSTRUCTION;
            case SequencerInstructions.DELAY -> AllGuiTextures.SEQUENCER_DELAY;
            case SequencerInstructions.AWAIT -> AllGuiTextures.SEQUENCER_AWAIT;
            case SequencerInstructions.END -> AllGuiTextures.SEQUENCER_END;
        };
    }

    private static int shiftStep(SequencerInstructions def) {
        return switch (def) {
            case SequencerInstructions.TURN_ANGLE -> 45;
            case SequencerInstructions.TURN_DISTANCE -> 5;
            case SequencerInstructions.DELAY -> 20;
            default -> -1;
        };
    }

    public void updateParamsOfRow(int row) {
        Instruction instruction = this.instructions.get(row);
        Vector<ScrollInput> rowInputs = this.inputs.get(row);
        SequencerInstructions def = instruction.instruction;
        boolean hasValue = SequencedGearshiftScreen.hasValueParameter(def);
        boolean hasModifier = SequencedGearshiftScreen.hasSpeedParameter(def);
        ScrollInput value = rowInputs.get(1);
        value.field_22763 = value.field_22764 = hasValue;
        if (hasValue) {
            value.withRange(1, SequencedGearshiftScreen.maxValue(def) + 1).titled(CreateLang.translateDirect(SequencedGearshiftScreen.parameterKey(def), new Object[0])).withShiftStep(SequencedGearshiftScreen.shiftStep(def)).setState(instruction.value).onChanged();
        }
        if (def == SequencerInstructions.DELAY) {
            value.withStepFunction(context -> {
                int v = context.currentValue;
                if (!context.forward) {
                    --v;
                }
                if (v < 20) {
                    return context.shift ? 20 : 1;
                }
                return context.shift ? 100 : 20;
            });
        } else {
            value.withStepFunction(value.standardStep());
        }
        ScrollInput modifier = rowInputs.get(2);
        modifier.field_22763 = modifier.field_22764 = hasModifier;
        if (hasModifier) {
            modifier.setState(instruction.speedModifier.ordinal());
        }
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (this.be.computerBehaviour.hasAttachedComputer()) {
            ScreenOpener.open(new ComputerScreen(this.field_22785, this, this, this.be.computerBehaviour::hasAttachedComputer));
        }
    }

    private static String formatValue(SequencerInstructions def, int value) {
        return switch (def) {
            case SequencerInstructions.TURN_ANGLE -> value + CreateLang.translateDirect("generic.unit.degrees", new Object[0]).getString();
            case SequencerInstructions.TURN_DISTANCE -> value + "m";
            case SequencerInstructions.DELAY -> {
                if (value >= 20) {
                    yield value / 20 + "s";
                }
                yield value + "t";
            }
            default -> String.valueOf(value);
        };
    }

    private static class_2561 label(InstructionSpeedModifiers def) {
        return class_2561.method_43470((String)(switch (def) {
            default -> throw new MatchException(null, null);
            case InstructionSpeedModifiers.FORWARD_FAST -> ">>";
            case InstructionSpeedModifiers.FORWARD -> "->";
            case InstructionSpeedModifiers.BACK -> "<-";
            case InstructionSpeedModifiers.BACK_FAST -> "<<";
        }));
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int yOffset;
        AllGuiTextures toDraw;
        int row;
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        for (row = 0; row < this.instructions.capacity(); ++row) {
            toDraw = AllGuiTextures.SEQUENCER_EMPTY;
            yOffset = toDraw.getHeight() * row;
            toDraw.render(graphics, x, y + 16 + yOffset);
        }
        for (row = 0; row < this.instructions.capacity(); ++row) {
            toDraw = AllGuiTextures.SEQUENCER_EMPTY;
            yOffset = toDraw.getHeight() * row;
            if (row >= this.instructions.size()) {
                toDraw.render(graphics, x, y + 16 + yOffset);
                continue;
            }
            Instruction instruction = this.instructions.get(row);
            SequencerInstructions def = instruction.instruction;
            SequencedGearshiftScreen.background(def).render(graphics, x, y + 16 + yOffset);
            this.label(graphics, 36, yOffset - 1, (class_2561)CreateLang.translateDirect(SequencedGearshiftScreen.translationKey(def), new Object[0]));
            if (SequencedGearshiftScreen.hasValueParameter(def)) {
                String text = SequencedGearshiftScreen.formatValue(def, instruction.value);
                int stringWidth = this.field_22793.method_1727(text);
                this.label(graphics, 90 + (12 - stringWidth / 2), yOffset - 1, (class_2561)class_2561.method_43470((String)text));
            }
            if (!SequencedGearshiftScreen.hasSpeedParameter(def)) continue;
            this.label(graphics, 127, yOffset - 1, SequencedGearshiftScreen.label(instruction.speedModifier));
        }
        graphics.method_51439(this.field_22793, this.field_22785, x + (this.background.getWidth() - 8) / 2 - this.field_22793.method_27525((class_5348)this.field_22785) / 2, y + 4, -10935260, false);
    }

    private void label(class_332 graphics, int x, int y, class_2561 text) {
        graphics.method_51439(this.field_22793, text, this.guiLeft + x, this.guiTop + 26 + y, -18, true);
    }

    public void sendPacket() {
        class_310.method_1551().method_1562().method_52787((class_2596)new ConfigureSequencedGearshiftPacket(this.be.method_11016(), this.instructions));
    }

    public void method_25432() {
        this.sendPacket();
    }

    private static int defaultValue(SequencerInstructions def) {
        return switch (def) {
            case SequencerInstructions.TURN_ANGLE -> 90;
            case SequencerInstructions.TURN_DISTANCE -> 5;
            case SequencerInstructions.DELAY -> 10;
            default -> -1;
        };
    }

    private void instructionUpdated(int index, int state) {
        SequencerInstructions newValue;
        this.instructions.get((int)index).instruction = newValue = SequencerInstructions.values()[state];
        this.instructions.get((int)index).value = SequencedGearshiftScreen.defaultValue(newValue);
        this.updateParamsOfRow(index);
        if (newValue == SequencerInstructions.END) {
            for (int i = this.instructions.size() - 1; i > index; --i) {
                this.instructions.remove(i);
                Vector<ScrollInput> rowInputs = this.inputs.get(i);
                this.removeWidgets(rowInputs);
                rowInputs.clear();
            }
        } else if (index + 1 < this.instructions.capacity() && index + 1 == this.instructions.size()) {
            this.instructions.add(new Instruction(SequencerInstructions.END));
            this.initInputsOfRow(index + 1, this.guiLeft, this.guiTop);
        }
    }
}

