/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.waterwheel;

import com.zurrtum.create.catnip.registry.RegisteredObjectsHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.StitchedSprite;
import com.zurrtum.create.client.catnip.render.SuperBufferFactory;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.catnip.render.SuperByteBufferCache;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.model.BakedModelHelper;
import com.zurrtum.create.content.kinetics.waterwheel.LargeWaterWheelBlock;
import com.zurrtum.create.content.kinetics.waterwheel.WaterWheelBlock;
import com.zurrtum.create.content.kinetics.waterwheel.WaterWheelBlockEntity;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_10801;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class WaterWheelRenderer<T extends WaterWheelBlockEntity>
extends KineticBlockEntityRenderer<T> {
    public static final SuperByteBufferCache.Compartment<ModelKey> WATER_WHEEL = new SuperByteBufferCache.Compartment();
    public static final StitchedSprite OAK_PLANKS_TEMPLATE = new StitchedSprite(class_2960.method_60654((String)"block/oak_planks"));
    public static final StitchedSprite OAK_LOG_TEMPLATE = new StitchedSprite(class_2960.method_60654((String)"block/oak_log"));
    public static final StitchedSprite OAK_LOG_TOP_TEMPLATE = new StitchedSprite(class_2960.method_60654((String)"block/oak_log_top"));
    protected final boolean large;
    private static final String[] LOG_LOCATIONS = new String[]{"x_log", "x_stem", "x_block", "wood/log/x"};

    public WaterWheelRenderer(class_5614.class_5615 context, boolean large) {
        super(context);
        this.large = large;
    }

    public static <T extends WaterWheelBlockEntity> WaterWheelRenderer<T> standard(class_5614.class_5615 context) {
        return new WaterWheelRenderer<T>(context, false);
    }

    public static <T extends WaterWheelBlockEntity> WaterWheelRenderer<T> large(class_5614.class_5615 context) {
        return new WaterWheelRenderer<T>(context, true);
    }

    @Override
    protected SuperByteBuffer getRotatedModel(T be, class_2680 state) {
        ModelKey key = new ModelKey(this.large, state, ((WaterWheelBlockEntity)be).material);
        return SuperByteBufferCache.getInstance().get(WATER_WHEEL, key, () -> {
            class_10801 model = WaterWheelRenderer.generateModel(key);
            class_2680 state1 = key.state();
            class_2350 dir = key.large() ? class_2350.method_10169((class_2350.class_2351)((class_2350.class_2351)state1.method_11654((class_2769)LargeWaterWheelBlock.AXIS)), (class_2350.class_2352)class_2350.class_2352.field_11056) : (class_2350)state1.method_11654((class_2769)WaterWheelBlock.FACING);
            class_4587 transform = CachedBuffers.rotateToFaceVertical(dir).get();
            return SuperBufferFactory.getInstance().createForBlock(model, class_2246.field_10124.method_9564(), transform);
        });
    }

    public static class_10801 generateModel(ModelKey key) {
        return WaterWheelRenderer.generateModel(Variant.of(key.large(), key.state()), key.material());
    }

    public static class_10801 generateModel(Variant variant, class_2680 material) {
        return WaterWheelRenderer.generateModel(variant.model(), material);
    }

    public static class_10801 generateModel(class_10801 template, class_2680 planksBlockState) {
        class_2248 planksBlock = planksBlockState.method_26204();
        class_2960 id = RegisteredObjectsHelper.getKeyOrThrow(planksBlock);
        String wood = WaterWheelRenderer.plankStateToWoodName(planksBlockState);
        if (wood == null) {
            return BakedModelHelper.generateModel(template, sprite -> null);
        }
        String namespace = id.method_12836();
        class_2680 logBlockState = WaterWheelRenderer.getLogBlockState(namespace, wood);
        Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
        map.put(OAK_PLANKS_TEMPLATE.get(), WaterWheelRenderer.getSpriteOnSide(planksBlockState, class_2350.field_11036));
        map.put(OAK_LOG_TEMPLATE.get(), WaterWheelRenderer.getSpriteOnSide(logBlockState, class_2350.field_11035));
        map.put(OAK_LOG_TOP_TEMPLATE.get(), WaterWheelRenderer.getSpriteOnSide(logBlockState, class_2350.field_11036));
        return BakedModelHelper.generateModel(template, ((Map)map)::get);
    }

    @Nullable
    private static String plankStateToWoodName(class_2680 planksBlockState) {
        class_2248 planksBlock = planksBlockState.method_26204();
        class_2960 id = RegisteredObjectsHelper.getKeyOrThrow(planksBlock);
        String path = id.method_12832();
        if (path.endsWith("_planks")) {
            return (path.startsWith("archwood") ? "blue_" : "") + path.substring(0, path.length() - 7);
        }
        if (path.contains("wood/planks/")) {
            return path.substring(12);
        }
        return null;
    }

    private static class_2680 getLogBlockState(String namespace, String wood) {
        for (String location : LOG_LOCATIONS) {
            Optional<class_2680> state = class_7923.field_41175.method_46746(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)namespace, (String)location.replace("x", wood)))).map(class_6880::comp_349).map(class_2248::method_9564);
            if (!state.isPresent()) continue;
            return state.get();
        }
        return class_2246.field_10431.method_9564();
    }

    private static class_1058 getSpriteOnSide(class_2680 state, class_2350 side) {
        List quads;
        class_1087 model = class_310.method_1551().method_1541().method_3349(state);
        if (model == null) {
            return null;
        }
        class_5819 random = class_5819.method_43047();
        random.method_43052(42L);
        List parts = model.method_68512(random);
        for (class_10889 part : parts) {
            quads = part.method_68509(side);
            if (quads.isEmpty()) continue;
            return ((class_777)quads.getFirst()).comp_3724();
        }
        random.method_43052(42L);
        for (class_10889 part : parts) {
            quads = part.method_68509(null);
            if (quads.isEmpty()) continue;
            for (class_777 quad : quads) {
                if (quad.comp_3723() != side) continue;
                return quad.comp_3724();
            }
        }
        return model.method_68511();
    }

    @Environment(value=EnvType.CLIENT)
    public record ModelKey(boolean large, class_2680 state, class_2680 material) {
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Variant {
        SMALL(AllPartialModels.WATER_WHEEL),
        LARGE(AllPartialModels.LARGE_WATER_WHEEL),
        LARGE_EXTENSION(AllPartialModels.LARGE_WATER_WHEEL_EXTENSION);

        private final PartialModel partial;

        private Variant(PartialModel partial) {
            this.partial = partial;
        }

        public class_10801 model() {
            return this.partial.get();
        }

        public static Variant of(boolean large, class_2680 blockState) {
            if (large) {
                boolean extension = (Boolean)blockState.method_11654((class_2769)LargeWaterWheelBlock.EXTENSION);
                if (extension) {
                    return LARGE_EXTENSION;
                }
                return LARGE;
            }
            return SMALL;
        }
    }
}

