/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.stockTicker;

import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.stockTicker.PackageOrder;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;

@Environment(value=EnvType.CLIENT)
public record CraftableInput(Object2ObjectMap<List<class_1799>, IntList> data, boolean crafting) {
    private static final InputStrategy STACK_STRATEGY = new InputStrategy();

    public void add(List<class_1799> stacks, int index) {
        ((IntList)this.data.computeIfAbsent(stacks, CraftableInput::createIntArray)).add(index);
    }

    public ObjectSet<Object2ObjectMap.Entry<List<class_1799>, IntList>> entrySet() {
        return this.data.object2ObjectEntrySet();
    }

    public IntSet getMissing(List<BigItemStack> inputs) {
        IntOpenHashSet missing = new IntOpenHashSet();
        this.data.forEach((arg_0, arg_1) -> CraftableInput.lambda$getMissing$0(inputs, (IntSet)missing, arg_0, arg_1));
        return missing;
    }

    public PackageOrder getPattern(List<BigItemStack> inputs) {
        List<BigItemStack> mutableInputs = BigItemStack.duplicateWrappers(inputs);
        BigItemStack empty = new BigItemStack(class_1799.field_8037, 1);
        BigItemStack[] pattern = new BigItemStack[]{empty, empty, empty, empty, empty, empty, empty, empty, empty};
        this.data.forEach((stacks, indices) -> {
            IntListIterator iterator = indices.iterator();
            for (BigItemStack bigItemStack : mutableInputs) {
                int count = bigItemStack.count;
                if (count <= 0 || !CraftableInput.contains(stacks, bigItemStack.stack)) continue;
                BigItemStack ingredient = new BigItemStack(bigItemStack.stack, 1);
                do {
                    pattern[iterator.nextInt()] = ingredient;
                } while (iterator.hasNext() && --count > 0);
                bigItemStack.count = count;
                if (iterator.hasNext()) continue;
                break;
            }
        });
        return new PackageOrder(Arrays.asList(pattern));
    }

    public static CraftableInput create(boolean crafting) {
        return new CraftableInput((Object2ObjectMap<List<class_1799>, IntList>)new Object2ObjectOpenCustomHashMap((Hash.Strategy)STACK_STRATEGY), crafting);
    }

    public static boolean contains(List<class_1799> list, class_1799 stack) {
        for (class_1799 item : list) {
            if (!class_1799.method_31577((class_1799)item, (class_1799)stack)) continue;
            return true;
        }
        return false;
    }

    private static IntArrayList createIntArray(List<class_1799> stacks) {
        return new IntArrayList();
    }

    private static /* synthetic */ void lambda$getMissing$0(List inputs, IntSet missing, List stacks, IntList indices) {
        int count = ((class_1799)stacks.getFirst()).method_7947();
        int size = indices.size();
        int remaining = count * size;
        for (BigItemStack stack : inputs) {
            if (!CraftableInput.contains(stacks, stack.stack) || (remaining -= stack.count) > 0) continue;
            return;
        }
        missing.addAll((IntCollection)indices.subList(size - (remaining + count - 1) / count, size));
    }

    @Environment(value=EnvType.CLIENT)
    public static class InputStrategy
    implements Hash.Strategy<List<class_1799>> {
        public int hashCode(List<class_1799> list) {
            int size = list.size();
            int[] codes = new int[size];
            for (int i = 0; i < size; ++i) {
                codes[i] = class_1799.method_57355((class_1799)list.get(i));
            }
            Arrays.sort(codes);
            int hash = 0;
            for (int i = 0; i < size; ++i) {
                hash = hash * 31 + codes[i];
            }
            return hash;
        }

        public boolean equals(List<class_1799> a, List<class_1799> b) {
            class_1799 stack;
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            int size = a.size();
            if (b.size() != size) {
                return false;
            }
            if (size == 1) {
                return class_1799.method_31577((class_1799)a.getFirst(), (class_1799)b.getFirst());
            }
            int end = size - 1;
            LinkedList<class_1799> queue = new LinkedList<class_1799>();
            class_1799 current = b.getFirst();
            int index = 1;
            for (int i = 0; i < end; ++i) {
                stack = a.get(i);
                if (class_1799.method_31577((class_1799)stack, (class_1799)current)) {
                    current = b.get(index++);
                    continue;
                }
                queue.add(stack);
            }
            stack = a.get(end);
            if (class_1799.method_31577((class_1799)stack, (class_1799)current)) {
                if (index == size) {
                    return true;
                }
                current = b.get(index++);
            } else {
                if (queue.size() == end) {
                    return false;
                }
                queue.add(stack);
            }
            block1: while (index <= end) {
                Iterator iterator = queue.iterator();
                do {
                    if (!class_1799.method_31577((class_1799)(stack = (class_1799)iterator.next()), (class_1799)current)) continue;
                    iterator.remove();
                    current = b.get(index++);
                    continue block1;
                } while (iterator.hasNext());
                return false;
            }
            return class_1799.method_31577((class_1799)((class_1799)queue.getFirst()), (class_1799)current);
        }
    }
}

