/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.stockTicker;

import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.content.logistics.AddressEditBox;
import com.zurrtum.create.client.content.logistics.stockTicker.CraftableBigItemStack;
import com.zurrtum.create.client.content.logistics.stockTicker.CraftableInput;
import com.zurrtum.create.client.content.trains.station.NoShadowFontWrapper;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.render.BlazeBurnerRenderState;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.contraptions.actors.seat.SeatEntity;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.stockTicker.PackageOrder;
import com.zurrtum.create.content.logistics.stockTicker.StockKeeperRequestMenu;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.infrastructure.component.ClipboardEntry;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import com.zurrtum.create.infrastructure.packet.c2s.LogisticalStockRequestPacket;
import com.zurrtum.create.infrastructure.packet.c2s.PackageOrderRequestPacket;
import com.zurrtum.create.infrastructure.packet.c2s.StockKeeperCategoryHidingPacket;
import com.zurrtum.create.infrastructure.packet.c2s.StockKeeperLockPacket;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_11256;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_768;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class StockKeeperRequestScreen
extends AbstractSimiContainerScreen<StockKeeperRequestMenu> {
    private static final AllGuiTextures NUMBERS = AllGuiTextures.NUMBERS;
    private static final AllGuiTextures HEADER = AllGuiTextures.STOCK_KEEPER_REQUEST_HEADER;
    private static final AllGuiTextures BODY = AllGuiTextures.STOCK_KEEPER_REQUEST_BODY;
    private static final AllGuiTextures FOOTER = AllGuiTextures.STOCK_KEEPER_REQUEST_FOOTER;
    StockTickerBlockEntity blockEntity;
    public LerpedFloat itemScroll = LerpedFloat.linear().startWithValue(0.0);
    final int rows = 9;
    final int cols = 9;
    final int rowHeight = 20;
    final int colWidth = 20;
    final Couple<Integer> noneHovered = Couple.create(-1, -1);
    int itemsX;
    int itemsY;
    int orderY;
    int lockX;
    int lockY;
    int windowWidth;
    int windowHeight;
    public class_342 searchBox;
    public AddressEditBox addressBox;
    int emptyTicks = 0;
    int successTicks = 0;
    public List<List<BigItemStack>> currentItemSource;
    public List<List<BigItemStack>> displayedItems = new ArrayList<List<BigItemStack>>();
    public List<CategoryEntry> categories = new ArrayList<CategoryEntry>();
    public List<BigItemStack> itemsToOrder = new ArrayList<BigItemStack>();
    public List<CraftableBigItemStack> recipesToOrder = new ArrayList<CraftableBigItemStack>();
    WeakReference<class_1309> stockKeeper = new WeakReference<Object>(null);
    WeakReference<BlazeBurnerBlockEntity> blaze = new WeakReference<Object>(null);
    boolean encodeRequester;
    class_1799 itemToProgram;
    List<List<ClipboardEntry>> clipboardItem;
    private boolean isAdmin;
    private boolean isLocked;
    private boolean scrollHandleActive;
    private boolean ignoreTextInput;
    public boolean refreshSearchNextTick = false;
    public boolean moveToTopNextTick = false;
    private List<class_768> extraAreas = Collections.emptyList();
    private final Set<Integer> hiddenCategories;
    private InventorySummary forcedEntries = new InventorySummary();
    private boolean canRequestCraftingPackage = false;

    public StockKeeperRequestScreen(StockKeeperRequestMenu container, class_1661 inv, class_2561 title) {
        super(container, inv, title);
        this.blockEntity = (StockTickerBlockEntity)container.contentHolder;
        this.blockEntity.lastClientsideStockSnapshot = null;
        this.blockEntity.ticksSinceLastUpdate = 15;
        ((StockKeeperRequestMenu)this.field_2797).screenReference = this;
        this.hiddenCategories = new HashSet<Integer>(this.blockEntity.hiddenCategoriesByPlayer.getOrDefault(((StockKeeperRequestMenu)this.field_2797).player.method_5667(), List.of()));
        this.itemToProgram = ((StockKeeperRequestMenu)this.field_2797).player.method_6047();
        boolean bl = this.encodeRequester = this.itemToProgram.method_31573(AllItemTags.TABLE_CLOTHS) || this.itemToProgram.method_31574((class_1792)AllItems.REDSTONE_REQUESTER);
        if (this.itemToProgram.method_31574((class_1792)AllItems.CLIPBOARD)) {
            this.clipboardItem = ClipboardEntry.readAll(this.itemToProgram);
            boolean anyItems = false;
            block0: for (List<ClipboardEntry> list : this.clipboardItem) {
                for (ClipboardEntry entry : list) {
                    if (entry.icon.method_7960()) continue;
                    anyItems = true;
                    continue block0;
                }
            }
            if (!anyItems) {
                this.clipboardItem = null;
            }
        }
        for (int yOffset : Iterate.zeroAndOne) {
            for (class_2350 side : Iterate.horizontalDirections) {
                class_2586 class_25862;
                class_2338 seatPos = this.blockEntity.method_11016().method_10087(yOffset).method_10093(side);
                for (SeatEntity seatEntity : this.blockEntity.method_10997().method_18467(SeatEntity.class, new class_238(seatPos))) {
                    Object e;
                    if (seatEntity.method_5685().isEmpty() || !((e = seatEntity.method_5685().getFirst()) instanceof class_1309)) continue;
                    class_1309 keeper = (class_1309)e;
                    this.stockKeeper = new WeakReference<class_1309>(keeper);
                }
                if (yOffset != 0 || !((class_25862 = this.blockEntity.method_10997().method_8321(seatPos)) instanceof BlazeBurnerBlockEntity)) continue;
                BlazeBurnerBlockEntity bbbe = (BlazeBurnerBlockEntity)class_25862;
                this.blaze = new WeakReference<BlazeBurnerBlockEntity>(bbbe);
                return;
            }
        }
    }

    public static StockKeeperRequestScreen create(class_310 mc, MenuType<StockTickerBlockEntity> type, int syncId, class_1661 inventory, class_2561 title, class_9129 extraData) {
        StockKeeperRequestScreen screen = (StockKeeperRequestScreen)((Object)type.create(StockKeeperRequestScreen::new, syncId, inventory, title, (StockTickerBlockEntity)StockKeeperRequestScreen.getBlockEntity(mc, extraData)));
        if (screen == null) {
            return null;
        }
        screen.isAdmin = extraData.readBoolean();
        screen.isLocked = extraData.readBoolean();
        return screen;
    }

    @Override
    protected void method_25426() {
        int appropriateHeight = class_310.method_1551().method_22683().method_4502() - 10;
        appropriateHeight -= class_3532.method_15387((int)(appropriateHeight - HEADER.getHeight() - FOOTER.getHeight()), (int)BODY.getHeight());
        appropriateHeight = Math.min(appropriateHeight, HEADER.getHeight() + FOOTER.getHeight() + BODY.getHeight() * 17);
        this.windowWidth = 226;
        this.windowHeight = appropriateHeight;
        this.setWindowSize(226, this.windowHeight);
        super.method_25426();
        this.method_37067();
        this.itemsX = this.field_2776 + (this.windowWidth - 180) / 2 + 1;
        this.itemsY = this.field_2800 + 33;
        this.orderY = this.field_2800 + this.windowHeight - 72;
        this.lockX = this.field_2776 + 186;
        this.lockY = this.field_2800 + 18;
        class_5250 searchLabel = CreateLang.translateDirect("gui.stock_keeper.search_items", new Object[0]);
        this.searchBox = new class_342((class_327)new NoShadowFontWrapper(this.field_22793), this.field_2776 + 71, this.field_2800 + 22, 100, 9, (class_2561)searchLabel);
        this.searchBox.method_1880(50);
        this.searchBox.method_1858(false);
        this.searchBox.method_1868(-11915983);
        this.method_25429((class_364)this.searchBox);
        boolean initial = this.addressBox == null;
        String previouslyUsedAddress = initial ? this.blockEntity.previouslyUsedAddress : this.addressBox.method_1882();
        this.addressBox = new AddressEditBox((class_437)this, new NoShadowFontWrapper(this.field_22793), this.field_2776 + 27, this.field_2800 + this.windowHeight - 36, 92, 10, true);
        this.addressBox.method_1868(-9352640);
        this.addressBox.method_1852(previouslyUsedAddress);
        this.method_37063((class_364)this.addressBox);
        this.extraAreas = new ArrayList<class_768>();
        int leftHeight = 40;
        int rightHeight = 50;
        class_1309 keeper = (class_1309)this.stockKeeper.get();
        if (keeper != null && keeper.method_5805()) {
            leftHeight = (int)(Math.max(0.0, keeper.method_5829().method_17940()) * 50.0);
        }
        this.extraAreas.add(new class_768(0, this.field_2800 + this.windowHeight - 15 - leftHeight, this.field_2776, this.field_22790));
        if (this.encodeRequester) {
            this.extraAreas.add(new class_768(this.field_2776 + this.windowWidth, this.field_2800 + this.windowHeight - 15 - rightHeight, rightHeight + 10, rightHeight));
        }
        if (initial) {
            this.playUiSound(class_3417.field_14808, 0.5f, 1.5f);
            this.playUiSound(class_3417.field_17481, 1.0f, 1.0f);
        }
    }

    private void refreshSearchResults(boolean scrollBackUp) {
        this.displayedItems = Collections.emptyList();
        if (scrollBackUp) {
            this.itemScroll.startWithValue(0.0);
        }
        if (this.currentItemSource == null) {
            this.clampScrollBar();
            return;
        }
        if (this.isSchematicListMode()) {
            this.clampScrollBar();
            this.requestSchematicList();
            return;
        }
        this.categories = new ArrayList<CategoryEntry>();
        for (int i = 0; i < this.blockEntity.categories.size(); ++i) {
            class_1799 stack = this.blockEntity.categories.get(i);
            CategoryEntry entry = new CategoryEntry(i, stack.method_7960() ? "" : stack.method_7964().getString(), 0);
            entry.hidden = this.hiddenCategories.contains(i);
            this.categories.add(entry);
        }
        CategoryEntry unsorted = new CategoryEntry(-1, CreateLang.translate("gui.stock_keeper.unsorted_category", new Object[0]).string(), 0);
        unsorted.hidden = this.hiddenCategories.contains(-1);
        this.categories.add(unsorted);
        String valueWithPrefix = this.searchBox.method_1882();
        boolean anyItemsInCategory = false;
        if (valueWithPrefix.isBlank()) {
            this.displayedItems = new ArrayList<List<BigItemStack>>(this.currentItemSource);
            int categoryY = 0;
            for (int categoryIndex = 0; categoryIndex < this.currentItemSource.size(); ++categoryIndex) {
                this.categories.get((int)categoryIndex).y = categoryY;
                List<BigItemStack> displayedItemsInCategory = this.displayedItems.get(categoryIndex);
                if (displayedItemsInCategory.isEmpty()) continue;
                if (categoryIndex < this.currentItemSource.size() - 1) {
                    anyItemsInCategory = true;
                }
                categoryY += 20;
                if (this.categories.get((int)categoryIndex).hidden) continue;
                categoryY = (int)((double)categoryY + Math.ceil((float)displayedItemsInCategory.size() / 9.0f) * 20.0);
            }
            if (!anyItemsInCategory) {
                this.categories.clear();
            }
            this.clampScrollBar();
            this.updateCraftableAmounts();
            return;
        }
        boolean modSearch = false;
        boolean tagSearch = false;
        modSearch = valueWithPrefix.startsWith("@");
        if (modSearch || (tagSearch = valueWithPrefix.startsWith("#"))) {
            valueWithPrefix = valueWithPrefix.substring(1);
        }
        String value = valueWithPrefix.toLowerCase(Locale.ROOT);
        this.displayedItems = new ArrayList<List<BigItemStack>>();
        this.currentItemSource.forEach($ -> this.displayedItems.add(new ArrayList()));
        int categoryY = 0;
        for (int categoryIndex = 0; categoryIndex < this.displayedItems.size(); ++categoryIndex) {
            List<BigItemStack> category = this.currentItemSource.get(categoryIndex);
            this.categories.get((int)categoryIndex).y = categoryY;
            if (this.displayedItems.size() <= categoryIndex) break;
            List<BigItemStack> displayedItemsInCategory = this.displayedItems.get(categoryIndex);
            for (BigItemStack entry : category) {
                class_1799 stack = entry.stack;
                if (modSearch) {
                    if (!class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836().contains(value)) continue;
                    displayedItemsInCategory.add(entry);
                    continue;
                }
                if (tagSearch) {
                    if (!stack.method_40133().anyMatch(key -> key.comp_327().toString().contains(value))) continue;
                    displayedItemsInCategory.add(entry);
                    continue;
                }
                if (!stack.method_7964().getString().toLowerCase(Locale.ROOT).contains(value) && !class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832().contains(value)) continue;
                displayedItemsInCategory.add(entry);
            }
            if (displayedItemsInCategory.isEmpty()) continue;
            if (categoryIndex < this.currentItemSource.size() - 1) {
                anyItemsInCategory = true;
            }
            categoryY += 20;
            if (this.categories.get((int)categoryIndex).hidden) continue;
            categoryY = (int)((double)categoryY + Math.ceil((float)displayedItemsInCategory.size() / 9.0f) * 20.0);
        }
        if (!anyItemsInCategory) {
            this.categories.clear();
        }
        this.clampScrollBar();
        this.updateCraftableAmounts();
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        this.addressBox.tick();
        if (!this.forcedEntries.isEmpty()) {
            InventorySummary summary = this.blockEntity.getLastClientsideStockSnapshotAsSummary();
            for (BigItemStack bigItemStack : this.forcedEntries.getStacks()) {
                int limitedAmount = -bigItemStack.count - 1;
                int actualAmount = summary.getCountOf(bigItemStack.stack);
                if (actualAmount > limitedAmount) continue;
                this.forcedEntries.erase(bigItemStack.stack);
            }
        }
        boolean allEmpty = true;
        for (List list : this.displayedItems) {
            allEmpty &= list.isEmpty();
        }
        this.emptyTicks = allEmpty ? ++this.emptyTicks : 0;
        this.successTicks = this.successTicks > 0 && this.itemsToOrder.isEmpty() ? ++this.successTicks : 0;
        List<List<BigItemStack>> clientStockSnapshot = this.blockEntity.getClientStockSnapshot();
        if (clientStockSnapshot != this.currentItemSource) {
            this.currentItemSource = clientStockSnapshot;
            this.refreshSearchResults(false);
            this.revalidateOrders();
        }
        if (this.refreshSearchNextTick) {
            this.refreshSearchNextTick = false;
            this.refreshSearchResults(this.moveToTopNextTick);
        }
        this.itemScroll.tickChaser();
        if (Math.abs(this.itemScroll.getValue() - this.itemScroll.getChaseTarget()) < 0.0625f) {
            this.itemScroll.setValue(this.itemScroll.getChaseTarget());
        }
        if (this.blockEntity.ticksSinceLastUpdate > 15) {
            this.blockEntity.resetTicksSinceLastUpdate();
            this.field_22787.field_1724.field_3944.method_52787((class_2596)new LogisticalStockRequestPacket(this.blockEntity.method_11016()));
        }
        class_1309 class_13092 = (class_1309)this.stockKeeper.get();
        BlazeBurnerBlockEntity blazeKeeper = (BlazeBurnerBlockEntity)this.blaze.get();
        if (!(class_13092 != null && class_13092.method_5805() || blazeKeeper != null && !blazeKeeper.method_11015())) {
            this.field_22787.field_1724.method_7346();
        }
    }

    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        boolean justSent;
        BlazeBurnerBlockEntity keeperBE;
        int entityY;
        int entityX;
        if (this != this.field_22787.field_1755) {
            return;
        }
        partialTicks = AnimationTickHolder.getPartialTicksUI(this.field_22787.method_61966());
        Matrix3x2fStack ms = graphics.method_51448();
        float currentScroll = this.itemScroll.getValue(partialTicks);
        Couple<Integer> hoveredSlot = this.getHoveredSlot(mouseX, mouseY);
        int x = this.field_2776;
        int y = this.field_2800;
        HEADER.render(graphics, x - 15, y);
        y += HEADER.getHeight();
        for (int i = 0; i < (this.windowHeight - HEADER.getHeight() - FOOTER.getHeight()) / BODY.getHeight(); ++i) {
            BODY.render(graphics, x - 15, y);
            y += BODY.getHeight();
        }
        FOOTER.render(graphics, x - 15, y);
        y = this.field_2800;
        if (this.addressBox.method_1882().isBlank() && !this.addressBox.method_25370()) {
            graphics.method_51439(this.field_22793, (class_2561)CreateLang.translate("gui.stock_keeper.package_adress", new Object[0]).style(class_124.field_1056).component(), this.addressBox.method_46426(), this.addressBox.method_46427(), -3294040, false);
        }
        int entitySizeOffset = 0;
        class_1309 keeper = (class_1309)this.stockKeeper.get();
        if (keeper != null && keeper.method_5805()) {
            ms.pushMatrix();
            entitySizeOffset = (int)(Math.max(0.0, keeper.method_5829().method_17939() - 1.0) * 50.0);
            int entitySizeOffsetY = (int)(Math.max(0.0, keeper.method_5829().method_17940() - 1.0) * 25.0);
            entityX = x - 35 - entitySizeOffset;
            entityY = y + this.windowHeight - 47 - entitySizeOffsetY;
            class_490.method_2486((class_332)graphics, (int)(entityX - 100), (int)(entityY - 100), (int)(entityX + 100), (int)(entityY + 100), (int)50, (float)0.0f, (float)mouseX, (float)class_3532.method_15340((int)mouseY, (int)(entityY - 50), (int)(entityY + 10)), (class_1309)keeper);
            ms.popMatrix();
        }
        if ((keeperBE = (BlazeBurnerBlockEntity)this.blaze.get()) != null && !keeperBE.method_11015()) {
            entityX = x - 69;
            entityY = y + this.windowHeight - 85;
            class_638 world = this.field_22787.field_1687;
            class_2680 block = keeperBE.method_11010();
            BlazeBurnerBlock.HeatLevel heatLevel = keeperBE.getHeatLevelForRender();
            float animation = keeperBE.headAnimation.getValue(partialTicks) * 0.175f;
            boolean drawGoggles = keeperBE.goggles;
            int hashCode = keeperBE.hashCode();
            graphics.field_59826.method_70922((class_11256)new BlazeBurnerRenderState(new Matrix3x2f((Matrix3x2fc)ms), entityX, entityY, (class_1937)world, block, heatLevel, animation, drawGoggles, hashCode));
        }
        if (this.encodeRequester) {
            ms.pushMatrix();
            ms.scale(3.5f, 3.5f);
            graphics.method_51427(this.itemToProgram, x + this.windowWidth + 5, y + this.windowHeight - 70);
            ms.popMatrix();
        }
        for (int index = 0; index < 9 && this.itemsToOrder.size() > index; ++index) {
            BigItemStack entry = this.itemsToOrder.get(index);
            boolean isStackHovered = index == (Integer)hoveredSlot.getSecond() && (Integer)hoveredSlot.getFirst() == -1;
            ms.pushMatrix();
            ms.translate((float)(this.itemsX + index * 20), (float)this.orderY);
            this.renderItemEntry(graphics, entry, isStackHovered, true);
            ms.popMatrix();
        }
        if (this.itemsToOrder.size() > 9) {
            graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)("[+" + (this.itemsToOrder.size() - 9) + "]")), x + this.windowWidth - 40, this.orderY + 21, -460564, true);
        }
        boolean bl = justSent = this.itemsToOrder.isEmpty() && this.successTicks > 0;
        if (this.isConfirmHovered(mouseX, mouseY) && !justSent) {
            AllGuiTextures.STOCK_KEEPER_REQUEST_SEND_HOVER.render(graphics, x + this.windowWidth - 81, y + this.windowHeight - 41);
        }
        class_5250 headerTitle = CreateLang.translate("gui.stock_keeper.title", new Object[0]).component();
        graphics.method_51439(this.field_22793, (class_2561)headerTitle, x + this.windowWidth / 2 - this.field_22793.method_27525((class_5348)headerTitle) / 2, y + 4, -9352640, false);
        class_5250 component = CreateLang.translate(this.encodeRequester ? "gui.stock_keeper.configure" : "gui.stock_keeper.send", new Object[0]).component();
        if (justSent) {
            float alpha = class_3532.method_15363((float)(((float)this.successTicks + partialTicks - 5.0f) / 5.0f), (float)0.0f, (float)1.0f);
            ms.pushMatrix();
            ms.translate(alpha * alpha * 50.0f, 0.0f);
            if (this.successTicks < 10) {
                graphics.method_51439(this.field_22793, (class_2561)component, x + this.windowWidth - 42 - this.field_22793.method_27525((class_5348)component) / 2, y + this.windowHeight - 35, new Color(0x252525).setAlpha(1.0f - alpha * alpha).getRGB(), false);
            }
            ms.popMatrix();
        } else {
            graphics.method_51439(this.field_22793, (class_2561)component, x + this.windowWidth - 42 - this.field_22793.method_27525((class_5348)component) / 2, y + this.windowHeight - 35, -14342875, false);
        }
        if (justSent) {
            class_5250 msg = CreateLang.translateDirect("gui.stock_keeper.request_sent", new Object[0]);
            float alpha = class_3532.method_15363((float)(((float)this.successTicks + partialTicks - 10.0f) / 5.0f), (float)0.0f, (float)1.0f);
            int msgX = x + this.windowWidth / 2 - (this.field_22793.method_27525((class_5348)msg) + 10) / 2;
            int msgY = this.orderY + 5;
            if (alpha > 0.0f) {
                int c3 = new Color(9198923).setAlpha(alpha).getRGB();
                int w = this.field_22793.method_27525((class_5348)msg) + 14;
                AllGuiTextures.STOCK_KEEPER_REQUEST_BANNER_L.render(graphics, msgX - 8, msgY - 4);
                UIRenderHelper.drawStretched(graphics, msgX, msgY - 4, w, 16, AllGuiTextures.STOCK_KEEPER_REQUEST_BANNER_M);
                AllGuiTextures.STOCK_KEEPER_REQUEST_BANNER_R.render(graphics, msgX + this.field_22793.method_27525((class_5348)msg) + 10, msgY - 4);
                graphics.method_51439(this.field_22793, (class_2561)msg, msgX + 5, msgY, c3, false);
            }
        }
        int itemWindowX = x + 21;
        int itemWindowX2 = itemWindowX + 184;
        int itemWindowY = y + 17;
        int itemWindowY2 = y + this.windowHeight - 80;
        graphics.method_44379(itemWindowX - 5, itemWindowY, itemWindowX2 + 10, itemWindowY2);
        ms.pushMatrix();
        ms.translate(0.0f, -currentScroll * 20.0f);
        for (int sliceY = -2; sliceY < this.getMaxScroll() * 20 + this.windowHeight - 72; sliceY += AllGuiTextures.STOCK_KEEPER_REQUEST_BG.getHeight()) {
            if ((float)sliceY - currentScroll * 20.0f < -20.0f || (float)sliceY - currentScroll * 20.0f > (float)(this.windowHeight - 72)) continue;
            AllGuiTextures.STOCK_KEEPER_REQUEST_BG.render(graphics, x + 22, y + sliceY + 18);
        }
        AllGuiTextures.STOCK_KEEPER_REQUEST_SEARCH.render(graphics, x + 42, this.searchBox.method_46427() - 5);
        this.searchBox.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.searchBox.method_1882().isBlank() && !this.searchBox.method_25370()) {
            graphics.method_51439(this.field_22793, this.searchBox.method_25369(), x + this.windowWidth / 2 - this.field_22793.method_27525((class_5348)this.searchBox.method_25369()) / 2, this.searchBox.method_46427(), -11915983, false);
        }
        boolean allEmpty = true;
        for (List<BigItemStack> list : this.displayedItems) {
            allEmpty &= list.isEmpty();
        }
        if (allEmpty) {
            class_2561 msg = this.getTroubleshootingMessage();
            float alpha = class_3532.method_15363((float)(((float)this.emptyTicks - 10.0f) / 5.0f), (float)0.0f, (float)1.0f);
            if (alpha > 0.0f) {
                List split = this.field_22793.method_1728((class_5348)msg, 160);
                for (int i = 0; i < split.size(); ++i) {
                    class_5481 sequence = (class_5481)split.get(i);
                    int lineWidth = this.field_22793.method_30880(sequence);
                    int n = x + this.windowWidth / 2 - lineWidth / 2 + 1;
                    Objects.requireNonNull(this.field_22793);
                    graphics.method_51430(this.field_22793, sequence, n, this.itemsY + 20 + 1 + i * (9 + 1), new Color(4861233).setAlpha(alpha).getRGB(), false);
                    int n2 = x + this.windowWidth / 2 - lineWidth / 2;
                    Objects.requireNonNull(this.field_22793);
                    graphics.method_51430(this.field_22793, sequence, n2, this.itemsY + 20 + i * (9 + 1), new Color(16316652).setAlpha(alpha).getRGB(), false);
                }
            }
        }
        block5: for (int categoryIndex = 0; categoryIndex < this.displayedItems.size(); ++categoryIndex) {
            int categoryY;
            List<BigItemStack> category = this.displayedItems.get(categoryIndex);
            CategoryEntry categoryEntry = this.categories.isEmpty() ? null : this.categories.get(categoryIndex);
            int n = categoryY = this.categories.isEmpty() ? 0 : categoryEntry.y;
            if (category.isEmpty()) continue;
            if (!this.categories.isEmpty()) {
                (categoryEntry.hidden ? AllGuiTextures.STOCK_KEEPER_CATEGORY_HIDDEN : AllGuiTextures.STOCK_KEEPER_CATEGORY_SHOWN).render(graphics, this.itemsX, this.itemsY + categoryY + 6);
                graphics.method_51433(this.field_22793, categoryEntry.name, this.itemsX + 10, this.itemsY + categoryY + 8, -11915983, false);
                graphics.method_51433(this.field_22793, categoryEntry.name, this.itemsX + 9, this.itemsY + categoryY + 7, -460564, false);
                if (categoryEntry.hidden) continue;
            }
            for (int index = 0; index < category.size(); ++index) {
                int pY = this.itemsY + categoryY + (this.categories.isEmpty() ? 4 : 20) + index / 9 * 20;
                float cullY = (float)pY - currentScroll * 20.0f;
                if (cullY < (float)y) continue;
                if (cullY > (float)(y + this.windowHeight - 72)) continue block5;
                boolean isStackHovered = index == (Integer)hoveredSlot.getSecond() && categoryIndex == (Integer)hoveredSlot.getFirst();
                BigItemStack entry = category.get(index);
                ms.pushMatrix();
                ms.translate((float)(this.itemsX + index % 9 * 20), (float)pY);
                this.renderItemEntry(graphics, entry, isStackHovered, false);
                ms.popMatrix();
            }
        }
        if (this.isAdmin) {
            (this.isLocked ? AllGuiTextures.STOCK_KEEPER_REQUEST_LOCKED : AllGuiTextures.STOCK_KEEPER_REQUEST_UNLOCKED).render(graphics, this.lockX, this.lockY);
        }
        ms.popMatrix();
        graphics.method_44380();
        int windowH = this.windowHeight - 92;
        int totalH = this.getMaxScroll() * 20 + windowH;
        int barSize = Math.max(5, class_3532.method_15375((float)((float)windowH / (float)totalH * (float)(windowH - 2))));
        if (barSize < windowH - 2) {
            int barX = this.itemsX + 180;
            int barY = y + 15;
            ms.pushMatrix();
            ms.translate(0.0f, currentScroll * 20.0f / (float)totalH * (float)(windowH - 2));
            AllGuiTextures pad = AllGuiTextures.STOCK_KEEPER_REQUEST_SCROLL_PAD;
            graphics.method_25302(class_10799.field_56883, pad.location, barX, barY, (float)pad.getStartX(), (float)pad.getStartY(), pad.getWidth(), barSize, pad.getWidth(), pad.getHeight(), 256, 256);
            AllGuiTextures.STOCK_KEEPER_REQUEST_SCROLL_TOP.render(graphics, barX, barY);
            if (barSize > 16) {
                AllGuiTextures.STOCK_KEEPER_REQUEST_SCROLL_MID.render(graphics, barX, barY + barSize / 2 - 4);
            }
            AllGuiTextures.STOCK_KEEPER_REQUEST_SCROLL_BOT.render(graphics, barX, barY + barSize - 5);
            ms.popMatrix();
        }
        if (!this.recipesToOrder.isEmpty()) {
            int jeiX = x + (this.windowWidth - 20 * this.recipesToOrder.size()) / 2 + 1;
            int jeiY = this.orderY - 31;
            ms.pushMatrix();
            ms.translate((float)jeiX, (float)jeiY);
            int xoffset = -3;
            AllGuiTextures.STOCK_KEEPER_REQUEST_BLUEPRINT_LEFT.render(graphics, xoffset, -3);
            xoffset += 10;
            for (int i = 0; i <= (this.recipesToOrder.size() - 1) * 5; ++i) {
                AllGuiTextures.STOCK_KEEPER_REQUEST_BLUEPRINT_MIDDLE.render(graphics, xoffset, -3);
                xoffset += 4;
            }
            AllGuiTextures.STOCK_KEEPER_REQUEST_BLUEPRINT_RIGHT.render(graphics, xoffset, -3);
            for (int index = 0; index < this.recipesToOrder.size(); ++index) {
                CraftableBigItemStack craftableBigItemStack = this.recipesToOrder.get(index);
                boolean isStackHovered = index == (Integer)hoveredSlot.getSecond() && -2 == (Integer)hoveredSlot.getFirst();
                ms.pushMatrix();
                ms.translate((float)(index * 20), 0.0f);
                this.renderItemEntry(graphics, craftableBigItemStack, isStackHovered, true);
                ms.popMatrix();
            }
            ms.popMatrix();
        }
    }

    @Override
    protected void renderForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
        float currentScroll = this.itemScroll.getValue(partialTicks);
        Couple<Integer> hoveredSlot = this.getHoveredSlot(mouseX, mouseY);
        if (hoveredSlot != this.noneHovered) {
            BigItemStack entry;
            boolean orderHovered;
            int slot = (Integer)hoveredSlot.getSecond();
            boolean recipeHovered = (Integer)hoveredSlot.getFirst() == -2;
            boolean bl = orderHovered = (Integer)hoveredSlot.getFirst() == -1;
            BigItemStack bigItemStack = recipeHovered ? (BigItemStack)this.recipesToOrder.get(slot) : (entry = orderHovered ? this.itemsToOrder.get(slot) : this.displayedItems.get((Integer)hoveredSlot.getFirst()).get(slot));
            if (recipeHovered) {
                ArrayList<class_5250> lines = new ArrayList<class_5250>(entry.stack.method_7950(class_1792.class_9635.method_59528((class_1937)this.field_22787.field_1687), (class_1657)this.field_22787.field_1724, (class_1836)class_1836.field_41070));
                if (!lines.isEmpty()) {
                    lines.set(0, CreateLang.translateDirect("gui.stock_keeper.craft", ((class_2561)lines.getFirst()).method_27661()));
                }
                graphics.method_51434(this.field_22793, lines, mouseX, mouseY);
            } else {
                graphics.method_51446(this.field_22793, entry.stack, mouseX, mouseY);
            }
        }
        if (currentScroll < 1.0f && this.isAdmin && mouseX > this.lockX && mouseX <= this.lockX + 15 && mouseY > this.lockY && mouseY <= this.lockY + 15) {
            graphics.method_51434(this.field_22793, List.of(CreateLang.translate(this.isLocked ? "gui.stock_keeper.network_locked" : "gui.stock_keeper.network_open", new Object[0]).component(), CreateLang.translate("gui.stock_keeper.network_lock_tip", new Object[0]).style(class_124.field_1080).component(), CreateLang.translate("gui.stock_keeper.network_lock_tip_1", new Object[0]).style(class_124.field_1080).component(), CreateLang.translate("gui.stock_keeper.network_lock_tip_2", new Object[0]).style(class_124.field_1063).style(class_124.field_1056).component()), mouseX, mouseY);
        }
        if (this.addressBox.method_1882().isBlank() && !this.addressBox.method_25370() && this.addressBox.method_49606()) {
            graphics.method_51434(this.field_22793, List.of(CreateLang.translate("gui.factory_panel.restocker_address", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.schedule.lmb_edit", new Object[0]).style(class_124.field_1063).style(class_124.field_1056).component()), mouseX, mouseY);
        }
    }

    private void renderItemEntry(class_332 graphics, BigItemStack entry, boolean isStackHovered, boolean isRenderingOrders) {
        int customCount = entry.count;
        if (!isRenderingOrders) {
            BigItemStack order = this.getOrderForItem(entry.stack);
            if (entry.count < 1000000000) {
                int forcedCount = this.forcedEntries.getCountOf(entry.stack);
                if (forcedCount != 0) {
                    customCount = Math.min(customCount, -forcedCount - 1);
                }
                if (order != null) {
                    customCount -= order.count;
                }
                customCount = Math.max(0, customCount);
            }
            AllGuiTextures.STOCK_KEEPER_REQUEST_SLOT.render(graphics, 0, 0);
        }
        boolean craftable = entry instanceof CraftableBigItemStack;
        Matrix3x2fStack ms = graphics.method_51448();
        ms.pushMatrix();
        float scaleFromHover = 1.0f;
        if (isStackHovered) {
            scaleFromHover += 0.075f;
        }
        ms.translate(1.0f, 1.0f);
        ms.translate(9.0f, 9.0f);
        ms.scale(scaleFromHover, scaleFromHover);
        ms.translate(-9.0f, -9.0f);
        if (customCount != 0 || craftable) {
            graphics.method_51427(entry.stack, 0, 0);
        }
        ms.popMatrix();
        ms.pushMatrix();
        if (customCount != 0 || craftable) {
            graphics.method_51432(this.field_22793, entry.stack, 1, 1, "");
        }
        if (customCount > 1 || craftable) {
            this.drawItemCount(graphics, customCount);
        }
        ms.popMatrix();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawItemCount(class_332 graphics, int customCount) {
        Object text;
        Object object = customCount >= 1000000 ? customCount / 1000000 + "m" : (customCount >= 10000 ? customCount / 1000 + "k" : (customCount >= 1000 ? (float)(customCount * 10 / 1000) / 10.0f + "k" : (text = customCount >= 100 ? "" + customCount : " " + customCount)));
        if (customCount >= 1000000000) {
            text = "+";
        }
        if (((String)text).isBlank()) {
            return;
        }
        int x = (int)Math.floor((double)(-((String)text).length()) * 2.5);
        char[] cArray = ((String)text).toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (true) {
            block11: {
                if (n2 >= n) {
                    return;
                }
                char c = cArray[n2];
                int index = c - 48;
                int xOffset = index * 6;
                int spriteWidth = NUMBERS.getWidth();
                switch (c) {
                    case ' ': {
                        x += 4;
                        break block11;
                    }
                    case '.': {
                        spriteWidth = 3;
                        xOffset = 60;
                        break;
                    }
                    case 'k': {
                        xOffset = 64;
                        break;
                    }
                    case 'm': {
                        spriteWidth = 7;
                        xOffset = 70;
                        break;
                    }
                    case '+': {
                        spriteWidth = 9;
                        xOffset = 84;
                    }
                }
                graphics.method_25290(class_10799.field_56883, StockKeeperRequestScreen.NUMBERS.location, 14 + x, 10, (float)(NUMBERS.getStartX() + xOffset), (float)NUMBERS.getStartY(), spriteWidth, NUMBERS.getHeight(), 256, 256);
                x += spriteWidth - 1;
            }
            ++n2;
        }
    }

    @Nullable
    private BigItemStack getOrderForItem(class_1799 stack) {
        for (BigItemStack entry : this.itemsToOrder) {
            if (!class_1799.method_31577((class_1799)stack, (class_1799)entry.stack)) continue;
            return entry;
        }
        return null;
    }

    private void revalidateOrders() {
        HashSet<BigItemStack> invalid = new HashSet<BigItemStack>(this.itemsToOrder);
        InventorySummary summary = this.blockEntity.getLastClientsideStockSnapshotAsSummary();
        if (this.currentItemSource == null || summary == null) {
            this.itemsToOrder.removeAll(invalid);
            return;
        }
        for (BigItemStack entry : this.itemsToOrder) {
            entry.count = Math.min(summary.getCountOf(entry.stack), entry.count);
            if (entry.count <= 0) continue;
            invalid.remove(entry);
        }
        this.itemsToOrder.removeAll(invalid);
    }

    private Couple<Integer> getHoveredSlot(int x, int y) {
        if (++x < this.itemsX || x >= this.itemsX + 180 || this.isSchematicListMode()) {
            return this.noneHovered;
        }
        if (y >= this.orderY && y < this.orderY + 20) {
            int col = (x - this.itemsX) / 20;
            if (this.itemsToOrder.size() <= col || col < 0) {
                return this.noneHovered;
            }
            return Couple.create(-1, col);
        }
        if (y >= this.orderY - 31 && y < this.orderY - 31 + 20) {
            int jeiX = this.field_2776 + (this.windowWidth - 20 * this.recipesToOrder.size()) / 2 + 1;
            int col = class_3532.method_48116((int)(x - jeiX), (int)20);
            if (this.recipesToOrder.size() > col && col >= 0) {
                return Couple.create(-2, col);
            }
        }
        if (y < this.field_2800 + 16 || y > this.field_2800 + this.windowHeight - 80) {
            return this.noneHovered;
        }
        if (!this.itemScroll.settled()) {
            return this.noneHovered;
        }
        int localY = y - this.itemsY;
        for (int categoryIndex = 0; categoryIndex < this.displayedItems.size(); ++categoryIndex) {
            int col;
            CategoryEntry entry;
            CategoryEntry categoryEntry = entry = this.categories.isEmpty() ? new CategoryEntry(0, "", 0) : this.categories.get(categoryIndex);
            if (entry.hidden) continue;
            int row = class_3532.method_15375((float)((float)(localY - (this.categories.isEmpty() ? 4 : 20) - entry.y) / 20.0f + this.itemScroll.getChaseTarget()));
            int slot = row * 9 + (col = (x - this.itemsX) / 20);
            if (slot < 0) {
                return this.noneHovered;
            }
            if (this.displayedItems.get(categoryIndex).size() <= slot) continue;
            return Couple.create(categoryIndex, slot);
        }
        return this.noneHovered;
    }

    @Nullable
    public class_1799 getHoveredItemStack(int mouseX, int mouseY) {
        boolean recipeHovered;
        Couple<Integer> hoveredSlot = this.getHoveredSlot(mouseX, mouseY);
        if (hoveredSlot == this.noneHovered) {
            return null;
        }
        int index = (Integer)hoveredSlot.getSecond();
        boolean bl = recipeHovered = (Integer)hoveredSlot.getFirst() == -2;
        BigItemStack entry = recipeHovered ? (BigItemStack)this.recipesToOrder.get(index) : ((Integer)hoveredSlot.getFirst() == -1 ? this.itemsToOrder.get(index) : this.displayedItems.get((Integer)hoveredSlot.getFirst()).get(index));
        return entry.stack.method_7972();
    }

    private boolean isConfirmHovered(int mouseX, int mouseY) {
        int confirmX = this.field_2776 + 143;
        int confirmY = this.field_2800 + this.windowHeight - 39;
        int confirmW = 78;
        int confirmH = 18;
        if (mouseX < confirmX || mouseX >= confirmX + confirmW) {
            return false;
        }
        return mouseY >= confirmY && mouseY < confirmY + confirmH;
    }

    private class_2561 getTroubleshootingMessage() {
        if (this.currentItemSource == null) {
            return CreateLang.translate("gui.stock_keeper.checking_stocks", new Object[0]).component();
        }
        if (this.blockEntity.activeLinks == 0) {
            return CreateLang.translate("gui.stock_keeper.no_packagers_linked", new Object[0]).component();
        }
        if (this.currentItemSource.isEmpty()) {
            return CreateLang.translate("gui.stock_keeper.inventories_empty", new Object[0]).component();
        }
        if (this.isSchematicListMode()) {
            return CreateLang.translate(this.itemsToOrder.isEmpty() ? "gui.stock_keeper.schematic_list.no_results" : "gui.stock_keeper.schematic_list.requesting", new Object[0]).component();
        }
        return CreateLang.translate("gui.stock_keeper.no_search_results", new Object[0]).component();
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        int transfer;
        boolean recipeClicked;
        boolean rmb;
        boolean lmb = pButton == 0;
        boolean bl = rmb = pButton == 1;
        if (rmb && this.searchBox.method_25405(pMouseX, pMouseY)) {
            this.searchBox.method_1852("");
            this.refreshSearchNextTick = true;
            this.moveToTopNextTick = true;
            this.searchBox.method_25365(true);
            return true;
        }
        if (this.addressBox.method_25370()) {
            boolean result = this.addressBox.method_25402(pMouseX, pMouseY, pButton);
            if (this.addressBox.method_49606() || result) {
                return result;
            }
            this.addressBox.method_25365(false);
        }
        if (this.searchBox.method_25370()) {
            if (this.searchBox.method_49606()) {
                return this.searchBox.method_25402(pMouseX, pMouseY, pButton);
            }
            this.searchBox.method_25365(false);
        }
        int barX = this.itemsX + 180 - 1;
        if (this.getMaxScroll() > 0 && lmb && pMouseX > (double)barX && pMouseX <= (double)(barX + 8) && pMouseY > (double)(this.field_2800 + 15) && pMouseY < (double)(this.field_2800 + this.windowHeight - 82)) {
            this.scrollHandleActive = true;
            if (this.field_22787.method_1569()) {
                GLFW.glfwSetInputMode((long)this.field_22787.method_22683().method_4490(), (int)208897, (int)212994);
            }
            return true;
        }
        Couple<Integer> hoveredSlot = this.getHoveredSlot((int)pMouseX, (int)pMouseY);
        if (this.isAdmin && this.itemScroll.getChaseTarget() == 0.0f && lmb && pMouseX > (double)this.lockX && pMouseX <= (double)(this.lockX + 15) && pMouseY > (double)this.lockY && pMouseY <= (double)(this.lockY + 15)) {
            this.isLocked = !this.isLocked;
            this.field_22787.field_1724.field_3944.method_52787((class_2596)new StockKeeperLockPacket(this.blockEntity.method_11016(), this.isLocked));
            this.playUiSound((class_3414)class_3417.field_15015.comp_349(), 1.0f, 1.0f);
            return true;
        }
        if (lmb && this.isConfirmHovered((int)pMouseX, (int)pMouseY)) {
            this.sendIt();
            this.playUiSound((class_3414)class_3417.field_15015.comp_349(), 1.0f, 1.0f);
            return true;
        }
        int localY = (int)(pMouseY - (double)this.itemsY);
        if (this.itemScroll.settled() && lmb && !this.categories.isEmpty() && pMouseX >= (double)this.itemsX && pMouseX < (double)(this.itemsX + 180) && pMouseY >= (double)(this.field_2800 + 16) && pMouseY <= (double)(this.field_2800 + this.windowHeight - 80)) {
            for (int categoryIndex = 0; categoryIndex < this.displayedItems.size(); ++categoryIndex) {
                int indexOf;
                CategoryEntry entry = this.categories.get(categoryIndex);
                if (class_3532.method_15375((float)((float)(localY - entry.y) / 20.0f + this.itemScroll.getChaseTarget())) != 0 || this.displayedItems.get(categoryIndex).isEmpty() || (indexOf = entry.targetBECategory) >= this.blockEntity.categories.size()) continue;
                if (!entry.hidden) {
                    this.hiddenCategories.add(indexOf);
                    this.playUiSound(class_3417.field_15038, 1.0f, 1.5f);
                } else {
                    this.hiddenCategories.remove(indexOf);
                    this.playUiSound(class_3417.field_15038, 1.0f, 0.675f);
                }
                this.refreshSearchNextTick = true;
                this.moveToTopNextTick = false;
                return true;
            }
        }
        if (hoveredSlot == this.noneHovered || !lmb && !rmb) {
            return super.method_25402(pMouseX, pMouseY, pButton);
        }
        boolean orderClicked = (Integer)hoveredSlot.getFirst() == -1;
        boolean bl2 = recipeClicked = (Integer)hoveredSlot.getFirst() == -2;
        BigItemStack entry = recipeClicked ? (BigItemStack)this.recipesToOrder.get((Integer)hoveredSlot.getSecond()) : (orderClicked ? this.itemsToOrder.get((Integer)hoveredSlot.getSecond()) : this.displayedItems.get((Integer)hoveredSlot.getFirst()).get((Integer)hoveredSlot.getSecond()));
        class_1799 itemStack = entry.stack;
        int n = StockKeeperRequestScreen.method_25442() ? itemStack.method_7914() : (transfer = StockKeeperRequestScreen.method_25441() ? 10 : 1);
        if (recipeClicked && entry instanceof CraftableBigItemStack) {
            CraftableBigItemStack cbis = (CraftableBigItemStack)entry;
            if (rmb && cbis.count == 0) {
                this.recipesToOrder.remove(cbis);
                return true;
            }
            this.requestCraftable(cbis, rmb ? -transfer : transfer);
            return true;
        }
        BigItemStack existingOrder = this.getOrderForItem(entry.stack);
        if (existingOrder == null) {
            if (this.itemsToOrder.size() >= 9 || rmb) {
                return true;
            }
            existingOrder = new BigItemStack(itemStack.method_46651(1), 0);
            this.itemsToOrder.add(existingOrder);
            this.playUiSound(class_3417.field_15181, 0.75f, 1.2f);
            this.playUiSound(class_3417.field_40061, 0.75f, 0.8f);
        }
        int current = existingOrder.count;
        if (rmb || orderClicked) {
            existingOrder.count = current - transfer;
            if (existingOrder.count <= 0) {
                this.itemsToOrder.remove(existingOrder);
                this.playUiSound(class_3417.field_15181, 0.75f, 1.8f);
                this.playUiSound(class_3417.field_40061, 0.75f, 1.8f);
            }
            return true;
        }
        existingOrder.count = current + Math.min(transfer, entry.count - current);
        return true;
    }

    public boolean method_25406(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0 && this.scrollHandleActive) {
            this.scrollHandleActive = false;
            if (this.field_22787.method_1569()) {
                GLFW.glfwSetInputMode((long)this.field_22787.method_22683().method_4490(), (int)208897, (int)212993);
            }
        }
        return super.method_25406(pMouseX, pMouseY, pButton);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        BigItemStack existingOrder;
        boolean recipeClicked;
        boolean noHover;
        if (this.addressBox.method_25401(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        Couple<Integer> hoveredSlot = this.getHoveredSlot((int)mouseX, (int)mouseY);
        boolean bl = noHover = hoveredSlot == this.noneHovered;
        if (noHover || (Integer)hoveredSlot.getFirst() >= 0 && !StockKeeperRequestScreen.method_25442() && this.getMaxScroll() != 0) {
            int maxScroll = this.getMaxScroll();
            int direction = (int)(Math.ceil(Math.abs(scrollY)) * -Math.signum(scrollY));
            float newTarget = class_3532.method_15340((int)Math.round(this.itemScroll.getChaseTarget() + (float)direction), (int)0, (int)maxScroll);
            this.itemScroll.chase(newTarget, 0.5, LerpedFloat.Chaser.EXP);
            return true;
        }
        boolean orderClicked = (Integer)hoveredSlot.getFirst() == -1;
        boolean bl2 = recipeClicked = (Integer)hoveredSlot.getFirst() == -2;
        BigItemStack entry = recipeClicked ? (BigItemStack)this.recipesToOrder.get((Integer)hoveredSlot.getSecond()) : (orderClicked ? this.itemsToOrder.get((Integer)hoveredSlot.getSecond()) : this.displayedItems.get((Integer)hoveredSlot.getFirst()).get((Integer)hoveredSlot.getSecond()));
        boolean remove = scrollY < 0.0;
        int transfer = class_3532.method_15384((double)Math.abs(scrollY)) * (StockKeeperRequestScreen.method_25441() ? 10 : 1);
        if (recipeClicked && entry instanceof CraftableBigItemStack) {
            CraftableBigItemStack cbis = (CraftableBigItemStack)entry;
            this.requestCraftable(cbis, remove ? -transfer : transfer);
            return true;
        }
        BigItemStack bigItemStack = existingOrder = orderClicked ? entry : this.getOrderForItem(entry.stack);
        if (existingOrder == null) {
            if (this.itemsToOrder.size() >= 9 || remove) {
                return true;
            }
            existingOrder = new BigItemStack(entry.stack.method_46651(1), 0);
            this.itemsToOrder.add(existingOrder);
            this.playUiSound(class_3417.field_15181, 0.75f, 1.2f);
            this.playUiSound(class_3417.field_40061, 0.75f, 0.8f);
        }
        int current = existingOrder.count;
        if (remove) {
            existingOrder.count = current - transfer;
            if (existingOrder.count <= 0) {
                this.itemsToOrder.remove(existingOrder);
                this.playUiSound(class_3417.field_15181, 0.75f, 1.8f);
                this.playUiSound(class_3417.field_40061, 0.75f, 1.8f);
            } else if (existingOrder.count != current) {
                this.playUiSound(AllSoundEvents.SCROLL_VALUE.getMainEvent(), 0.25f, 1.2f);
            }
            return true;
        }
        existingOrder.count = current + Math.min(transfer, this.blockEntity.getLastClientsideStockSnapshotAsSummary().getCountOf(entry.stack) - current);
        if (existingOrder.count != current && current != 0) {
            this.playUiSound(AllSoundEvents.SCROLL_VALUE.getMainEvent(), 0.25f, 1.2f);
        }
        return true;
    }

    private void clampScrollBar() {
        float newTarget;
        int maxScroll = this.getMaxScroll();
        float prevTarget = this.itemScroll.getChaseTarget();
        if (prevTarget != (newTarget = class_3532.method_15363((float)prevTarget, (float)0.0f, (float)maxScroll))) {
            this.itemScroll.startWithValue(newTarget);
        }
    }

    private int getMaxScroll() {
        int visibleHeight = this.windowHeight - 84;
        int totalRows = 2;
        for (int i = 0; i < this.displayedItems.size(); ++i) {
            List<BigItemStack> list = this.displayedItems.get(i);
            if (list.isEmpty()) continue;
            ++totalRows;
            if (this.categories.size() > i && this.categories.get((int)i).hidden) continue;
            totalRows = (int)((double)totalRows + Math.ceil((float)list.size() / 9.0f));
        }
        return Math.max(0, (totalRows * 20 - visibleHeight + 50) / 20);
    }

    public boolean method_25403(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (pButton != 0 || !this.scrollHandleActive) {
            return super.method_25403(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        class_1041 window = this.field_22787.method_22683();
        double scaleX = (double)window.method_4486() / (double)window.method_4480();
        double scaleY = (double)window.method_4502() / (double)window.method_4507();
        int windowH = this.windowHeight - 92;
        int totalH = this.getMaxScroll() * 20 + windowH;
        int barSize = Math.max(5, class_3532.method_15375((float)((float)windowH / (float)totalH * (float)(windowH - 2))));
        int minY = this.field_2800 + 15 + barSize / 2;
        int maxY = this.field_2800 + 15 + windowH - barSize / 2;
        if (barSize >= windowH - 2) {
            return true;
        }
        int barX = this.itemsX + 180;
        double target = (pMouseY - (double)this.field_2800 - 15.0 - (double)barSize / 2.0) * (double)totalH / (double)(windowH - 2) / 20.0;
        this.itemScroll.chase(class_3532.method_15350((double)target, (double)0.0, (double)this.getMaxScroll()), 0.8, LerpedFloat.Chaser.EXP);
        if (this.field_22787.method_1569()) {
            double forceX = (double)(barX + 2) / scaleX;
            double forceY = class_3532.method_15350((double)pMouseY, (double)minY, (double)maxY) / scaleY;
            GLFW.glfwSetCursorPos((long)window.method_4490(), (double)forceX, (double)forceY);
        }
        return true;
    }

    public boolean method_25400(char pCodePoint, int pModifiers) {
        if (this.ignoreTextInput) {
            return false;
        }
        if (this.addressBox.method_25370() && this.addressBox.method_25400(pCodePoint, pModifiers)) {
            return true;
        }
        String s = this.searchBox.method_1882();
        if (!this.searchBox.method_25400(pCodePoint, pModifiers)) {
            return false;
        }
        if (!Objects.equals(s, this.searchBox.method_1882())) {
            this.refreshSearchNextTick = true;
            this.moveToTopNextTick = true;
        }
        return true;
    }

    @Override
    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        this.ignoreTextInput = false;
        if (!this.addressBox.method_25370() && !this.searchBox.method_25370() && this.field_22787.field_1690.field_1890.method_1417(pKeyCode, pScanCode)) {
            this.ignoreTextInput = true;
            this.searchBox.method_25365(true);
            return true;
        }
        if (pKeyCode == 257 && this.searchBox.method_25370()) {
            this.searchBox.method_25365(false);
            return true;
        }
        if (pKeyCode == 257 && StockKeeperRequestScreen.method_25442()) {
            this.sendIt();
            return true;
        }
        if (this.addressBox.method_25370() && this.addressBox.method_25404(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        String s = this.searchBox.method_1882();
        if (!this.searchBox.method_25404(pKeyCode, pScanCode, pModifiers)) {
            return this.searchBox.method_25370() && this.searchBox.method_1885() && pKeyCode != 256 || super.method_25404(pKeyCode, pScanCode, pModifiers);
        }
        if (!Objects.equals(s, this.searchBox.method_1882())) {
            this.refreshSearchNextTick = true;
            this.moveToTopNextTick = true;
        }
        return true;
    }

    public void method_25432() {
        class_2338 pos = this.blockEntity.method_11016();
        class_634 networkHandler = this.field_22787.field_1724.field_3944;
        networkHandler.method_52787((class_2596)new PackageOrderRequestPacket(pos, PackageOrderWithCrafts.empty(), this.addressBox.method_1882(), false));
        networkHandler.method_52787((class_2596)new StockKeeperCategoryHidingPacket(pos, new ArrayList<Integer>(this.hiddenCategories)));
        super.method_25432();
    }

    private void sendIt() {
        this.revalidateOrders();
        if (this.itemsToOrder.isEmpty()) {
            return;
        }
        this.forcedEntries = new InventorySummary();
        InventorySummary summary = this.blockEntity.getLastClientsideStockSnapshotAsSummary();
        for (BigItemStack toOrder : this.itemsToOrder) {
            int countOf = summary.getCountOf(toOrder.stack);
            if (countOf == 1000000000) continue;
            this.forcedEntries.add(toOrder.stack.method_7972(), -1 - Math.max(0, countOf - toOrder.count));
        }
        PackageOrderWithCrafts order = PackageOrderWithCrafts.simple(this.itemsToOrder);
        if (this.canRequestCraftingPackage && !this.itemsToOrder.isEmpty() && !this.recipesToOrder.isEmpty()) {
            ArrayList<PackageOrderWithCrafts.CraftingEntry> craftList = new ArrayList<PackageOrderWithCrafts.CraftingEntry>();
            block1: for (CraftableBigItemStack cbis : this.recipesToOrder) {
                int availableCrafts;
                if (!cbis.input.crafting()) continue;
                int targetCount = cbis.count / cbis.stack.method_7947();
                List<BigItemStack> mutableOrder = BigItemStack.duplicateWrappers(this.itemsToOrder);
                for (int craftedCount = 0; craftedCount < targetCount; craftedCount += availableCrafts) {
                    PackageOrder pattern = cbis.input.getPattern(mutableOrder);
                    int maxCrafts = targetCount - craftedCount;
                    boolean itemsExhausted = false;
                    block3: for (availableCrafts = 0; availableCrafts < maxCrafts && !itemsExhausted; ++availableCrafts) {
                        List<BigItemStack> previousSnapshot = BigItemStack.duplicateWrappers(mutableOrder);
                        itemsExhausted = true;
                        block4: for (BigItemStack patternStack : pattern.stacks()) {
                            if (patternStack.stack.method_7960()) continue;
                            for (BigItemStack ordered : mutableOrder) {
                                if (!class_1799.method_31577((class_1799)ordered.stack, (class_1799)patternStack.stack) || ordered.count == 0) continue;
                                --ordered.count;
                                itemsExhausted = false;
                                continue block4;
                            }
                            mutableOrder = previousSnapshot;
                            break block3;
                        }
                    }
                    if (availableCrafts == 0) continue block1;
                    craftList.add(new PackageOrderWithCrafts.CraftingEntry(pattern, availableCrafts));
                }
            }
            order = new PackageOrderWithCrafts(order.orderedStacks(), craftList);
        }
        this.field_22787.field_1724.field_3944.method_52787((class_2596)new PackageOrderRequestPacket(this.blockEntity.method_11016(), order, this.addressBox.method_1882(), this.encodeRequester));
        this.itemsToOrder = new ArrayList<BigItemStack>();
        this.recipesToOrder = new ArrayList<CraftableBigItemStack>();
        this.blockEntity.ticksSinceLastUpdate = 10;
        this.successTicks = 1;
        if (this.isSchematicListMode()) {
            this.field_22787.field_1724.method_7346();
        }
    }

    public boolean method_16803(int pKeyCode, int pScanCode, int pModifiers) {
        this.ignoreTextInput = false;
        return super.method_16803(pKeyCode, pScanCode, pModifiers);
    }

    @Override
    public List<class_768> getExtraAreas() {
        return this.extraAreas;
    }

    public boolean isSchematicListMode() {
        return this.clipboardItem != null;
    }

    public void requestSchematicList() {
        this.itemsToOrder.clear();
        InventorySummary availableItems = this.blockEntity.getLastClientsideStockSnapshotAsSummary();
        for (List<ClipboardEntry> list : this.clipboardItem) {
            for (ClipboardEntry entry : list) {
                class_1799 stack = entry.icon;
                int toOrder = Math.min(entry.itemAmount, availableItems.getCountOf(stack));
                if (toOrder == 0) continue;
                this.itemsToOrder.add(new BigItemStack(stack, toOrder));
            }
        }
    }

    public void requestCraftable(CraftableBigItemStack cbis, int requestedDifference) {
        boolean takeOrdersAway;
        boolean bl = takeOrdersAway = requestedDifference < 0;
        if (takeOrdersAway) {
            requestedDifference = Math.max(-cbis.count, requestedDifference);
        }
        if (requestedDifference == 0) {
            return;
        }
        InventorySummary availableItems = this.blockEntity.getLastClientsideStockSnapshotAsSummary();
        Function<class_1799, Integer> countModifier = stack -> {
            BigItemStack ordered = this.getOrderForItem((class_1799)stack);
            return ordered == null ? 0 : -ordered.count;
        };
        if (takeOrdersAway) {
            availableItems = new InventorySummary();
            for (BigItemStack ordered : this.itemsToOrder) {
                availableItems.add(ordered.stack, ordered.count);
            }
            countModifier = stack -> 0;
        }
        Pair<Integer, List<List<BigItemStack>>> craftingResult = this.maxCraftable(cbis, availableItems, countModifier, takeOrdersAway ? -1 : 9 - this.itemsToOrder.size());
        int outputCount = cbis.stack.method_7947();
        int adjustToRecipeAmount = class_3532.method_15386((float)((float)Math.abs(requestedDifference) / (float)outputCount)) * outputCount;
        int maxCraftable = Math.min(adjustToRecipeAmount, craftingResult.getFirst());
        if (maxCraftable == 0) {
            return;
        }
        cbis.count = cbis.count + (takeOrdersAway ? -maxCraftable : maxCraftable);
        List<List<BigItemStack>> validEntriesByIngredient = craftingResult.getSecond();
        block1: for (List<BigItemStack> list : validEntriesByIngredient) {
            int remaining = maxCraftable / outputCount;
            for (BigItemStack entry : list) {
                if (remaining <= 0) continue block1;
                int toTransfer = Math.min(remaining, entry.count);
                BigItemStack order = this.getOrderForItem(entry.stack);
                if (takeOrdersAway) {
                    if (order != null) {
                        order.count -= toTransfer;
                        if (order.count == 0) {
                            this.itemsToOrder.remove(order);
                        }
                    }
                } else {
                    if (order == null) {
                        order = new BigItemStack(entry.stack.method_46651(1), 0);
                        this.itemsToOrder.add(order);
                    }
                    order.count += toTransfer;
                }
                remaining -= entry.count;
            }
        }
        this.updateCraftableAmounts();
    }

    private void updateCraftableAmounts() {
        InventorySummary usedItems = new InventorySummary();
        InventorySummary availableItems = new InventorySummary();
        for (BigItemStack ordered : this.itemsToOrder) {
            availableItems.add(ordered.stack, ordered.count);
        }
        for (CraftableBigItemStack cbis : this.recipesToOrder) {
            Pair<Integer, List<List<BigItemStack>>> craftingResult = this.maxCraftable(cbis, availableItems, stack -> -usedItems.getCountOf((class_1799)stack), -1);
            int maxCraftable = craftingResult.getFirst();
            List<List<BigItemStack>> validEntriesByIngredient = craftingResult.getSecond();
            int outputCount = cbis.stack.method_7947();
            cbis.count = Math.min(cbis.count, maxCraftable);
            block2: for (List<BigItemStack> list : validEntriesByIngredient) {
                int remaining = cbis.count / outputCount;
                for (BigItemStack entry : list) {
                    if (remaining <= 0) continue block2;
                    usedItems.add(entry.stack, Math.min(remaining, entry.count));
                    remaining -= entry.count;
                }
            }
        }
        this.canRequestCraftingPackage = false;
        for (BigItemStack ordered : this.itemsToOrder) {
            if (usedItems.getCountOf(ordered.stack) == ordered.count) continue;
            return;
        }
        this.canRequestCraftingPackage = true;
    }

    private Pair<Integer, List<List<BigItemStack>>> maxCraftable(CraftableBigItemStack cbis, InventorySummary summary, Function<class_1799, Integer> countModifier, int newTypeLimit) {
        List<List<BigItemStack>> validEntriesByIngredient = new ArrayList<List<BigItemStack>>();
        ArrayList<BigItemStack> alreadyCreated = new ArrayList<BigItemStack>();
        for (Object2ObjectMap.Entry value : cbis.input.entrySet()) {
            List ingredient = (List)value.getKey();
            ArrayList<BigItemStack> valid = new ArrayList<BigItemStack>();
            for (List<BigItemStack> list : summary.getItemMap().values()) {
                block2: for (BigItemStack entry2 : list) {
                    if (!CraftableInput.contains(ingredient, entry2.stack)) continue;
                    for (BigItemStack visitedStack : alreadyCreated) {
                        if (!class_1799.method_31577((class_1799)visitedStack.stack, (class_1799)entry2.stack)) continue;
                        valid.add(visitedStack);
                        continue block2;
                    }
                    BigItemStack asBis = new BigItemStack(entry2.stack, summary.getCountOf(entry2.stack) + countModifier.apply(entry2.stack));
                    if (asBis.count <= 0) continue;
                    valid.add(asBis);
                    alreadyCreated.add(asBis);
                }
            }
            if (valid.isEmpty()) {
                return Pair.of(0, List.of());
            }
            valid.sort((bis1, bis2) -> -Integer.compare(summary.getCountOf(bis1.stack), summary.getCountOf(bis2.stack)));
            int size = ((IntList)value.getValue()).size();
            for (int i = 0; i < size; ++i) {
                validEntriesByIngredient.add(valid);
            }
        }
        if (newTypeLimit != -1) {
            int toRemove = (int)validEntriesByIngredient.stream().flatMap(Collection::stream).filter(entry -> this.getOrderForItem(entry.stack) == null).distinct().count() - newTypeLimit;
            for (int i = 0; i < toRemove; ++i) {
                this.removeLeastEssentialItemStack(validEntriesByIngredient);
            }
        }
        validEntriesByIngredient = this.resolveIngredientAmounts(validEntriesByIngredient);
        int minCount = Integer.MAX_VALUE;
        for (List<BigItemStack> list : validEntriesByIngredient) {
            int sum = 0;
            for (BigItemStack entry3 : list) {
                sum += entry3.count;
            }
            minCount = Math.min(sum, minCount);
        }
        if (minCount == 0) {
            return Pair.of(0, List.of());
        }
        return Pair.of(minCount * cbis.stack.method_7947(), validEntriesByIngredient);
    }

    private void removeLeastEssentialItemStack(List<List<BigItemStack>> validIngredients) {
        List<BigItemStack> longest = null;
        int most = 0;
        for (List<BigItemStack> list : validIngredients) {
            int count = (int)list.stream().filter(entry -> this.getOrderForItem(entry.stack) == null).count();
            if (longest != null && count <= most) continue;
            longest = list;
            most = count;
        }
        if (longest.isEmpty()) {
            return;
        }
        BigItemStack chosen = null;
        for (int i = 0; i < longest.size(); ++i) {
            BigItemStack entry2 = longest.get(longest.size() - 1 - i);
            if (this.getOrderForItem(entry2.stack) != null) continue;
            chosen = entry2;
            break;
        }
        for (List<BigItemStack> list : validIngredients) {
            list.remove(chosen);
        }
    }

    private List<List<BigItemStack>> resolveIngredientAmounts(List<List<BigItemStack>> validIngredients) {
        ArrayList<List<BigItemStack>> resolvedIngredients = new ArrayList<List<BigItemStack>>();
        for (int i = 0; i < validIngredients.size(); ++i) {
            resolvedIngredients.add(new ArrayList());
        }
        boolean everythingTaken = false;
        while (!everythingTaken) {
            everythingTaken = true;
            block2: for (int i = 0; i < validIngredients.size(); ++i) {
                List<BigItemStack> list = validIngredients.get(i);
                List resolvedList = (List)resolvedIngredients.get(i);
                for (BigItemStack bigItemStack : list) {
                    if (bigItemStack.count == 0) continue;
                    --bigItemStack.count;
                    everythingTaken = false;
                    for (BigItemStack resolvedItemStack : resolvedList) {
                        if (resolvedItemStack.stack != bigItemStack.stack) continue;
                        ++resolvedItemStack.count;
                        continue block2;
                    }
                    resolvedList.add(new BigItemStack(bigItemStack.stack, 1));
                    continue block2;
                }
            }
        }
        return resolvedIngredients;
    }

    @Environment(value=EnvType.CLIENT)
    public static class CategoryEntry {
        boolean hidden;
        String name;
        int y;
        int targetBECategory;

        public CategoryEntry(int targetBECategory, String name, int y) {
            this.targetBECategory = targetBECategory;
            this.name = name;
            this.hidden = false;
            this.y = y;
        }
    }
}

