/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.track;

import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.trains.track.TrackRenderer;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.utility.RaycastHelper;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackBlock;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.content.trains.track.TrackShape;
import com.zurrtum.create.content.trains.track.TrackVoxelShapes;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1934;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5134;
import net.minecraft.class_746;
import org.apache.commons.lang3.mutable.MutableBoolean;

@Environment(value=EnvType.CLIENT)
public class TrackBlockOutline {
    public static WorldAttached<Map<class_2338, TrackBlockEntity>> TRACKS_WITH_TURNS = new WorldAttached<Map>(w -> new HashMap());
    public static BezierPointSelection result;
    private static final class_265 LONG_CROSS;
    private static final class_265 LONG_ORTHO;
    private static final class_265 LONG_ORTHO_OFFSET;

    public static void pickCurves(class_310 mc) {
        class_1297 class_12972 = mc.field_1719;
        if (!(class_12972 instanceof class_746)) {
            return;
        }
        class_746 player = (class_746)class_12972;
        if (mc.field_1687 == null) {
            return;
        }
        class_243 origin = player.method_5836(AnimationTickHolder.getPartialTicks((class_1936)mc.field_1687));
        double maxRange = mc.field_1765 == null ? Double.MAX_VALUE : mc.field_1765.method_17784().method_1025(origin);
        result = null;
        double range = player.method_45325(class_5134.field_47758);
        class_243 target = RaycastHelper.getTraceTarget((class_1657)player, Math.min(maxRange, range) + 1.0, origin);
        Map<class_2338, TrackBlockEntity> turns = TRACKS_WITH_TURNS.get((class_1936)mc.field_1687);
        for (TrackBlockEntity be : turns.values()) {
            for (BezierConnection bc : be.getConnections().values()) {
                class_238 bounds;
                if (!bc.isPrimary() || !(bounds = bc.getBounds()).method_1006(origin) && bounds.method_992(origin, target).isEmpty()) continue;
                float[] stepLUT = bc.getStepLUT();
                int segments = (int)(bc.getLength() * 2.0);
                class_238 segmentBounds = AllShapes.TRACK_ORTHO.get(class_2350.field_11035).method_1107();
                segmentBounds = segmentBounds.method_989(-0.5, segmentBounds.method_17940() / -2.0, -0.5);
                int bestSegment = -1;
                double bestDistance = Double.MAX_VALUE;
                double newMaxRange = maxRange;
                for (int i = 0; i < stepLUT.length - 2; ++i) {
                    double distanceToSqr;
                    float t = stepLUT[i] * (float)i / (float)segments;
                    float t1 = stepLUT[i + 1] * (float)(i + 1) / (float)segments;
                    float t2 = stepLUT[i + 2] * (float)(i + 2) / (float)segments;
                    class_243 v1 = bc.getPosition(t);
                    class_243 v2 = bc.getPosition(t2);
                    class_243 diff = v2.method_1020(v1);
                    class_243 angles = TrackRenderer.getModelAngles(bc.getNormal(t1), diff);
                    class_243 anchor = v1.method_1019(diff.method_1021(0.5));
                    class_243 localOrigin = origin.method_1020(anchor);
                    class_243 localDirection = target.method_1020(origin);
                    localOrigin = VecHelper.rotate(localOrigin, AngleHelper.deg(-angles.field_1352), class_2350.class_2351.field_11048);
                    localOrigin = VecHelper.rotate(localOrigin, AngleHelper.deg(-angles.field_1351), class_2350.class_2351.field_11052);
                    localDirection = VecHelper.rotate(localDirection, AngleHelper.deg(-angles.field_1352), class_2350.class_2351.field_11048);
                    Optional clip = segmentBounds.method_992(localOrigin, localOrigin.method_1019(localDirection = VecHelper.rotate(localDirection, AngleHelper.deg(-angles.field_1351), class_2350.class_2351.field_11052)));
                    if (clip.isEmpty() || bestSegment != -1 && bestDistance < ((class_243)clip.get()).method_1028(0.0, 0.25, 0.0) || (distanceToSqr = ((class_243)clip.get()).method_1025(localOrigin)) > maxRange) continue;
                    bestSegment = i;
                    newMaxRange = distanceToSqr;
                    bestDistance = ((class_243)clip.get()).method_1028(0.0, 0.25, 0.0);
                    BezierTrackPointLocation location = new BezierTrackPointLocation(bc.getKey(), i);
                    result = new BezierPointSelection(be, location, anchor, angles, diff.method_1029());
                }
                if (bestSegment == -1) continue;
                maxRange = newMaxRange;
            }
        }
        if (result == null) {
            return;
        }
        if (mc.field_1765 != null && mc.field_1765.method_17783() != class_239.class_240.field_1333) {
            class_243 priorLoc = mc.field_1765.method_17784();
            mc.field_1765 = class_3965.method_17778((class_243)priorLoc, (class_2350)class_2350.field_11036, (class_2338)class_2338.method_49638((class_2374)priorLoc));
        }
    }

    public static void drawCurveSelection(class_310 mc, class_4587 ms, class_4597 buffer, class_243 camera) {
        if (mc.field_1690.field_1842 || mc.field_1761.method_2920() == class_1934.field_9219) {
            return;
        }
        BezierPointSelection result = TrackBlockOutline.result;
        if (result == null) {
            return;
        }
        class_4588 vb = buffer.getBuffer(class_1921.method_23594());
        class_243 vec = result.vec().method_1020(camera);
        class_243 angles = result.angles();
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(ms).pushPose().translate(vec.field_1352, vec.field_1351 + 0.125, vec.field_1350)).rotateY((float)angles.field_1351)).rotateX((float)angles.field_1352)).translate(-0.5, -0.125, -0.5);
        boolean holdingTrack = mc.field_1724.method_6047().method_31573(AllItemTags.TRACKS);
        TrackBlockOutline.renderShape(AllShapes.TRACK_ORTHO.get(class_2350.field_11035), ms, vb, holdingTrack ? Boolean.valueOf(false) : null);
        ms.method_22909();
    }

    public static boolean drawCustomBlockSelection(class_310 mc, class_3965 target, class_4597 vertexConsumers, class_4184 camera, class_4587 ms) {
        TrackBlockEntity tbe;
        class_2586 class_25862;
        class_2338 pos = target.method_17777();
        class_2680 blockstate = mc.field_1687.method_8320(pos);
        if (!(blockstate.method_26204() instanceof TrackBlock)) {
            return false;
        }
        if (!mc.field_1687.method_8621().method_11952(pos)) {
            return false;
        }
        class_4588 vb = vertexConsumers.getBuffer(class_1921.method_23594());
        class_243 camPos = camera.method_19326();
        ms.method_22903();
        ms.method_22904((double)pos.method_10263() - camPos.field_1352, (double)pos.method_10264() - camPos.field_1351, (double)pos.method_10260() - camPos.field_1350);
        boolean holdingTrack = mc.field_1724.method_6047().method_31573(AllItemTags.TRACKS);
        TrackShape shape = (TrackShape)((Object)blockstate.method_11654(TrackBlock.SHAPE));
        boolean canConnectFrom = !shape.isJunction() && (!((class_25862 = mc.field_1687.method_8321(pos)) instanceof TrackBlockEntity) || !(tbe = (TrackBlockEntity)class_25862).isTilted());
        MutableBoolean cancel = new MutableBoolean();
        TrackBlockOutline.walkShapes(shape, TransformStack.of(ms), s -> {
            TrackBlockOutline.renderShape(s, ms, vb, holdingTrack ? Boolean.valueOf(canConnectFrom) : null);
            cancel.setTrue();
        });
        ms.method_22909();
        return cancel.isTrue();
    }

    public static void renderShape(class_265 s, class_4587 ms, class_4588 vb, Boolean valid) {
        class_4587.class_4665 transform = ms.method_23760();
        s.method_1104((x1, y1, z1, x2, y2, z2) -> {
            float xDiff = (float)(x2 - x1);
            float yDiff = (float)(y2 - y1);
            float zDiff = (float)(z2 - z1);
            float length = class_3532.method_15355((float)(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff));
            xDiff /= length;
            yDiff /= length;
            zDiff /= length;
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            if (valid != null && valid.booleanValue()) {
                g = 1.0f;
                b = 1.0f;
                r = 1.0f;
            }
            if (valid != null && !valid.booleanValue()) {
                r = 1.0f;
                b = 0.125f;
                g = 0.25f;
            }
            vb.method_22918(transform.method_23761(), (float)x1, (float)y1, (float)z1).method_22915(r, g, b, 0.4f).method_60831(transform.method_56822(), xDiff, yDiff, zDiff);
            vb.method_22918(transform.method_23761(), (float)x2, (float)y2, (float)z2).method_22915(r, g, b, 0.4f).method_60831(transform.method_56822(), xDiff, yDiff, zDiff);
        });
    }

    private static void walkShapes(TrackShape shape, TransformStack<?> msr, Consumer<class_265> renderer) {
        float angle45 = 0.7853982f;
        if (shape == TrackShape.XO || shape == TrackShape.CR_NDX || shape == TrackShape.CR_PDX) {
            renderer.accept(AllShapes.TRACK_ORTHO.get(class_2350.field_11034));
        } else if (shape == TrackShape.ZO || shape == TrackShape.CR_NDZ || shape == TrackShape.CR_PDZ) {
            renderer.accept(AllShapes.TRACK_ORTHO.get(class_2350.field_11035));
        }
        if (shape.isPortal()) {
            for (class_2350 d : Iterate.horizontalDirections) {
                if (TrackShape.asPortal(d) != shape) continue;
                msr.rotateCentered(AngleHelper.rad(AngleHelper.horizontalAngle(d)), class_2350.field_11036);
                renderer.accept(LONG_ORTHO_OFFSET);
                return;
            }
        }
        if (shape == TrackShape.PD || shape == TrackShape.CR_PDX || shape == TrackShape.CR_PDZ) {
            msr.rotateCentered(angle45, class_2350.field_11036);
            renderer.accept(LONG_ORTHO);
        } else if (shape == TrackShape.ND || shape == TrackShape.CR_NDX || shape == TrackShape.CR_NDZ) {
            msr.rotateCentered(-0.7853982f, class_2350.field_11036);
            renderer.accept(LONG_ORTHO);
        }
        if (shape == TrackShape.CR_O) {
            renderer.accept(AllShapes.TRACK_CROSS);
        } else if (shape == TrackShape.CR_D) {
            msr.rotateCentered(angle45, class_2350.field_11036);
            renderer.accept(LONG_CROSS);
        }
        if (shape != TrackShape.AE && shape != TrackShape.AN && shape != TrackShape.AW && shape != TrackShape.AS) {
            return;
        }
        msr.translate(0.0f, 1.0f, 0.0f);
        msr.rotateCentered((float)Math.PI - AngleHelper.rad(shape.getModelRotation()), class_2350.field_11036);
        msr.rotateX(angle45);
        msr.translate(0.0f, -0.1875f, 0.0625f);
        renderer.accept(LONG_ORTHO);
    }

    public static void registerToCurveInteraction(TrackBlockEntity be) {
        TRACKS_WITH_TURNS.get((class_1936)be.method_10997()).put(be.method_11016(), be);
    }

    public static void removeFromCurveInteraction(TrackBlockEntity be) {
        TRACKS_WITH_TURNS.get((class_1936)be.method_10997()).remove(be.method_11016());
    }

    static {
        LONG_CROSS = class_259.method_1084((class_265)TrackVoxelShapes.longOrthogonalZ(), (class_265)TrackVoxelShapes.longOrthogonalX());
        LONG_ORTHO = TrackVoxelShapes.longOrthogonalZ();
        LONG_ORTHO_OFFSET = TrackVoxelShapes.longOrthogonalZOffset();
    }

    @Environment(value=EnvType.CLIENT)
    public record BezierPointSelection(TrackBlockEntity blockEntity, BezierTrackPointLocation loc, class_243 vec, class_243 angles, class_243 direction) {
    }
}

