/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.compile;

import com.zurrtum.create.client.flywheel.api.layout.ArrayElementType;
import com.zurrtum.create.client.flywheel.api.layout.ElementType;
import com.zurrtum.create.client.flywheel.api.layout.FloatRepr;
import com.zurrtum.create.client.flywheel.api.layout.IntegerRepr;
import com.zurrtum.create.client.flywheel.api.layout.MatrixElementType;
import com.zurrtum.create.client.flywheel.api.layout.ScalarElementType;
import com.zurrtum.create.client.flywheel.api.layout.UnsignedIntegerRepr;
import com.zurrtum.create.client.flywheel.api.layout.ValueRepr;
import com.zurrtum.create.client.flywheel.api.layout.VectorElementType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class LayoutInterpreter {
    public static String typeName(ElementType type) {
        if (type instanceof ScalarElementType) {
            ScalarElementType scalar = (ScalarElementType)type;
            return LayoutInterpreter.scalarTypeName(scalar);
        }
        if (type instanceof VectorElementType) {
            VectorElementType vector = (VectorElementType)type;
            return LayoutInterpreter.vectorTypeName(vector);
        }
        if (type instanceof MatrixElementType) {
            MatrixElementType matrix = (MatrixElementType)type;
            return LayoutInterpreter.matrixTypeName(matrix);
        }
        if (type instanceof ArrayElementType) {
            ArrayElementType array = (ArrayElementType)type;
            return LayoutInterpreter.arrayTypeName(array);
        }
        throw new IllegalArgumentException("Unknown type " + String.valueOf(type));
    }

    public static String scalarTypeName(ScalarElementType scalar) {
        ValueRepr repr = scalar.repr();
        if (repr instanceof IntegerRepr) {
            return "int";
        }
        if (repr instanceof UnsignedIntegerRepr) {
            return "uint";
        }
        if (repr instanceof FloatRepr) {
            return "float";
        }
        throw new IllegalArgumentException("Unknown repr " + String.valueOf(repr));
    }

    public static String vectorTypeName(VectorElementType vector) {
        ValueRepr repr = vector.repr();
        int size = vector.size();
        if (repr instanceof IntegerRepr) {
            return "ivec" + size;
        }
        if (repr instanceof UnsignedIntegerRepr) {
            return "uvec" + size;
        }
        if (repr instanceof FloatRepr) {
            return "vec" + size;
        }
        throw new IllegalArgumentException("Unknown repr " + String.valueOf(repr));
    }

    public static String matrixTypeName(MatrixElementType matrix) {
        return "mat" + matrix.columns() + "x" + matrix.rows();
    }

    public static String arrayTypeName(ArrayElementType array) {
        return LayoutInterpreter.typeName(array.innerType()) + "[" + array.length() + "]";
    }
}

