/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.impl;

import com.zurrtum.create.catnip.config.Builder;
import com.zurrtum.create.client.flywheel.api.backend.Backend;
import com.zurrtum.create.client.flywheel.api.backend.BackendManager;
import com.zurrtum.create.client.flywheel.backend.BackendConfig;
import com.zurrtum.create.client.flywheel.impl.FlwConfig;
import com.zurrtum.create.client.flywheel.impl.FlwImpl;
import com.zurrtum.create.client.flywheel.impl.config.CClient;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class FabricFlwConfig
implements FlwConfig {
    public static final FabricFlwConfig INSTANCE = new FabricFlwConfig();
    private CClient client;

    public void register() {
        this.client = Builder.create(CClient::new, "flywheel", "client", true);
    }

    @Override
    public Backend backend() {
        Backend backend = FabricFlwConfig.parseBackend((String)this.client.backend.get());
        if (backend == null) {
            this.client.backend.set("DEFAULT");
            backend = BackendManager.defaultBackend();
        }
        return backend;
    }

    @Override
    public boolean limitUpdates() {
        return (Boolean)this.client.limitUpdates.get();
    }

    @Override
    public int workerThreads() {
        return (Integer)this.client.workerThreads.get();
    }

    @Override
    public BackendConfig backendConfig() {
        return this.client.flwBackends;
    }

    @Nullable
    private static Backend parseBackend(String value) {
        class_2960 backendId;
        if (value.equals("DEFAULT")) {
            return BackendManager.defaultBackend();
        }
        if (value.equals("OFF")) {
            return BackendManager.offBackend();
        }
        try {
            backendId = class_2960.method_60654((String)value);
        }
        catch (class_151 e) {
            FlwImpl.CONFIG_LOGGER.warn("'backend' value '{}' is not a valid resource location", (Object)value);
            return null;
        }
        Backend backend = Backend.REGISTRY.get(backendId);
        if (backend == null) {
            FlwImpl.CONFIG_LOGGER.warn("Backend with ID '{}' is not registered", (Object)backendId);
            return null;
        }
        return backend;
    }
}

