/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.material.Transparency;
import com.zurrtum.create.client.flywheel.api.model.Mesh;
import com.zurrtum.create.client.flywheel.lib.material.CutoutShaders;
import com.zurrtum.create.client.flywheel.lib.material.Materials;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.baked.ItemMeshEmitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.class_9801;

@Environment(value=EnvType.CLIENT)
public class BakedItemModelBufferer {
    static final Map<BlendFunction, Transparency> TRANSPARENCY = Map.of(BlendFunction.ADDITIVE, Transparency.ADDITIVE, BlendFunction.LIGHTNING, Transparency.LIGHTNING, BlendFunction.GLINT, Transparency.GLINT, BlendFunction.TRANSLUCENT, Transparency.TRANSLUCENT);
    static final List<class_1921> CHUNK_LAYERS = List.of(class_4722.method_24073(), class_4722.method_24074(), class_4722.method_29382(), class_1921.method_23590(), class_1921.method_30676(), class_1921.method_23591());
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    public static void bufferItemStack(class_1799 stack, class_1920 level, class_811 displayContext, ResultConsumer resultConsumer, MeshResultConsumer meshResultConsumer) {
        class_638 clientWorld;
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        class_4587 poseStack = objects.identityPoseStack;
        class_638 world = level instanceof class_638 ? (clientWorld = (class_638)level) : null;
        class_918 itemRenderer = class_310.method_1551().method_1480();
        ItemMeshEmitterProvider provider = objects.provider;
        provider.setResultConsumer(resultConsumer, meshResultConsumer);
        itemRenderer.method_23178(stack, displayContext, 0, class_4608.field_21444, poseStack, (class_4597)provider, (class_1937)world, 0);
        provider.end();
    }

    public static Map<class_1921, Integer> getChunkLayers() {
        return BakedItemModelBufferer.THREAD_LOCAL_OBJECTS.get().chunkLayers;
    }

    @Environment(value=EnvType.CLIENT)
    private static class ThreadLocalObjects {
        public final class_4587 identityPoseStack = new class_4587();
        public final ItemMeshEmitterProvider provider = new ItemMeshEmitterProvider(this);
        public final Map<class_1921, Material> materials = new HashMap<class_1921, Material>();
        public final Map<class_1921, Integer> chunkLayers = new HashMap<class_1921, Integer>();
        public final List<ItemMeshEmitter> emitters = new ArrayList<ItemMeshEmitter>();

        private ThreadLocalObjects() {
            int size = CHUNK_LAYERS.size();
            for (int i = 0; i < size; ++i) {
                class_1921 renderType = CHUNK_LAYERS.get(i);
                this.chunkLayers.put(renderType, i);
                this.emitters.add(new ItemMeshEmitter(renderType));
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ItemMeshEmitterProvider
    implements class_4597 {
        private final ThreadLocalObjects objects;
        private ResultConsumer resultConsumer;
        private MeshResultConsumer meshResultConsumer;

        private ItemMeshEmitterProvider(ThreadLocalObjects objects) {
            this.objects = objects;
        }

        public void setResultConsumer(ResultConsumer resultConsumer, MeshResultConsumer meshResultConsumer) {
            this.resultConsumer = resultConsumer;
            this.meshResultConsumer = meshResultConsumer;
        }

        private void emitMesh(class_1921 renderType, Mesh mesh) {
            Material material = this.objects.materials.computeIfAbsent(renderType, ItemMeshEmitterProvider::createMaterial);
            this.meshResultConsumer.accept(renderType, material, mesh);
        }

        private static Material createMaterial(class_1921 renderLayer) {
            class_1921.class_4687 layer = (class_1921.class_4687)renderLayer;
            Optional id = layer.field_21403.field_21406.method_23564();
            if (id.isPresent()) {
                String cutout;
                Transparency transparency;
                SimpleMaterial.Builder builder = SimpleMaterial.builder().texture((class_2960)id.get()).mipmap(false);
                Optional blendFunction = layer.field_56922.getBlendFunction();
                if (blendFunction.isPresent() && (transparency = TRANSPARENCY.get(blendFunction.get())) != null) {
                    builder.transparency(transparency);
                }
                if ((cutout = (String)layer.field_56922.getShaderDefines().comp_3103().get("ALPHA_CUTOUT")) != null) {
                    if (cutout.equals("0.1")) {
                        builder.cutout(CutoutShaders.ONE_TENTH);
                    } else if (cutout.equals("0.5")) {
                        builder.cutout(CutoutShaders.HALF);
                    }
                }
                return builder.build();
            }
            return Materials.TRANSLUCENT_ENTITY;
        }

        public class_4588 getBuffer(class_1921 layer) {
            ItemMeshEmitter emitter;
            Integer index = this.objects.chunkLayers.get(layer);
            if (index == null) {
                this.objects.chunkLayers.put(layer, this.objects.chunkLayers.size());
                emitter = new ItemMeshEmitter(layer);
                emitter.prepare(this.resultConsumer, this::emitMesh);
                this.objects.emitters.add(emitter);
            } else {
                emitter = this.objects.emitters.get(index);
                if (emitter.isEnd()) {
                    emitter.prepare(this.resultConsumer, this::emitMesh);
                }
            }
            return emitter;
        }

        public void end() {
            for (ItemMeshEmitter emitter : this.objects.emitters) {
                emitter.end();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface ResultConsumer {
        public void accept(class_1921 var1, boolean var2, class_9801 var3);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface MeshResultConsumer {
        public void accept(class_1921 var1, Material var2, Mesh var3);
    }
}

