/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering;

import com.zurrtum.create.client.content.logistics.tunnel.BrassTunnelFilterSlot;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.zurrtum.create.content.logistics.tunnel.BrassTunnelBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerSidedFilteringBehaviour;
import java.util.EnumMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;

@Environment(value=EnvType.CLIENT)
public class SidedFilteringBehaviour
extends FilteringBehaviour<ServerSidedFilteringBehaviour> {
    Map<class_2350, FilteringBehaviour<ServerFilteringBehaviour>> sidedFilters = new EnumMap<class_2350, FilteringBehaviour<ServerFilteringBehaviour>>(class_2350.class);

    public SidedFilteringBehaviour(SmartBlockEntity be, ValueBoxTransform slot) {
        super(be, slot);
    }

    @Override
    public void initialize() {
        super.initialize();
        ((ServerSidedFilteringBehaviour)this.behaviour).setRemoveListener(this::removeFilter);
    }

    private void removeFilter(class_2350 side) {
        FilteringBehaviour<ServerFilteringBehaviour> filter = this.sidedFilters.get(side);
        if (filter != null) {
            filter.behaviour = null;
        }
    }

    public FilteringBehaviour<ServerFilteringBehaviour> get(class_2350 side) {
        FilteringBehaviour<ServerFilteringBehaviour> sidedFilter = this.sidedFilters.get(side);
        if (sidedFilter != null && sidedFilter.behaviour != null) {
            return sidedFilter;
        }
        if (this.behaviour == null) {
            return null;
        }
        ServerFilteringBehaviour filter = ((ServerSidedFilteringBehaviour)this.behaviour).get(side);
        if (filter == null) {
            return null;
        }
        if (sidedFilter == null) {
            sidedFilter = new FilteringBehaviour(this.blockEntity, this.slotPositioning);
        }
        sidedFilter.behaviour = filter;
        this.sidedFilters.put(side, sidedFilter);
        return sidedFilter;
    }

    public static SidedFilteringBehaviour tunnel(BrassTunnelBlockEntity be) {
        return new SidedFilteringBehaviour(be, new BrassTunnelFilterSlot());
    }
}

