/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.fluid;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllFluidConfigs;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.infrastructure.fluid.FluidConfig;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

@Environment(value=EnvType.CLIENT)
public class FluidRenderer {
    public static void renderFluidStream(FluidStack fluidStack, class_2350 direction, float radius, float progress, boolean inbound, class_4597 buffer, class_4587 ms, int light) {
        FluidRenderer.renderFluidStream(fluidStack, direction, radius, progress, inbound, FluidRenderHelper.getFluidBuilder(buffer), ms, light);
    }

    public static void renderFluidStream(FluidStack fluidStack, class_2350 direction, float radius, float progress, boolean inbound, class_4588 builder, class_4587 ms, int light) {
        class_3611 fluid = fluidStack.getFluid();
        FluidConfig config = AllFluidConfigs.get(fluid);
        if (config == null) {
            return;
        }
        class_1058 flowTexture = config.flowing().get();
        class_1058 stillTexture = config.still().get();
        int color = config.tint().apply(fluidStack.getComponentChanges()) | 0xFF000000;
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, fluid.method_15785().method_15759().method_26213());
        light = light & 0xF00000 | luminosity << 4;
        if (inbound) {
            direction = direction.method_10153();
        }
        PoseTransformStack msr = TransformStack.of(ms);
        ms.method_22903();
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)msr.center()).rotateYDegrees(AngleHelper.horizontalAngle(direction))).rotateXDegrees(direction == class_2350.field_11036 ? 180.0f : (direction == class_2350.field_11033 ? 0.0f : 270.0f))).uncenter();
        ms.method_22904(0.5, 0.0, 0.5);
        float hMin = -radius;
        float y = inbound ? 1.0f : 0.5f;
        float yMin = y - class_3532.method_15363((float)(progress * 0.5f), (float)0.0f, (float)1.0f);
        for (int i = 0; i < 4; ++i) {
            ms.method_22903();
            FluidRenderer.renderFlowingTiledFace(class_2350.field_11035, hMin, yMin, radius, y, radius, builder, ms, light, color, flowTexture);
            ms.method_22909();
            msr.rotateYDegrees(90.0f);
        }
        if (progress != 1.0f) {
            FluidRenderHelper.renderStillTiledFace(class_2350.field_11033, hMin, hMin, radius, radius, yMin, builder, ms, light, color, stillTexture);
        }
        ms.method_22909();
    }

    public static void renderFlowingTiledFace(class_2350 dir, float left, float down, float right, float up, float depth, class_4588 builder, class_4587 ms, int light, int color, class_1058 texture) {
        FluidRenderHelper.renderTiledFace(dir, left, down, right, up, depth, builder, ms, light, color, texture, 0.5f);
    }
}

