/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.render;

import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.registry.RegisteredObjectsHelper;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.flywheel.lib.visualization.VisualizationHelper;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import java.util.BitSet;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_761;
import net.minecraft.class_824;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class BlockEntityRenderHelper {
    public static void renderBlockEntities(List<class_2586> blockEntities, BitSet shouldRenderBEs, BitSet erroredBEsOut, @Nullable VirtualRenderWorld renderLevel, class_1937 realLevel, class_4587 ms, @Nullable Matrix4f lightTransform, class_4597 buffer, float pt) {
        class_310 mc = class_310.method_1551();
        class_824 dispatcher = mc.method_31975();
        class_243 camera = mc.field_1773.method_19418().method_19326();
        int i = shouldRenderBEs.nextSetBit(0);
        while (i >= 0 && i < blockEntities.size()) {
            class_2586 blockEntity = blockEntities.get(i);
            if (!VisualizationManager.supportsVisualization((class_1936)realLevel) || !VisualizationHelper.skipVanillaRender(blockEntity)) {
                class_827 renderer = dispatcher.method_3550(blockEntity);
                if (renderer == null) {
                    erroredBEsOut.set(i);
                } else {
                    class_2338 pos = blockEntity.method_11016();
                    ms.method_22903();
                    TransformStack.of(ms).translate((class_2382)pos);
                    try {
                        int light;
                        int realLevelLight = class_761.method_23794((class_1920)realLevel, (class_2338)BlockEntityRenderHelper.getLightPos(lightTransform, pos));
                        if (renderLevel != null) {
                            renderLevel.setExternalLight(realLevelLight);
                            light = class_761.method_23794((class_1920)renderLevel, (class_2338)pos);
                        } else {
                            light = realLevelLight;
                        }
                        renderer.method_3569(blockEntity, pt, ms, buffer, light, class_4608.field_21444, camera);
                    }
                    catch (Exception e) {
                        erroredBEsOut.set(i);
                        String message = "BlockEntity " + String.valueOf(RegisteredObjectsHelper.getKeyOrThrow(blockEntity.method_11017())) + " could not be rendered virtually.";
                        if (((Boolean)AllConfigs.client().explainRenderErrors.get()).booleanValue()) {
                            Create.LOGGER.error(message, (Throwable)e);
                        }
                        Create.LOGGER.error(message);
                    }
                    ms.method_22909();
                }
            }
            i = shouldRenderBEs.nextSetBit(i + 1);
        }
        if (renderLevel != null) {
            renderLevel.resetExternalLight();
        }
    }

    private static class_2338 getLightPos(@Nullable Matrix4f lightTransform, class_2338 contraptionPos) {
        if (lightTransform != null) {
            Vector4f lightVec = new Vector4f((float)contraptionPos.method_10263() + 0.5f, (float)contraptionPos.method_10264() + 0.5f, (float)contraptionPos.method_10260() + 0.5f, 1.0f);
            lightVec.mul((Matrix4fc)lightTransform);
            return class_2338.method_49637((double)lightVec.x(), (double)lightVec.y(), (double)lightVec.z());
        }
        return contraptionPos;
    }
}

