/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Suppliers;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.client.foundation.render.RenderTypes;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10419;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10515;
import net.minecraft.class_10526;
import net.minecraft.class_10809;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_11515;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2310;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_4722;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_765;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_7833;
import net.minecraft.class_796;
import net.minecraft.class_804;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class WorldshaperModel
implements class_10439,
class_10515<RenderData> {
    public static final class_2960 ID = class_2960.method_60655((String)"create", (String)"model/handheld_worldshaper");
    public static final class_2960 ITEM_ID = class_2960.method_60655((String)"create", (String)"item/handheld_worldshaper/item");
    public static final class_2960 CORE_ID = class_2960.method_60655((String)"create", (String)"item/handheld_worldshaper/core");
    public static final class_2960 CORE_GLOW_ID = class_2960.method_60655((String)"create", (String)"item/handheld_worldshaper/core_glow");
    public static final class_2960 ACCELERATOR_ID = class_2960.method_60655((String)"create", (String)"item/handheld_worldshaper/accelerator");
    private static final int[] TINTS = new int[0];
    private static final class_5819 random = class_5819.method_43047();
    private final class_10809 settings;
    private final List<class_777> item;
    private final List<class_777> core;
    private final List<class_777> coreGlow;
    private final List<class_777> accelerator;
    private final Supplier<Vector3f[]> vector;

    public WorldshaperModel(class_10809 settings, List<class_777> item, List<class_777> core, List<class_777> coreGlow, List<class_777> accelerator) {
        this.settings = settings;
        this.item = item;
        this.core = core;
        this.coreGlow = coreGlow;
        this.accelerator = accelerator;
        this.vector = Suppliers.memoize(() -> {
            HashSet set = new HashSet();
            WorldshaperModel.calculatePosition(item, set::add);
            WorldshaperModel.calculatePosition(core, set::add);
            WorldshaperModel.calculatePosition(coreGlow, set::add);
            WorldshaperModel.calculatePosition(accelerator, set::add);
            return (Vector3f[])set.toArray(Vector3f[]::new);
        });
    }

    private static void calculatePosition(List<class_777> quads, Consumer<Vector3f> consumer) {
        for (class_777 bakedQuad : quads) {
            class_796.method_67923((int[])bakedQuad.comp_3721(), consumer);
        }
    }

    public void method_65584(class_10444 state, class_1799 stack, class_10442 resolver, class_811 displayContext, @Nullable class_638 world, @Nullable class_1309 user, int seed) {
        state.method_70946((Object)this);
        state.method_70947();
        class_10444.class_10446 renderState = state.method_65601();
        renderState.method_67995(this.vector);
        renderState.method_67996(this.settings.comp_3766());
        renderState.method_67994(this.settings.comp_3767());
        RenderData data = new RenderData();
        data.transform = this.settings.comp_3768().method_3503(displayContext);
        class_746 player = class_310.method_1551().field_1724;
        boolean mainHand = player.method_6047() == stack;
        data.rightHand = mainHand ^ player.method_6068() == class_1306.field_6182;
        boolean bl = data.inHand = mainHand || player.method_6079() == stack;
        if (displayContext == class_811.field_4317) {
            data.state = (class_2680)stack.method_58694(AllDataComponents.SHAPER_BLOCK_USED);
        }
        state.method_70946((Object)data);
        renderState.method_65617((class_10515)this, (Object)data);
    }

    public void render(RenderData data, class_811 displayContext, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, boolean glint) {
        assert (data != null);
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22903();
        data.transform.method_23075(displayContext.method_67675(), matrices.method_23760());
        class_1921 layer = class_4722.method_29382();
        WorldshaperModel.renderItem(matrices, vertexConsumers, light, overlay, this.item, layer);
        float pt = AnimationTickHolder.getPartialTicks();
        float worldTime = AnimationTickHolder.getRenderTime() / 20.0f;
        float animation = class_3532.method_15363((float)(Create.ZAPPER_RENDER_HANDLER.getAnimation(data.rightHand, pt) * 5.0f), (float)0.0f, (float)1.0f);
        float multiplier = data.inHand ? animation : class_3532.method_15374((float)(worldTime * 5.0f));
        int lightItensity = (int)(15.0f * class_3532.method_15363((float)multiplier, (float)0.0f, (float)1.0f));
        int glowLight = class_765.method_23687((int)lightItensity, (int)Math.max(lightItensity, 4));
        WorldshaperModel.renderItem(matrices, vertexConsumers, glowLight, overlay, this.core, RenderTypes.itemGlowingSolid());
        WorldshaperModel.renderItem(matrices, vertexConsumers, glowLight, overlay, this.coreGlow, RenderTypes.itemGlowingTranslucent());
        float angle = worldTime * -25.0f;
        if (data.inHand) {
            angle += 360.0f * animation;
        }
        matrices.method_46416(0.5f, 0.345f, 0.5f);
        matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(angle %= 360.0f));
        matrices.method_46416(-0.5f, -0.345f, -0.5f);
        WorldshaperModel.renderItem(matrices, vertexConsumers, light, overlay, this.accelerator, layer);
        matrices.method_22909();
        if (data.state != null) {
            class_310 mc = class_310.method_1551();
            if (data.state.method_26204() instanceof class_2310) {
                boolean flat;
                class_918 itemRenderer = mc.method_1480();
                class_1799 stack = new class_1799((class_1935)data.state.method_26204());
                itemRenderer.field_55296.method_65598(itemRenderer.field_55297, stack, displayContext, (class_1937)mc.field_1687, (class_1309)mc.field_1724, 0);
                boolean bl = flat = !itemRenderer.field_55297.method_65608();
                if (flat && vertexConsumers instanceof class_4597.class_4598) {
                    class_4597.class_4598 immediate = (class_4597.class_4598)vertexConsumers;
                    immediate.method_22993();
                }
                matrices.method_46416(-0.242f, -0.278f, 0.0f);
                matrices.method_22905(0.25f, 0.25f, 0.25f);
                matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(30.0f));
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(45.0f));
                if (flat) {
                    mc.field_1773.method_71114().method_71034(class_308.class_11274.field_60026);
                }
                itemRenderer.field_55297.method_65604(matrices, vertexConsumers, light, overlay);
            } else {
                matrices.method_46416(-0.42f, -0.385f, 0.0f);
                matrices.method_22905(0.25f, 0.25f, 0.25f);
                matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(30.0f));
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(45.0f));
                class_1921 blockLayer = class_4696.method_23679((class_2680)data.state) == class_11515.field_60926 ? class_4722.method_29382() : class_4722.method_24074();
                SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
                world.blockState(data.state);
                random.method_43052(42L);
                List parts = mc.method_1541().method_3349(data.state).method_68512(random);
                mc.method_1541().method_3355(data.state, class_2338.field_10980, (class_1920)world, matrices, vertexConsumers.getBuffer(blockLayer), false, parts);
            }
        }
        matrices.method_22909();
    }

    private static void renderItem(class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, List<class_777> item, class_1921 layer) {
        class_918.method_62476(null, (class_4587)matrices, (class_4597)vertexConsumers, (int)light, (int)overlay, (int[])TINTS, item, (class_1921)layer, (class_10444.class_10445)class_10444.class_10445.field_55341);
    }

    public void method_72175(Set<Vector3f> vertices) {
        throw new UnsupportedOperationException();
    }

    public RenderData getData(class_1799 stack) {
        throw new UnsupportedOperationException();
    }

    @Environment(value=EnvType.CLIENT)
    public static class RenderData {
        class_804 transform;
        class_2680 state;
        boolean rightHand;
        boolean inHand;

        public boolean equals(Object o) {
            if (!(o instanceof RenderData)) {
                return false;
            }
            RenderData data = (RenderData)o;
            return this.transform == data.transform && this.state == data.state && this.rightHand == data.rightHand && this.inHand == data.inHand;
        }

        public int hashCode() {
            return Objects.hash(this.rightHand, this.inHand);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Unbaked
    implements class_10439.class_10441 {
        public static final MapCodec<Unbaked> CODEC = MapCodec.unit(Unbaked::new);

        public MapCodec<? extends class_10439.class_10441> method_65585() {
            return CODEC;
        }

        public void method_62326(class_10526.class_10103 resolver) {
            resolver.markDependency(ITEM_ID);
            resolver.markDependency(CORE_ID);
            resolver.markDependency(CORE_GLOW_ID);
            resolver.markDependency(ACCELERATOR_ID);
        }

        public class_10439 method_65587(class_10439.class_10440 context) {
            class_7775 baker = context.comp_3390();
            class_10819 model = baker.method_45872(ITEM_ID);
            class_10419 textures = model.method_68045();
            List quads = model.method_68034(textures, baker, (class_3665)class_1086.field_5350).method_68048();
            class_10809 settings = class_10809.method_68001((class_7775)baker, (class_10819)model, (class_10419)textures);
            return new WorldshaperModel(settings, quads, Unbaked.bake(baker, CORE_ID), Unbaked.bake(baker, CORE_GLOW_ID), Unbaked.bake(baker, ACCELERATOR_ID));
        }

        private static List<class_777> bake(class_7775 baker, class_2960 id) {
            class_10819 model = baker.method_45872(id);
            return model.method_68034(model.method_68045(), baker, (class_3665)class_1086.field_5350).method_68048();
        }
    }
}

