/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.particle;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllFluidConfigs;
import com.zurrtum.create.client.infrastructure.fluid.FluidConfig;
import com.zurrtum.create.client.infrastructure.particle.FluidParticle;
import com.zurrtum.create.content.processing.basin.BasinBlock;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.infrastructure.particle.FluidParticleData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4184;
import net.minecraft.class_4538;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_9326;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class BasinFluidParticle
extends FluidParticle {
    class_2338 basinPos;
    class_243 targetPos;
    class_243 centerOfBasin;
    float yOffset;

    public BasinFluidParticle(class_638 world, class_3611 fluid, class_9326 components, FluidConfig config, double x, double y, double z, double vx, double vy, double vz) {
        super(world, fluid, components, config, x, y, z, vx, vy, vz);
        this.field_3844 = 0.0f;
        this.field_3852 = 0.0;
        this.field_3869 = 0.0;
        this.field_3850 = 0.0;
        this.yOffset = world.field_9229.method_43057() * 1.0f / 32.0f;
        this.field_17867 = 0.0f;
        this.field_3847 = 60;
        class_243 currentPos = new class_243(x, y += (double)this.yOffset, z);
        this.basinPos = class_2338.method_49638((class_2374)currentPos);
        this.centerOfBasin = VecHelper.getCenterOf((class_2382)this.basinPos);
        if (vx != 0.0) {
            this.field_3847 = 20;
            class_243 centerOf = VecHelper.getCenterOf((class_2382)this.basinPos);
            class_243 diff = currentPos.method_1020(centerOf).method_18805(1.0, 0.0, 1.0).method_1029().method_1021(0.375);
            this.targetPos = centerOf.method_1019(diff);
            this.field_3858 = this.field_3874 = this.centerOfBasin.field_1352;
            this.field_3856 = this.field_3871 = this.centerOfBasin.field_1350;
        }
    }

    @Override
    public void method_3070() {
        super.method_3070();
        float f = this.field_17867 = this.targetPos != null ? Math.max(0.03125f, 1.0f * (float)this.field_3866 / (float)this.field_3847 / 8.0f) : 0.125f * (1.0f - (float)Math.abs(this.field_3866 - this.field_3847 / 2) / (1.0f * (float)this.field_3847));
        if (this.field_3866 % 2 == 0) {
            if (!this.field_3851.method_8320(this.basinPos).method_27852((class_2248)AllBlocks.BASIN) && !BasinBlock.isBasin((class_4538)this.field_3851, this.basinPos)) {
                this.method_3085();
                return;
            }
            class_2586 blockEntity = this.field_3851.method_8321(this.basinPos);
            if (blockEntity instanceof BasinBlockEntity) {
                float totalUnits = ((BasinBlockEntity)blockEntity).getTotalFluidUnits(0.0f);
                if (totalUnits < 1.0f) {
                    totalUnits = 0.0f;
                }
                float fluidLevel = class_3532.method_15363((float)(totalUnits / 162000.0f), (float)0.0f, (float)1.0f);
                this.field_3854 = 0.125f + (float)this.basinPos.method_10264() + 0.75f * fluidLevel + this.yOffset;
            }
        }
        if (this.targetPos != null) {
            float progess = 1.0f * (float)this.field_3866 / (float)this.field_3847;
            class_243 currentPos = this.centerOfBasin.method_1019(this.targetPos.method_1020(this.centerOfBasin).method_1021((double)progess));
            this.field_3874 = currentPos.field_1352;
            this.field_3871 = currentPos.field_1350;
        }
    }

    @Override
    protected void updateColor() {
        this.field_3841 = 0.9f;
    }

    @Override
    protected int method_3068(float p_189214_1_) {
        return 0xF000F0;
    }

    public void method_3074(class_4588 vb, class_4184 info, float pt) {
        Quaternionf rotation = info.method_23767();
        Quaternionf prevRotation = new Quaternionf((Quaternionfc)rotation);
        rotation.set(-1.0f, 0.0f, 0.0f, 1.0f);
        rotation.normalize();
        super.method_3074(vb, info, pt);
        rotation.set(0.0f, 0.0f, 0.0f, 1.0f);
        rotation.mul((Quaternionfc)prevRotation);
    }

    @Override
    protected boolean canEvaporate() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<FluidParticleData> {
        public class_703 createParticle(FluidParticleData data, class_638 world, double x, double y, double z, double vx, double vy, double vz) {
            FluidConfig config = AllFluidConfigs.get(data.fluid());
            if (config == null) {
                return null;
            }
            return new BasinFluidParticle(world, data.fluid(), data.components(), config, x, y, z, vx, vy, vz);
        }
    }
}

