/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.ponder.scenes.highLogistics;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.infrastructure.ponder.scenes.highLogistics.PonderHilo;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.saw.SawBlockEntity;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.box.PackageStyles;
import com.zurrtum.create.content.processing.recipe.ProcessingInventory;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

@Environment(value=EnvType.CLIENT)
public class PackagerScenes {
    public static void packager(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("packager", "Creating and unwrapping packages");
        scene.configureBasePlate(0, 0, 7);
        scene.showBasePlate();
        Selection chest1 = util.select().fromTo(5, 2, 3, 5, 2, 4);
        class_2338 funnel1 = util.grid().at(4, 2, 2);
        class_2338 funnel2 = util.grid().at(1, 2, 2);
        Selection funnel1S = util.select().position(funnel1);
        Selection funnel2S = util.select().position(funnel2);
        class_2338 packager1 = util.grid().at(5, 2, 2);
        class_2338 packager2 = util.grid().at(1, 2, 3);
        Selection packager1S = util.select().position(packager1);
        Selection packager2S = util.select().position(packager2);
        Selection largeCog = util.select().position(7, 0, 3);
        Selection cogNBelt = util.select().fromTo(6, 1, 2, 0, 1, 2).add(util.select().position(6, 1, 3));
        class_2338 lever = util.grid().at(5, 3, 2);
        Selection scaff1 = util.select().fromTo(5, 1, 3, 5, 1, 4);
        Selection scaff2 = util.select().fromTo(1, 1, 3, 1, 1, 4);
        scene.idle(5);
        ElementLink<WorldSectionElement> chestL = scene.world().showIndependentSection(chest1, class_2350.field_11033);
        scene.world().moveSection(chestL, util.vector().of(-2.0, -1.0, 0.0), 0);
        scene.idle(10);
        ElementLink<WorldSectionElement> packagerL = scene.world().showIndependentSection(packager1S, class_2350.field_11035);
        scene.world().moveSection(packagerL, util.vector().of(-2.0, -1.0, 0.0), 0);
        scene.idle(20);
        class_1799 dirt = new class_1799((class_1935)class_1802.field_8831);
        scene.overlay().showControls(util.vector().of(2.5, 3.0, 2.5), Pointing.DOWN, 40).withItem(dirt);
        scene.idle(20);
        scene.overlay().showText(80).text("Attach packagers to the inventory they should target").attachKeyFrame().placeNearTarget().pointAt(util.vector().of(2.0, 2.5, 2.5));
        scene.idle(60);
        ElementLink<WorldSectionElement> leverL = scene.world().showIndependentSection(util.select().position(lever), class_2350.field_11033);
        scene.world().moveSection(leverL, util.vector().of(-2.0, -1.0, 0.0), 0);
        scene.idle(30);
        scene.world().toggleRedstonePower(util.select().fromTo(lever, packager1));
        scene.effects().indicateRedstone(lever.method_10088(2).method_10074());
        scene.idle(10);
        class_1799 box = PackageStyles.getDefaultBox().method_7972();
        PackageItem.addAddress(box, "Warehouse");
        PonderHilo.packagerCreate(scene, packager1, box);
        scene.idle(30);
        scene.overlay().showText(80).text("Given redstone power, it will pack items from the inventory into a package").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(3, 1, 2), class_2350.field_11036));
        scene.idle(30);
        scene.idle(80);
        scene.world().moveSection(leverL, util.vector().of(2.0, 1.0, 0.0), 10);
        scene.world().moveSection(packagerL, util.vector().of(2.0, 1.0, 0.0), 10);
        scene.world().moveSection(chestL, util.vector().of(2.0, 1.0, 0.0), 10);
        scene.world().showSection(scaff1, class_2350.field_11036);
        scene.idle(10);
        scene.world().showSection(largeCog, class_2350.field_11036);
        scene.world().showSection(cogNBelt, class_2350.field_11035);
        scene.idle(10);
        scene.world().showSection(funnel1S, class_2350.field_11033);
        scene.idle(15);
        scene.world().createItemOnBelt(util.grid().at(4, 1, 2), class_2350.field_11034, box);
        PonderHilo.packagerClear(scene, packager1);
        scene.idle(20);
        scene.world().toggleRedstonePower(util.select().fromTo(5, 2, 2, 5, 3, 2));
        scene.idle(10);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), 0.0625f);
        scene.overlay().showText(70).text("These can be picked up and transported like any other item").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(3, 2, 2), class_2350.field_11034));
        scene.idle(80);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), 16.0f);
        scene.idle(10);
        scene.world().showSection(scaff2, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(packager2S, class_2350.field_11033);
        scene.world().showSection(util.select().position(1, 2, 4), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(funnel2S, class_2350.field_11035);
        scene.rotateCameraY(-15.0f);
        scene.idle(40);
        scene.world().removeItemsFromBelt(util.grid().at(1, 1, 2));
        scene.world().flapFunnel(util.grid().at(1, 2, 2), false);
        PonderHilo.packagerUnpack(scene, packager2, box);
        scene.idle(20);
        scene.overlay().showControls(util.vector().topOf(util.grid().at(1, 2, 4)), Pointing.DOWN, 40).withItem(dirt);
        scene.idle(20);
        scene.overlay().showText(90).text("Packages inserted will be destroyed, unpacking the contents into the inventory").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(1, 2, 3), class_2350.field_11039));
        scene.idle(100);
        scene.world().toggleRedstonePower(util.select().fromTo(5, 2, 2, 5, 3, 2));
        scene.effects().indicateRedstone(util.grid().at(5, 3, 2));
        PonderHilo.packagerCreate(scene, packager1, box);
        scene.idle(25);
        scene.world().createItemOnBelt(util.grid().at(4, 1, 2), class_2350.field_11034, box);
        PonderHilo.packagerClear(scene, packager1);
        scene.idle(30);
        scene.overlay().showText(60).text("Full").colored(PonderPalette.RED).placeNearTarget().pointAt(util.vector().topOf(util.grid().at(1, 2, 4)));
        scene.idle(80);
        scene.overlay().showOutlineWithText(util.select().fromTo(1, 2, 3, 1, 2, 4), 90).text("Packagers will not accept packages they cannot fully unpack").colored(PonderPalette.RED).placeNearTarget().attachKeyFrame().pointAt(util.vector().blockSurface(util.grid().at(1, 2, 3), class_2350.field_11039));
        scene.idle(39);
        PonderHilo.packageHopsOffBelt(scene, util.grid().at(0, 1, 2), class_2350.field_11039, box);
        scene.idle(40);
    }

    public static void packagerAddress(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("packager_address", "Routing packages with an address");
        scene.configureBasePlate(0, 0, 9);
        scene.scaleSceneView(0.875f);
        scene.showBasePlate();
        Selection frogport = util.select().position(7, 1, 1);
        Selection postbox = util.select().fromTo(6, 1, 2, 6, 2, 2);
        Selection northBelt = util.select().fromTo(3, 1, 3, 4, 1, 0);
        Selection initialKinetics = util.select().fromTo(3, 1, 5, 3, 1, 9);
        Selection largeCog = util.select().position(2, 0, 9);
        Selection saw = util.select().fromTo(2, 1, 5, 0, 1, 4);
        Selection eastBelt = util.select().fromTo(3, 1, 4, 8, 1, 4);
        Selection tunnelS = util.select().position(4, 2, 4);
        Selection chest = util.select().fromTo(7, 2, 8, 7, 2, 7);
        Selection scaffold = util.select().fromTo(7, 1, 8, 7, 1, 7);
        class_2338 packager = util.grid().at(7, 2, 6);
        Selection packagerAndLever = util.select().fromTo(7, 2, 6, 7, 3, 6);
        Selection packagerBelt = util.select().fromTo(7, 1, 6, 4, 1, 6);
        class_2338 funnel = util.grid().at(6, 2, 6);
        Selection signS = util.select().position(7, 2, 5);
        scene.idle(10);
        ElementLink<WorldSectionElement> chestL = scene.world().showIndependentSection(chest, class_2350.field_11033);
        scene.world().moveSection(chestL, util.vector().of(-2.0, -1.0, -2.0), 0);
        scene.idle(5);
        scene.world().showSectionAndMerge(packagerAndLever, class_2350.field_11035, chestL);
        scene.idle(20);
        scene.world().showSectionAndMerge(signS, class_2350.field_11035, chestL);
        scene.idle(15);
        scene.overlay().showText(40).text("Warehouse").colored(PonderPalette.OUTPUT).placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(5, 1, 4), class_2350.field_11043).method_1031(-0.5, 0.0, 0.0));
        scene.idle(50);
        scene.overlay().showText(60).text("When a sign is placed on a packager..").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(5, 1, 4), class_2350.field_11043).method_1031(-0.5, 0.0, 0.0));
        scene.idle(50);
        scene.world().toggleRedstonePower(packagerAndLever);
        scene.effects().indicateRedstone(util.grid().at(5, 1, 4));
        class_1799 box = PackageStyles.getDefaultBox().method_7972();
        PonderHilo.packagerCreate(scene, packager, box);
        scene.idle(20);
        scene.world().moveSection(chestL, util.vector().of(0.0, 1.0, 0.0), 10);
        scene.idle(10);
        scene.world().showSectionAndMerge(scaffold, class_2350.field_11043, chestL);
        scene.world().showSection(largeCog, class_2350.field_11036);
        scene.world().showSection(initialKinetics, class_2350.field_11043);
        scene.world().showSectionAndMerge(packagerBelt, class_2350.field_11035, chestL);
        scene.idle(5);
        scene.world().showSectionAndMerge(util.select().position(funnel), class_2350.field_11033, chestL);
        scene.idle(15);
        PonderHilo.packagerClear(scene, packager);
        scene.world().createItemOnBelt(util.grid().at(6, 1, 6), class_2350.field_11034, box);
        scene.idle(20);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), 0.03125f);
        scene.overlay().showText(40).text("\u2192 Warehouse").colored(PonderPalette.OUTPUT).placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(3, 2, 4), class_2350.field_11043));
        scene.idle(50);
        scene.overlay().showText(100).text("Created packages will carry the written lines of text as their address").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(3, 2, 4), class_2350.field_11043).method_1031(-0.5, 0.0, 0.0));
        scene.idle(120);
        scene.world().hideIndependentSection(chestL, class_2350.field_11043);
        scene.idle(15);
        scene.world().removeItemsFromBelt(util.grid().at(5, 1, 6));
        scene.world().removeItemsFromBelt(util.grid().at(4, 1, 6));
        scene.idle(15);
        scene.world().showSection(eastBelt, class_2350.field_11039);
        scene.idle(5);
        scene.world().showSection(tunnelS, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(saw, class_2350.field_11034);
        scene.idle(5);
        scene.world().showSection(northBelt, class_2350.field_11035);
        scene.rotateCameraY(-15.0f);
        scene.idle(15);
        scene.overlay().showControls(util.vector().of(4.0, 2.825, 4.5), Pointing.DOWN, 60).withItem(AllItems.PACKAGE_FILTER.method_7854());
        scene.idle(10);
        scene.overlay().showFilterSlotInput(util.vector().of(4.1, 2.825, 4.5), 50);
        scene.idle(30);
        scene.overlay().showText(70).text("Package filters route packages based on their address").attachKeyFrame().placeNearTarget().pointAt(util.vector().of(4.0, 2.825, 4.5));
        scene.idle(70);
        class_1799 warehouseBox = PackageStyles.getDefaultBox().method_7972();
        class_1799 iron = new class_1799((class_1935)class_1802.field_8620);
        class_1799 factoryBox = PackageItem.containing(List.of(iron));
        PackageItem.addAddress(warehouseBox, "Warehouse");
        PackageItem.addAddress(factoryBox, "Factory");
        scene.world().createItemOnBelt(util.grid().at(6, 1, 4), class_2350.field_11034, warehouseBox);
        scene.idle(10);
        scene.overlay().showText(50).text("\u2192 Warehouse").colored(PonderPalette.OUTPUT).placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(7, 2, 4), class_2350.field_11039));
        scene.overlay().showText(50).colored(PonderPalette.BLUE).text("Factory").placeNearTarget().pointAt(util.vector().of(4.0, 2.825, 4.5));
        scene.idle(60);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), 32.0f);
        scene.idle(60);
        scene.world().createItemOnBelt(util.grid().at(6, 1, 4), class_2350.field_11034, factoryBox);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), 0.03125f);
        scene.idle(10);
        scene.overlay().showText(50).text("\u2192 Factory").colored(PonderPalette.OUTPUT).placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(7, 2, 4), class_2350.field_11039));
        scene.overlay().showText(50).colored(PonderPalette.BLUE).text("Factory").placeNearTarget().pointAt(util.vector().of(4.0, 2.825, 4.5));
        scene.idle(60);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), 32.0f);
        scene.idle(27);
        PonderHilo.packageHopsOffBelt(scene, util.grid().at(4, 1, 0), class_2350.field_11043, warehouseBox);
        scene.idle(13);
        class_2338 sawPos = util.grid().at(2, 1, 4);
        scene.world().modifyBlockEntity(sawPos, SawBlockEntity.class, be -> {
            ProcessingInventory inventory = be.inventory;
            inventory.recipeDuration = 10.0f;
            inventory.remainingTime = 10.0f;
            inventory.appliedRecipe = false;
        });
        scene.idle(6);
        scene.world().modifyBlockEntity(sawPos, SawBlockEntity.class, be -> {
            ProcessingInventory inventory = be.inventory;
            inventory.method_5447(0, class_1799.field_8037);
            inventory.method_5447(1, iron);
            inventory.recipeDuration = 20.0f;
            inventory.remainingTime = 20.0f;
            inventory.appliedRecipe = true;
        });
        scene.idle(15);
        scene.world().modifyBlockEntity(sawPos, SawBlockEntity.class, be -> {
            ProcessingInventory inventory = be.inventory;
            inventory.method_5447(1, class_1799.field_8037);
            DirectBeltInputBehaviour behaviour = BlockEntityBehaviour.get((class_1922)be.method_10997(), util.grid().at(1, 1, 4), DirectBeltInputBehaviour.TYPE);
            behaviour.handleInsertion(iron, class_2350.field_11039, false);
        });
        scene.idle(19);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), 0.03125f);
        scene.overlay().showText(100).text("For compactness, mechanical saws can unpack straight onto a belt").attachKeyFrame().placeNearTarget().pointAt(util.vector().topOf(util.grid().at(2, 1, 4)));
        scene.idle(110);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), 32.0f);
        scene.idle(20);
        scene.world().hideSection(eastBelt, class_2350.field_11034);
        scene.idle(5);
        scene.world().hideSection(tunnelS, class_2350.field_11036);
        scene.idle(5);
        scene.world().hideSection(saw, class_2350.field_11039);
        scene.idle(5);
        scene.world().hideSection(initialKinetics, class_2350.field_11036);
        scene.world().hideSection(largeCog, class_2350.field_11033);
        scene.world().hideSection(northBelt, class_2350.field_11043);
        scene.rotateCameraY(15.0f);
        scene.idle(15);
        ElementLink<WorldSectionElement> extrasL = scene.world().showIndependentSection(postbox, class_2350.field_11033);
        scene.world().moveSection(extrasL, util.vector().of(-3.0, 0.0, 2.0), 0);
        scene.idle(5);
        scene.world().showSectionAndMerge(frogport, class_2350.field_11033, extrasL);
        scene.idle(20);
        scene.overlay().showText(100).text("Aside from filters, Frogports and Postboxes have package routing abilities").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(3, 2, 4), class_2350.field_11043));
        scene.idle(110);
        scene.overlay().showText(80).text("Inspect them to find out more about their behaviour").placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(3, 2, 4), class_2350.field_11043));
        scene.idle(90);
    }
}

