/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.mixin;

import com.zurrtum.create.client.infrastructure.itemGroup.FabricCreativeGuiComponents;
import com.zurrtum.create.client.infrastructure.itemGroup.FabricCreativeInventoryScreen;
import com.zurrtum.create.infrastructure.itemGroup.FabricItemGroupImpl;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_7706;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_481.class})
public abstract class CreativeInventoryScreenMixin
extends class_465<class_481.class_483>
implements FabricCreativeInventoryScreen {
    @Shadow
    private static class_1761 field_2896;
    @Unique
    private static int currentPage;

    public CreativeInventoryScreenMixin(class_481.class_483 screenHandler, class_1661 playerInventory, class_2561 text) {
        super((class_1703)screenHandler, playerInventory, text);
    }

    @Shadow
    protected abstract void method_2466(class_1761 var1);

    @Inject(method={"init"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/TextFieldWidget;setEditableColor(I)V", shift=At.Shift.AFTER)})
    private void init(CallbackInfo info) {
        currentPage = this.fabric_getPage(field_2896);
        int xpos = this.field_2776 + 171;
        int ypos = this.field_2800 + 4;
        this.method_37063((class_364)new FabricCreativeGuiComponents.ItemGroupButtonWidget(xpos + 10, ypos, FabricCreativeGuiComponents.Type.NEXT, this));
        this.method_37063((class_364)new FabricCreativeGuiComponents.ItemGroupButtonWidget(xpos, ypos, FabricCreativeGuiComponents.Type.PREVIOUS, this));
    }

    @Inject(method={"setSelectedTab"}, at={@At(value="HEAD")}, cancellable=true)
    private void setSelectedTab(class_1761 itemGroup, CallbackInfo info) {
        if (!this.isGroupVisible(itemGroup)) {
            info.cancel();
        }
    }

    @Inject(method={"renderTabTooltipIfHovered"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTabTooltipIfHovered(class_332 drawContext, class_1761 itemGroup, int mx, int my, CallbackInfoReturnable<Boolean> info) {
        if (!this.isGroupVisible(itemGroup)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isClickInTab"}, at={@At(value="HEAD")}, cancellable=true)
    private void isClickInTab(class_1761 itemGroup, double mx, double my, CallbackInfoReturnable<Boolean> info) {
        if (!this.isGroupVisible(itemGroup)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"renderTabIcon"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTabIcon(class_332 drawContext, class_1761 itemGroup, CallbackInfo info) {
        if (!this.isGroupVisible(itemGroup)) {
            info.cancel();
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (keyCode == 266) {
            if (this.fabric_switchToPreviousPage()) {
                cir.setReturnValue((Object)true);
            }
        } else if (keyCode == 267 && this.fabric_switchToNextPage()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Override
    public int fabric_getCurrentPage() {
        return currentPage;
    }

    @Override
    public boolean fabric_switchToPage(int page) {
        if (!this.hasGroupForPage(page)) {
            return false;
        }
        if (currentPage == page) {
            return false;
        }
        currentPage = page;
        this.updateSelection();
        return true;
    }

    @Override
    public int fabric_getPage(class_1761 itemGroup) {
        if (FabricCreativeGuiComponents.COMMON_GROUPS.contains(itemGroup)) {
            return currentPage;
        }
        FabricItemGroupImpl fabricItemGroup = (FabricItemGroupImpl)itemGroup;
        return fabricItemGroup.fabric_getPage();
    }

    @Override
    public boolean fabric_hasAdditionalPages() {
        return class_7706.method_47335().size() > (Objects.requireNonNull(class_7706.field_42466).comp_1252() ? 14 : 13);
    }

    @Override
    public int fabric_getPageCount() {
        return FabricCreativeGuiComponents.getPageCount();
    }

    @Unique
    private boolean isGroupVisible(class_1761 itemGroup) {
        return itemGroup.method_47311() && currentPage == this.fabric_getPage(itemGroup);
    }

    @Unique
    private void updateSelection() {
        if (!this.isGroupVisible(field_2896)) {
            class_7706.method_47341().stream().filter(this::isGroupVisible).min((a, b) -> Boolean.compare(a.method_7752(), b.method_7752())).ifPresent(this::method_2466);
        }
    }

    @Unique
    private boolean hasGroupForPage(int page) {
        return class_7706.method_47335().stream().anyMatch(itemGroup -> this.fabric_getPage((class_1761)itemGroup) == page);
    }

    static {
        currentPage = 0;
    }
}

