/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.instruction;

import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.element.OutlinerElement;
import com.zurrtum.create.client.ponder.foundation.element.TextWindowElement;
import com.zurrtum.create.client.ponder.foundation.instruction.FadeInOutInstruction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class TextInstruction
extends FadeInOutInstruction {
    private final TextWindowElement element;
    private OutlinerElement outline;

    public TextInstruction(TextWindowElement element, int duration) {
        super(duration);
        this.element = element;
    }

    public TextInstruction(TextWindowElement element, int duration, Selection selection) {
        this(element, duration);
        this.outline = new OutlinerElement(o -> selection.makeOutline((Outliner)o).lineWidth(0.0625f));
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        if (this.outline != null) {
            this.outline.setColor(this.element.getPalette().getColor());
        }
    }

    @Override
    protected void show(PonderScene scene) {
        scene.addElement(this.element);
        this.element.setVisible(true);
        if (this.outline != null) {
            scene.addElement(this.outline);
            this.outline.setFade(1.0f);
            this.outline.setVisible(true);
        }
    }

    @Override
    protected void hide(PonderScene scene) {
        this.element.setVisible(false);
        if (this.outline != null) {
            this.outline.setFade(0.0f);
            this.outline.setVisible(false);
        }
    }

    @Override
    protected void applyFade(PonderScene scene, float fade) {
        this.element.setFade(fade);
    }
}

