/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.config;

import com.zurrtum.create.client.flywheel.api.visualization.BlockEntityVisualizer;
import com.zurrtum.create.client.flywheel.api.visualization.EntityVisualizer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizerRegistry;
import com.zurrtum.create.client.vanillin.Vanillin;
import com.zurrtum.create.client.vanillin.config.VisualConfigValue;
import com.zurrtum.create.client.vanillin.config.VisualOverride;
import com.zurrtum.create.client.vanillin.config.VisualOverrideValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class Configurator {
    public final Map<class_2591<?>, ConfiguredBlockEntity<?>> blockEntities = new LinkedHashMap();
    public final Map<class_1299<?>, ConfiguredEntity<?>> entities = new LinkedHashMap();

    public <T extends class_2586> void register(class_2591<T> type, BlockEntityVisualizer<? super T> visualizer, boolean enabledByDefault) {
        this.blockEntities.put(type, new ConfiguredBlockEntity<T>(type, visualizer, enabledByDefault));
    }

    public <T extends class_1297> void register(class_1299<T> type, EntityVisualizer<? super T> visualizer, boolean enabledByDefault) {
        this.entities.put(type, new ConfiguredEntity<T>(type, visualizer, enabledByDefault));
    }

    @Environment(value=EnvType.CLIENT)
    public static class ConfiguredBlockEntity<T extends class_2586>
    extends ConfiguredVisual {
        public final class_2591<T> type;
        public final BlockEntityVisualizer<? super T> visualizer;

        private ConfiguredBlockEntity(class_2591<T> type, BlockEntityVisualizer<? super T> visualizer, boolean enabledByDefault) {
            super(enabledByDefault);
            this.type = type;
            this.visualizer = visualizer;
        }

        @Override
        public String configKey() {
            return class_7923.field_41181.method_10221(this.type).toString();
        }

        @Override
        protected void enable() {
            VisualizerRegistry.setVisualizer(this.type, this.visualizer);
        }

        @Override
        protected void disable() {
            VisualizerRegistry.setVisualizer(this.type, null);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ConfiguredEntity<T extends class_1297>
    extends ConfiguredVisual {
        public final class_1299<T> type;
        public final EntityVisualizer<? super T> visualizer;

        private ConfiguredEntity(class_1299<T> type, EntityVisualizer<? super T> visualizer, boolean enabledByDefault) {
            super(enabledByDefault);
            this.type = type;
            this.visualizer = visualizer;
        }

        @Override
        public String configKey() {
            return class_7923.field_41177.method_10221(this.type).toString();
        }

        @Override
        protected void enable() {
            VisualizerRegistry.setVisualizer(this.type, this.visualizer);
        }

        @Override
        protected void disable() {
            VisualizerRegistry.setVisualizer(this.type, null);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class ConfiguredVisual {
        private final boolean enabledByDefault;

        protected ConfiguredVisual(boolean enabledByDefault) {
            this.enabledByDefault = enabledByDefault;
        }

        public void set(VisualConfigValue configValue, @Nullable List<VisualOverride> overrides) {
            if (configValue == VisualConfigValue.DISABLE) {
                this.disable();
            } else if (configValue == VisualConfigValue.FORCE_ENABLE) {
                this.enable();
                this.maybeWarnEnabledDespiteOverrides(overrides);
            } else if (configValue == VisualConfigValue.DEFAULT) {
                if (this.disableAndWarnDueToOverrides(overrides)) {
                    this.disable();
                } else if (this.enabledByDefault) {
                    this.enable();
                } else {
                    this.disable();
                }
            }
        }

        private boolean disableAndWarnDueToOverrides(@Nullable List<VisualOverride> overrides) {
            if (overrides == null || overrides.isEmpty()) {
                return false;
            }
            List<String> modIds = ConfiguredVisual.disablingModIds(overrides);
            if (modIds.isEmpty()) {
                return false;
            }
            Vanillin.CONFIG_LOGGER.warn("Disabling {} visual due to overrides from mods: {}", (Object)this.configKey(), (Object)String.join((CharSequence)", ", modIds));
            return true;
        }

        private void maybeWarnEnabledDespiteOverrides(@Nullable List<VisualOverride> overrides) {
            if (overrides == null || overrides.isEmpty()) {
                return;
            }
            List<String> modIds = ConfiguredVisual.disablingModIds(overrides);
            if (!modIds.isEmpty()) {
                Vanillin.CONFIG_LOGGER.warn("Enabling {} visual despite overrides from mods: {}", (Object)this.configKey(), (Object)String.join((CharSequence)", ", modIds));
            }
        }

        public abstract String configKey();

        protected abstract void enable();

        protected abstract void disable();

        private static List<String> disablingModIds(List<VisualOverride> overrides) {
            ArrayList<String> out = new ArrayList<String>();
            for (VisualOverride override : overrides) {
                if (override.value() != VisualOverrideValue.DISABLE) continue;
                out.add(override.modId());
            }
            return out;
        }
    }
}

