/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.visuals;

import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.flywheel.lib.visual.component.ShadowComponent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4590;
import net.minecraft.class_8113;

@Environment(value=EnvType.CLIENT)
public class BlockDisplayVisual
extends AbstractEntityVisual<class_8113.class_8115>
implements SimpleDynamicVisual {
    private final TransformedInstance instance;
    private class_2680 currentBlockState;
    private final ShadowComponent shadowComponent;

    public BlockDisplayVisual(VisualizationContext ctx, class_8113.class_8115 entity, float partialTick) {
        super(ctx, entity, partialTick);
        class_2680 state;
        class_8113.class_8115.class_8225 blockRenderState = entity.method_49778();
        this.currentBlockState = state = blockRenderState != null ? blockRenderState.comp_1319() : class_2246.field_10124.method_9564();
        this.instance = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.block(state)).createInstance();
        this.shadowComponent = new ShadowComponent(ctx, (class_1297)entity);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        class_8113.class_8229 renderState = ((class_8113.class_8115)this.entity).method_49777();
        if (renderState == null) {
            this.instance.handle().setVisible(false);
            return;
        }
        class_8113.class_8115.class_8225 object = ((class_8113.class_8115)this.entity).method_49778();
        if (object == null) {
            this.instance.handle().setVisible(false);
            return;
        }
        this.instance.handle().setVisible(true);
        if (this.currentBlockState != object.comp_1319()) {
            this.currentBlockState = object.comp_1319();
            this.visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.block(this.currentBlockState)).stealInstance(this.instance);
        }
        float f = ((class_8113.class_8115)this.entity).method_48844(ctx.partialTick());
        this.shadowComponent.radius(renderState.comp_1331().method_48886(f));
        this.shadowComponent.strength(renderState.comp_1332().method_48886(f));
        this.shadowComponent.beginFrame(ctx);
        int i = renderState.comp_1330();
        int j = i != -1 ? i : this.computePackedLight(ctx.partialTick());
        class_4590 transformation = (class_4590)renderState.comp_1328().method_48888(f);
        class_243 pos = ((class_8113.class_8115)this.entity).method_19538();
        class_2382 renderOrigin = this.renderOrigin();
        this.instance.setIdentityTransform().translate((float)(pos.field_1352 - (double)renderOrigin.method_10263()), (float)(pos.field_1351 - (double)renderOrigin.method_10264()), (float)(pos.field_1350 - (double)renderOrigin.method_10260()));
        float partialTick = ctx.partialTick();
        class_4184 camera = ctx.camera();
        switch (renderState.comp_1329()) {
            case field_42406: {
                this.instance.pose.rotateYXZ((float)(-Math.PI) / 180 * BlockDisplayVisual.entityYRot(this.entity, partialTick), (float)Math.PI / 180 * BlockDisplayVisual.entityXRot(this.entity, partialTick), 0.0f);
                break;
            }
            case field_42408: {
                this.instance.pose.rotateYXZ((float)(-Math.PI) / 180 * BlockDisplayVisual.entityYRot(this.entity, partialTick), (float)Math.PI / 180 * BlockDisplayVisual.cameraXRot(camera), 0.0f);
                break;
            }
            case field_42407: {
                this.instance.pose.rotateYXZ((float)(-Math.PI) / 180 * BlockDisplayVisual.cameraYrot(camera), (float)Math.PI / 180 * BlockDisplayVisual.entityXRot(this.entity, partialTick), 0.0f);
                break;
            }
            case field_42409: {
                this.instance.pose.rotateYXZ((float)(-Math.PI) / 180 * BlockDisplayVisual.cameraYrot(camera), (float)Math.PI / 180 * BlockDisplayVisual.cameraXRot(camera), 0.0f);
            }
        }
        this.instance.mul(transformation.method_22936()).light(j).setChanged();
    }

    private static float cameraYrot(class_4184 camera) {
        return camera.method_19330() - 180.0f;
    }

    private static float cameraXRot(class_4184 camera) {
        return -camera.method_19329();
    }

    private static float entityYRot(class_1297 entity, float partialTick) {
        return class_3532.method_17821((float)partialTick, (float)entity.field_5982, (float)entity.method_36454());
    }

    private static float entityXRot(class_1297 entity, float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)entity.field_6004, (float)entity.method_36455());
    }

    @Override
    protected void _delete() {
        this.instance.delete();
    }
}

