/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.visuals;

import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.flywheel.lib.visual.util.InstanceRecycler;
import com.zurrtum.create.client.vanillin.item.ItemModels;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_238;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class ItemVisual
extends AbstractEntityVisual<class_1542>
implements SimpleDynamicVisual {
    private static final ThreadLocal<class_5819> RANDOM = ThreadLocal.withInitial(class_5819::method_43053);
    private final class_4587 pPoseStack = new class_4587();
    private final class_10444 itemRenderState = new class_10444();
    private class_10439 itemModel;
    private Model currentModel;
    private class_1799 currentStack;
    private final InstanceRecycler<TransformedInstance> instances;

    public ItemVisual(VisualizationContext ctx, class_1542 entity, float partialTick) {
        super(ctx, entity, partialTick);
        this.updateModel(entity.method_6983());
        this.instances = new InstanceRecycler<TransformedInstance>(this::getInstance);
        this.animate(partialTick);
    }

    public static boolean isSupported(class_1542 entity) {
        if (entity.getClass() != class_1542.class) {
            return false;
        }
        return ItemModels.isSupported(entity.method_6983(), class_811.field_4318);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        if (!this.isVisible(ctx.frustum())) {
            return;
        }
        class_1799 stack = ((class_1542)this.entity).method_6983();
        if (!class_1799.method_31577((class_1799)this.currentStack, (class_1799)stack)) {
            this.updateModel(stack);
            this.instances.delete();
        }
        this.animate(ctx.partialTick());
    }

    private void updateModel(class_1799 stack) {
        this.currentStack = stack.method_7972();
        this.itemModel = ItemModels.getModel(this.currentStack);
        this.currentModel = ItemModels.get(this.level, this.currentStack, class_811.field_4318);
    }

    private TransformedInstance getInstance() {
        return this.visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, this.currentModel).createInstance();
    }

    private void animate(float partialTick) {
        class_638 clientWorld;
        this.pPoseStack.method_34426();
        TransformStack.of(this.pPoseStack).translate((Vector3fc)this.getVisualPosition(partialTick));
        this.instances.resetCount();
        class_1799 itemstack = ((class_1542)this.entity).method_6983();
        if (itemstack.method_7960()) {
            return;
        }
        this.itemRenderState.method_65605();
        class_10442 manager = class_310.method_1551().method_65386();
        class_1937 class_19372 = ((class_1542)this.entity).method_37908();
        class_638 world = class_19372 instanceof class_638 ? (clientWorld = (class_638)class_19372) : null;
        this.itemRenderState.field_55337 = class_811.field_4318;
        this.itemModel.method_65584(this.itemRenderState, itemstack, manager, class_811.field_4318, world, null, ((class_1542)this.entity).method_5628());
        if (this.itemRenderState.method_65606()) {
            return;
        }
        float age = (float)((class_1542)this.entity).method_6985() + partialTick;
        class_238 box = this.itemRenderState.method_72173();
        float f = -((float)box.field_1322) + 0.0625f;
        if (this.shouldBob()) {
            float g = class_3532.method_15374((float)(age / 10.0f + ((class_1542)this.entity).field_7203)) * 0.1f + 0.1f;
            this.pPoseStack.method_46416(0.0f, g + f, 0.0f);
        } else {
            this.pPoseStack.method_46416(0.0f, f, 0.0f);
        }
        float h = class_1542.method_27314((float)age, (float)((class_1542)this.entity).field_7203);
        this.pPoseStack.method_22907((Quaternionfc)class_7833.field_40716.rotation(h));
        int i = this.getRenderAmount(itemstack);
        int seed = itemstack.method_7960() ? 187 : class_1792.method_7880((class_1792)itemstack.method_7909()) + itemstack.method_7919();
        class_5819 random = RANDOM.get();
        random.method_43052((long)seed);
        int light = class_765.method_23687((int)this.level.method_8314(class_1944.field_9282, ((class_1542)this.entity).method_24515()), (int)this.level.method_8314(class_1944.field_9284, ((class_1542)this.entity).method_24515()));
        float lengthZ = (float)box.method_17941();
        if (lengthZ > 0.0625f) {
            this.instances.get().setTransform(this.pPoseStack.method_23760()).light(light).setChanged();
            if (this.shouldSpreadItems()) {
                for (int j = 1; j < i; ++j) {
                    this.pPoseStack.method_22903();
                    float x = (random.method_43057() * 2.0f - 1.0f) * 0.15f;
                    float y = (random.method_43057() * 2.0f - 1.0f) * 0.15f;
                    float z = (random.method_43057() * 2.0f - 1.0f) * 0.15f;
                    this.pPoseStack.method_46416(x, y, z);
                    this.instances.get().setTransform(this.pPoseStack.method_23760()).light(light).setChanged();
                    this.pPoseStack.method_22909();
                }
            }
        } else {
            float l = lengthZ * 1.5f;
            this.pPoseStack.method_46416(0.0f, 0.0f, -(l * (float)(i - 1) / 2.0f));
            this.instances.get().setTransform(this.pPoseStack.method_23760()).light(light).setChanged();
            this.pPoseStack.method_46416(0.0f, 0.0f, l);
            if (this.shouldSpreadItems()) {
                for (int m = 1; m < i; ++m) {
                    this.pPoseStack.method_22903();
                    float x = (random.method_43057() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    float y = (random.method_43057() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    this.pPoseStack.method_46416(x, y, 0.0f);
                    this.instances.get().setTransform(this.pPoseStack.method_23760()).light(light).setChanged();
                    this.pPoseStack.method_22909();
                    this.pPoseStack.method_46416(0.0f, 0.0f, l);
                }
            }
        }
        this.instances.discardExtra();
    }

    protected int getRenderAmount(class_1799 pStack) {
        int i = 1;
        if (pStack.method_7947() > 48) {
            i = 5;
        } else if (pStack.method_7947() > 32) {
            i = 4;
        } else if (pStack.method_7947() > 16) {
            i = 3;
        } else if (pStack.method_7947() > 1) {
            i = 2;
        }
        return i;
    }

    public boolean shouldSpreadItems() {
        return true;
    }

    public boolean shouldBob() {
        return true;
    }

    @Override
    protected void _delete() {
        this.instances.delete();
    }
}

