/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.compat.computercraft.implementation.peripherals;

import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Glob;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.compat.computercraft.events.ComputerEvent;
import com.zurrtum.create.compat.computercraft.events.StationTrainPresenceEvent;
import com.zurrtum.create.compat.computercraft.implementation.CreateLuaTable;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.SyncedPeripheral;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.graph.DiscoveredPath;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.schedule.Schedule;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.foundation.utility.StringHelper;
import com.zurrtum.create.infrastructure.packet.s2c.TrainEditReturnPacket;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StationPeripheral
extends SyncedPeripheral<StationBlockEntity> {
    public StationPeripheral(StationBlockEntity blockEntity) {
        super(blockEntity);
    }

    @LuaFunction(mainThread=true)
    public final void assemble() throws LuaException {
        if (!((StationBlockEntity)this.blockEntity).isAssembling()) {
            throw new LuaException("station must be in assembly mode");
        }
        ((StationBlockEntity)this.blockEntity).assemble(null);
        if (((StationBlockEntity)this.blockEntity).getStation() == null || ((StationBlockEntity)this.blockEntity).getStation().getPresentTrain() == null) {
            throw new LuaException("failed to assemble train");
        }
        if (!((StationBlockEntity)this.blockEntity).exitAssemblyMode()) {
            throw new LuaException("failed to exit assembly mode");
        }
    }

    @LuaFunction(mainThread=true)
    public final void disassemble() throws LuaException {
        if (((StationBlockEntity)this.blockEntity).isAssembling()) {
            throw new LuaException("station must not be in assembly mode");
        }
        this.getTrainOrThrow();
        if (!((StationBlockEntity)this.blockEntity).enterAssemblyMode(null)) {
            throw new LuaException("could not disassemble train");
        }
    }

    @LuaFunction(mainThread=true)
    public final void setAssemblyMode(boolean assemblyMode) throws LuaException {
        if (assemblyMode) {
            if (!((StationBlockEntity)this.blockEntity).enterAssemblyMode(null)) {
                throw new LuaException("failed to enter assembly mode");
            }
        } else if (!((StationBlockEntity)this.blockEntity).exitAssemblyMode()) {
            throw new LuaException("failed to exit assembly mode");
        }
    }

    @LuaFunction
    public final boolean isInAssemblyMode() {
        return ((StationBlockEntity)this.blockEntity).isAssembling();
    }

    @LuaFunction
    public final String getStationName() throws LuaException {
        GlobalStation station = ((StationBlockEntity)this.blockEntity).getStation();
        if (station == null) {
            throw new LuaException("station is not connected to a track");
        }
        return station.name;
    }

    @LuaFunction(mainThread=true)
    public final void setStationName(String name) throws LuaException {
        if (!((StationBlockEntity)this.blockEntity).updateName(name)) {
            throw new LuaException("could not set station name");
        }
    }

    @LuaFunction
    public final boolean isTrainPresent() throws LuaException {
        GlobalStation station = ((StationBlockEntity)this.blockEntity).getStation();
        if (station == null) {
            throw new LuaException("station is not connected to a track");
        }
        return station.getPresentTrain() != null;
    }

    @LuaFunction
    public final boolean isTrainImminent() throws LuaException {
        GlobalStation station = ((StationBlockEntity)this.blockEntity).getStation();
        if (station == null) {
            throw new LuaException("station is not connected to a track");
        }
        return station.getImminentTrain() != null;
    }

    @LuaFunction
    public final boolean isTrainEnroute() throws LuaException {
        GlobalStation station = ((StationBlockEntity)this.blockEntity).getStation();
        if (station == null) {
            throw new LuaException("station is not connected to a track");
        }
        return station.getNearestTrain() != null;
    }

    @LuaFunction
    public final String getTrainName() throws LuaException {
        Train train = this.getTrainOrThrow();
        return train.name.getString();
    }

    @LuaFunction(mainThread=true)
    public final void setTrainName(String name) throws LuaException {
        Train train = this.getTrainOrThrow();
        train.name = class_2561.method_43470((String)name);
        ((StationBlockEntity)this.blockEntity).method_10997().method_8503().method_3760().method_14581((class_2596)new TrainEditReturnPacket(train.id, name, train.icon.id(), train.mapColorIndex));
    }

    @LuaFunction
    public final boolean hasSchedule() throws LuaException {
        Train train = this.getTrainOrThrow();
        return train.runtime.getSchedule() != null;
    }

    @LuaFunction
    public final CreateLuaTable getSchedule() throws LuaException {
        class_11362 writeView;
        Train train = this.getTrainOrThrow();
        Schedule schedule = train.runtime.getSchedule();
        if (schedule == null) {
            throw new LuaException("train doesn't have a schedule");
        }
        try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "StationPeripheral", Create.LOGGER);){
            writeView = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)((StationBlockEntity)this.blockEntity).method_10997().method_30349());
            schedule.write((class_11372)writeView);
        }
        return StationPeripheral.fromCompoundTag(writeView.method_71475());
    }

    @LuaFunction(mainThread=true)
    public final void setSchedule(IArguments arguments) throws LuaException {
        class_11368 readView;
        Train train = this.getTrainOrThrow();
        try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "StationPeripheral", Create.LOGGER);){
            readView = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)((StationBlockEntity)this.blockEntity).method_10997().method_30349(), (class_2487)StationPeripheral.toCompoundTag(new CreateLuaTable(arguments.getTable(0))));
        }
        Schedule schedule = Schedule.read(readView);
        if (schedule.entries.isEmpty()) {
            throw new LuaException("Schedule must have at least one entry");
        }
        boolean autoSchedule = train.runtime.getSchedule() == null || train.runtime.isAutoSchedule;
        train.runtime.setSchedule(schedule, autoSchedule);
    }

    private Pair<@Nullable DiscoveredPath, @NotNull Boolean> findPath(String destinationFilter) throws LuaException {
        DiscoveredPath best;
        Train train = this.getTrainOrThrow();
        String regex = Glob.toRegexPattern(destinationFilter, "");
        boolean anyMatch = false;
        ArrayList<GlobalStation> validStations = new ArrayList<GlobalStation>();
        try {
            for (GlobalStation globalStation : train.graph.getPoints(EdgePointType.STATION)) {
                if (!globalStation.name.matches(regex)) continue;
                anyMatch = true;
                validStations.add(globalStation);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        if ((best = train.navigation.findPathTo(validStations, Double.MAX_VALUE)) == null) {
            return Pair.of(null, anyMatch);
        }
        return Pair.of(best, true);
    }

    @LuaFunction
    public MethodResult canTrainReach(String destinationFilter) throws LuaException {
        Pair<@Nullable DiscoveredPath, @NotNull Boolean> path = this.findPath(destinationFilter);
        if (path.getFirst() != null) {
            return MethodResult.of((Object[])new Object[]{true, null});
        }
        return MethodResult.of((Object[])new Object[]{false, path.getSecond() != false ? "cannot-reach" : "no-target"});
    }

    @LuaFunction
    public MethodResult distanceTo(String destinationFilter) throws LuaException {
        Pair<@Nullable DiscoveredPath, @NotNull Boolean> path = this.findPath(destinationFilter);
        if (path.getFirst() != null) {
            return MethodResult.of((Object[])new Object[]{path.getFirst().distance, null});
        }
        return MethodResult.of((Object[])new Object[]{null, path.getSecond() != false ? "cannot-reach" : "no-target"});
    }

    @NotNull
    private Train getTrainOrThrow() throws LuaException {
        GlobalStation station = ((StationBlockEntity)this.blockEntity).getStation();
        if (station == null) {
            throw new LuaException("station is not connected to a track");
        }
        Train train = station.getPresentTrain();
        if (train == null) {
            throw new LuaException("there is no train present");
        }
        return train;
    }

    @NotNull
    private static CreateLuaTable fromCompoundTag(class_2487 tag) throws LuaException {
        return (CreateLuaTable)StationPeripheral.fromNBTTag(null, (class_2520)tag);
    }

    @NotNull
    private static Object fromNBTTag(@Nullable String key, class_2520 tag) throws LuaException {
        byte type = tag.method_10711();
        if (type == 1 && key != null && key.equals("Count")) {
            return tag.method_68600().get();
        }
        if (type == 1) {
            return (Byte)tag.method_68600().get() != 0;
        }
        if (type == 2 || type == 3 || type == 4) {
            return tag.method_68603().get();
        }
        if (type == 5 || type == 6) {
            return tag.method_68605().get();
        }
        if (type == 8) {
            return tag.method_68658().get();
        }
        if (type == 9 || type == 7 || type == 11 || type == 12) {
            CreateLuaTable list = new CreateLuaTable();
            class_2499 listTag = (class_2499)tag.method_68592().get();
            for (int i = 0; i < listTag.size(); ++i) {
                list.put(i + 1, StationPeripheral.fromNBTTag(null, (class_2520)listTag.get(i)));
            }
            return list;
        }
        if (type == 10) {
            CreateLuaTable table = new CreateLuaTable();
            class_2487 compoundTag = (class_2487)tag.method_68571().get();
            for (String compoundKey : compoundTag.method_10541()) {
                table.put(StringHelper.camelCaseToSnakeCase(compoundKey), StationPeripheral.fromNBTTag(compoundKey, compoundTag.method_10580(compoundKey)));
            }
            return table;
        }
        throw new LuaException("unknown tag type " + tag.getClass().getName());
    }

    @NotNull
    private static class_2487 toCompoundTag(CreateLuaTable table) throws LuaException {
        return (class_2487)StationPeripheral.toNBTTag(null, table.getMap());
    }

    @NotNull
    private static class_2520 toNBTTag(@Nullable String key, Object value) throws LuaException {
        Map v;
        if (value instanceof Boolean) {
            Boolean v2 = (Boolean)value;
            return class_2481.method_23234((boolean)v2);
        }
        if (value instanceof Byte || key != null && key.equals("count")) {
            return class_2481.method_23233((byte)((Number)value).byteValue());
        }
        if (value instanceof Number) {
            Number v3 = (Number)value;
            if ((double)v3.intValue() == v3.doubleValue()) {
                return class_2497.method_23247((int)v3.intValue());
            }
            return class_2489.method_23241((double)v3.doubleValue());
        }
        if (value instanceof String) {
            String v4 = (String)value;
            return class_2519.method_23256((String)v4);
        }
        if (value instanceof Map && (v = (Map)value).containsKey(1.0)) {
            class_2499 list = new class_2499();
            for (double i = 1.0; i <= (double)v.size(); i += 1.0) {
                if (v.get(i) == null) continue;
                list.add((Object)StationPeripheral.toNBTTag(null, v.get(i)));
            }
            return list;
        }
        if (value instanceof Map) {
            Map v5 = (Map)value;
            class_2487 compound = new class_2487();
            for (Object objectKey : v5.keySet()) {
                if (!(objectKey instanceof String)) {
                    throw new LuaException("table key is not of type string");
                }
                String compoundKey = (String)objectKey;
                compound.method_10566(compoundKey.equals("id") && v5.containsKey("count") ? "id" : StringHelper.snakeCaseToCamelCase(compoundKey), StationPeripheral.toNBTTag(compoundKey, v5.get(compoundKey)));
            }
            return compound;
        }
        throw new LuaException("unknown object type " + value.getClass().getName());
    }

    @Override
    public void prepareComputerEvent(@NotNull ComputerEvent event) {
        if (event instanceof StationTrainPresenceEvent) {
            StationTrainPresenceEvent stpe = (StationTrainPresenceEvent)event;
            this.queueEvent(stpe.type.name, stpe.train.name.getString());
        }
    }

    @NotNull
    public String getType() {
        return "Create_Station";
    }
}

