/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.compat.computercraft.implementation.peripherals;

import com.zurrtum.create.compat.computercraft.events.ComputerEvent;
import com.zurrtum.create.compat.computercraft.events.KineticsChangeEvent;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.SyncedPeripheral;
import com.zurrtum.create.content.kinetics.gauge.StressGaugeBlockEntity;
import dan200.computercraft.api.lua.LuaFunction;
import org.jetbrains.annotations.NotNull;

public class StressGaugePeripheral
extends SyncedPeripheral<StressGaugeBlockEntity> {
    public StressGaugePeripheral(StressGaugeBlockEntity blockEntity) {
        super(blockEntity);
    }

    @LuaFunction
    public final float getStress() {
        return ((StressGaugeBlockEntity)this.blockEntity).getNetworkStress();
    }

    @LuaFunction
    public final float getStressCapacity() {
        return ((StressGaugeBlockEntity)this.blockEntity).getNetworkCapacity();
    }

    @Override
    public void prepareComputerEvent(@NotNull ComputerEvent event) {
        if (event instanceof KineticsChangeEvent) {
            KineticsChangeEvent kce = (KineticsChangeEvent)event;
            if (kce.overStressed) {
                this.queueEvent("overstressed", new Object[0]);
            } else {
                this.queueEvent("stress_change", Float.valueOf(kce.stress), Float.valueOf(kce.capacity));
            }
        }
    }

    @NotNull
    public String getType() {
        return "Create_Stressometer";
    }
}

