/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.actors.harvester;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.actors.harvester.HarvesterBlock;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2523;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3830;
import net.minecraft.class_4538;
import net.minecraft.class_4865;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class HarvesterMovementBehaviour
extends MovementBehaviour {
    @Override
    public boolean isActive(MovementContext context) {
        return super.isActive(context) && !VecHelper.isVecPointingTowards(context.relativeMotion, ((class_2350)context.state.method_11654((class_2769)HarvesterBlock.field_11177)).method_10153());
    }

    @Override
    public class_243 getActiveAreaOffset(MovementContext context) {
        return class_243.method_24954((class_2382)((class_2350)context.state.method_11654((class_2769)HarvesterBlock.field_11177)).method_62675()).method_1021(0.45);
    }

    @Override
    public void visitNewPosition(MovementContext context, class_2338 pos) {
        class_1937 world = context.world;
        if (world.field_9236) {
            return;
        }
        class_2680 stateVisited = world.method_8320(pos);
        if (stateVisited.method_26215() || stateVisited.method_26164(AllBlockTags.NON_HARVESTABLE)) {
            return;
        }
        boolean notCropButCuttable = false;
        if (!this.isValidCrop(world, pos, stateVisited)) {
            if (this.isValidOther(world, pos, stateVisited)) {
                notCropButCuttable = true;
            } else {
                return;
            }
        }
        class_1799 item = class_1799.field_8037;
        float effectChance = 1.0f;
        if (stateVisited.method_26164(class_3481.field_15503)) {
            item = new class_1799((class_1935)class_1802.field_8868);
            effectChance = 0.45f;
        }
        MutableBoolean seedSubtracted = new MutableBoolean(notCropButCuttable);
        class_2680 state = stateVisited;
        BlockHelper.destroyBlockAs(world, pos, null, item, effectChance, stack -> {
            if (((Boolean)AllConfigs.server().kinetics.harvesterReplants.get()).booleanValue() && !seedSubtracted.getValue().booleanValue() && ItemHelper.sameItem(stack, new class_1799((class_1935)state.method_26204()))) {
                stack.method_7934(1);
                seedSubtracted.setTrue();
            }
            this.collectOrDropItem(context, (class_1799)stack);
        });
        class_2680 cutCrop = this.cutCrop(world, pos, stateVisited);
        world.method_8501(pos, cutCrop.method_26184((class_4538)world, pos) ? cutCrop : class_2246.field_10124.method_9564());
    }

    public boolean isValidCrop(class_1937 world, class_2338 pos, class_2680 state) {
        boolean harvestPartial = (Boolean)AllConfigs.server().kinetics.harvestPartiallyGrown.get();
        boolean replant = (Boolean)AllConfigs.server().kinetics.harvesterReplants.get();
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof class_2302) {
            class_2302 crop = (class_2302)class_22482;
            if (harvestPartial) {
                return state != crop.method_9828(0) || !replant;
            }
            return crop.method_9825(state);
        }
        if (state.method_26220((class_1922)world, pos).method_1110() || state.method_26204() instanceof class_2282) {
            for (class_2769 property : state.method_28501()) {
                if (!(property instanceof class_2758)) continue;
                class_2758 ageProperty = (class_2758)property;
                if (!property.method_11899().equals(class_2741.field_12521.method_11899())) continue;
                int age = (Integer)state.method_11654((class_2769)ageProperty);
                if (state.method_26204() instanceof class_3830 && age <= 1 && replant || age == 0 && replant || !harvestPartial && ageProperty.method_11898().size() - 1 != age) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidOther(class_1937 world, class_2338 pos, class_2680 state) {
        if (state.method_26204() instanceof class_2302) {
            return false;
        }
        if (state.method_26204() instanceof class_2523) {
            return true;
        }
        if (state.method_26164(class_3481.field_15503)) {
            return true;
        }
        if (state.method_26204() instanceof class_2282) {
            return (Integer)state.method_11654((class_2769)class_2282.field_10779) == 2;
        }
        if (state.method_26220((class_1922)world, pos).method_1110()) {
            if (state.method_26204() instanceof class_4865) {
                return true;
            }
            for (class_2769 property : state.method_28501()) {
                if (!(property instanceof class_2758) || !property.method_11899().equals(class_2741.field_12521.method_11899())) continue;
                return false;
            }
            if (state.method_26204() instanceof class_2261) {
                return true;
            }
        }
        return false;
    }

    private class_2680 cutCrop(class_1937 world, class_2338 pos, class_2680 state) {
        if (!((Boolean)AllConfigs.server().kinetics.harvesterReplants.get()).booleanValue()) {
            if (state.method_26227().method_15769()) {
                return class_2246.field_10124.method_9564();
            }
            return state.method_26227().method_15759();
        }
        class_2248 block = state.method_26204();
        if (block instanceof class_2302) {
            class_2302 crop = (class_2302)block;
            class_2680 newState = crop.method_9828(0);
            if (!newState.method_27852(block)) {
                return newState;
            }
            class_2758 ageProperty = crop.method_9824();
            return (class_2680)state.method_11657((class_2769)ageProperty, (Comparable)Integer.valueOf(0));
        }
        if (block == class_2246.field_16999) {
            return (class_2680)state.method_11657((class_2769)class_2741.field_12497, (Comparable)Integer.valueOf(1));
        }
        if (state.method_26164(AllBlockTags.SUGAR_CANE_VARIANTS) || block instanceof class_4865) {
            if (state.method_26227().method_15769()) {
                return class_2246.field_10124.method_9564();
            }
            return state.method_26227().method_15759();
        }
        if (state.method_26220((class_1922)world, pos).method_1110() || block instanceof class_2282) {
            for (class_2769 property : state.method_28501()) {
                if (!(property instanceof class_2758) || !property.method_11899().equals(class_2741.field_12521.method_11899())) continue;
                return (class_2680)state.method_11657((class_2769)((class_2758)property), (Comparable)Integer.valueOf(0));
            }
        }
        if (state.method_26227().method_15769()) {
            return class_2246.field_10124.method_9564();
        }
        return state.method_26227().method_15759();
    }

    @Override
    public boolean disableBlockEntityRendering() {
        return true;
    }
}

