/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.decoration.girder;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.content.decoration.girder.GirderBlock;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class GirderWrenchBehavior {
    @Nullable
    public static Pair<class_2350, Action> getDirectionAndAction(class_3965 result, class_1937 world, class_2338 pos) {
        List<Pair<class_2350, Action>> validDirections = GirderWrenchBehavior.getValidDirections((class_1922)world, pos);
        if (validDirections.isEmpty()) {
            return null;
        }
        List<class_2350> directions = IPlacementHelper.orderedByDistance(pos, result.method_17784(), validDirections.stream().map(Pair::getFirst).toList());
        if (directions.isEmpty()) {
            return null;
        }
        class_2350 dir = directions.getFirst();
        return validDirections.stream().filter(pair -> pair.getFirst() == dir).findFirst().orElseGet(() -> Pair.of(dir, Action.SINGLE));
    }

    public static List<Pair<class_2350, Action>> getValidDirections(class_1922 level, class_2338 pos) {
        class_2680 blockState = level.method_8320(pos);
        if (!blockState.method_27852((class_2248)AllBlocks.METAL_GIRDER)) {
            return Collections.emptyList();
        }
        return Arrays.stream(Iterate.directions).mapMulti((direction, consumer) -> {
            class_2680 other = level.method_8320(pos.method_10093(direction));
            if (!((Boolean)blockState.method_11654((class_2769)GirderBlock.X)).booleanValue() && !((Boolean)blockState.method_11654((class_2769)GirderBlock.Z)).booleanValue()) {
                return;
            }
            if (direction.method_10166() == class_2350.class_2351.field_11052) {
                if (!other.method_27852((class_2248)AllBlocks.METAL_GIRDER)) {
                    if ((Boolean)blockState.method_11654((class_2769)GirderBlock.X) == false ^ (Boolean)blockState.method_11654((class_2769)GirderBlock.Z) == false) {
                        consumer.accept(Pair.of(direction, Action.SINGLE));
                    }
                    return;
                }
                if (blockState.method_11654((class_2769)GirderBlock.X) == blockState.method_11654((class_2769)GirderBlock.Z)) {
                    return;
                }
                if (other.method_11654((class_2769)GirderBlock.X) == other.method_11654((class_2769)GirderBlock.Z)) {
                    return;
                }
                consumer.accept(Pair.of(direction, Action.PAIR));
                return;
            }
        }).toList();
    }

    public static boolean handleClick(class_1937 level, class_2338 pos, class_2680 state, class_3965 result) {
        Pair<class_2350, Action> dirPair = GirderWrenchBehavior.getDirectionAndAction(result, level, pos);
        if (dirPair == null) {
            return false;
        }
        if (level.field_9236) {
            return true;
        }
        if (!((Boolean)state.method_11654((class_2769)GirderBlock.X)).booleanValue() && !((Boolean)state.method_11654((class_2769)GirderBlock.Z)).booleanValue()) {
            return false;
        }
        class_2350 dir = dirPair.getFirst();
        class_2338 otherPos = pos.method_10093(dir);
        class_2680 other = level.method_8320(otherPos);
        if (dir == class_2350.field_11036) {
            level.method_8652(pos, GirderWrenchBehavior.postProcess((class_2680)state.method_28493((class_2769)GirderBlock.TOP)), 18);
            if (dirPair.getSecond() == Action.PAIR && other.method_27852((class_2248)AllBlocks.METAL_GIRDER)) {
                level.method_8652(otherPos, GirderWrenchBehavior.postProcess((class_2680)other.method_28493((class_2769)GirderBlock.BOTTOM)), 18);
            }
            return true;
        }
        if (dir == class_2350.field_11033) {
            level.method_8652(pos, GirderWrenchBehavior.postProcess((class_2680)state.method_28493((class_2769)GirderBlock.BOTTOM)), 18);
            if (dirPair.getSecond() == Action.PAIR && other.method_27852((class_2248)AllBlocks.METAL_GIRDER)) {
                level.method_8652(otherPos, GirderWrenchBehavior.postProcess((class_2680)other.method_28493((class_2769)GirderBlock.TOP)), 18);
            }
            return true;
        }
        return true;
    }

    private static class_2680 postProcess(class_2680 newState) {
        if (((Boolean)newState.method_11654((class_2769)GirderBlock.TOP)).booleanValue() && ((Boolean)newState.method_11654((class_2769)GirderBlock.BOTTOM)).booleanValue()) {
            return newState;
        }
        if (newState.method_11654(GirderBlock.AXIS) != class_2350.class_2351.field_11052) {
            return newState;
        }
        return (class_2680)newState.method_11657(GirderBlock.AXIS, (Comparable)((Boolean)newState.method_11654((class_2769)GirderBlock.X) != false ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051));
    }

    public static enum Action {
        SINGLE,
        PAIR,
        HORIZONTAL;

    }
}

