/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.bell;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.content.equipment.bell.AbstractBellBlockEntity;
import com.zurrtum.create.content.equipment.bell.HauntedBellPulser;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;

public class HauntedBellBlockEntity
extends AbstractBellBlockEntity {
    public static final int DISTANCE = 10;
    public static final int RECHARGE_TICKS = 65;
    public static final int EFFECT_TICKS = 20;
    public int effectTicks = 0;

    public HauntedBellBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.HAUNTED_BELL, pos, state);
    }

    @Override
    public boolean ring(class_1937 world, class_2338 pos, class_2350 direction) {
        if (this.isRinging && this.ringingTicks < 65) {
            return false;
        }
        if (world instanceof class_3218) {
            class_3218 serverLevel = (class_3218)world;
            HauntedBellPulser.sendPulse(serverLevel, pos, 10, false);
        }
        this.effectTicks = 20;
        return super.ring(world, pos, direction);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71465("EffectTicks", this.effectTicks);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.effectTicks = view.method_71424("EffectTicks", 0);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.effectTicks <= 0) {
            return;
        }
        --this.effectTicks;
        if (!this.field_11863.field_9236) {
            return;
        }
        class_5819 rand = this.field_11863.method_8409();
        if (rand.method_43057() > 0.25f) {
            return;
        }
        this.spawnParticle(rand);
        this.playSound(rand);
    }

    protected void spawnParticle(class_5819 rand) {
        double x = (double)this.field_11867.method_10263() + rand.method_43058();
        double y = (double)this.field_11867.method_10264() + 0.5;
        double z = (double)this.field_11867.method_10260() + rand.method_43058();
        double vx = rand.method_43058() * 0.04 - 0.02;
        double vy = 0.1;
        double vz = rand.method_43058() * 0.04 - 0.02;
        this.field_11863.method_8406((class_2394)class_2398.field_23114, x, y, z, vx, vy, vz);
    }

    protected void playSound(class_5819 rand) {
        float vol = rand.method_43057() * 0.4f + rand.method_43057() > 0.9f ? 0.6f : 0.0f;
        float pitch = 0.6f + rand.method_43057() * 0.4f;
        this.field_11863.method_8396(null, this.field_11867, (class_3414)class_3417.field_23060.comp_349(), class_3419.field_15245, vol, pitch);
    }
}

