/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.pipes.valve;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.content.fluids.FluidPropagator;
import com.zurrtum.create.content.fluids.pipes.StraightPipeBlockEntity;
import com.zurrtum.create.content.fluids.pipes.valve.FluidValveBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class FluidValveBlockEntity
extends KineticBlockEntity {
    public LerpedFloat pointer = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.0, LerpedFloat.Chaser.LINEAR);

    public FluidValveBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.FLUID_VALVE, pos, state);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        float speed = this.getSpeed();
        this.pointer.chase(speed > 0.0f ? 1.0 : 0.0, this.getChaseSpeed(), LerpedFloat.Chaser.LINEAR);
        this.sendData();
    }

    @Override
    public void tick() {
        super.tick();
        this.pointer.tickChaser();
        if (this.field_11863.field_9236) {
            return;
        }
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof FluidValveBlock)) {
            return;
        }
        boolean stateOpen = (Boolean)blockState.method_11654((class_2769)FluidValveBlock.ENABLED);
        if (stateOpen && this.pointer.getValue() == 0.0f) {
            FluidValveBlockEntity.switchToBlockState(this.field_11863, this.field_11867, (class_2680)blockState.method_11657((class_2769)FluidValveBlock.ENABLED, (Comparable)Boolean.valueOf(false)));
            return;
        }
        if (!stateOpen && this.pointer.getValue() == 1.0f) {
            FluidValveBlockEntity.switchToBlockState(this.field_11863, this.field_11867, (class_2680)blockState.method_11657((class_2769)FluidValveBlock.ENABLED, (Comparable)Boolean.valueOf(true)));
        }
    }

    private float getChaseSpeed() {
        return class_3532.method_15363((float)(Math.abs(this.getSpeed()) / 16.0f / 20.0f), (float)0.0f, (float)1.0f);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        this.pointer.write(view.method_71461("Pointer"));
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.pointer.read(view.method_71434("Pointer"), clientPacket);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new ValvePipeBehaviour(this));
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return FluidPropagator.getSharedTriggers();
    }

    static class ValvePipeBehaviour
    extends StraightPipeBlockEntity.StraightPipeFluidTransportBehaviour {
        public ValvePipeBehaviour(SmartBlockEntity be) {
            super(be);
        }

        @Override
        public boolean canHaveFlowToward(class_2680 state, class_2350 direction) {
            return FluidValveBlock.getPipeAxis(state) == direction.method_10166();
        }

        @Override
        public boolean canPullFluidFrom(FluidStack fluid, class_2680 state, class_2350 direction) {
            if (state.method_28498((class_2769)FluidValveBlock.ENABLED) && ((Boolean)state.method_11654((class_2769)FluidValveBlock.ENABLED)).booleanValue()) {
                return super.canPullFluidFrom(fluid, state, direction);
            }
            return false;
        }
    }
}

