/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.chainConveyor;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBehaviour;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorRoutingTable;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class ChainConveyorBlockEntity
extends KineticBlockEntity
implements TransformableBlockEntity {
    public static final Codec<List<ChainConveyorPackage>> PACKAGE_CODEC = ChainConveyorPackage.CODEC.listOf();
    public static final Codec<List<ChainConveyorPackage>> CLIENT_PACKAGE_CODEC = ChainConveyorPackage.CLIENT_CODEC.listOf();
    public static final Codec<Map<class_2338, List<ChainConveyorPackage>>> MAP_CODEC = CreateCodecs.getCodecMap(class_2338.field_25064, PACKAGE_CODEC);
    public static final Codec<Map<class_2338, List<ChainConveyorPackage>>> CLIENT_MAP_CODEC = CreateCodecs.getCodecMap(class_2338.field_25064, CreateCodecs.getArrayListCodec(ChainConveyorPackage.CLIENT_CODEC));
    public Set<class_2338> connections = new HashSet<class_2338>();
    public Map<class_2338, ConnectionStats> connectionStats;
    public Map<class_2338, ConnectedPort> loopPorts = new HashMap<class_2338, ConnectedPort>();
    public Map<class_2338, ConnectedPort> travelPorts = new HashMap<class_2338, ConnectedPort>();
    public ChainConveyorRoutingTable routingTable = new ChainConveyorRoutingTable();
    List<ChainConveyorPackage> loopingPackages = new ArrayList<ChainConveyorPackage>();
    Map<class_2338, List<ChainConveyorPackage>> travellingPackages = new HashMap<class_2338, List<ChainConveyorPackage>>();
    public boolean reversed;
    public boolean cancelDrops;
    public boolean checkInvalid = true;
    class_2338 chainDestroyedEffectToSend;

    public ChainConveyorBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.CHAIN_CONVEYOR, pos, state);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867).method_1014(this.connections.isEmpty() ? 3.0 : 64.0);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.updateChainShapes();
    }

    public boolean canAcceptMorePackages() {
        return this.loopingPackages.size() + this.travellingPackages.size() < (Integer)AllConfigs.server().logistics.chainConveyorCapacity.get();
    }

    public boolean canAcceptPackagesFor(@Nullable class_2338 connection) {
        ChainConveyorBlockEntity otherClbe;
        class_2586 class_25862;
        if (connection == null && !this.canAcceptMorePackages()) {
            return false;
        }
        return connection == null || (class_25862 = this.field_11863.method_8321(this.field_11867.method_10081((class_2382)connection))) instanceof ChainConveyorBlockEntity && (otherClbe = (ChainConveyorBlockEntity)class_25862).canAcceptMorePackages();
    }

    public boolean canAcceptMorePackagesFromOtherConveyor() {
        return this.loopingPackages.size() < (Integer)AllConfigs.server().logistics.chainConveyorCapacity.get();
    }

    @Override
    public void tick() {
        Iterator iterator;
        super.tick();
        if (this.checkInvalid && !this.field_11863.method_8608()) {
            this.checkInvalid = false;
            this.removeInvalidConnections();
        }
        float serverSpeed = this.field_11863.method_8608() && !this.isVirtual() ? AllClientHandle.INSTANCE.getServerSpeed() : 1.0f;
        float speed = this.getSpeed() / 360.0f;
        float radius = 1.5f;
        float distancePerTick = Math.abs(speed);
        float degreesPerTick = speed / ((float)Math.PI * radius) * 360.0f;
        boolean reversedPreviously = this.reversed;
        this.prepareStats();
        if (this.field_11863.method_8608()) {
            this.getBehaviour(ChainConveyorBehaviour.TYPE).blockEntityTickBoxVisuals();
        }
        if (!this.field_11863.method_8608()) {
            this.routingTable.tick();
            if (this.routingTable.shouldAdvertise()) {
                for (class_2338 class_23382 : this.connections) {
                    class_2586 class_25862 = this.field_11863.method_8321(this.field_11867.method_10081((class_2382)class_23382));
                    if (!(class_25862 instanceof ChainConveyorBlockEntity)) continue;
                    ChainConveyorBlockEntity clbe = (ChainConveyorBlockEntity)class_25862;
                    this.routingTable.advertiseTo(class_23382, clbe.routingTable);
                }
                this.routingTable.changed = false;
                this.routingTable.lastUpdate = 0;
            }
        }
        if (speed == 0.0f) {
            this.updateBoxWorldPositions();
            return;
        }
        if (reversedPreviously != this.reversed) {
            for (Map.Entry entry : this.travellingPackages.entrySet()) {
                class_2338 offset = (class_2338)entry.getKey();
                class_2586 class_25863 = this.field_11863.method_8321(this.field_11867.method_10081((class_2382)offset));
                if (!(class_25863 instanceof ChainConveyorBlockEntity)) continue;
                ChainConveyorBlockEntity otherLift = (ChainConveyorBlockEntity)class_25863;
                iterator = ((List)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    ChainConveyorPackage chainConveyorPackage = (ChainConveyorPackage)iterator.next();
                    if (chainConveyorPackage.justFlipped) continue;
                    chainConveyorPackage.justFlipped = true;
                    float length = (float)class_243.method_24954((class_2382)offset).method_1033() - 1.375f;
                    chainConveyorPackage.chainPosition = length - chainConveyorPackage.chainPosition;
                    otherLift.addTravellingPackage(chainConveyorPackage, offset.method_35830(-1));
                    iterator.remove();
                }
            }
            this.notifyUpdate();
        }
        for (Map.Entry entry : this.travellingPackages.entrySet()) {
            class_2338 target = (class_2338)entry.getKey();
            ConnectionStats stats = this.connectionStats.get(target);
            if (stats == null) continue;
            iterator = ((List)entry.getValue()).iterator();
            block4: while (iterator.hasNext()) {
                class_2586 class_25864;
                ChainConveyorPackage chainConveyorPackage = (ChainConveyorPackage)iterator.next();
                chainConveyorPackage.justFlipped = false;
                float prevChainPosition = chainConveyorPackage.chainPosition;
                chainConveyorPackage.chainPosition += serverSpeed * distancePerTick;
                float anticipatePosition = chainConveyorPackage.chainPosition = Math.min(stats.chainLength, chainConveyorPackage.chainPosition);
                anticipatePosition += serverSpeed * distancePerTick * 4.0f;
                anticipatePosition = Math.min(stats.chainLength, anticipatePosition);
                if (this.field_11863.method_8608() && !this.isVirtual()) continue;
                for (Map.Entry<class_2338, ConnectedPort> portEntry : this.travelPorts.entrySet()) {
                    boolean notAtPositionYet;
                    ConnectedPort port = portEntry.getValue();
                    float chainPosition = port.chainPosition();
                    if (prevChainPosition > chainPosition || !target.equals((Object)port.connection)) continue;
                    boolean bl = notAtPositionYet = chainConveyorPackage.chainPosition < chainPosition;
                    if (notAtPositionYet && anticipatePosition < chainPosition || !PackageItem.matchAddress(chainConveyorPackage.item, port.filter())) continue;
                    if (notAtPositionYet) {
                        this.notifyPortToAnticipate(portEntry.getKey());
                        continue;
                    }
                    if (!this.exportToPort(chainConveyorPackage, portEntry.getKey())) continue;
                    iterator.remove();
                    this.notifyUpdate();
                    continue block4;
                }
                if (chainConveyorPackage.chainPosition < stats.chainLength || !((class_25864 = this.field_11863.method_8321(this.field_11867.method_10081((class_2382)target))) instanceof ChainConveyorBlockEntity)) continue;
                ChainConveyorBlockEntity clbe = (ChainConveyorBlockEntity)class_25864;
                chainConveyorPackage.chainPosition = this.wrapAngle(stats.tangentAngle + 180.0f + (float)(70 * (this.reversed ? -1 : 1)));
                clbe.addLoopingPackage(chainConveyorPackage);
                iterator.remove();
                this.notifyUpdate();
            }
        }
        Iterator<ChainConveyorPackage> iterator2 = this.loopingPackages.iterator();
        block6: while (iterator2.hasNext()) {
            ChainConveyorPackage chainConveyorPackage = iterator2.next();
            chainConveyorPackage.justFlipped = false;
            float prevChainPosition = chainConveyorPackage.chainPosition;
            chainConveyorPackage.chainPosition += serverSpeed * degreesPerTick;
            float anticipatePosition = chainConveyorPackage.chainPosition = this.wrapAngle(chainConveyorPackage.chainPosition);
            anticipatePosition += serverSpeed * degreesPerTick * 4.0f;
            anticipatePosition = this.wrapAngle(anticipatePosition);
            if (this.field_11863.method_8608()) continue;
            for (Map.Entry entry : this.loopPorts.entrySet()) {
                boolean notAtPositionYet;
                ConnectedPort port = (ConnectedPort)entry.getValue();
                float offBranchAngle = port.chainPosition();
                boolean bl = notAtPositionYet = !this.loopThresholdCrossed(chainConveyorPackage.chainPosition, prevChainPosition, offBranchAngle);
                if (notAtPositionYet && !this.loopThresholdCrossed(anticipatePosition, prevChainPosition, offBranchAngle) || !PackageItem.matchAddress(chainConveyorPackage.item, port.filter())) continue;
                if (notAtPositionYet) {
                    this.notifyPortToAnticipate((class_2338)entry.getKey());
                    continue;
                }
                if (!this.exportToPort(chainConveyorPackage, (class_2338)entry.getKey())) continue;
                iterator2.remove();
                this.notifyUpdate();
                continue block6;
            }
            for (class_2338 class_23383 : this.connections) {
                float offBranchAngle;
                ChainConveyorBlockEntity ccbe;
                class_2586 class_25865 = this.field_11863.method_8321(this.field_11867.method_10081((class_2382)class_23383));
                if (class_25865 instanceof ChainConveyorBlockEntity && !(ccbe = (ChainConveyorBlockEntity)class_25865).canAcceptMorePackagesFromOtherConveyor() || !this.loopThresholdCrossed(chainConveyorPackage.chainPosition, prevChainPosition, offBranchAngle = this.connectionStats.get((Object)class_23383).tangentAngle) || !this.routingTable.getExitFor(chainConveyorPackage.item).equals((Object)class_23383)) continue;
                chainConveyorPackage.chainPosition = 0.0f;
                this.addTravellingPackage(chainConveyorPackage, class_23383);
                iterator2.remove();
                continue block6;
            }
        }
        this.updateBoxWorldPositions();
    }

    public void removeInvalidConnections() {
        boolean changed = false;
        Iterator<class_2338> iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            class_2338 next = iterator.next();
            class_2338 target = this.field_11867.method_10081((class_2382)next);
            if (!this.field_11863.method_8477(target)) continue;
            class_2586 class_25862 = this.field_11863.method_8321(target);
            if (class_25862 instanceof ChainConveyorBlockEntity) {
                ChainConveyorBlockEntity ccbe = (ChainConveyorBlockEntity)class_25862;
                if (ccbe.connections.contains(next.method_35830(-1))) continue;
            }
            iterator.remove();
            changed = true;
        }
        if (changed) {
            this.notifyUpdate();
        }
    }

    public void notifyConnectedToValidate() {
        for (class_2338 blockPos : this.connections) {
            class_2586 class_25862;
            class_2338 target = this.field_11867.method_10081((class_2382)blockPos);
            if (!this.field_11863.method_8477(target) || !((class_25862 = this.field_11863.method_8321(target)) instanceof ChainConveyorBlockEntity)) continue;
            ChainConveyorBlockEntity ccbe = (ChainConveyorBlockEntity)class_25862;
            ccbe.checkInvalid = true;
        }
    }

    public boolean loopThresholdCrossed(float chainPosition, float prevChainPosition, float offBranchAngle) {
        int sign2;
        int sign1 = class_3532.method_17822((double)AngleHelper.getShortestAngleDiff(offBranchAngle, prevChainPosition));
        boolean notCrossed = sign1 >= (sign2 = class_3532.method_17822((double)AngleHelper.getShortestAngleDiff(offBranchAngle, chainPosition))) && !this.reversed || sign1 <= sign2 && this.reversed;
        return !notCrossed;
    }

    private boolean exportToPort(ChainConveyorPackage box, class_2338 offset) {
        class_2338 globalPos = this.field_11867.method_10081((class_2382)offset);
        class_2586 class_25862 = this.field_11863.method_8321(globalPos);
        if (!(class_25862 instanceof FrogportBlockEntity)) {
            return false;
        }
        FrogportBlockEntity ppbe = (FrogportBlockEntity)class_25862;
        if (ppbe.isAnimationInProgress()) {
            return false;
        }
        if (ppbe.isBackedUp()) {
            return false;
        }
        ppbe.startAnimation(box.item, false);
        return true;
    }

    private void notifyPortToAnticipate(class_2338 offset) {
        class_2586 class_25862 = this.field_11863.method_8321(this.field_11867.method_10081((class_2382)offset));
        if (class_25862 instanceof FrogportBlockEntity) {
            FrogportBlockEntity ppbe = (FrogportBlockEntity)class_25862;
            ppbe.sendAnticipate();
        }
    }

    public boolean addTravellingPackage(ChainConveyorPackage box, class_2338 connection) {
        if (!this.connections.contains(connection)) {
            return false;
        }
        this.travellingPackages.computeIfAbsent(connection, $ -> new ArrayList()).add(box);
        if (this.field_11863.field_9236) {
            return true;
        }
        this.notifyUpdate();
        return true;
    }

    @Override
    public void notifyUpdate() {
        this.field_11863.method_8524(this.field_11867);
        this.sendData();
    }

    public boolean addLoopingPackage(ChainConveyorPackage box) {
        this.loopingPackages.add(box);
        this.notifyUpdate();
        return true;
    }

    public void prepareStats() {
        float speed = this.getSpeed();
        if (this.reversed != speed < 0.0f && speed != 0.0f) {
            this.reversed = speed < 0.0f;
            this.connectionStats = null;
        }
        if (this.connectionStats == null) {
            this.connectionStats = new HashMap<class_2338, ConnectionStats>();
            this.connections.forEach(this::calculateConnectionStats);
        }
    }

    public void updateBoxWorldPositions() {
        this.prepareStats();
        for (Map.Entry<class_2338, List<ChainConveyorPackage>> entry : this.travellingPackages.entrySet()) {
            class_2338 target = entry.getKey();
            ConnectionStats stats = this.connectionStats.get(target);
            if (stats == null) continue;
            for (ChainConveyorPackage box : entry.getValue()) {
                box.worldPosition = this.getPackagePosition(box.chainPosition, target);
                if (this.field_11863 == null || !this.field_11863.method_8608()) continue;
                class_243 diff = stats.end.method_1020(stats.start).method_1029();
                box.yaw = class_3532.method_15393((float)((float)class_3532.method_15349((double)diff.field_1352, (double)diff.field_1350) * 57.295776f - 90.0f));
            }
        }
        for (ChainConveyorPackage box : this.loopingPackages) {
            box.worldPosition = this.getPackagePosition(box.chainPosition, null);
            box.yaw = class_3532.method_15393((float)box.chainPosition);
            if (!this.reversed) continue;
            box.yaw += 180.0f;
        }
    }

    public class_243 getPackagePosition(float chainPosition, @Nullable class_2338 travelTarget) {
        if (travelTarget == null) {
            return class_243.method_24955((class_2382)this.field_11867).method_1019(VecHelper.rotate(new class_243(0.0, 0.375, 0.875), chainPosition, class_2350.class_2351.field_11052));
        }
        this.prepareStats();
        ConnectionStats stats = this.connectionStats.get(travelTarget);
        if (stats == null) {
            return class_243.field_1353;
        }
        class_243 diff = stats.end.method_1020(stats.start).method_1029();
        return stats.start.method_1019(diff.method_1021((double)Math.min(stats.chainLength, chainPosition)));
    }

    private void calculateConnectionStats(class_2338 connection) {
        boolean reversed = this.getSpeed() < 0.0f;
        float offBranchDistance = 35.0f;
        float direction = 57.295776f * (float)class_3532.method_15349((double)connection.method_10263(), (double)connection.method_10260());
        float angle = this.wrapAngle(direction - offBranchDistance * (float)(reversed ? -1 : 1));
        float oppositeAngle = this.wrapAngle(angle + 180.0f + 2.0f * offBranchDistance * (float)(reversed ? -1 : 1));
        class_243 start = class_243.method_24955((class_2382)this.field_11867).method_1019(VecHelper.rotate(new class_243(0.0, 0.0, 1.25), angle, class_2350.class_2351.field_11052)).method_1031(0.0, 0.375, 0.0);
        class_243 end = class_243.method_24955((class_2382)this.field_11867.method_10081((class_2382)connection)).method_1019(VecHelper.rotate(new class_243(0.0, 0.0, 1.25), oppositeAngle, class_2350.class_2351.field_11052)).method_1031(0.0, 0.375, 0.0);
        float length = (float)start.method_1022(end);
        this.connectionStats.put(connection, new ConnectionStats(angle, length, start, end));
    }

    public boolean addConnectionTo(class_2338 target) {
        class_2338 localTarget = target.method_10059((class_2382)this.field_11867);
        boolean added = this.connections.add(localTarget);
        if (added) {
            this.notifyUpdate();
            this.calculateConnectionStats(localTarget);
            this.updateChainShapes();
        }
        this.detachKinetics();
        this.updateSpeed = true;
        return added;
    }

    public void chainDestroyed(class_2338 target, boolean spawnDrops, boolean sendEffect) {
        int chainCount = ChainConveyorBlockEntity.getChainCost(target);
        if (sendEffect) {
            this.chainDestroyedEffectToSend = target;
            this.sendData();
        }
        if (!spawnDrops) {
            return;
        }
        if (!this.forPointsAlongChains(target, chainCount, vec -> this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, vec.field_1352, vec.field_1351, vec.field_1350, new class_1799((class_1935)class_1802.field_23983))))) {
            while (chainCount > 0) {
                class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1799)new class_1799((class_1935)class_2246.field_23985.method_8389(), Math.min(chainCount, 64)));
                chainCount -= 64;
            }
        }
    }

    public boolean removeConnectionTo(class_2338 target) {
        class_2338 localTarget = target.method_10059((class_2382)this.field_11867);
        if (!this.connections.contains(localTarget)) {
            return false;
        }
        this.detachKinetics();
        this.connections.remove(localTarget);
        this.connectionStats.remove(localTarget);
        List<ChainConveyorPackage> packages = this.travellingPackages.remove(localTarget);
        if (packages != null) {
            for (ChainConveyorPackage box : packages) {
                this.drop(box);
            }
        }
        this.notifyUpdate();
        this.updateChainShapes();
        this.updateSpeed = true;
        return true;
    }

    private void updateChainShapes() {
        this.prepareStats();
        if (this.field_11863 != null && this.field_11863.method_8608()) {
            this.getBehaviour(ChainConveyorBehaviour.TYPE).updateChainShapes();
        }
    }

    @Override
    public void remove() {
        super.remove();
        if (this.field_11863 == null || !this.field_11863.method_8608()) {
            return;
        }
        for (class_2338 blockPos : this.connections) {
            this.spawnDestroyParticles(blockPos);
        }
    }

    private void spawnDestroyParticles(class_2338 blockPos) {
        this.forPointsAlongChains(blockPos, (int)Math.round(class_243.method_24954((class_2382)blockPos).method_1033() * 8.0), vec -> this.field_11863.method_8406((class_2394)new class_2388(class_2398.field_11217, class_2246.field_23985.method_9564()), vec.field_1352, vec.field_1351, vec.field_1350, 0.0, 0.0, 0.0));
    }

    @Override
    public void destroy() {
        super.destroy();
        for (class_2338 class_23382 : this.connections) {
            this.chainDestroyed(class_23382, !this.cancelDrops, false);
            class_2586 class_25862 = this.field_11863.method_8321(this.field_11867.method_10081((class_2382)class_23382));
            if (!(class_25862 instanceof ChainConveyorBlockEntity)) continue;
            ChainConveyorBlockEntity clbe = (ChainConveyorBlockEntity)class_25862;
            clbe.removeConnectionTo(this.field_11867);
        }
        for (ChainConveyorPackage chainConveyorPackage : this.loopingPackages) {
            this.drop(chainConveyorPackage);
        }
        for (Map.Entry entry : this.travellingPackages.entrySet()) {
            for (ChainConveyorPackage box : (List)entry.getValue()) {
                this.drop(box);
            }
        }
    }

    public boolean forPointsAlongChains(class_2338 connection, int positions, Consumer<class_243> callback) {
        this.prepareStats();
        ConnectionStats stats = this.connectionStats.get(connection);
        if (stats == null) {
            return false;
        }
        class_243 start = stats.start;
        class_243 direction = stats.end.method_1020(start);
        class_243 origin = class_243.method_24953((class_2382)this.field_11867);
        class_243 normal = direction.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
        class_243 offset = start.method_1020(origin);
        class_243 start2 = origin.method_1019(offset.method_1019(normal.method_1021(-2.0 * normal.method_1026(offset))));
        for (boolean firstChain : Iterate.trueAndFalse) {
            int steps = positions / 2;
            if (firstChain) {
                steps += positions % 2;
            }
            for (int i = 0; i < steps; ++i) {
                callback.accept((firstChain ? start : start2).method_1019(direction.method_1021((0.5 + (double)i) / (double)steps)));
            }
        }
        return true;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.field_11863 != null && this.field_11863.method_8608()) {
            this.getBehaviour(ChainConveyorBehaviour.TYPE).invalidate();
        }
    }

    private void drop(ChainConveyorPackage box) {
        if (box.worldPosition != null) {
            this.field_11863.method_8649((class_1297)PackageEntity.fromItemStack(this.field_11863, box.worldPosition.method_1023(0.0, 0.5, 0.0), box.item));
        }
    }

    @Override
    public List<class_2338> addPropagationLocations(IRotate block, class_2680 state, List<class_2338> neighbours) {
        this.connections.forEach(p -> neighbours.add(this.field_11867.method_10081((class_2382)p)));
        return super.addPropagationLocations(block, state, neighbours);
    }

    @Override
    public float propagateRotationTo(KineticBlockEntity target, class_2680 stateFrom, class_2680 stateTo, class_2338 diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (this.connections.contains(target.method_11016().method_10059((class_2382)this.field_11867))) {
            if (!(target instanceof ChainConveyorBlockEntity)) {
                return 0.0f;
            }
            return 1.0f;
        }
        return super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);
    }

    @Override
    public void writeSafe(class_11372 view) {
        super.writeSafe(view);
        view.method_71468("Connections", CreateCodecs.BLOCKPOS_SET_CODEC, this.connections);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (clientPacket && this.chainDestroyedEffectToSend != null) {
            view.method_71468("DestroyEffect", class_2338.field_25064, (Object)this.chainDestroyedEffectToSend);
            this.chainDestroyedEffectToSend = null;
        }
        view.method_71468("Connections", CreateCodecs.BLOCKPOS_SET_CODEC, this.connections);
        view.method_71468("TravellingPackages", clientPacket ? CLIENT_MAP_CODEC : MAP_CODEC, this.travellingPackages);
        view.method_71468("LoopingPackages", clientPacket ? CLIENT_PACKAGE_CODEC : PACKAGE_CODEC, this.loopingPackages);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (clientPacket) {
            view.method_71426("DestroyEffect", class_2338.field_25064).ifPresent(this::spawnDestroyParticles);
        }
        int sizeBefore = this.connections.size();
        this.connections.clear();
        this.travellingPackages.clear();
        this.loopingPackages.clear();
        view.method_71426("Connections", CreateCodecs.BLOCKPOS_SET_CODEC).ifPresent(data -> this.connections.addAll((Collection<class_2338>)data));
        view.method_71426("TravellingPackages", CLIENT_MAP_CODEC).ifPresent(map -> this.travellingPackages.putAll((Map<class_2338, List<ChainConveyorPackage>>)map));
        view.method_71426("LoopingPackages", CLIENT_PACKAGE_CODEC).ifPresent(list -> this.loopingPackages.addAll((Collection<ChainConveyorPackage>)list));
        this.connectionStats = null;
        this.updateBoxWorldPositions();
        this.updateChainShapes();
        if (this.connections.size() != sizeBefore && this.field_11863 != null && this.field_11863.field_9236) {
            this.invalidateRenderBoundingBox();
        }
    }

    public float wrapAngle(float angle) {
        if ((angle %= 360.0f) < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public static int getChainCost(class_2338 connection) {
        return (int)Math.max(Math.round(class_243.method_24954((class_2382)connection).method_1033() / 2.5), 1L);
    }

    public static boolean getChainsFromInventory(class_1657 player, class_1799 chain, int cost, boolean simulate) {
        int found = 0;
        class_1661 inv = player.method_31548();
        int size = 36;
        for (int j = 0; j <= size + 1; ++j) {
            class_1799 stackInSlot;
            boolean offhand;
            int i = j;
            boolean bl = offhand = j == size + 1;
            if (j == size) {
                i = inv.method_67532();
            } else if (offhand) {
                i = 0;
            } else if (j == inv.method_67532()) continue;
            class_1799 class_17992 = stackInSlot = offhand ? player.method_5998(class_1268.field_5810) : inv.method_5438(i);
            if (!class_1799.method_7984((class_1799)stackInSlot, (class_1799)chain) || found >= cost) continue;
            int count = stackInSlot.method_7947();
            if (!simulate) {
                int remainingItems = count - Math.min(cost - found, count);
                class_1799 newItem = stackInSlot.method_46651(remainingItems);
                if (offhand) {
                    player.method_6122(class_1268.field_5810, newItem);
                } else {
                    inv.method_5447(i, newItem);
                }
            }
            found += count;
        }
        return found >= cost;
    }

    public List<ChainConveyorPackage> getLoopingPackages() {
        return this.loopingPackages;
    }

    public Map<class_2338, List<ChainConveyorPackage>> getTravellingPackages() {
        return this.travellingPackages;
    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        if (this.connections == null || this.connections.isEmpty()) {
            return;
        }
        this.connections = new HashSet<class_2338>(this.connections.stream().map(transform::applyWithoutOffset).toList());
        HashMap<class_2338, List<ChainConveyorPackage>> newMap = new HashMap<class_2338, List<ChainConveyorPackage>>();
        this.travellingPackages.forEach((key, value) -> newMap.put(transform.applyWithoutOffset((class_2338)key), (List<ChainConveyorPackage>)value));
        this.travellingPackages = newMap;
        this.connectionStats = null;
        this.notifyUpdate();
    }

    public record ConnectionStats(float tangentAngle, float chainLength, class_243 start, class_243 end) {
    }

    public record ConnectedPort(float chainPosition, @Nullable class_2338 connection, String filter) {
    }
}

