/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.gauge;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.compat.computercraft.AbstractComputerBehaviour;
import com.zurrtum.create.compat.computercraft.ComputerCraftProxy;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.gauge.GaugeBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class SpeedGaugeBlockEntity
extends GaugeBlockEntity {
    public AbstractComputerBehaviour computerBehaviour;

    public SpeedGaugeBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.SPEEDOMETER, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        if (this.computerBehaviour.hasAttachedComputer()) {
            this.computerBehaviour.prepareComputerEvent(this.makeComputerKineticsChangeEvent());
        }
        float speed = Math.abs(this.getSpeed());
        this.dialTarget = SpeedGaugeBlockEntity.getDialTarget(speed);
        this.color = Color.mixColors(IRotate.SpeedLevel.of(speed).getColor(), 0xFFFFFF, 0.25f);
        this.method_5431();
    }

    public static float getDialTarget(float speed) {
        speed = Math.abs(speed);
        float medium = ((Float)AllConfigs.server().kinetics.mediumSpeed.get()).floatValue();
        float fast = ((Float)AllConfigs.server().kinetics.fastSpeed.get()).floatValue();
        float max = ((Integer)AllConfigs.server().kinetics.maxRotationSpeed.get()).floatValue();
        float target = speed == 0.0f ? 0.0f : (speed < medium ? class_3532.method_16439((float)(speed / medium), (float)0.0f, (float)0.45f) : (speed < fast ? class_3532.method_16439((float)((speed - medium) / (fast - medium)), (float)0.45f, (float)0.75f) : class_3532.method_16439((float)((speed - fast) / (max - fast)), (float)0.75f, (float)1.125f)));
        return target;
    }
}

