/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.factoryBoard;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.codecs.CatnipCodecs;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelSetItemMenu;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.zurrtum.create.content.logistics.factoryBoard.PanelSlot;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.packager.PackagerBlockEntity;
import com.zurrtum.create.content.logistics.packager.PackagingRequest;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.zurrtum.create.content.logistics.packagerLink.LogisticsManager;
import com.zurrtum.create.content.logistics.packagerLink.RequestPromise;
import com.zurrtum.create.content.logistics.packagerLink.RequestPromiseQueue;
import com.zurrtum.create.content.logistics.stockTicker.PackageOrder;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.s2c.FactoryPanelEffectPacket;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_3965;
import net.minecraft.class_4844;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7708;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public class ServerFactoryPanelBehaviour
extends ServerFilteringBehaviour
implements MenuProvider {
    private static final Codec<Set<FactoryPanelPosition>> TARGET_CODEC = CatnipCodecs.set(FactoryPanelPosition.CODEC);
    private static final Codec<List<BigItemStack>> CRAFTING_LIST_CODEC = BigItemStack.CODEC.listOf();
    public static final BehaviourType<ServerFactoryPanelBehaviour> TOP_LEFT = new BehaviourType();
    public static final BehaviourType<ServerFactoryPanelBehaviour> TOP_RIGHT = new BehaviourType();
    public static final BehaviourType<ServerFactoryPanelBehaviour> BOTTOM_LEFT = new BehaviourType();
    public static final BehaviourType<ServerFactoryPanelBehaviour> BOTTOM_RIGHT = new BehaviourType();
    public Map<FactoryPanelPosition, FactoryPanelConnection> targetedBy;
    public Map<class_2338, FactoryPanelConnection> targetedByLinks;
    public Set<FactoryPanelPosition> targeting;
    public List<class_1799> activeCraftingArrangement;
    public List<BigItemStack> craftingList;
    public boolean satisfied;
    public boolean promisedSatisfied;
    public boolean waitingForNetwork;
    public String recipeAddress;
    public int recipeOutput;
    public LerpedFloat bulb;
    public PanelSlot slot;
    public int promiseClearingInterval;
    public boolean forceClearPromises;
    public UUID network;
    public boolean active;
    public boolean redstonePowered;
    public RequestPromiseQueue restockerPromises;
    private boolean promisePrimedForMarkDirty;
    private int lastReportedUnloadedLinks;
    private int lastReportedLevelInStorage;
    private int lastReportedPromises;
    private int timer;

    public ServerFactoryPanelBehaviour(FactoryPanelBlockEntity be, PanelSlot slot) {
        super(be);
        this.slot = slot;
        this.targetedBy = new HashMap<FactoryPanelPosition, FactoryPanelConnection>();
        this.targetedByLinks = new HashMap<class_2338, FactoryPanelConnection>();
        this.targeting = new HashSet<FactoryPanelPosition>();
        this.count = 0;
        this.satisfied = false;
        this.promisedSatisfied = false;
        this.waitingForNetwork = false;
        this.activeCraftingArrangement = List.of();
        this.recipeAddress = "";
        this.recipeOutput = 1;
        this.active = false;
        this.forceClearPromises = false;
        this.redstonePowered = false;
        this.promiseClearingInterval = -1;
        this.bulb = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.175, LerpedFloat.Chaser.EXP);
        this.restockerPromises = new RequestPromiseQueue(() -> ((FactoryPanelBlockEntity)be).method_5431());
        this.promisePrimedForMarkDirty = true;
        this.network = UUID.randomUUID();
        this.setLazyTickRate(40);
    }

    public void setNetwork(UUID network) {
        this.network = network;
    }

    @Nullable
    public static ServerFactoryPanelBehaviour at(class_1920 world, FactoryPanelConnection connection) {
        Object cached = connection.cachedSource.get();
        if (cached instanceof ServerFactoryPanelBehaviour) {
            ServerFactoryPanelBehaviour fbe = (ServerFactoryPanelBehaviour)cached;
            if (!fbe.blockEntity.method_11015()) {
                return fbe;
            }
        }
        ServerFactoryPanelBehaviour result = ServerFactoryPanelBehaviour.at(world, connection.from);
        connection.cachedSource = new WeakReference<ServerFactoryPanelBehaviour>(result);
        return result;
    }

    @Nullable
    public static ServerFactoryPanelBehaviour at(class_1920 world, FactoryPanelPosition pos) {
        class_1937 l;
        if (world instanceof class_1937 && !(l = (class_1937)world).method_8477(pos.pos())) {
            return null;
        }
        class_2586 class_25862 = world.method_8321(pos.pos());
        if (!(class_25862 instanceof FactoryPanelBlockEntity)) {
            return null;
        }
        FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)class_25862;
        ServerFactoryPanelBehaviour behaviour = fpbe.panels.get((Object)pos.slot());
        if (!behaviour.active) {
            return null;
        }
        return behaviour;
    }

    @Nullable
    public static FactoryPanelSupportBehaviour linkAt(class_1920 world, FactoryPanelConnection connection) {
        Object cached = connection.cachedSource.get();
        if (cached instanceof FactoryPanelSupportBehaviour) {
            FactoryPanelSupportBehaviour fpsb = (FactoryPanelSupportBehaviour)cached;
            if (!fpsb.blockEntity.method_11015()) {
                return fpsb;
            }
        }
        FactoryPanelSupportBehaviour result = ServerFactoryPanelBehaviour.linkAt(world, connection.from);
        connection.cachedSource = new WeakReference<FactoryPanelSupportBehaviour>(result);
        return result;
    }

    @Nullable
    public static FactoryPanelSupportBehaviour linkAt(class_1920 world, FactoryPanelPosition pos) {
        class_1937 l;
        if (world instanceof class_1937 && !(l = (class_1937)world).method_8477(pos.pos())) {
            return null;
        }
        return BlockEntityBehaviour.get((class_1922)world, pos.pos(), FactoryPanelSupportBehaviour.TYPE);
    }

    public void moveTo(FactoryPanelPosition newPos, class_3222 player) {
        BlockEntityBehaviour at;
        FactoryPanelBlockEntity fpbe;
        class_1937 level = this.getWorld();
        class_2680 existingState = level.method_8320(newPos.pos());
        if (ServerFactoryPanelBehaviour.at((class_1920)level, newPos) != null) {
            return;
        }
        boolean isAddedToOtherGauge = existingState.method_27852((class_2248)AllBlocks.FACTORY_GAUGE);
        if (!existingState.method_26215() && !isAddedToOtherGauge) {
            return;
        }
        if (isAddedToOtherGauge && existingState != this.blockEntity.method_11010()) {
            return;
        }
        if (!isAddedToOtherGauge) {
            level.method_8652(newPos.pos(), this.blockEntity.method_11010(), 3);
        }
        for (class_2338 class_23382 : this.targetedByLinks.keySet()) {
            if (class_23382.method_19771((class_2382)newPos.pos(), 24.0)) continue;
            return;
        }
        for (FactoryPanelPosition factoryPanelPosition : this.targetedBy.keySet()) {
            if (factoryPanelPosition.pos().method_19771((class_2382)newPos.pos(), 24.0)) continue;
            return;
        }
        for (FactoryPanelPosition factoryPanelPosition : this.targeting) {
            if (factoryPanelPosition.pos().method_19771((class_2382)newPos.pos(), 24.0)) continue;
            return;
        }
        for (class_2338 class_23383 : this.targetedByLinks.keySet()) {
            FactoryPanelSupportBehaviour at2 = ServerFactoryPanelBehaviour.linkAt((class_1920)level, new FactoryPanelPosition(class_23383, this.slot));
            if (at2 == null) continue;
            at2.disconnect(this);
        }
        SmartBlockEntity oldBE = this.blockEntity;
        FactoryPanelPosition factoryPanelPosition = this.getPanelPosition();
        this.moveToSlot(newPos.slot());
        class_2586 class_25862 = level.method_8321(newPos.pos());
        if (class_25862 instanceof FactoryPanelBlockEntity) {
            fpbe = (FactoryPanelBlockEntity)class_25862;
            fpbe.attachBehaviourLate(this);
            fpbe.panels.put(this.slot, this);
            fpbe.redraw = true;
            fpbe.lastShape = null;
            fpbe.notifyUpdate();
        }
        if (oldBE instanceof FactoryPanelBlockEntity) {
            fpbe = (FactoryPanelBlockEntity)oldBE;
            ServerFactoryPanelBehaviour newBehaviour = new ServerFactoryPanelBehaviour(fpbe, factoryPanelPosition.slot());
            fpbe.attachBehaviourLate(newBehaviour);
            fpbe.panels.put(factoryPanelPosition.slot(), newBehaviour);
            fpbe.redraw = true;
            fpbe.lastShape = null;
            fpbe.notifyUpdate();
        }
        for (FactoryPanelPosition position : this.targeting) {
            at = ServerFactoryPanelBehaviour.at((class_1920)level, position);
            if (at == null) continue;
            FactoryPanelConnection connection = ((ServerFactoryPanelBehaviour)at).targetedBy.remove(factoryPanelPosition);
            connection.from = newPos;
            ((ServerFactoryPanelBehaviour)at).targetedBy.put(newPos, connection);
            ((ServerFactoryPanelBehaviour)at).blockEntity.sendData();
        }
        for (FactoryPanelPosition position : this.targetedBy.keySet()) {
            at = ServerFactoryPanelBehaviour.at((class_1920)level, position);
            if (at == null) continue;
            ((ServerFactoryPanelBehaviour)at).targeting.remove(factoryPanelPosition);
            ((ServerFactoryPanelBehaviour)at).targeting.add(newPos);
        }
        for (class_2338 pos : this.targetedByLinks.keySet()) {
            at = ServerFactoryPanelBehaviour.linkAt((class_1920)level, new FactoryPanelPosition(pos, this.slot));
            if (at == null) continue;
            ((FactoryPanelSupportBehaviour)at).connect(this);
        }
        player.method_7353((class_2561)class_2561.method_43471((String)"create.factory_panel.relocated").method_27692(class_124.field_1060), true);
        player.method_51469().method_8396(null, newPos.pos(), class_3417.field_26960, class_3419.field_15245, 1.0f, 1.0f);
    }

    private void moveToSlot(PanelSlot slot) {
        this.slot = slot;
        if (this.getWorld().field_9236) {
            AllClientHandle.INSTANCE.factoryPanelMoveToSlot(this.blockEntity, slot);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.notifyRedstoneOutputs();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getWorld().method_8608()) {
            if (this.blockEntity.isVirtual()) {
                this.tickStorageMonitor();
            }
            this.bulb.updateChaseTarget(this.redstonePowered || this.satisfied ? 1.0f : 0.0f);
            this.bulb.tickChaser();
            return;
        }
        if (!this.promisePrimedForMarkDirty) {
            this.restockerPromises.setOnChanged(() -> ((SmartBlockEntity)this.blockEntity).method_5431());
            this.promisePrimedForMarkDirty = true;
        }
        this.tickStorageMonitor();
        this.tickRequests();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.getWorld().method_8608()) {
            return;
        }
        this.checkForRedstoneInput();
    }

    public void checkForRedstoneInput() {
        if (!this.active) {
            return;
        }
        boolean shouldPower = false;
        for (FactoryPanelConnection connection : this.targetedByLinks.values()) {
            if (!this.getWorld().method_8477(connection.from.pos())) {
                return;
            }
            FactoryPanelSupportBehaviour linkAt = ServerFactoryPanelBehaviour.linkAt((class_1920)this.getWorld(), connection);
            if (linkAt == null) {
                return;
            }
            shouldPower |= linkAt.shouldPanelBePowered();
        }
        if (shouldPower == this.redstonePowered) {
            return;
        }
        this.redstonePowered = shouldPower;
        this.blockEntity.notifyUpdate();
        this.timer = 1;
    }

    private void notifyRedstoneOutputs() {
        for (FactoryPanelConnection connection : this.targetedByLinks.values()) {
            if (!this.getWorld().method_8477(connection.from.pos())) {
                return;
            }
            FactoryPanelSupportBehaviour linkAt = ServerFactoryPanelBehaviour.linkAt((class_1920)this.getWorld(), connection);
            if (linkAt == null || linkAt.isOutput()) {
                return;
            }
            linkAt.notifyLink();
        }
    }

    private void tickStorageMonitor() {
        boolean shouldWait;
        class_1799 filter = this.getFilter();
        int unloadedLinkCount = this.getUnloadedLinks();
        FactoryPanelBlockEntity panelBE = this.panelBE();
        if (!panelBE.restocker && unloadedLinkCount == 0 && this.lastReportedUnloadedLinks != 0) {
            LogisticsManager.SUMMARIES.invalidate((Object)this.network);
        }
        int inStorage = this.getLevelInStorage();
        int promised = this.getPromised();
        int demand = this.getAmount() * (this.upTo ? 1 : filter.method_7914());
        boolean shouldSatisfy = filter.method_7960() || inStorage >= demand;
        boolean shouldPromiseSatisfy = filter.method_7960() || inStorage + promised >= demand;
        boolean bl = shouldWait = unloadedLinkCount > 0;
        if (this.lastReportedLevelInStorage == inStorage && this.lastReportedPromises == promised && this.lastReportedUnloadedLinks == unloadedLinkCount && this.satisfied == shouldSatisfy && this.promisedSatisfied == shouldPromiseSatisfy && this.waitingForNetwork == shouldWait) {
            return;
        }
        if (!this.satisfied && shouldSatisfy && demand > 0) {
            AllSoundEvents.CONFIRM.playOnServer(this.getWorld(), (class_2382)this.getPos(), 0.075f, 1.0f);
            AllSoundEvents.CONFIRM_2.playOnServer(this.getWorld(), (class_2382)this.getPos(), 0.125f, 0.575f);
        }
        boolean notifyOutputs = this.satisfied != shouldSatisfy;
        this.lastReportedLevelInStorage = inStorage;
        this.satisfied = shouldSatisfy;
        this.lastReportedPromises = promised;
        this.promisedSatisfied = shouldPromiseSatisfy;
        this.lastReportedUnloadedLinks = unloadedLinkCount;
        this.waitingForNetwork = shouldWait;
        if (!this.getWorld().field_9236) {
            this.blockEntity.sendData();
        }
        if (notifyOutputs) {
            this.notifyRedstoneOutputs();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void tickRequests() {
        FactoryPanelBlockEntity panelBE = this.panelBE();
        if (this.targetedBy.isEmpty() && !panelBE.restocker) {
            return;
        }
        if (panelBE.restocker) {
            this.restockerPromises.tick();
        }
        if (this.satisfied || this.promisedSatisfied || this.waitingForNetwork || this.redstonePowered) {
            return;
        }
        if (this.timer > 0) {
            this.timer = Math.min((int)this.timer, (int)this.getConfigRequestIntervalInTicks());
            --this.timer;
            return;
        }
        this.resetTimer();
        if (this.recipeAddress.isBlank()) {
            return;
        }
        if (panelBE.restocker) {
            this.tryRestock();
            return;
        }
        boolean failed = false;
        HashMap<UUID, Map> consolidated = new HashMap<UUID, Map>();
        for (FactoryPanelConnection factoryPanelConnection : this.targetedBy.values()) {
            ServerFactoryPanelBehaviour serverFactoryPanelBehaviour = ServerFactoryPanelBehaviour.at((class_1920)this.getWorld(), factoryPanelConnection);
            if (serverFactoryPanelBehaviour == null) {
                return;
            }
            class_1799 item = serverFactoryPanelBehaviour.getFilter();
            Map networkItemCounts = consolidated.computeIfAbsent(serverFactoryPanelBehaviour.network, $ -> new Object2ObjectOpenCustomHashMap(class_7708.field_40212));
            networkItemCounts.computeIfAbsent(item, $ -> new ItemStackConnections(item));
            ItemStackConnections itemStackConnections = (ItemStackConnections)networkItemCounts.get(item);
            itemStackConnections.add(factoryPanelConnection);
            itemStackConnections.totalAmount += factoryPanelConnection.amount;
        }
        HashMultimap toRequest = HashMultimap.create();
        for (Map.Entry entry : consolidated.entrySet()) {
            UUID network = (UUID)entry.getKey();
            Iterator summary = LogisticsManager.getSummaryOfNetwork(network, true);
            for (ItemStackConnections connections : ((Map)entry.getValue()).values()) {
                if (connections.totalAmount == 0 || connections.item.method_7960() || ((InventorySummary)((Object)summary)).getCountOf(connections.item) < connections.totalAmount) {
                    for (FactoryPanelConnection connection : connections) {
                        this.sendEffect(connection.from, false);
                    }
                    failed = true;
                    continue;
                }
                BigItemStack stack2 = new BigItemStack(connections.item, connections.totalAmount);
                toRequest.put((Object)network, (Object)stack2);
                for (FactoryPanelConnection connection : connections) {
                    this.sendEffect(connection.from, true);
                }
            }
        }
        if (failed) {
            return;
        }
        Map map = toRequest.asMap();
        PackageOrderWithCrafts packageOrderWithCrafts = PackageOrderWithCrafts.empty();
        ArrayList<Multimap<PackagerBlockEntity, PackagingRequest>> requests = new ArrayList<Multimap<PackagerBlockEntity, PackagingRequest>>();
        if (!this.activeCraftingArrangement.isEmpty()) {
            PackageOrderWithCrafts packageOrderWithCrafts2 = PackageOrderWithCrafts.singleRecipe(this.activeCraftingArrangement.stream().map(stack -> new BigItemStack(stack.method_46651(1))).toList());
        }
        for (Map.Entry entry : map.entrySet()) {
            void var6_13;
            PackageOrderWithCrafts order = new PackageOrderWithCrafts(new PackageOrder(new ArrayList<BigItemStack>((Collection)entry.getValue())), var6_13.orderedCrafts());
            Multimap<PackagerBlockEntity, PackagingRequest> request = LogisticsManager.findPackagersForRequest((UUID)entry.getKey(), order, null, this.recipeAddress);
            requests.add(request);
        }
        for (Multimap multimap : requests) {
            for (PackagerBlockEntity packager : multimap.keySet()) {
                if (!packager.isTooBusyFor(LogisticallyLinkedBehaviour.RequestType.RESTOCK)) continue;
                return;
            }
        }
        for (Multimap multimap : requests) {
            LogisticsManager.performPackageRequests((Multimap<PackagerBlockEntity, PackagingRequest>)multimap);
        }
        RequestPromiseQueue promises = Create.LOGISTICS.getQueuedPromises(this.network);
        if (promises != null) {
            promises.add(new RequestPromise(new BigItemStack(this.getFilter(), this.recipeOutput)));
        }
        panelBE.award(AllAdvancements.FACTORY_GAUGE);
    }

    private void tryRestock() {
        class_1799 item = this.getFilter();
        if (item.method_7960()) {
            return;
        }
        FactoryPanelBlockEntity panelBE = this.panelBE();
        PackagerBlockEntity packager = panelBE.getRestockedPackager();
        if (packager == null || !packager.targetInventory.hasInventory()) {
            return;
        }
        int availableOnNetwork = LogisticsManager.getStockOf(this.network, item, packager.targetInventory.getIdentifiedInventory());
        if (availableOnNetwork == 0) {
            this.sendEffect(this.getPanelPosition(), false);
            return;
        }
        int inStorage = this.getLevelInStorage();
        int promised = this.getPromised();
        int maxStackSize = item.method_7914();
        int demand = this.getAmount() * (this.upTo ? 1 : maxStackSize);
        int amountToOrder = Math.clamp((int)(demand - promised - inStorage), (int)0, (int)(maxStackSize * 9));
        BigItemStack orderedItem = new BigItemStack(item, Math.min((int)amountToOrder, (int)availableOnNetwork));
        PackageOrderWithCrafts order = PackageOrderWithCrafts.simple(List.of(orderedItem));
        this.sendEffect(this.getPanelPosition(), true);
        if (!LogisticsManager.broadcastPackageRequest(this.network, LogisticallyLinkedBehaviour.RequestType.RESTOCK, order, packager.targetInventory.getIdentifiedInventory(), this.recipeAddress)) {
            return;
        }
        this.restockerPromises.add(new RequestPromise(orderedItem));
    }

    private void sendEffect(FactoryPanelPosition fromPos, boolean success) {
        class_1937 class_19372 = this.getWorld();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_2338 pos = this.getPos();
            serverLevel.method_8503().method_3760().method_14605(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 64.0, serverLevel.method_27983(), (class_2596)new FactoryPanelEffectPacket(fromPos, this.getPanelPosition(), success));
        }
    }

    public void addConnection(FactoryPanelPosition fromPos) {
        FactoryPanelSupportBehaviour link = ServerFactoryPanelBehaviour.linkAt((class_1920)this.getWorld(), fromPos);
        if (link != null) {
            this.targetedByLinks.put(fromPos.pos(), new FactoryPanelConnection(fromPos, 1));
            link.connect(this);
            this.blockEntity.notifyUpdate();
            return;
        }
        if (this.panelBE().restocker) {
            return;
        }
        if (this.targetedBy.size() >= 9) {
            return;
        }
        ServerFactoryPanelBehaviour source = ServerFactoryPanelBehaviour.at((class_1920)this.getWorld(), fromPos);
        if (source == null) {
            return;
        }
        source.targeting.add(this.getPanelPosition());
        this.targetedBy.put(fromPos, new FactoryPanelConnection(fromPos, 1));
        this.searchForCraftingRecipe();
        this.blockEntity.notifyUpdate();
    }

    public FactoryPanelPosition getPanelPosition() {
        return new FactoryPanelPosition(this.getPos(), this.slot);
    }

    public FactoryPanelBlockEntity panelBE() {
        return (FactoryPanelBlockEntity)this.blockEntity;
    }

    @Override
    public void onShortInteract(class_1657 player, class_1268 hand, class_2350 side, class_3965 hitResult) {
        if (!Create.LOGISTICS.mayInteract(this.network, player)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"create.logistically_linked.protected").method_27692(class_124.field_1061), true);
            return;
        }
        boolean isClientSide = player.method_37908().field_9236;
        class_1799 heldItem = player.method_5998(hand);
        if (this.targeting.size() + this.targetedByLinks.size() > 0 && heldItem.method_31573(AllItemTags.TOOLS_WRENCH)) {
            int sharedMode = -1;
            boolean notifySelf = false;
            for (FactoryPanelPosition target : this.targeting) {
                FactoryPanelConnection connection;
                ServerFactoryPanelBehaviour at = ServerFactoryPanelBehaviour.at((class_1920)this.getWorld(), target);
                if (at == null || (connection = at.targetedBy.get(this.getPanelPosition())) == null) continue;
                if (sharedMode == -1) {
                    sharedMode = (connection.arrowBendMode + 1) % 4;
                }
                connection.arrowBendMode = sharedMode;
                if (isClientSide) continue;
                at.blockEntity.notifyUpdate();
            }
            for (FactoryPanelConnection connection : this.targetedByLinks.values()) {
                if (sharedMode == -1) {
                    sharedMode = (connection.arrowBendMode + 1) % 4;
                }
                connection.arrowBendMode = sharedMode;
                if (isClientSide) continue;
                notifySelf = true;
            }
            if (sharedMode == -1) {
                return;
            }
            char[] boxes = "\u25a1\u25a1\u25a1\u25a1".toCharArray();
            boxes[sharedMode] = 9632;
            player.method_7353((class_2561)class_2561.method_43469((String)"create.factory_panel.cycled_arrow_path", (Object[])new Object[]{new String(boxes)}), true);
            if (notifySelf) {
                this.blockEntity.notifyUpdate();
            }
            return;
        }
        if (isClientSide && AllClientHandle.INSTANCE.factoryPanelClicked(this.getWorld(), player, this)) {
            return;
        }
        if (this.getFilter().method_7960()) {
            if (heldItem.method_7960()) {
                if (!isClientSide && player instanceof class_3222) {
                    class_3222 sp = (class_3222)player;
                    this.openHandledScreen(sp);
                }
                return;
            }
            super.onShortInteract(player, hand, side, hitResult);
            return;
        }
        if (heldItem.method_7909() instanceof LogisticallyLinkedBlockItem) {
            if (!isClientSide) {
                LogisticallyLinkedBlockItem.assignFrequency(heldItem, player, this.network);
            }
            return;
        }
        if (isClientSide) {
            AllClientHandle.INSTANCE.openFactoryPanelScreen(this, player);
        }
    }

    public void enable() {
        this.active = true;
        this.blockEntity.notifyUpdate();
    }

    public void disable() {
        this.destroy();
        this.active = false;
        this.targetedBy = new HashMap<FactoryPanelPosition, FactoryPanelConnection>();
        this.targeting = new HashSet<FactoryPanelPosition>();
        this.count = 0;
        this.satisfied = false;
        this.promisedSatisfied = false;
        this.recipeAddress = "";
        this.recipeOutput = 1;
        this.setFilter(class_1799.field_8037);
        this.blockEntity.notifyUpdate();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public boolean isMissingAddress() {
        return (!this.targetedBy.isEmpty() || this.panelBE().restocker) && this.count != 0 && this.recipeAddress.isBlank();
    }

    @Override
    public void destroy() {
        this.disconnectAll();
        super.destroy();
    }

    public void disconnectAll() {
        FactoryPanelPosition panelPosition = this.getPanelPosition();
        this.disconnectAllLinks();
        for (FactoryPanelConnection connection : this.targetedBy.values()) {
            ServerFactoryPanelBehaviour source = ServerFactoryPanelBehaviour.at((class_1920)this.getWorld(), connection);
            if (source == null) continue;
            source.targeting.remove(panelPosition);
            source.blockEntity.sendData();
        }
        for (FactoryPanelPosition position : this.targeting) {
            ServerFactoryPanelBehaviour target = ServerFactoryPanelBehaviour.at((class_1920)this.getWorld(), position);
            if (target == null) continue;
            target.targetedBy.remove(panelPosition);
            target.searchForCraftingRecipe();
            target.blockEntity.sendData();
        }
        this.targetedBy.clear();
        this.targeting.clear();
    }

    public void disconnectAllLinks() {
        for (FactoryPanelConnection connection : this.targetedByLinks.values()) {
            FactoryPanelSupportBehaviour source = ServerFactoryPanelBehaviour.linkAt((class_1920)this.getWorld(), connection);
            if (source == null) continue;
            source.disconnect(this);
        }
        this.targetedByLinks.clear();
    }

    public int getUnloadedLinks() {
        if (this.getWorld().method_8608()) {
            return this.lastReportedUnloadedLinks;
        }
        if (this.panelBE().restocker) {
            return this.panelBE().getRestockedPackager() == null ? 1 : 0;
        }
        return Create.LOGISTICS.getUnloadedLinkCount(this.network);
    }

    public int getLevelInStorage() {
        if (this.blockEntity.isVirtual()) {
            return 1;
        }
        if (this.getWorld().method_8608()) {
            return this.lastReportedLevelInStorage;
        }
        if (this.getFilter().method_7960()) {
            return 0;
        }
        InventorySummary summary = this.getRelevantSummary();
        return summary.getCountOf(this.getFilter());
    }

    private InventorySummary getRelevantSummary() {
        FactoryPanelBlockEntity panelBE = this.panelBE();
        if (!panelBE.restocker) {
            return LogisticsManager.getSummaryOfNetwork(this.network, false);
        }
        PackagerBlockEntity packager = panelBE.getRestockedPackager();
        if (packager == null) {
            return InventorySummary.EMPTY;
        }
        return packager.getAvailableItems();
    }

    public int getPromised() {
        if (this.getWorld().method_8608()) {
            return this.lastReportedPromises;
        }
        class_1799 item = this.getFilter();
        if (item.method_7960()) {
            return 0;
        }
        if (this.panelBE().restocker) {
            if (this.forceClearPromises) {
                this.restockerPromises.forceClear(item);
                this.resetTimerSlightly();
            }
            this.forceClearPromises = false;
            return this.restockerPromises.getTotalPromisedAndRemoveExpired(item, this.getPromiseExpiryTimeInTicks());
        }
        RequestPromiseQueue promises = Create.LOGISTICS.getQueuedPromises(this.network);
        if (promises == null) {
            return 0;
        }
        if (this.forceClearPromises) {
            promises.forceClear(item);
            this.resetTimerSlightly();
        }
        this.forceClearPromises = false;
        return promises.getTotalPromisedAndRemoveExpired(item, this.getPromiseExpiryTimeInTicks());
    }

    public void resetTimer() {
        this.timer = this.getConfigRequestIntervalInTicks();
    }

    public void resetTimerSlightly() {
        this.timer = this.getConfigRequestIntervalInTicks() / 2;
    }

    private int getConfigRequestIntervalInTicks() {
        return (Integer)AllConfigs.server().logistics.factoryGaugeTimer.get();
    }

    private int getPromiseExpiryTimeInTicks() {
        if (this.promiseClearingInterval == -1) {
            return -1;
        }
        if (this.promiseClearingInterval == 0) {
            return 600;
        }
        return this.promiseClearingInterval * 20 * 60;
    }

    @Override
    public void writeSafe(class_11372 view) {
        if (!this.active) {
            return;
        }
        class_11372 panelTag = view.method_71461(this.slot.name().toLowerCase(Locale.ROOT));
        panelTag.method_71468("Filter", FilterItemStack.CODEC, (Object)this.filter);
        panelTag.method_71472("UpTo", this.upTo);
        panelTag.method_71465("FilterAmount", this.count);
        panelTag.method_71468("Freq", class_4844.field_25122, (Object)this.network);
        panelTag.method_71469("RecipeAddress", this.recipeAddress);
        panelTag.method_71465("PromiseClearingInterval", -1);
        panelTag.method_71465("RecipeOutput", 1);
        if (this.panelBE().restocker) {
            panelTag.method_71468("Promises", RequestPromiseQueue.CODEC, (Object)this.restockerPromises);
        }
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        if (!this.active) {
            return;
        }
        class_11372 panelTag = view.method_71461(this.slot.name().toLowerCase(Locale.ROOT));
        super.write(panelTag, clientPacket);
        panelTag.method_71465("Timer", this.timer);
        panelTag.method_71465("LastLevel", this.lastReportedLevelInStorage);
        panelTag.method_71465("LastPromised", this.lastReportedPromises);
        panelTag.method_71465("LastUnloadedLinks", this.lastReportedUnloadedLinks);
        panelTag.method_71472("Satisfied", this.satisfied);
        panelTag.method_71472("PromisedSatisfied", this.promisedSatisfied);
        panelTag.method_71472("Waiting", this.waitingForNetwork);
        panelTag.method_71472("RedstonePowered", this.redstonePowered);
        panelTag.method_71468("Targeting", TARGET_CODEC, this.targeting);
        class_11372.class_11373 targetedByList = panelTag.method_71467("TargetedBy", FactoryPanelConnection.CODEC);
        this.targetedBy.values().forEach(arg_0 -> ((class_11372.class_11373)targetedByList).method_71484(arg_0));
        class_11372.class_11373 targetedByLinkList = panelTag.method_71467("TargetedByLinks", FactoryPanelConnection.CODEC);
        this.targetedByLinks.values().forEach(arg_0 -> ((class_11372.class_11373)targetedByLinkList).method_71484(arg_0));
        panelTag.method_71469("RecipeAddress", this.recipeAddress);
        panelTag.method_71465("RecipeOutput", this.recipeOutput);
        panelTag.method_71465("PromiseClearingInterval", this.promiseClearingInterval);
        panelTag.method_71468("Freq", class_4844.field_25122, (Object)this.network);
        panelTag.method_71468("Craft", CreateCodecs.ITEM_LIST_CODEC, this.activeCraftingArrangement);
        if (this.craftingList != null) {
            panelTag.method_71468("CraftingList", CRAFTING_LIST_CODEC, this.craftingList);
        }
        if (this.panelBE().restocker && !clientPacket) {
            panelTag.method_71468("Promises", RequestPromiseQueue.CODEC, (Object)this.restockerPromises);
        }
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        Optional slotView = view.method_71420(this.slot.name().toLowerCase(Locale.ROOT));
        if (slotView.isEmpty()) {
            this.active = false;
            return;
        }
        class_11368 panelTag = (class_11368)slotView.get();
        this.active = true;
        this.filter = panelTag.method_71426("Filter", FilterItemStack.CODEC).orElseGet(FilterItemStack::empty);
        this.count = panelTag.method_71424("FilterAmount", 0);
        this.upTo = panelTag.method_71433("UpTo", false);
        this.timer = panelTag.method_71424("Timer", 0);
        this.lastReportedLevelInStorage = panelTag.method_71424("LastLevel", 0);
        this.lastReportedPromises = panelTag.method_71424("LastPromised", 0);
        this.lastReportedUnloadedLinks = panelTag.method_71424("LastUnloadedLinks", 0);
        this.satisfied = panelTag.method_71433("Satisfied", false);
        this.promisedSatisfied = panelTag.method_71433("PromisedSatisfied", false);
        this.waitingForNetwork = panelTag.method_71433("Waiting", false);
        this.redstonePowered = panelTag.method_71433("RedstonePowered", false);
        this.promiseClearingInterval = panelTag.method_71424("PromiseClearingInterval", 0);
        panelTag.method_71426("Freq", class_4844.field_25122).ifPresent(uuid -> {
            this.network = uuid;
        });
        this.targeting.clear();
        panelTag.method_71426("Targeting", TARGET_CODEC).ifPresent(this.targeting::addAll);
        this.targetedBy.clear();
        panelTag.method_71437("TargetedBy", FactoryPanelConnection.CODEC).forEach(c -> this.targetedBy.put(c.from, (FactoryPanelConnection)c));
        this.targetedByLinks.clear();
        panelTag.method_71437("TargetedByLinks", FactoryPanelConnection.CODEC).forEach(c -> this.targetedByLinks.put(c.from.pos(), (FactoryPanelConnection)c));
        this.activeCraftingArrangement = panelTag.method_71426("Craft", CreateCodecs.ITEM_LIST_CODEC).orElseGet(List::of);
        this.recipeAddress = panelTag.method_71428("RecipeAddress", "");
        this.recipeOutput = panelTag.method_71424("RecipeOutput", 0);
        if (view.method_71433("Restocker", false) && !clientPacket) {
            Optional queue = panelTag.method_71426("Promises", RequestPromiseQueue.CODEC);
            if (queue.isPresent()) {
                this.restockerPromises = (RequestPromiseQueue)queue.get();
                this.restockerPromises.setOnChanged(() -> {});
            } else {
                this.restockerPromises = new RequestPromiseQueue(() -> {});
            }
            this.promisePrimedForMarkDirty = false;
        }
        this.craftingList = panelTag.method_71426("CraftingList", CRAFTING_LIST_CODEC).orElse(null);
    }

    @Override
    public boolean setFilter(class_1799 stack) {
        class_1799 filter = stack.method_7972();
        if (stack.method_7909() instanceof FilterItem) {
            return false;
        }
        this.filter = FilterItemStack.of(filter);
        this.searchForCraftingRecipe();
        this.blockEntity.method_5431();
        this.blockEntity.sendData();
        return true;
    }

    public void searchForCraftingRecipe() {
        class_1937 class_19372 = this.getWorld();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_1799 output = this.filter.item();
        if (output.method_7960() || this.targetedBy.isEmpty()) {
            this.craftingList = null;
            return;
        }
        List<BigItemStack> inputConfig = this.targetedBy.values().stream().map(c -> {
            ServerFactoryPanelBehaviour b = ServerFactoryPanelBehaviour.at((class_1920)serverWorld, c.from);
            return b == null ? new BigItemStack(class_1799.field_8037, 0) : new BigItemStack(b.getFilter(), c.amount);
        }).toList();
        Set itemsToUse = inputConfig.stream().map(b -> b.stack).filter(i -> !i.method_7960()).map(class_1799::method_7909).collect(Collectors.toSet());
        class_1792 item = output.method_7909();
        class_5455 registryManager = serverWorld.method_30349();
        class_3955 availableCraftingRecipe = serverWorld.method_64577().field_54638.method_64698(class_3956.field_17545).parallelStream().filter(entry -> {
            List ingredients;
            class_3955 recipe = (class_3955)entry.comp_1933();
            if (recipe instanceof class_1869) {
                class_1869 shapedRecipe = (class_1869)recipe;
                try {
                    result = recipe.method_8116((class_9695)class_9694.field_51631, (class_7225.class_7874)registryManager);
                }
                catch (Exception ignore) {
                    result = class_1799.field_8037;
                }
                if (result.method_7960() && ((result = shapedRecipe.field_9053) == null || result.method_7960())) {
                    return false;
                }
                if (result.method_7909() != item) {
                    return false;
                }
                ingredients = shapedRecipe.method_61693().stream().flatMap(Optional::stream).toList();
            } else if (recipe instanceof class_1867) {
                class_1867 shapelessRecipe = (class_1867)recipe;
                try {
                    result = recipe.method_8116((class_9695)class_9694.field_51631, (class_7225.class_7874)registryManager);
                }
                catch (Exception ignore) {
                    result = class_1799.field_8037;
                }
                if (result.method_7960() && ((result = shapelessRecipe.field_9050) == null || result.method_7960())) {
                    return false;
                }
                if (result.method_7909() != item) {
                    return false;
                }
                ingredients = shapelessRecipe.field_9047;
            } else {
                return false;
            }
            if (AllRecipeTypes.shouldIgnoreInAutomation(entry)) {
                return false;
            }
            HashSet<class_1792> itemsUsed = new HashSet<class_1792>();
            for (class_1856 ingredient : ingredients) {
                if (ingredient.method_65799()) continue;
                boolean available = false;
                for (BigItemStack bis : inputConfig) {
                    if (bis.stack.method_7960() || !ingredient.method_8093(bis.stack)) continue;
                    available = true;
                    itemsUsed.add(bis.stack.method_7909());
                    break;
                }
                if (available) continue;
                return false;
            }
            return itemsUsed.size() >= itemsToUse.size();
        }).findAny().map(class_8786::comp_1933).orElse(null);
        if (availableCraftingRecipe == null) {
            this.craftingList = null;
            return;
        }
        this.craftingList = ServerFactoryPanelBehaviour.convertRecipeToPackageOrderContext(availableCraftingRecipe, registryManager, inputConfig, false);
    }

    @Nullable
    public static List<BigItemStack> convertRecipeToPackageOrderContext(class_3955 availableCraftingRecipe, class_5455 registryManager, List<BigItemStack> inputs, boolean respectAmounts) {
        List<class_1856> ingredients;
        if (availableCraftingRecipe instanceof class_1869) {
            class_1869 shapedRecipe = (class_1869)availableCraftingRecipe;
            ingredients = shapedRecipe.method_61693().stream().map(o -> o.orElse(null)).toList();
        } else if (availableCraftingRecipe instanceof class_1867) {
            class_1867 shapelessRecipe = (class_1867)availableCraftingRecipe;
            ingredients = shapelessRecipe.field_9047;
        } else {
            return null;
        }
        ArrayList<BigItemStack> craftingList = new ArrayList<BigItemStack>();
        class_1799 output = availableCraftingRecipe.method_8116((class_9695)class_9694.field_51631, (class_7225.class_7874)registryManager);
        int count = output.method_7947();
        output.method_7939(1);
        craftingList.add(new BigItemStack(output, count));
        BigItemStack emptyIngredient = new BigItemStack(class_1799.field_8037, 1);
        List<BigItemStack> mutableInputs = BigItemStack.duplicateWrappers(inputs);
        int width = Math.min((int)3, (int)ingredients.size());
        int height = Math.min((int)3, (int)(ingredients.size() / 3 + 1));
        if (availableCraftingRecipe instanceof class_1869) {
            class_1869 shaped = (class_1869)availableCraftingRecipe;
            width = shaped.method_8150();
            height = shaped.method_8158();
        }
        if (height == 1) {
            for (int i = 0; i < 3; ++i) {
                craftingList.add(emptyIngredient);
            }
        }
        if (width == 1) {
            craftingList.add(emptyIngredient);
        }
        for (int i = 0; i < ingredients.size(); ++i) {
            class_1856 ingredient = ingredients.get(i);
            BigItemStack craftingIngredient = emptyIngredient;
            if (ingredient != null && !ingredient.method_65799()) {
                for (BigItemStack bigItemStack : mutableInputs) {
                    if (bigItemStack.count <= 0 || !ingredient.method_8093(bigItemStack.stack)) continue;
                    craftingIngredient = new BigItemStack(bigItemStack.stack, 1);
                    if (!respectAmounts) break;
                    --bigItemStack.count;
                    break;
                }
            }
            craftingList.add(craftingIngredient);
            if (width >= 3 || (i + 1) % width != 0) continue;
            for (int j = 0; j < 3 - width; ++j) {
                if (craftingList.size() >= 10) continue;
                craftingList.add(emptyIngredient);
            }
        }
        while (craftingList.size() < 10) {
            craftingList.add(emptyIngredient);
        }
        return craftingList;
    }

    @Override
    public void setValueSettings(class_1657 player, ValueSettings settings, boolean ctrlDown) {
        if (this.getValueSettings().equals(settings)) {
            return;
        }
        this.count = Math.max((int)0, (int)settings.value());
        this.upTo = settings.row() == 0;
        this.panelBE().redraw = true;
        this.blockEntity.method_5431();
        this.blockEntity.sendData();
        this.playFeedbackSound(this);
        this.resetTimerSlightly();
        if (!this.getWorld().field_9236) {
            this.notifyRedstoneOutputs();
        }
    }

    @Override
    public ValueSettings getValueSettings() {
        return new ValueSettings(this.upTo ? 0 : 1, this.count);
    }

    @Override
    public int netId() {
        return 2 + this.slot.ordinal();
    }

    @Override
    public boolean isCountVisible() {
        return !this.getFilter().method_7960();
    }

    @Override
    public BehaviourType<?> getType() {
        return ServerFactoryPanelBehaviour.getTypeForSlot(this.slot);
    }

    public static BehaviourType<ServerFactoryPanelBehaviour> getTypeForSlot(PanelSlot slot) {
        return switch (slot) {
            default -> throw new MatchException(null, null);
            case PanelSlot.BOTTOM_LEFT -> BOTTOM_LEFT;
            case PanelSlot.TOP_LEFT -> TOP_LEFT;
            case PanelSlot.TOP_RIGHT -> TOP_RIGHT;
            case PanelSlot.BOTTOM_RIGHT -> BOTTOM_RIGHT;
        };
    }

    public int getIngredientStatusColor() {
        return this.count == 0 || this.isMissingAddress() || this.redstonePowered ? 0x888898 : (this.waitingForNetwork ? 0x5B3B3B : (this.satisfied ? 10420095 : (this.promisedSatisfied ? 0x22AFAF : 4026045)));
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return this.isActive() ? new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, AllBlocks.FACTORY_GAUGE.method_8389()) : ItemRequirement.NONE;
    }

    @Override
    public boolean canShortInteract(class_1799 toApply) {
        return true;
    }

    @Override
    public boolean readFromClipboard(class_11368 view, class_1657 player, class_2350 side, boolean simulate) {
        return false;
    }

    @Override
    public boolean canWrite(class_7225.class_7874 registries, class_2350 side) {
        return false;
    }

    @Override
    public boolean writeToClipboard(class_11372 view, class_2350 side) {
        return false;
    }

    public FactoryPanelSetItemMenu createMenu(int containerId, class_1661 playerInventory, class_1657 player, class_9129 extraData) {
        FactoryPanelPosition.PACKET_CODEC.encode((Object)extraData, (Object)this.getPanelPosition());
        return new FactoryPanelSetItemMenu(containerId, playerInventory, this);
    }

    @Override
    public class_2561 method_5476() {
        return this.blockEntity.method_11010().method_26204().method_9518();
    }

    public String getFrogAddress() {
        PackagerBlockEntity packager = this.panelBE().getRestockedPackager();
        if (packager == null) {
            return null;
        }
        class_2586 class_25862 = packager.method_10997().method_8321(packager.method_11016().method_10084());
        if (class_25862 instanceof FrogportBlockEntity) {
            FrogportBlockEntity fpbe = (FrogportBlockEntity)class_25862;
            if (fpbe.addressFilter != null && !fpbe.addressFilter.isBlank()) {
                return fpbe.addressFilter;
            }
        }
        return null;
    }

    public static class ItemStackConnections
    extends ArrayList<FactoryPanelConnection> {
        public class_1799 item;
        public int totalAmount;

        public ItemStackConnections(class_1799 item) {
            this.item = item;
        }
    }
}

