/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.recipe;

import com.zurrtum.create.infrastructure.items.SidedItemInventory;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import org.jetbrains.annotations.Nullable;

public class ProcessingInventory
implements SidedItemInventory {
    private static final int[] INPUT_SLOTS = new int[]{0};
    private static final int[] ALL_SLOTS = SlotRangeCache.get(32);
    private static final Optional<Integer> LIMIT = Optional.of(1);
    public float remainingTime;
    public float recipeDuration;
    public boolean appliedRecipe;
    private boolean limit;
    private byte outputFlag = 0;
    private final Predicate<class_2350> canInsert;
    private final Consumer<class_1799> callback;
    private final class_2371<class_1799> stacks = class_2371.method_10213((int)32, (Object)class_1799.field_8037);

    public ProcessingInventory(Consumer<class_1799> callback, Predicate<class_2350> canInsert) {
        this.canInsert = canInsert;
        this.callback = callback;
    }

    public void outputAllowInsertion() {
        this.outputFlag = (byte)(this.limit ? 1 : 2);
        this.limit = false;
    }

    public void outputForbidInsertion() {
        this.limit = this.outputFlag == 1;
        this.outputFlag = 0;
    }

    public int method_5439() {
        return 32;
    }

    public int[] method_5494(class_2350 side) {
        return this.outputFlag == 0 ? INPUT_SLOTS : ALL_SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (this.outputFlag == 0) {
            return slot == 0 && this.canInsert.test(dir);
        }
        return slot != 0;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (this.outputFlag == 0) {
            return this.method_5442();
        }
        return true;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }

    public class_1799 onExtract(class_1799 stack) {
        if (this.limit) {
            return this.removeMaxSize(stack, LIMIT);
        }
        return stack;
    }

    public class_1799 method_5438(int slot) {
        if (slot >= 32) {
            return class_1799.field_8037;
        }
        return (class_1799)this.stacks.get(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot >= 32) {
            return;
        }
        if (this.limit && stack != class_1799.field_8037) {
            this.setMaxSize(stack, LIMIT);
        }
        this.stacks.set(slot, (Object)stack);
        if (slot == 0 && !stack.method_7960()) {
            this.callback.accept(stack);
        }
    }

    public ProcessingInventory withSlotLimit(boolean limit) {
        this.limit = limit;
        return this;
    }

    public int method_5444() {
        return this.limit ? 1 : SidedItemInventory.super.method_5444();
    }

    @Override
    public void method_5448() {
        this.remainingTime = 0.0f;
        this.recipeDuration = 0.0f;
        this.appliedRecipe = false;
        SidedItemInventory.super.method_5448();
    }

    public void write(class_11372 view) {
        class_11372.class_11373 list = view.method_71467("Inventory", class_1799.field_49266);
        list.method_71484((Object)((class_1799)this.stacks.getFirst()));
        for (int i = 1; i < this.stacks.size(); ++i) {
            class_1799 stack = (class_1799)this.stacks.get(i);
            if (stack.method_7960()) continue;
            list.method_71484((Object)stack);
        }
        view.method_71464("ProcessingTime", this.remainingTime);
        view.method_71464("RecipeTime", this.recipeDuration);
        view.method_71472("AppliedRecipe", this.appliedRecipe);
    }

    public void read(class_11368 view) {
        class_11368.class_11369 list = view.method_71437("Inventory", class_1799.field_49266);
        int i = 0;
        for (class_1799 itemStack : list) {
            this.stacks.set(i++, (Object)itemStack);
        }
        int size = this.stacks.size();
        while (i < size) {
            this.stacks.set(i, (Object)class_1799.field_8037);
            ++i;
        }
        this.remainingTime = view.method_71423("ProcessingTime", 0.0f);
        this.recipeDuration = view.method_71423("RecipeTime", 0.0f);
        this.appliedRecipe = view.method_71433("AppliedRecipe", false);
        if (this.appliedRecipe && this.method_5442()) {
            this.appliedRecipe = false;
        }
    }
}

